/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModelCache;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import fr.ifremer.tutti.util.Weights;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SpeciesFrequencyUIModel
extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";
    public static final String PROPERTY_FREQUENCIES_CONFIGURATION_MODE = "frequenciesConfigurationMode";
    public static final String PROPERTY_STEP = "step";
    private static final String PROPERTY_MIN_STEP = "minStep";
    private static final String PROPERTY_MAX_STEP = "maxStep";
    public static final String PROPERTY_CAN_GENERATE = "canGenerate";
    public static final String PROPERTY_FREQUENCIES_MODE = "frequenciesMode";
    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";
    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";
    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";
    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    public static final String PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT = "lengthStepCaracteristicUnit";
    public static final String PROPERTY_TOTAL_NUMBER = "totalNumber";
    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";
    public static final String PROPERTY_TOTAL_COMPUTED_WEIGHT = "totalComputedWeight";
    public static final String PROPERTY_COPY_RTP_WEIGHTS = "copyRtpWeights";
    public static final String PROPERTY_RTP = "rtp";
    public static final String PROPERTY_ADD_INDIVIDUAL_OBSERVATION_ON_RAFALE = "addIndividualObservationOnRafale";
    public static final String PROPERTY_EMPTY_ROWS = "emptyRows";
    public static final String PROPERTY_NEXT_EDITABLE_ROW_INDEX = "nextEditableRowIndex";
    public static final String PROPERTY_CAN_EDIT_LENGTH_STEP = "canEditLengthStep";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_MODE = "copyIndividualObservationMode";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_ALL = "copyIndividualObservationAll";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_NOTHING = "copyIndividualObservationNothing";
    public static final String PROPERTY_COPY_INDIVIDUAL_OBSERVATION_SIZE = "copyIndividualObservationSize";
    public static final String PROPERTY_INDIVIDUAL_OBSERVATION_ROWS = "individualObservationRows";
    public static final String PROPERTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR = "individualObservationRowsInError";
    public static final String PROPERTY_NON_EMPTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR = "nonEmptyIndividualObservationRowsInError";
    public static final String PROPERTY_INIT_BATCH_EDITION = "initBatchEdition";
    private final SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;
    protected FrequencyConfigurationMode configurationMode;
    protected FrequencyConfigurationMode frequenciesConfigurationMode = FrequencyConfigurationMode.AUTO_GEN;
    protected SpeciesBatchRowModel batch;
    protected Float step;
    protected Float minStep;
    protected Float maxStep;
    protected Caracteristic lengthStepCaracteristic;
    protected Integer totalNumber;
    protected ComputableData<Float> totalComputedOrNotWeight = new ComputableData();
    protected Rtp rtp;
    protected boolean copyRtpWeights;
    protected boolean addIndividualObservationOnRafale;
    protected Integer simpleCount;
    protected Integer nextEditableRowIndex;
    protected Set<SpeciesFrequencyRowModel> emptyRows;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected final WeightUnit individualObservationWeightUnit;
    protected final SpeciesFrequencyUIModelCache cache = new SpeciesFrequencyUIModelCache();
    protected boolean canEditLengthStep = true;
    protected CopyIndividualObservationMode copyIndividualObservationMode = CopyIndividualObservationMode.NOTHING;
    protected final XYSeriesCollection frequenciesDataset;
    protected final XYSeriesCollection averageWeightsDataset;
    protected final List<Caracteristic> defaultCaracteristic;
    protected List<IndividualObservationBatchRowModel> individualObservationRows;
    protected Set<IndividualObservationBatchRowModel> individualObservationRowsInError;
    protected boolean rowComputationInProgress;
    protected boolean initBatchEdition;
    protected final PropertyChangeListener rowInErrorChangedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SpeciesFrequencyUIModel.this.reloadNonEmptyIndividualObservationRowsInError();
        }
    };

    public SpeciesFrequencyUIModel(SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport, WeightUnit individualObservationWeightUnit, SampleCategoryModel sampleCategoryModel, List<Caracteristic> defaultCaracteristic) {
        super(SpeciesBatchRowModel.class, null, null);
        this.speciesOrBenthosBatchUISupport = speciesOrBenthosBatchUISupport;
        this.weightUnit = speciesOrBenthosBatchUISupport.getWeightUnit();
        this.individualObservationWeightUnit = individualObservationWeightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.totalComputedOrNotWeight.addPropagateListener(PROPERTY_TOTAL_WEIGHT, this);
        this.setEmptyRows(new HashSet<SpeciesFrequencyRowModel>());
        XYSeries series = new XYSeries((Comparable)((Object)""), true, false);
        this.frequenciesDataset = new XYSeriesCollection(series);
        this.frequenciesDataset.setIntervalPositionFactor(0.0);
        this.frequenciesDataset.setIntervalWidth(0.0);
        series = new XYSeries((Comparable)((Object)""), true, false);
        this.averageWeightsDataset = new XYSeriesCollection(series);
        this.averageWeightsDataset.setIntervalPositionFactor(0.0);
        this.averageWeightsDataset.setIntervalWidth(0.0);
        this.defaultCaracteristic = defaultCaracteristic == null ? new ArrayList<Caracteristic>() : new ArrayList<Caracteristic>(defaultCaracteristic);
        this.setIndividualObservationRowsInError(new HashSet<IndividualObservationBatchRowModel>());
    }

    public boolean isInitBatchEdition() {
        return this.initBatchEdition;
    }

    public void setInitBatchEdition(boolean initBatchEdition) {
        Boolean oldValue = this.isInitBatchEdition();
        this.initBatchEdition = initBatchEdition;
        this.firePropertyChange(PROPERTY_INIT_BATCH_EDITION, oldValue, initBatchEdition);
    }

    public void reloadRows() {
        this.setEmptyRows(new HashSet<SpeciesFrequencyRowModel>());
        XYSeries frequenciesSeries = this.frequenciesDataset.getSeries(0);
        frequenciesSeries.clear();
        XYSeries averageWeightsSeries = this.averageWeightsDataset.getSeries(0);
        averageWeightsSeries.clear();
        this.cache.loadCache(this.rows);
        this.recomputeRowsValidateState();
        if (this.rows != null) {
            this.rows.stream().filter(AbstractTuttiBeanUIModel::isValid).forEach(row -> {
                Float lengthStep = row.getLengthStep();
                Integer number = row.getNumber();
                frequenciesSeries.addOrUpdate((Number)lengthStep, (Number)number);
                Float averageWeight = this.individualObservationWeightUnit.convertWeight(row.computeAverageWeight(), this.weightUnit);
                if (averageWeight != null) {
                    averageWeightsSeries.addOrUpdate((Number)lengthStep, (Number)averageWeight);
                }
            });
        }
        this.recomputeTotalNumberAndWeight();
    }

    public boolean isRowValid(SpeciesFrequencyRowModel row) {
        boolean valid;
        boolean bl = valid = row.getLengthStepCaracteristic() != null;
        if (valid) {
            Float lengthStep = row.getLengthStep();
            boolean bl2 = valid = lengthStep != null && lengthStep.floatValue() > 0.0f && this.numberOfRows(lengthStep.floatValue()) < 2;
        }
        if (valid) {
            valid = row.withNumber();
        }
        if (valid) {
            valid = this.getNbRowsWithWeight() == 0 || row.withWeight();
        }
        return valid;
    }

    @Override
    protected SpeciesBatchRowModel newEntity() {
        return new SpeciesBatchRowModel(this.weightUnit, this.sampleCategoryModel);
    }

    public FrequencyConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(FrequencyConfigurationMode configurationMode) {
        FrequencyConfigurationMode oldValue = this.getConfigurationMode();
        this.configurationMode = configurationMode;
        this.firePropertyChange(PROPERTY_FREQUENCIES_MODE, null, this.isFrequenciesMode());
        this.firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, this.isSimpleCountingMode());
        this.firePropertyChange(PROPERTY_CONFIGURATION_MODE, (Object)oldValue, (Object)configurationMode);
    }

    public FrequencyConfigurationMode getFrequenciesConfigurationMode() {
        return this.frequenciesConfigurationMode;
    }

    public void setFrequenciesConfigurationMode(FrequencyConfigurationMode frequenciesConfigurationMode) {
        FrequencyConfigurationMode oldValue = this.getFrequenciesConfigurationMode();
        this.frequenciesConfigurationMode = frequenciesConfigurationMode;
        this.firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, this.isAutoGenMode());
        this.firePropertyChange(PROPERTY_RAFALE_MODE, null, this.isRafaleMode());
        this.firePropertyChange(PROPERTY_FREQUENCIES_CONFIGURATION_MODE, (Object)oldValue, (Object)this.getFrequenciesConfigurationMode());
    }

    public Float getStep() {
        return this.step;
    }

    public void setStep(Float step) {
        Float oldValue = this.getStep();
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
        this.firePropertyChange(PROPERTY_LENGTH_STEP_CARACTERISTIC_UNIT, null, this.getLengthStepCaracteristicUnit());
    }

    public String getLengthStepCaracteristicUnit() {
        return this.lengthStepCaracteristic == null ? null : this.lengthStepCaracteristic.getUnit();
    }

    public Float getMinStep() {
        return this.minStep;
    }

    public void setMinStep(Float minStep) {
        Float oldValue = this.getMinStep();
        this.minStep = minStep;
        this.firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Float oldValue = this.getMaxStep();
        this.maxStep = maxStep;
        this.firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Integer getSimpleCount() {
        return this.simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Integer oldValue = this.getSimpleCount();
        this.simpleCount = simpleCount;
        this.firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public boolean isCanEditLengthStep() {
        return this.canEditLengthStep;
    }

    public void setCanEditLengthStep(boolean canEditLengthStep) {
        Boolean oldValue = this.isCanEditLengthStep();
        this.canEditLengthStep = canEditLengthStep;
        this.firePropertyChange(PROPERTY_CAN_EDIT_LENGTH_STEP, oldValue, canEditLengthStep);
    }

    public Integer getNextEditableRowIndex() {
        return this.nextEditableRowIndex;
    }

    public void setNextEditableRowIndex(Integer nextEditableRowIndex) {
        Integer oldValue = this.getNextEditableRowIndex();
        this.nextEditableRowIndex = nextEditableRowIndex;
        this.firePropertyChange(PROPERTY_NEXT_EDITABLE_ROW_INDEX, oldValue, nextEditableRowIndex);
    }

    public boolean isSimpleCountingMode() {
        return FrequencyConfigurationMode.SIMPLE_COUNTING == this.configurationMode;
    }

    public boolean isFrequenciesMode() {
        return FrequencyConfigurationMode.FREQUENCIES == this.configurationMode;
    }

    public boolean isAutoGenMode() {
        return FrequencyConfigurationMode.AUTO_GEN == this.frequenciesConfigurationMode;
    }

    public boolean isRafaleMode() {
        return FrequencyConfigurationMode.RAFALE == this.frequenciesConfigurationMode;
    }

    public boolean isCanGenerate() {
        return this.minStep != null && this.maxStep != null && this.maxStep.floatValue() > this.minStep.floatValue() && this.lengthStepCaracteristic != null;
    }

    public SpeciesBatchRowModel getBatch() {
        return this.batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        this.batch = batch;
        this.firePropertyChange(PROPERTY_BATCH, null, batch);
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int)(lengthStep * 10.0f);
        int intStep = (int)(this.step.floatValue() * 10.0f);
        int correctIntStep = intValue - intValue % intStep;
        return (float)correctIntStep / 10.0f;
    }

    public Integer getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        Integer oldValue = this.getTotalNumber();
        this.totalNumber = totalNumber;
        this.firePropertyChange(PROPERTY_TOTAL_NUMBER, oldValue, totalNumber);
    }

    public ComputableData<Float> getTotalComputedOrNotWeight() {
        return this.totalComputedOrNotWeight;
    }

    public Float getTotalWeight() {
        return this.totalComputedOrNotWeight.getData();
    }

    public void setTotalWeight(Float totalWeight) {
        Float oldValue = this.getTotalWeight();
        this.totalComputedOrNotWeight.setData(this.weightUnit.round(totalWeight));
        this.firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getTotalComputedWeight() {
        return this.totalComputedOrNotWeight.getComputedData();
    }

    public void setTotalComputedWeight(Float totalComputedWeight) {
        Float oldValue = this.getTotalComputedWeight();
        this.totalComputedOrNotWeight.setComputedData(this.weightUnit.round(totalComputedWeight));
        this.firePropertyChange(PROPERTY_TOTAL_COMPUTED_WEIGHT, oldValue, totalComputedWeight);
    }

    public boolean isTotalWeightSameAsComputedWeight() {
        Float totalWeight = this.getTotalWeight();
        Float totalComputedWeight = this.getTotalComputedWeight();
        return totalWeight != null && totalComputedWeight != null && Weights.isEqualWeight((float)totalWeight.floatValue(), (float)totalComputedWeight.floatValue());
    }

    public Rtp getRtp() {
        return this.rtp;
    }

    public void setRtp(Rtp rtp) {
        Rtp oldValue = this.getRtp();
        this.rtp = rtp;
        this.firePropertyChange(PROPERTY_RTP, oldValue, rtp);
    }

    public boolean isCopyRtpWeights() {
        return this.copyRtpWeights;
    }

    public void setCopyRtpWeights(boolean copyRtpWeights) {
        boolean oldValue = this.isCopyRtpWeights();
        try {
            this.fireVetoableChange(PROPERTY_COPY_RTP_WEIGHTS, oldValue, copyRtpWeights);
            this.copyRtpWeights = copyRtpWeights;
            this.firePropertyChange(PROPERTY_COPY_RTP_WEIGHTS, oldValue, copyRtpWeights);
        }
        catch (PropertyVetoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error in setting copyRtpWeights", (Throwable)e);
            }
            this.firePropertyChange(PROPERTY_COPY_RTP_WEIGHTS, copyRtpWeights, oldValue);
        }
    }

    public boolean isAddIndividualObservationOnRafale() {
        return this.addIndividualObservationOnRafale;
    }

    public void setAddIndividualObservationOnRafale(boolean addIndividualObservationOnRafale) {
        Boolean oldValue = this.isAddIndividualObservationOnRafale();
        this.addIndividualObservationOnRafale = addIndividualObservationOnRafale;
        this.firePropertyChange(PROPERTY_ADD_INDIVIDUAL_OBSERVATION_ON_RAFALE, oldValue, addIndividualObservationOnRafale);
    }

    public CopyIndividualObservationMode getCopyIndividualObservationMode() {
        return this.copyIndividualObservationMode;
    }

    public void setCopyIndividualObservationMode(CopyIndividualObservationMode copyIndividualObservationMode) {
        CopyIndividualObservationMode oldValue = this.getCopyIndividualObservationMode();
        this.copyIndividualObservationMode = copyIndividualObservationMode;
        try {
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_ALL, oldValue == CopyIndividualObservationMode.ALL, copyIndividualObservationMode == CopyIndividualObservationMode.ALL);
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_NOTHING, oldValue == CopyIndividualObservationMode.NOTHING, copyIndividualObservationMode == CopyIndividualObservationMode.NOTHING);
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_SIZE, oldValue == CopyIndividualObservationMode.SIZE, copyIndividualObservationMode == CopyIndividualObservationMode.SIZE);
            this.fireVetoableChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_MODE, oldValue, copyIndividualObservationMode);
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_MODE, oldValue, copyIndividualObservationMode);
        }
        catch (PropertyVetoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error in setting copyIndividualObservationMode", (Throwable)e);
            }
            this.copyIndividualObservationMode = oldValue;
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_ALL, copyIndividualObservationMode == CopyIndividualObservationMode.ALL, oldValue == CopyIndividualObservationMode.ALL);
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_NOTHING, copyIndividualObservationMode == CopyIndividualObservationMode.NOTHING, oldValue == CopyIndividualObservationMode.NOTHING);
            this.firePropertyChange(PROPERTY_COPY_INDIVIDUAL_OBSERVATION_SIZE, copyIndividualObservationMode == CopyIndividualObservationMode.SIZE, oldValue == CopyIndividualObservationMode.SIZE);
        }
    }

    public boolean mustCopyIndividualObservationSize() {
        return this.isCopyIndividualObservationAll() || this.isCopyIndividualObservationSize();
    }

    public boolean mustCopyIndividualObservationWeight() {
        return this.isCopyIndividualObservationAll();
    }

    public boolean isCopyIndividualObservationAll() {
        return this.copyIndividualObservationMode == CopyIndividualObservationMode.ALL;
    }

    public boolean isCopyIndividualObservationNothing() {
        return this.copyIndividualObservationMode == CopyIndividualObservationMode.NOTHING;
    }

    public boolean isCopyIndividualObservationSize() {
        return this.copyIndividualObservationMode == CopyIndividualObservationMode.SIZE;
    }

    public Set<SpeciesFrequencyRowModel> getEmptyRows() {
        return this.emptyRows;
    }

    public void setEmptyRows(Set<SpeciesFrequencyRowModel> emptyRows) {
        this.emptyRows = emptyRows;
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, emptyRows);
    }

    public int getNbRowsWithWeight() {
        return this.cache.getNbRowsWithWeight();
    }

    public boolean isSomeRowsWithWeightAndOtherWithout() {
        boolean result;
        if (CollectionUtils.isEmpty((Collection)this.rows)) {
            result = false;
        } else {
            int nbNoneEmptyRows = 0;
            int nbNoneEmptyRowsWithWeight = 0;
            for (SpeciesFrequencyRowModel row : this.rows) {
                if (row.isEmpty()) continue;
                ++nbNoneEmptyRows;
                if (row.getWeight() == null) continue;
                ++nbNoneEmptyRowsWithWeight;
            }
            result = nbNoneEmptyRowsWithWeight > 0 && nbNoneEmptyRows != nbNoneEmptyRowsWithWeight;
        }
        return result;
    }

    public void updateEmptyRow(SpeciesFrequencyRowModel row) {
        if (row.isValid() && row.getNumber() == null && row.getWeight() == null) {
            this.emptyRows.add(row);
        } else {
            this.emptyRows.remove(row);
        }
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    public int computeTotalNumber() {
        int result = 0;
        if (this.rows != null) {
            for (SpeciesFrequencyRowModel row : this.rows) {
                if (!row.isValid() || row.getNumber() == null) continue;
                result += row.getNumber().intValue();
            }
        }
        return result;
    }

    public void recomputeTotalNumberAndWeight() {
        int computeTotalNumber = this.computeTotalNumber();
        Float computeTotalWeight = this.cache.computeTotalWeight();
        this.setTotalNumber(computeTotalNumber);
        this.setTotalComputedWeight(computeTotalWeight);
    }

    public void recomputeCanEditLengthStep() {
        boolean result = true;
        if (this.rows != null) {
            for (SpeciesFrequencyRowModel speciesFrequencyRowModel : this.rows) {
                if (speciesFrequencyRowModel.isEmpty() || speciesFrequencyRowModel.getLengthStep() == null || speciesFrequencyRowModel.getNumber() == null) continue;
                result = false;
                break;
            }
        }
        if (this.individualObservationRows != null) {
            for (IndividualObservationBatchRowModel individualObservationBatchRowModel : this.individualObservationRows) {
                if (individualObservationBatchRowModel.isEmpty()) continue;
                result = false;
                break;
            }
        }
        this.setCanEditLengthStep(result);
    }

    public void computeRowWeightWithRtp() {
        this.rows.forEach(this::computeRowWeightWithRtp);
    }

    public void computeRowWeightWithRtp(SpeciesFrequencyRowModel row) {
        Float computedWeight = null;
        if (row.withNumber() && row.getLengthStep() != null && this.withRtp()) {
            float computedWeightForLengthStep = Weights.computeWithRtp((Rtp)this.getRtp(), (float)row.getLengthStep().floatValue(), (String)this.getLengthStepCaracteristicUnit());
            computedWeight = this.weightUnit.fromEntity(Float.valueOf((float)row.getNumber().intValue() * computedWeightForLengthStep));
        }
        row.setRtpComputedWeight(computedWeight);
        if (this.isCopyRtpWeights()) {
            row.setWeight(computedWeight);
        }
    }

    public boolean withRtp() {
        return this.rtp != null;
    }

    public int numberOfRows(float lengthStep) {
        return this.cache.numberOfRows(lengthStep);
    }

    public Map<Float, SpeciesFrequencyRowModel> getRowCache() {
        return this.cache.getRowCache();
    }

    public List<IndividualObservationBatchRowModel> getIndividualObservationRows() {
        return this.individualObservationRows;
    }

    public void setIndividualObservationRows(List<IndividualObservationBatchRowModel> individualObservationRows) {
        List<IndividualObservationBatchRowModel> oldValue = this.getIndividualObservationRows();
        this.individualObservationRows = individualObservationRows;
        this.firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_ROWS, oldValue, individualObservationRows);
        this.individualObservationRowsInError.clear();
        for (IndividualObservationBatchRowModel row : individualObservationRows) {
            if (row.isValid()) continue;
            this.individualObservationRowsInError.add(row);
        }
        this.setIndividualObservationRowsInError(this.individualObservationRowsInError);
    }

    public Set<IndividualObservationBatchRowModel> getIndividualObservationRowsInError() {
        return this.individualObservationRowsInError;
    }

    public void setIndividualObservationRowsInError(Set<IndividualObservationBatchRowModel> individualObservationRowsInError) {
        if (this.individualObservationRowsInError != null) {
            this.individualObservationRowsInError.forEach(row -> row.removePropertyChangeListener(this.rowInErrorChangedListener));
        }
        this.individualObservationRowsInError = individualObservationRowsInError;
        if (this.individualObservationRowsInError != null) {
            this.individualObservationRowsInError.forEach(row -> row.addPropertyChangeListener(this.rowInErrorChangedListener));
        }
        this.reloadNonEmptyIndividualObservationRowsInError();
    }

    public void addIndividualObservationRowInError(IndividualObservationBatchRowModel row) {
        boolean nonEmptyIndividualObservationInError = this.isNonEmptyIndividualObservationRowsInError();
        HashSet<IndividualObservationBatchRowModel> oldValue = new HashSet<IndividualObservationBatchRowModel>(this.individualObservationRowsInError);
        this.individualObservationRowsInError.add(row);
        row.addPropertyChangeListener(this.rowInErrorChangedListener);
        this.firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR, oldValue, this.individualObservationRowsInError);
        this.setNonEmptyIndividualObservationRowsInError(nonEmptyIndividualObservationInError);
    }

    public void removeIndividualObservationRowInError(IndividualObservationBatchRowModel row) {
        boolean nonEmptyIndividualObservationInError = this.isNonEmptyIndividualObservationRowsInError();
        HashSet<IndividualObservationBatchRowModel> oldValue = new HashSet<IndividualObservationBatchRowModel>(this.individualObservationRowsInError);
        this.individualObservationRowsInError.remove(row);
        row.removePropertyChangeListener(this.rowInErrorChangedListener);
        this.firePropertyChange(PROPERTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR, oldValue, this.individualObservationRowsInError);
        this.setNonEmptyIndividualObservationRowsInError(nonEmptyIndividualObservationInError);
    }

    public boolean isNonEmptyIndividualObservationRowsInError() {
        return this.individualObservationRowsInError != null && this.individualObservationRowsInError.stream().anyMatch(row -> !row.isEmpty());
    }

    public void setNonEmptyIndividualObservationRowsInError(boolean oldNonEmptyIndividualObservationInError) {
        this.firePropertyChange(PROPERTY_NON_EMPTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR, oldNonEmptyIndividualObservationInError, this.isNonEmptyIndividualObservationRowsInError());
    }

    public void reloadNonEmptyIndividualObservationRowsInError() {
        this.firePropertyChange(PROPERTY_NON_EMPTY_INDIVIDUAL_OBSERVATION_ROWS_IN_ERROR, null, this.isNonEmptyIndividualObservationRowsInError());
    }

    public void recomputeRowsValidateState() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Revalidate all rows");
        }
        this.rows.forEach(this::recomputeRowValidState);
    }

    public void recomputeIndividualObservationRowsValidateState() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Revalidate all individual observation rows");
        }
        this.individualObservationRows.forEach(this::recomputeIndividualObservationRowValidState);
    }

    public boolean isIndividualObservationRowValid(IndividualObservationBatchRowModel row) {
        return this.copyIndividualObservationMode == CopyIndividualObservationMode.NOTHING || this.copyIndividualObservationMode == CopyIndividualObservationMode.SIZE && row.getSize() != null || this.copyIndividualObservationMode == CopyIndividualObservationMode.ALL && row.getSize() != null && row.getWeight() != null;
    }

    public void setDataSetIntervalWidth(float step) {
        this.frequenciesDataset.setIntervalWidth((double)step);
        this.averageWeightsDataset.setIntervalWidth((double)step);
    }

    public List<Caracteristic> getDefaultCaracteristic() {
        return this.defaultCaracteristic;
    }

    public boolean isRowComputationInProgress() {
        return this.rowComputationInProgress;
    }

    public void setRowComputationInProgress(boolean rowComputationInProgress) {
        this.rowComputationInProgress = rowComputationInProgress;
    }

    protected final void recomputeRowValidState(SpeciesFrequencyRowModel row) {
        boolean valid = this.isRowValid(row);
        row.setValid(valid);
        if (valid) {
            this.removeRowInError(row);
        } else {
            this.addRowInError(row);
        }
    }

    protected final void recomputeIndividualObservationRowValidState(IndividualObservationBatchRowModel row) {
        boolean valid = this.isIndividualObservationRowValid(row);
        row.setValid(valid);
        if (valid) {
            this.removeIndividualObservationRowInError(row);
        } else {
            this.addIndividualObservationRowInError(row);
        }
    }

    public SpeciesOrBenthosBatchUISupport getSpeciesOrBenthosBatchUISupport() {
        return this.speciesOrBenthosBatchUISupport;
    }
}

