/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderMeasureRecord;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Sexs;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SamplingCodeCellEditor;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.SamplingCodeCellRenderer;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationUICache;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.ApplySpeciesFrequencyRafaleAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.SoundEngine;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiNumberTickUnitSource;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI>
implements CaracteristicMapColumnUIHandler {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    public static final String OBS_TABLE_CARD = "obsTableCard";
    public static final String EDIT_CARACTERISTICS_CARD = "editCaracteristicsCard";
    private SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private TaxonCache taxonCache;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    private Map<String, Caracteristic> maturityCaracteristics;
    private JFreeChart frequenciesChart;
    private JFreeChart averageWeightsChart;
    protected final JFrame frequenciesHistogramPopup = new JFrame();
    protected final JFrame averageWeightsHistogramPopup = new JFrame();
    protected Caracteristic sexCaracteristic;
    protected WeightUnit weightUnit;
    protected final FeedReaderListener feedReaderListener;
    protected IndividualObservationUICache individualObservationUICache;
    protected ApplySpeciesFrequencyRafaleAction applySpeciesFrequencyRafaleAction;
    protected PropertyChangeListener obsChangedListener;
    protected VetoableChangeListener changeScreenListener;
    protected Optional<CaracteristicColumnIdentifier> maturityColumnId = Optional.empty();
    protected SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;

    public SpeciesFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
        this.feedReaderListener = new FeedReaderListener(){

            public void recordRead(FeedReaderEvent event) {
                FeedReaderMeasureRecord record = event.getRecord();
                SwingUtilities.invokeLater(() -> {
                    if (!((SpeciesFrequencyUIModel)((Object)((Object)SpeciesFrequencyUIHandler.this.getModel()))).isSimpleCountingMode()) {
                        SpeciesFrequencyUIHandler.this.consumeFeedRecord(record);
                    }
                });
            }
        };
        this.obsChangedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesFrequencyUIHandler.this.resetSamplingLabels();
                IndividualObservationBatchRowModel row = (IndividualObservationBatchRowModel)evt.getSource();
                String propertyName = evt.getPropertyName();
                CaracteristicQualitativeValue gender = row.getGender(SpeciesFrequencyUIHandler.this.sexCaracteristic);
                Optional<CaracteristicQualitativeValue> maturity = row.getMaturityState();
                if (row.isValid()) {
                    Float newValue;
                    Float oldValue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Row is valid");
                    }
                    if ("size".equals(propertyName)) {
                        oldValue = (Float)evt.getOldValue();
                        newValue = (Float)evt.getNewValue();
                        if (oldValue != null) {
                            SpeciesFrequencyUIHandler.this.individualObservationUICache.decrements(gender, maturity, oldValue.floatValue());
                        }
                        if (newValue != null) {
                            SpeciesFrequencyUIHandler.this.individualObservationUICache.increments(gender, maturity, newValue.floatValue());
                        }
                        if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationSize()) {
                            SpeciesFrequencyUIHandler.this.updateFrequencyRowsNumbers(oldValue, newValue);
                            Float weight = row.getWeight();
                            if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationWeight() && weight != null) {
                                SpeciesFrequencyUIHandler.this.updateFrequencyRowsWeights(oldValue, Float.valueOf(-weight.floatValue()));
                                SpeciesFrequencyUIHandler.this.updateFrequencyRowsWeights(newValue, weight);
                            }
                        }
                    }
                    if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationWeight() && "weight".equals(propertyName)) {
                        oldValue = (Float)evt.getOldValue();
                        newValue = (Float)evt.getNewValue();
                        Float weightToAdd = oldValue == null ? newValue : (newValue == null ? Float.valueOf(-oldValue.floatValue()) : Float.valueOf(newValue.floatValue() - oldValue.floatValue()));
                        if (weightToAdd != null) {
                            SpeciesFrequencyUIHandler.this.updateFrequencyRowsWeights(row.getSize(), weightToAdd);
                        }
                    }
                    if (row.withSize() && ("defaultCaracteristics".equals(propertyName) || "caracteristics".equals(propertyName))) {
                        CaracteristicQualitativeValue newGender;
                        CaracteristicQualitativeValue oldGender;
                        oldValue = (CaracteristicMap)evt.getOldValue();
                        newValue = (CaracteristicMap)evt.getNewValue();
                        if (log.isInfoEnabled()) {
                            log.info((Object)"caracteristics changed");
                        }
                        if (row.getMaturityCaracteristic().isPresent()) {
                            Optional<CaracteristicQualitativeValue> oldMaturity = Optional.ofNullable((CaracteristicQualitativeValue)oldValue.get(row.getMaturityCaracteristic().get()));
                            Optional<CaracteristicQualitativeValue> newMaturity = Optional.ofNullable((CaracteristicQualitativeValue)newValue.get(row.getMaturityCaracteristic().get()));
                            if (log.isInfoEnabled()) {
                                log.info((Object)("maturities : " + oldMaturity + " " + newMaturity));
                            }
                            if (!Objects.equals(oldMaturity, newMaturity)) {
                                SpeciesFrequencyUIHandler.this.individualObservationUICache.decrements(gender, oldMaturity, row.getSize().floatValue());
                                SpeciesFrequencyUIHandler.this.individualObservationUICache.increments(gender, newMaturity, row.getSize().floatValue());
                            }
                        }
                        if (!Objects.equals(oldGender = (CaracteristicQualitativeValue)oldValue.get(SpeciesFrequencyUIHandler.this.sexCaracteristic), newGender = (CaracteristicQualitativeValue)newValue.get(SpeciesFrequencyUIHandler.this.sexCaracteristic))) {
                            SpeciesFrequencyUIHandler.this.individualObservationUICache.decrements(oldGender, maturity, row.getSize().floatValue());
                            SpeciesFrequencyUIHandler.this.individualObservationUICache.increments(newGender, maturity, row.getSize().floatValue());
                        }
                    }
                }
                if (!((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).isRowComputationInProgress() && "valid".equals(propertyName)) {
                    boolean oldValue = (Boolean)evt.getOldValue();
                    boolean newValue = (Boolean)evt.getNewValue();
                    if (oldValue && ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationSize()) {
                        SpeciesFrequencyUIHandler.this.updateFrequencyRowsNumbers(row.getSize(), null);
                        SpeciesFrequencyUIHandler.this.individualObservationUICache.decrements(gender, maturity, row.getSize().floatValue());
                    }
                    if (newValue) {
                        if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationSize()) {
                            SpeciesFrequencyUIHandler.this.updateFrequencyRowsNumbers(null, row.getSize());
                            if (row.withSize()) {
                                SpeciesFrequencyUIHandler.this.individualObservationUICache.increments(gender, maturity, row.getSize().floatValue());
                            }
                        }
                        if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).mustCopyIndividualObservationWeight()) {
                            SpeciesFrequencyUIHandler.this.updateFrequencyRowsWeights(row.getSize(), row.getWeight());
                        }
                    }
                }
                ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).recomputeIndividualObservationRowValidState(row);
                ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).recomputeCanEditLengthStep();
                ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).setModify(true);
            }
        };
        this.changeScreenListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).isModify() && !SpeciesFrequencyUIHandler.this.askCancelEditBeforeLeaving()) {
                    throw new PropertyVetoException("The user does not want to quit the screen.", evt);
                }
            }
        };
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    public boolean isRowValid(SpeciesFrequencyRowModel row) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        return model.isRowValid(row);
    }

    @Override
    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        return ((SpeciesFrequencyUI)this.ui).getObsCaracteristicCaracteristicMapEditor();
    }

    @Override
    public void showCaracteristicMapEditor(CaracteristicMapColumnRowModel editRow) {
        IndividualObservationBatchRowModel row = (IndividualObservationBatchRowModel)editRow;
        WeightUnit individualObservationWeightUnit = this.getConfig().getIndividualObservationWeightUnit();
        String title = String.format("<html><body style='color:black;'><strong>%s - %s %s - %s %s</strong> - %s</body></html>", row.getRankOrder(), row.getSize(), ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristicUnit(), individualObservationWeightUnit.renderWeight(row.getWeight()), individualObservationWeightUnit.getShortLabel(), I18n.t((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics", (Object[])new Object[0]));
        ((SpeciesFrequencyUI)this.ui).getObsCaracteristicMapEditorReminderLabel().setTitle(title);
        ((SpeciesFrequencyUI)this.ui).getObsPanelLayout().setSelected(EDIT_CARACTERISTICS_CARD);
    }

    @Override
    public void hideCaracteristicMapEditor() {
        ((SpeciesFrequencyUI)this.ui).getObsPanelLayout().setSelected(OBS_TABLE_CARD);
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesFrequencyRowModel> rows) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.reloadRows();
        this.getTableModel().setRows(rows);
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)((SpeciesFrequencyUI)this.ui).getLogsTable().getModel());
        logsTableModel.setRows(Lists.newArrayList());
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setModify(false);
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesFrequencyUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.speciesOrBenthosBatchUISupport = ui.getContextValue(SpeciesOrBenthosBatchUISupport.class, ui.getSpeciesOrBenthosContext());
        this.weightUnit = this.speciesOrBenthosBatchUISupport.getWeightUnit();
        this.sexCaracteristic = this.getPersistenceService().getSexCaracteristic();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        List defaultCaracteristic = this.getDataContext().getDefaultIndividualObservationCaracteristics();
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel(this.speciesOrBenthosBatchUISupport, this.getConfig().getIndividualObservationWeightUnit(), sampleCategoryModel, defaultCaracteristic);
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
        this.getContext().addPropertyChangeListener("ichtyometerConnected", evt -> {
            boolean connected = (Boolean)evt.getNewValue();
            if (connected && this.frequencyEditor != null) {
                this.listenItchtyometer();
            }
            SwingUtilities.invokeLater(this::updateLogVisibility);
        });
        this.individualObservationUICache = new IndividualObservationUICache(this.getDataContext().getOptionalCruiseSamplingCache(), model, this.sexCaracteristic);
    }

    public void afterInit(SpeciesFrequencyUI ui) {
        this.applySpeciesFrequencyRafaleAction = new ApplySpeciesFrequencyRafaleAction(ui);
        this.initUI(this.ui);
        ArrayList lengthStepCaracteristics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById((Iterable)lengthStepCaracteristics);
        ArrayList maturityCaracteristics = Lists.newArrayList((Iterable)this.getDataContext().getMaturityCaracteristics());
        this.maturityCaracteristics = TuttiEntities.splitById((Iterable)maturityCaracteristics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        this.taxonCache = TaxonCaches.createSpeciesCacheWithoutVernacularCode((TuttiPersistence)this.getPersistenceService(), (TuttiProtocol)this.getDataContext().getProtocol());
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracteristics, modelCaracteristic);
        float step = this.getStep(modelCaracteristic);
        model.setStep(Float.valueOf(step));
        model.setMinStep(null);
        model.setMaxStep(null);
        ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel().getNumberValue();
                    SpeciesFrequencyUIHandler.this.applySpeciesFrequencyRafaleAction.applyRafaleStep(step, false);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", evt -> {
            Caracteristic newValue = (Caracteristic)evt.getNewValue();
            float step1 = this.getStep(newValue);
            model.setStep(Float.valueOf(step1));
            model.setDataSetIntervalWidth(step1);
            this.frequenciesChart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step1 == 1.0f));
            this.averageWeightsChart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step1 == 1.0f));
            if (CollectionUtils.isNotEmpty(((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).getRows())) {
                for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).getRows()) {
                    rowModel.setLengthStepCaracteristic(newValue);
                    this.recomputeRowValidState(rowModel);
                }
            }
            ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
            this.getObsTableModel().setLengthstepCaracteristic(newValue);
        });
        model.addPropertyChangeListener("lengthStepCaracteristicUnit", evt -> {
            String unit = (String)evt.getNewValue();
            if (unit == null) {
                unit = I18n.t((String)"tutti.editSpeciesFrequencies.unkownStepUnit", (Object[])new Object[0]);
            }
            ((SpeciesFrequencyUI)this.getUI()).getMinStepLabel().setText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep", (Object[])new Object[0]), unit));
            ((SpeciesFrequencyUI)this.getUI()).getMinStepLabel().setToolTipText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep.tip", (Object[])new Object[0]), unit));
            ((SpeciesFrequencyUI)this.getUI()).getMaxStepLabel().setText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep", (Object[])new Object[0]), unit));
            ((SpeciesFrequencyUI)this.getUI()).getMaxStepLabel().setToolTipText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep.tip", (Object[])new Object[0]), unit));
            ((SpeciesFrequencyUI)this.getUI()).getRafaleStepLabel().setText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep", (Object[])new Object[0]), unit));
            ((SpeciesFrequencyUI)this.getUI()).getRafaleStepLabel().setToolTipText(this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep.tip", (Object[])new Object[0]), unit));
            TableColumnExt column = (TableColumnExt)((SpeciesFrequencyUI)this.getUI()).getTable().getColumn(SpeciesFrequencyTableModel.LENGTH_STEP);
            String lengthStepLabelWithUnit = this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit);
            column.setHeaderValue((Object)lengthStepLabelWithUnit);
            column.setToolTipText(lengthStepLabelWithUnit);
            column = (TableColumnExt)((SpeciesFrequencyUI)this.getUI()).getObsTable().getColumn(IndividualObservationBatchTableModel.SIZE);
            column.setHeaderValue((Object)this.getLabelWithUnit(I18n.t((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), unit));
            column.setToolTipText(this.getLabelWithUnit(I18n.t((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), unit));
            this.frequenciesChart.getXYPlot().getDomainAxis().setLabel(lengthStepLabelWithUnit);
            this.averageWeightsChart.getXYPlot().getDomainAxis().setLabel(lengthStepLabelWithUnit);
        });
        model.addPropertyChangeListener("frequenciesConfigurationMode", evt -> {
            FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)((Object)evt.getNewValue()));
            SwingUtilities.invokeLater(() -> {
                JComponent componentToFocus = this.getComponentToFocus(newValue);
                if (componentToFocus != null) {
                    componentToFocus.grabFocus();
                }
                this.updateLogVisibility();
            });
        });
        model.addVetoableChangeListener("copyRtpWeights", evt -> {
            long rowsWithUserData;
            boolean newCopyRtpWeights = (Boolean)evt.getNewValue();
            if (newCopyRtpWeights && (rowsWithUserData = model.getRows().stream().filter(SpeciesFrequencyRowModel::withWeight).count()) > 0L) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.help", (Object[])new Object[0]));
                int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.title", (Object[])new Object[0]), 2, 3);
                if (i == 2) {
                    throw new PropertyVetoException("The user does not want to erase his data.", evt);
                }
            }
        });
        model.addPropertyChangeListener("copyRtpWeights", evt -> {
            ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).getRows().forEach(row -> ((SpeciesFrequencyUIModel)((Object)((Object)((Object)this.getModel())))).computeRowWeightWithRtp((SpeciesFrequencyRowModel)row));
            ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).reloadRows();
            this.getTableModel().fireTableDataChanged();
        });
        model.addPropertyChangeListener("individualObservationRows", evt -> this.getObsTableModel().setRows((List)evt.getNewValue()));
        model.addVetoableChangeListener("copyIndividualObservationMode", evt -> {
            long rowsWithUserData;
            SpeciesFrequencyUIModel source = (SpeciesFrequencyUIModel)((Object)((Object)evt.getSource()));
            CopyIndividualObservationMode oldCopyMode = (CopyIndividualObservationMode)evt.getOldValue();
            CopyIndividualObservationMode newCopyMode = (CopyIndividualObservationMode)evt.getNewValue();
            if (source.isInitBatchEdition()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Skip ask user to confirm copyIndividualObservationMode changed from " + oldCopyMode + " to " + newCopyMode));
                }
                return;
            }
            if (CopyIndividualObservationMode.ALL != oldCopyMode && (rowsWithUserData = oldCopyMode == CopyIndividualObservationMode.SIZE ? model.getRows().stream().filter(SpeciesFrequencyRowModel::withWeight).count() : model.getRows().stream().filter(row -> row.getLengthStep() != null || row.withNumber() || row.withWeight()).count()) > 0L) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.help", (Object[])new Object[0]));
                int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.title", (Object[])new Object[0]), 2, 3);
                if (i == 2) {
                    throw new PropertyVetoException("The user does not want to erase his data.", evt);
                }
            }
        });
        model.addPropertyChangeListener("copyIndividualObservationMode", evt -> {
            boolean nothingCopyMode;
            SpeciesFrequencyUIModel source = (SpeciesFrequencyUIModel)((Object)((Object)evt.getSource()));
            CopyIndividualObservationMode oldCopyMode = (CopyIndividualObservationMode)evt.getOldValue();
            CopyIndividualObservationMode newCopyMode = (CopyIndividualObservationMode)evt.getNewValue();
            if (newCopyMode == null) {
                return;
            }
            boolean bl = nothingCopyMode = CopyIndividualObservationMode.NOTHING == newCopyMode;
            if (!nothingCopyMode) {
                source.setFrequenciesConfigurationMode(FrequencyConfigurationMode.RAFALE);
                source.setAddIndividualObservationOnRafale(true);
            }
            if (source.isInitBatchEdition()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Skip recompute frequencies from indivudal observations (flag initBatchEdition is on), copyIndividualObservationMode changed from " + oldCopyMode + " to " + newCopyMode));
                }
                return;
            }
            model.setRowComputationInProgress(true);
            try {
                model.getRows().clear();
                model.getRowsInError().clear();
                model.reloadRows();
                model.recomputeIndividualObservationRowsValidateState();
                this.reloadRowsFromIndividualObservations();
            }
            finally {
                model.setRowComputationInProgress(false);
            }
            this.getTableModel().fireTableDataChanged();
            this.getObsTableModel().fireTableDataChanged();
        });
        ui.getSimpleCountingWeightField().setNumberPattern(this.weightUnit.getNumberEditorPattern());
        this.initFrequenciesHistogram();
        this.initDataTable();
        this.initAverageWeightsHistogram();
        this.initLogTable();
        this.initObsTable();
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
    }

    protected IndividualObservationBatchTableModel getObsTableModel() {
        return (IndividualObservationBatchTableModel)((Object)((SpeciesFrequencyUI)this.ui).getObsTable().getModel());
    }

    public void showAverageWeightsHistogram() {
        this.averageWeightsHistogramPopup.setVisible(true);
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getConfigurationMode();
        BeanFilterableComboBox<Caracteristic> componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequenciesHistogramPopup.dispose();
        this.averageWeightsHistogramPopup.dispose();
        this.resetSamplingLabels();
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.setValid(false);
        model.setSimpleCount(null);
        model.setModify(false);
        EditSpeciesBatchPanelUI parent = (EditSpeciesBatchPanelUI)this.getParentContainer(EditSpeciesBatchPanelUI.class);
        parent.switchToEditBatch();
        TuttiUIContext context = this.getContext();
        if (context.isIchtyometerConnected()) {
            context.getIchtyometerReader().removeFeedModeReaderListener(this.feedReaderListener);
        }
        this.individualObservationUICache.close();
        context.removeVetoableChangeListener("screen", this.changeScreenListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editBatch(SpeciesFrequencyCellComponent.FrequencyCellEditor editor, Optional<String> optionalTitle) {
        SpeciesBatchRowModel speciesBatch = editor.getEditRow();
        Objects.requireNonNull(speciesBatch, "Impossible d'\u00e9diter un lot non renseign\u00e9");
        if (this.maturityColumnId.isPresent()) {
            TableColumnExt maturityColumn = ((SpeciesFrequencyUI)this.ui).getObsTable().getColumnExt((Object)this.maturityColumnId.get());
            ((SpeciesFrequencyUI)this.ui).getObsTable().removeColumn((TableColumn)maturityColumn);
            this.maturityColumnId = Optional.empty();
        }
        if (optionalTitle.isPresent()) {
            String title = optionalTitle.get();
            this.frequenciesHistogramPopup.setTitle(title + I18n.t((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]));
            this.averageWeightsHistogramPopup.setTitle(title + this.weightUnit.decorateLabel(I18n.t((String)"tutti.editSpeciesFrequencies.field.graphAverageWeight", (Object[])new Object[0])));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.setInitBatchEdition(true);
        try {
            Integer number;
            String speciesLengthStepPmfmId;
            String lengthStepPmfmId;
            List<SpeciesFrequencyRowModel> previousFrequency;
            AbstractTuttiBeanUIModel rowModel;
            FrequencyConfigurationMode mode = FrequencyConfigurationMode.FREQUENCIES;
            FrequencyConfigurationMode frequenciesMode = FrequencyConfigurationMode.AUTO_GEN;
            model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
            model.setTotalNumber(null);
            model.setTotalComputedWeight(null);
            model.setTotalWeight(null);
            model.setSimpleCount(null);
            model.setMinStep(null);
            model.setMaxStep(null);
            model.setRtp(null);
            model.setCopyRtpWeights(false);
            model.setAddIndividualObservationOnRafale(false);
            this.frequencyEditor = editor;
            Caracteristic lengthStepCaracteristic = null;
            CopyIndividualObservationMode copyIndividualObservationMode = null;
            ArrayList<SpeciesFrequencyRowModel> rows = new ArrayList<SpeciesFrequencyRowModel>();
            ArrayList<IndividualObservationBatchRowModel> obsRows = new ArrayList<IndividualObservationBatchRowModel>();
            Species species = speciesBatch.getSpecies();
            IndividualObservationBatchTableModel obsTableModel = this.getObsTableModel();
            obsTableModel.setSpecies(species);
            String samplingCodeSeparator = this.getConfig().getSamplingCodeSeparator();
            obsTableModel.setSamplingCodePrefix(this.getConfig().getSamplingCodePrefix() + samplingCodeSeparator + this.decorate((Serializable)species, "withSurveyCodeNoName") + samplingCodeSeparator);
            model.setTotalWeight(speciesBatch.getWeight());
            Optional<String> speciesMaturityPmfmId = Optional.empty();
            TuttiProtocol protocol = this.getDataContext().getProtocol();
            if (protocol != null) {
                Integer referenceTaxonId = species.getReferenceTaxonId();
                Optional<SpeciesProtocol> optSpeciesProtocol = protocol.getSpecies().stream().filter(sp -> sp.getSpeciesReferenceTaxonId().equals(referenceTaxonId)).findFirst();
                if (optSpeciesProtocol.isPresent()) {
                    SpeciesProtocol speciesProtocol = optSpeciesProtocol.get();
                    CaracteristicQualitativeValue sampleCategoryValue = (CaracteristicQualitativeValue)speciesBatch.getSampleCategoryValue(this.sexCaracteristic.getIdAsInt());
                    Rtp rtp = sampleCategoryValue != null ? (Sexs.isMale((CaracteristicQualitativeValue)sampleCategoryValue) ? speciesProtocol.getRtpMale() : (Sexs.isFemale((CaracteristicQualitativeValue)sampleCategoryValue) ? speciesProtocol.getRtpFemale() : speciesProtocol.getRtpUndefined())) : speciesProtocol.getRtpUndefined();
                    model.setRtp(rtp);
                    speciesMaturityPmfmId = Optional.ofNullable(speciesProtocol.getMaturityPmfmId());
                }
            }
            List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
            List<IndividualObservationBatchRowModel> individualObservations = speciesBatch.getIndividualObservation();
            if (CollectionUtils.isNotEmpty(frequency)) {
                SpeciesFrequencyTableModel tableModel = this.getTableModel();
                for (SpeciesFrequencyRowModel rowModel2 : frequency) {
                    SpeciesFrequencyRowModel newRow = tableModel.createNewRow(false, false);
                    newRow.copy(rowModel2);
                    rows.add(newRow);
                }
                SpeciesFrequencyRowModel rowModel3 = frequency.get(0);
                lengthStepCaracteristic = rowModel3.getLengthStepCaracteristic();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
                }
            }
            Optional<Caracteristic> maturityCaracteristic = speciesMaturityPmfmId.map(this.maturityCaracteristics::get);
            this.setMaturityCaracteristic(maturityCaracteristic);
            if (CollectionUtils.isNotEmpty(individualObservations)) {
                IndividualObservationBatchTableModel tableModel = this.getObsTableModel();
                tableModel.setRows(new ArrayList());
                int rankOrder = 1;
                for (IndividualObservationBatchRowModel rowModel4 : individualObservations) {
                    CopyIndividualObservationMode incomingCopyIndividualObservationMode = rowModel4.getCopyIndividualObservationMode();
                    Objects.requireNonNull(incomingCopyIndividualObservationMode, "Mode de recopie non trouv\u00e9 sur l'observation individuelle: " + rowModel4.getId());
                    if (copyIndividualObservationMode == null) {
                        copyIndividualObservationMode = incomingCopyIndividualObservationMode;
                    } else if (copyIndividualObservationMode != incomingCopyIndividualObservationMode) {
                        throw new IllegalStateException("Plusieurs modes de recopie trouv\u00e9s sur les observations individuelles du lot, ce qui est impossible");
                    }
                    IndividualObservationBatchRowModel newRow = tableModel.createNewRow();
                    newRow.copy(rowModel4);
                    newRow.setRankOrder(rankOrder++);
                    newRow.addPropertyChangeListener(this.obsChangedListener);
                    newRow.setValid(true);
                    if (maturityCaracteristic.isPresent()) {
                        Caracteristic caracteristicKey = maturityCaracteristic.get();
                        Serializable caracteristicValue = (Serializable)newRow.getCaracteristics().remove((Object)caracteristicKey);
                        newRow.getDefaultCaracteristics().putIfAbsent((Object)caracteristicKey, (Object)caracteristicValue);
                    }
                    obsRows.add(newRow);
                }
                if (lengthStepCaracteristic == null) {
                    rowModel = individualObservations.get(0);
                    lengthStepCaracteristic = ((IndividualObservationBatchRowModel)rowModel).getLengthStepCaracteristic();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
                    }
                }
            } else {
                copyIndividualObservationMode = CopyIndividualObservationMode.NOTHING;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("CopyIndividualObservationMode: " + copyIndividualObservationMode));
            }
            SpeciesBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = ((SpeciesFrequencyRowModel)rowModel).getLengthStepCaracteristic();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
                }
            }
            if (lengthStepCaracteristic == null && (lengthStepPmfmId = this.taxonCache.getLengthStepPmfmId(species)) != null) {
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
                }
            }
            if (lengthStepCaracteristic == null && (speciesLengthStepPmfmId = this.taxonCache.getLengthStepPmfmId(species)) == null) {
                mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("FrequencyConfigurationMode: " + (Object)((Object)mode)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + rows.size() + " frequency"));
            }
            if ((number = speciesBatch.getNumber()) != null && rows.isEmpty()) {
                mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
                model.setSimpleCount(number);
            }
            model.setConfigurationMode(null);
            model.setConfigurationMode(mode);
            model.setFrequenciesConfigurationMode(null);
            model.setFrequenciesConfigurationMode(frequenciesMode);
            ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
            Collections.sort(rows);
            model.setLengthStepCaracteristic(lengthStepCaracteristic);
            model.setRows(rows);
            CaracteristicMap sampleCategoryValues = new CaracteristicMap();
            Iterator<SampleCategory<?>> iterator = speciesBatch.iterator();
            iterator.forEachRemaining(sampleCategory -> {
                Caracteristic caracteristic = sampleCategory.getCategoryDef().getCaracteristic();
                sampleCategoryValues.put(caracteristic, sampleCategory.getCategoryValue());
            });
            obsTableModel.setDefaultCaracteristicValues(sampleCategoryValues);
            model.setIndividualObservationRows(obsRows);
            obsTableModel.setRows(obsRows);
            model.recomputeIndividualObservationRowsValidateState();
            model.setBatch(speciesBatch);
            model.setCopyIndividualObservationMode(null);
            model.setCopyIndividualObservationMode(copyIndividualObservationMode);
            model.computeRowWeightWithRtp();
            if (this.getContext().isIchtyometerConnected()) {
                this.listenItchtyometer();
            }
            this.individualObservationUICache.init((SpeciesFrequencyUI)this.ui, this.frequencyEditor.getEditRow(), this.getDataContext().getFishingOperation());
            model.setModify(false);
            this.getContext().addVetoableChangeListener("screen", this.changeScreenListener);
        }
        finally {
            model.setInitBatchEdition(false);
            model.setModify(false);
        }
    }

    public boolean askCancelEditBeforeLeaving() {
        String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.askToCancelEditFrequencies.message", (Object[])new Object[0]), I18n.t((String)"tutti.askToCancelEditFrequencies.help", (Object[])new Object[0]));
        int saveResponse = JOptionPane.showOptionDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.askToCancelEditFrequencies.title", (Object[])new Object[0]), 2, 3, null, new String[]{I18n.t((String)"tutti.option.continue", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cancel", (Object[])new Object[0]));
        return saveResponse == 0;
    }

    public IndividualObservationUICache getIndividualObservationUICache() {
        return this.individualObservationUICache;
    }

    public void updateFrequencyRowsNumbers(Float lengthStepToDec, Float lengthStepToInc) {
        SpeciesFrequencyRowModel row;
        if (log.isInfoEnabled()) {
            log.info((Object)("updateFrequencyRowsNumbers " + lengthStepToDec + ", " + lengthStepToInc));
        }
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        if (lengthStepToDec != null) {
            lengthStepToDec = Float.valueOf(((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStep(lengthStepToDec.floatValue()));
            row = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRowCache().get(lengthStepToDec);
            if (row != null) {
                row.decNumber();
                if (!row.withNumber()) {
                    int rowIndex = tableModel.getRowIndex((Serializable)((Object)row));
                    tableModel.removeRow(rowIndex);
                    ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRowCache().remove(lengthStepToDec);
                } else {
                    tableModel.updateRow((Serializable)((Object)row));
                }
            }
        }
        if (lengthStepToInc != null) {
            lengthStepToInc = Float.valueOf(((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStep(lengthStepToInc.floatValue()));
            row = this.getRowForLengthstep(lengthStepToInc.floatValue());
            row.incNumber();
            tableModel.updateRow((Serializable)((Object)row));
        }
    }

    public void updateFrequencyRowsWeights(Float lengthStep, Float weight) {
        if (log.isInfoEnabled()) {
            log.info((Object)("updateFrequencyRowsWeights " + lengthStep + ", " + weight));
        }
        if (lengthStep != null && weight != null) {
            SpeciesFrequencyTableModel tableModel = this.getTableModel();
            lengthStep = Float.valueOf(((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStep(lengthStep.floatValue()));
            SpeciesFrequencyRowModel row = this.getRowForLengthstep(lengthStep.floatValue());
            weight = this.weightUnit.convertWeight(weight, this.getConfig().getIndividualObservationWeightUnit());
            row.addToWeight(weight.floatValue());
            if (Weights.isNullOrZero((Float)row.getWeight())) {
                int rowIndex = tableModel.getRowIndex((Serializable)((Object)row));
                tableModel.removeRow(rowIndex);
                ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRowCache().remove(lengthStep);
            } else {
                tableModel.updateRow((Serializable)((Object)row));
            }
        }
    }

    protected void initDataTable() {
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        TableCellRenderer renderer = (table1, value, isSelected, hasFocus, row, column) -> {
            Component result = table1.getDefaultRenderer(Number.class).getTableCellRendererComponent(table1, value, isSelected, hasFocus, row, column);
            if (result instanceof JLabel) {
                JLabel jLabel = (JLabel)result;
                jLabel.setHorizontalTextPosition(4);
                jLabel.setForeground(computedDataColor);
                jLabel.setFont(jLabel.getFont().deriveFont(2));
            }
            return result;
        };
        this.addColumnToModel((TableColumnModel)columnModel, null, renderer, SpeciesFrequencyTableModel.RTP_COMPUTED_WEIGHT, this.weightUnit);
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(this.weightUnit, this.getConfig().getIndividualObservationWeightUnit(), (TableColumnModelExt)columnModel, (SpeciesFrequencyUIModel)((Object)this.getModel()));
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        HighlightPredicate.NotHighlightPredicate notSelectedPredicate = new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED);
        HighlightPredicate weightTooDifferentFromRtpPredicate = (renderer, adapter) -> {
            boolean result = false;
            if (table.getModel() instanceof SpeciesFrequencyTableModel) {
                SpeciesFrequencyTableModel tableModel = (SpeciesFrequencyTableModel)((Object)((Object)table.getModel()));
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)((Object)tableModel.getEntry(modelRow));
                Float rate = this.getConfig().getDifferenceRateBetweenWeightAndRtpWeight();
                result = row.withWeight() && row.withRtpComputedWeight() && Math.abs(row.getWeight().floatValue() - row.getRtpComputedWeight().floatValue()) >= row.getWeight().floatValue() * rate.floatValue() / 100.0f;
            }
            return result;
        };
        Highlighter weightTooDifferentFromRtpHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{notSelectedPredicate, weightTooDifferentFromRtpPredicate}), (Color)this.getConfig().getColorWarningRow());
        table.addHighlighter(weightTooDifferentFromRtpHighlighter);
        Highlighter weightTooDifferentFromRtpSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, weightTooDifferentFromRtpPredicate}), (Color)this.getConfig().getColorWarningRow().darker());
        table.addHighlighter(weightTooDifferentFromRtpSelectedHighlighter);
    }

    protected void initFrequenciesHistogram() {
        this.frequenciesChart = ChartFactory.createXYBarChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (boolean)false, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (IntervalXYDataset)((SpeciesFrequencyUIModel)((Object)this.getModel())).frequenciesDataset);
        this.frequenciesChart.clearSubtitles();
        ValueAxis rangeAxis = this.frequenciesChart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource(true));
        ValueAxis domainAxis = this.frequenciesChart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        this.frequenciesChart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)this.getConfig().getColorComputedWeights());
        ChartPanel chartPanel = new ChartPanel(this.frequenciesChart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        JPanel histogramPanel = ((SpeciesFrequencyUI)this.ui).getHistogramPanel();
        histogramPanel.add((Component)chartPanel, "Center");
        chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() > 1) {
                    SpeciesFrequencyUIHandler.this.frequenciesHistogramPopup.getContentPane().removeAll();
                    ChartPanel chartPanel = new ChartPanel(SpeciesFrequencyUIHandler.this.frequenciesChart);
                    SpeciesFrequencyUIHandler.this.frequenciesHistogramPopup.getContentPane().add((Component)chartPanel);
                    SpeciesFrequencyUIHandler.this.frequenciesHistogramPopup.pack();
                    SpeciesFrequencyUIHandler.this.frequenciesHistogramPopup.setVisible(true);
                }
            }
        });
    }

    protected void initAverageWeightsHistogram() {
        this.averageWeightsChart = ChartFactory.createXYLineChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)this.getConfig().getIndividualObservationWeightUnit().decorateLabel(I18n.t((String)"tutti.editSpeciesFrequencies.averageWeight.label", (Object[])new Object[0])), (XYDataset)((SpeciesFrequencyUIModel)((Object)this.getModel())).averageWeightsDataset);
        this.averageWeightsChart.clearSubtitles();
        ValueAxis rangeAxis = this.averageWeightsChart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource());
        rangeAxis.setMinorTickMarksVisible(true);
        ValueAxis domainAxis = this.averageWeightsChart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)this.averageWeightsChart.getXYPlot().getRenderer();
        plotRenderer.setSeriesPaint(0, (Paint)this.getConfig().getColorComputedWeights());
        plotRenderer.setBaseShapesVisible(true);
        ChartPanel chartPanel = new ChartPanel(this.averageWeightsChart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        this.averageWeightsHistogramPopup.getContentPane().add((Component)chartPanel);
        this.averageWeightsHistogramPopup.pack();
    }

    protected void initLogTable() {
        JXTable logTable = ((SpeciesFrequencyUI)this.ui).getLogsTable();
        DefaultTableColumnModelExt logColumnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)logColumnModel, SpeciesFrequencyLogCellComponent.newEditor((SpeciesFrequencyUI)this.ui), SpeciesFrequencyLogCellComponent.newRender(), SpeciesFrequencyLogsTableModel.LABEL);
        SpeciesFrequencyLogsTableModel logTableModel = new SpeciesFrequencyLogsTableModel((TableColumnModelExt)logColumnModel);
        logTableModel.setRows(new ArrayList());
        logTable.setModel((TableModel)((Object)logTableModel));
        logTable.setColumnModel((TableColumnModel)logColumnModel);
        logTable.getTableHeader().setReorderingAllowed(false);
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.ODD, (Color)this.getConfig().getColorAlternateRow());
        logTable.addHighlighter(evenHighlighter);
    }

    protected void initObsTable() {
        JXTable obsTable = ((SpeciesFrequencyUI)this.ui).getObsTable();
        obsTable.setColumnControlVisible(true);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.RANK, "\\d{0,10}", (JTable)obsTable);
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SIZE, "\\d{0,6}(\\.\\d{0,3})?", (JTable)obsTable);
        WeightUnit individualObservationWeightUnit = this.getConfig().getIndividualObservationWeightUnit();
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.WEIGHT, individualObservationWeightUnit, (JTable)obsTable);
        List<Caracteristic> defaultCaracteristic = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getDefaultCaracteristic();
        for (Caracteristic caracteristic : defaultCaracteristic) {
            this.addCaracteristicColumnToModel(obsTable, (TableColumnModelExt)columnModel, caracteristicDecorator, caracteristicTipDecorator, caracteristicQualitativeDecorator, caracteristic);
        }
        Set<Caracteristic> caracteristicsToSkip = Collections.unmodifiableSet(Sets.newHashSet(((SpeciesFrequencyUIModel)((Object)this.getModel())).getDefaultCaracteristic()));
        this.addColumnToModel((TableColumnModel)columnModel, CaracteristicMapCellComponent.newEditor((TuttiUI)this.ui, caracteristicsToSkip), CaracteristicMapCellComponent.newRender(this.getContext()), IndividualObservationBatchTableModel.OTHER_CARACTERISTICS);
        this.addColumnToModel((TableColumnModel)columnModel, SamplingCodeCellEditor.newEditor((TuttiUI)this.ui), SamplingCodeCellRenderer.newRender(), IndividualObservationBatchTableModel.SAMPLING_CODE);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor((TuttiUI)this.ui), CommentCellRenderer.newRender(), IndividualObservationBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor((TuttiUI)this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), IndividualObservationBatchTableModel.ATTACHMENT);
        IndividualObservationBatchTableModel tableModel = new IndividualObservationBatchTableModel(individualObservationWeightUnit, defaultCaracteristic, (TableColumnModelExt)columnModel);
        obsTable.setModel((TableModel)((Object)tableModel));
        obsTable.setColumnModel((TableColumnModel)columnModel);
        this.initTable(obsTable);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{IndividualObservationBatchTableModel.COMMENT}), (renderer, adapter) -> {
            String value = (String)adapter.getValue();
            return StringUtils.isNotBlank((CharSequence)value);
        }}), (Color)cellWithValueColor);
        obsTable.addHighlighter(commentHighlighter);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)obsTable);
        tableModel.addTableModelListener(e -> {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            switch (e.getType()) {
                case -1: {
                    if (tableModel.getRowCount() == 0) {
                        tableModel.addNewRow();
                        break;
                    }
                    for (int i = firstRow; i < tableModel.getRowCount(); ++i) {
                        ((IndividualObservationBatchRowModel)tableModel.getRows().get(i)).setRankOrder(i + 1);
                    }
                    break;
                }
                case 1: {
                    for (int i = firstRow; i <= lastRow; ++i) {
                        IndividualObservationBatchRowModel newRow = (IndividualObservationBatchRowModel)tableModel.getRows().get(i);
                        newRow.addPropertyChangeListener(this.obsChangedListener);
                        if (((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).mustCopyIndividualObservationSize()) {
                            this.updateFrequencyRowsNumbers(null, newRow.getSize());
                        }
                        ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).recomputeIndividualObservationRowValidState(newRow);
                    }
                    break;
                }
                case 0: {
                    if (tableModel.getRowCount() != 0) break;
                    tableModel.addNewRow();
                }
            }
            ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).recomputeCanEditLengthStep();
        });
    }

    protected void resetSamplingLabels() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"reset smapling panel");
        }
        ((SpeciesFrequencyUI)this.ui).getSamplingWarningLabel().setVisible(false);
        ((SpeciesFrequencyUI)this.ui).getSamplingResumeLabel().setText(null);
    }

    public void setMaturityCaracteristic(Optional<Caracteristic> maturityCaracteristic) {
        this.getObsTableModel().setMaturityCaracteristic(maturityCaracteristic);
        if (maturityCaracteristic.isPresent()) {
            this.addMaturityCaracteristicColumnToModel(maturityCaracteristic.get());
        }
    }

    protected void addMaturityCaracteristicColumnToModel(Caracteristic caracteristic) {
        Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        ((SpeciesFrequencyUI)this.ui).getObsTable().setRowSorter(null);
        ((SpeciesFrequencyUI)this.ui).getObsTable().setAutoCreateRowSorter(false);
        TableColumnModelExt columnModel = (TableColumnModelExt)((SpeciesFrequencyUI)this.ui).getObsTable().getColumnModel();
        this.maturityColumnId = Optional.of(this.addCaracteristicColumnToModel(((SpeciesFrequencyUI)this.ui).getObsTable(), columnModel, caracteristicDecorator, caracteristicTipDecorator, caracteristicQualitativeDecorator, caracteristic));
        int otherCaracteristicsIndex = columnModel.getColumnExt(IndividualObservationBatchTableModel.OTHER_CARACTERISTICS).getModelIndex();
        ((SpeciesFrequencyUI)this.ui).getObsTable().moveColumn(columnModel.getColumnCount() - 1, otherCaracteristicsIndex);
        ((SpeciesFrequencyUI)this.ui).getObsTable().setAutoCreateRowSorter(true);
    }

    protected CaracteristicColumnIdentifier addCaracteristicColumnToModel(JXTable table, TableColumnModelExt columnModel, Decorator<Caracteristic> caracteristicDecorator, Decorator<Caracteristic> caracteristicTipDecorator, Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator, Caracteristic caracteristic) {
        String headerTip;
        String header = caracteristicDecorator.toString((Object)caracteristic);
        CaracteristicColumnIdentifier id = CaracteristicColumnIdentifier.newCaracteristicId(caracteristic, "defaultCaracteristics", header, headerTip = caracteristicTipDecorator.toString((Object)caracteristic));
        if (columnModel.getColumnExt((Object)id) == null) {
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    this.addFloatColumnToModel((TableColumnModel)columnModel, id, "\\d{0,6}(\\.\\d{0,3})?", (JTable)table);
                    break;
                }
                case QUALITATIVE: {
                    List values = caracteristic.getQualitativeValue();
                    this.addComboDataColumnToModel((TableColumnModel)columnModel, id, caracteristicQualitativeDecorator, values);
                    break;
                }
                case TEXT: {
                    this.addColumnToModel((TableColumnModel)columnModel, id);
                }
            }
        }
        return id;
    }

    protected void consumeFeedRecord(FeedReaderMeasureRecord record) {
        if (!record.isValid()) {
            SoundEngine soundEngine = this.getContext().getSoundEngine();
            soundEngine.beepOnIchtyometerErrorReception();
            throw new ApplicationBusinessException(I18n.t((String)"tutti.editSpeciesFrequencies.error.itchyometer.bad.record", (Object[])new Object[]{record.getRecord()}));
        }
        String unit = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristicUnit();
        float length = "mm".equals(unit) ? (float)record.getMeasure() : (float)record.getMeasure() / 10.0f;
        this.applySpeciesFrequencyRafaleAction.applyRafaleStep(Float.valueOf(length), true);
    }

    protected void listenItchtyometer() {
        this.getContext().getIchtyometerReader().removeAllFeedModeReaderListeners();
        if (log.isInfoEnabled()) {
            log.info((Object)"Start listen ichtyometer");
        }
        this.getContext().getIchtyometerReader().addFeedModeReaderListener(this.feedReaderListener);
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        BeanFilterableComboBox<Caracteristic> componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getSimpleCountingNumberField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected float getStep(Caracteristic caracteristic) {
        Float precision = null;
        if (caracteristic != null) {
            precision = caracteristic.getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        return precision.floatValue();
    }

    protected void updateLogVisibility() {
        boolean logVisible = ((SpeciesFrequencyUIModel)((Object)this.getModel())).isRafaleMode() || this.getContext().isIchtyometerConnected();
        JSplitPane firstSplitPane = ((SpeciesFrequencyUI)this.ui).getFirstSplitPane();
        JSplitPane secondSplitPane = ((SpeciesFrequencyUI)this.ui).getSecondSplitPane();
        int lastDividerLocation = secondSplitPane.getLastDividerLocation();
        if (lastDividerLocation == 0) {
            lastDividerLocation = 200;
        }
        secondSplitPane.setDividerLocation(logVisible ? lastDividerLocation : 0);
        secondSplitPane.setDividerSize(logVisible ? firstSplitPane.getDividerSize() : 0);
        ((SpeciesFrequencyUI)this.ui).getLogsScrollPane().setVisible(logVisible);
    }

    protected String getLabelWithUnit(String label, String unit) {
        return label + " (" + unit + ")";
    }

    protected SpeciesFrequencyRowModel getRowForLengthstep(float lengthstep) {
        Map<Float, SpeciesFrequencyRowModel> rowCache = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRowCache();
        SpeciesFrequencyRowModel row = rowCache.get(Float.valueOf(lengthstep));
        if (row == null) {
            row = this.getTableModel().createNewRow();
            row.setLengthStep(Float.valueOf(lengthstep));
            rowCache.put(Float.valueOf(lengthstep), row);
            ArrayList steps = Lists.newArrayList(rowCache.keySet());
            steps.add(Float.valueOf(lengthstep));
            Collections.sort(steps);
            int indexToInsert = steps.indexOf(Float.valueOf(lengthstep));
            this.getTableModel().addNewRow(indexToInsert, (Serializable)((Object)row));
        }
        return row;
    }

    protected void reloadRowsFromIndividualObservations() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        CopyIndividualObservationMode copyMode = model.getCopyIndividualObservationMode();
        if (CopyIndividualObservationMode.NOTHING != copyMode) {
            Caracteristic lengthStepCaracteristic = model.getLengthStepCaracteristic();
            ArrayList<IndividualObservationBatchRowModel> validObsRow = new ArrayList<IndividualObservationBatchRowModel>(model.getIndividualObservationRows());
            validObsRow.removeAll(model.getIndividualObservationRowsInError());
            WeightUnit individualObservationWeightUnit = this.getConfig().getIndividualObservationWeightUnit();
            for (IndividualObservationBatchRowModel obsRow : validObsRow) {
                SpeciesFrequencyRowModel row;
                Float size = obsRow.getSize();
                if (size == null) continue;
                size = Float.valueOf(model.getLengthStep(size.floatValue()));
                if (log.isInfoEnabled()) {
                    log.info((Object)("size : " + size));
                }
                if ((row = model.getRowCache().get(size)) == null) {
                    row = this.getTableModel().createNewRow(false, true);
                    row.setLengthStep(size);
                    row.setLengthStepCaracteristic(lengthStepCaracteristic);
                    model.getRows().add(row);
                    model.getRowCache().put(size, row);
                }
                row.incNumber();
                Float weight = obsRow.getWeight();
                if (CopyIndividualObservationMode.ALL != copyMode || weight == null) continue;
                weight = this.weightUnit.convertWeight(weight, individualObservationWeightUnit);
                row.addToWeight(weight.floatValue());
            }
            if (model.getRowCount() == 0) {
                this.getTableModel().addNewRow();
            } else {
                Collections.sort(model.getRows());
            }
        } else if (this.getTableModel().getRowCount() == 0) {
            this.getTableModel().addNewRow();
        }
        model.reloadRows();
    }

    public <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        super.initBeanFilterableComboBox(comboBox, data, selectedData);
    }

    public SpeciesFrequencyCellComponent.FrequencyCellEditor getFrequencyEditor() {
        return this.frequencyEditor;
    }

    protected void beforeOpenPopup(int modelRowIndex, int modelColumnIndex) {
        super.beforeOpenPopup(modelRowIndex, modelColumnIndex);
        boolean sampleCodeMenusEnabled = modelRowIndex >= 1 && ((SpeciesFrequencyUI)this.ui).getObsTable().getSelectedRowCount() == 1 && ((IndividualObservationBatchRowModel)this.getObsTableModel().getRows().get(((SpeciesFrequencyUI)this.ui).getObsTable().getSelectedRow())).withSamplingCodeId();
        ((SpeciesFrequencyUI)this.ui).getEditSampleCodeMenu().setEnabled(sampleCodeMenusEnabled);
        ((SpeciesFrequencyUI)this.ui).getDeleteSampleCodeMenu().setEnabled(sampleCodeMenusEnabled);
    }
}

