/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.util.Weights;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SpeciesFrequencyRowModel
extends AbstractTuttiBeanUIModel<SpeciesBatchFrequency, SpeciesFrequencyRowModel>
implements SpeciesBatchFrequency,
Comparable<SpeciesFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_LENGTH_STEP = "lengthStep";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_RTP_COMPUTED_WEIGHT = "rtpComputedWeight";
    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    protected Float lengthStep;
    protected Integer number;
    protected Float weight;
    protected Float rtpComputedWeight;
    protected Caracteristic lengthStepCaracteristic;
    protected final WeightUnit weightUnit;
    protected static final Binder<SpeciesBatchFrequency, SpeciesFrequencyRowModel> fromBeanBinder = BinderFactory.newBinder(SpeciesBatchFrequency.class, SpeciesFrequencyRowModel.class);
    protected static final Binder<SpeciesFrequencyRowModel, SpeciesBatchFrequency> toBeanBinder = BinderFactory.newBinder(SpeciesFrequencyRowModel.class, SpeciesBatchFrequency.class);
    private static final Ordering<Float> ordering = Ordering.natural().nullsFirst();

    public static List<SpeciesFrequencyRowModel> fromEntity(WeightUnit weightUnit, List<SpeciesBatchFrequency> entities) {
        ArrayList result = Lists.newArrayList();
        for (SpeciesBatchFrequency entity : entities) {
            SpeciesFrequencyRowModel row = new SpeciesFrequencyRowModel(weightUnit);
            row.fromEntity(entity);
            result.add(row);
        }
        return result;
    }

    public static List<SpeciesBatchFrequency> toEntity(List<SpeciesFrequencyRowModel> rows, SpeciesBatch batch) {
        ArrayList result = Lists.newArrayList();
        for (SpeciesFrequencyRowModel row : rows) {
            SpeciesBatchFrequency entity = row.toEntity();
            entity.setBatch(batch);
            result.add(entity);
        }
        return result;
    }

    public SpeciesFrequencyRowModel(WeightUnit weightUnit) {
        super(fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
    }

    @Override
    protected SpeciesBatchFrequency newEntity() {
        return SpeciesBatchFrequencys.newSpeciesBatchFrequency();
    }

    @Override
    public void fromEntity(SpeciesBatchFrequency entity) {
        super.fromEntity(entity);
        this.setWeight(this.weightUnit.fromEntity(this.getWeight()));
    }

    @Override
    public SpeciesBatchFrequency toEntity() {
        SpeciesBatchFrequency result = (SpeciesBatchFrequency)super.toEntity();
        result.setWeight(this.weightUnit.toEntity(this.getWeight()));
        return result;
    }

    public Float getLengthStep() {
        return this.lengthStep;
    }

    public void setLengthStep(Float lengthStep) {
        Float oldValue = this.getLengthStep();
        this.lengthStep = lengthStep;
        this.firePropertyChange(PROPERTY_LENGTH_STEP, oldValue, lengthStep);
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        Integer oldValue = this.getNumber();
        this.number = number;
        this.firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    public boolean withNumber() {
        return this.number != null && this.number > 0;
    }

    public void incNumber() {
        if (this.number == null) {
            this.number = 0;
        }
        this.setNumber(this.number + 1);
    }

    public void decNumber() {
        this.decNumber(1);
    }

    public void decNumber(int nb) {
        if (this.number != null && this.number >= nb) {
            this.setNumber(this.number - nb);
        }
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.weight = weight;
        this.firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public boolean withWeight() {
        Float weight = this.getWeight();
        return Weights.isNotNullNorZero((Float)weight);
    }

    public void addToWeight(float weightToAdd) {
        if (this.weight == null) {
            this.weight = Float.valueOf(0.0f);
        }
        if (this.weight.floatValue() + weightToAdd >= 0.0f) {
            this.setWeight(Float.valueOf(this.weight.floatValue() + weightToAdd));
        }
    }

    public Float getRtpComputedWeight() {
        return this.rtpComputedWeight;
    }

    public void setRtpComputedWeight(Float rtpComputedWeight) {
        Float oldValue = this.getRtpComputedWeight();
        this.rtpComputedWeight = rtpComputedWeight;
        this.firePropertyChange(PROPERTY_RTP_COMPUTED_WEIGHT, oldValue, rtpComputedWeight);
    }

    public boolean withRtpComputedWeight() {
        return this.rtpComputedWeight != null;
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
    }

    public SpeciesBatch getBatch() {
        return null;
    }

    public void setBatch(SpeciesBatch batch) {
    }

    @Override
    public int compareTo(SpeciesFrequencyRowModel o) {
        return ordering.compare((Object)this.lengthStep, (Object)o.lengthStep);
    }

    public Integer getRankOrder() {
        return null;
    }

    public void setRankOrder(Integer rankOrder) {
    }

    public boolean isBenthosFrequencyBatch() {
        return false;
    }

    public void setBenthosFrequencyBatch(boolean benthosFrequencyBatch) {
    }

    public boolean isEmpty() {
        return this.lengthStep == null && (this.weight == null || this.number == null);
    }

    public Float computeAverageWeight() {
        Float averageWeight = null;
        if (this.withWeight() && this.withNumber()) {
            averageWeight = Float.valueOf(this.weight.floatValue() / (float)this.number.intValue());
        }
        return averageWeight;
    }

    public void copy(SpeciesFrequencyRowModel source) {
        this.setLengthStepCaracteristic(source.getLengthStepCaracteristic());
        this.setLengthStep(source.getLengthStep());
        this.setNumber(source.getNumber());
        this.setWeight(source.getWeight());
    }
}

