/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinitions;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.samplingCache.CruiseSamplingCache;
import fr.ifremer.tutti.service.samplingCache.SamplingEvent;
import fr.ifremer.tutti.service.samplingCache.SamplingListener;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class IndividualObservationUICache
implements Closeable {
    private static final Log log = LogFactory.getLog(IndividualObservationUICache.class);
    private final SamplingListener samplingListener;
    private final Optional<CruiseSamplingCache> samplingCache;
    private final Caracteristic sexCaracteristic;
    private final SpeciesFrequencyUIModel uiModel;
    private SpeciesBatchRowModel speciesEditRow;
    private FishingOperation fishingOperation;
    private Species species;
    private SpeciesFrequencyUI ui;
    private boolean on;

    public IndividualObservationUICache(final Optional<CruiseSamplingCache> samplingCache, final SpeciesFrequencyUIModel uiModel, Caracteristic sexCaracteristic) {
        this.samplingCache = samplingCache;
        this.uiModel = uiModel;
        this.sexCaracteristic = sexCaracteristic;
        this.uiModel.addPropertyChangeListener("initBatchEdition", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue = (Boolean)evt.getNewValue();
                if (newValue.booleanValue()) {
                    IndividualObservationUICache.this.on = false;
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Cache is off while loading ui model.");
                    }
                } else {
                    IndividualObservationUICache.this.on = samplingCache.isPresent();
                    if (log.isInfoEnabled()) {
                        if (IndividualObservationUICache.this.on) {
                            log.info((Object)"Cache is on : ui model loading is done and sampling cache is present");
                        } else {
                            log.info((Object)"Cache is off : ui model loading is done bu not sampling cache present");
                        }
                    }
                }
            }
        });
        this.samplingListener = new SamplingListener(){

            public void samplingNeeded(SamplingEvent event) {
                boolean showSamplingWarning;
                CalcifiedPiecesSamplingDefinition cpsDef = event.getCpsDef();
                if (log.isInfoEnabled()) {
                    log.info((Object)("samplingNeeded for " + cpsDef));
                }
                int nbForOperation = event.getNbForOperation();
                int nbForZone = event.getNbForZone();
                int nbForCruise = event.getNbForCruise();
                Integer operationLimitation = cpsDef.getOperationLimitation();
                Integer zoneLimitation = cpsDef.getZoneLimitation();
                Integer maxByLenghtStep = cpsDef.getMaxByLenghtStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("nbForOperation: %d/%s - nbForZone: %d/%s - nbForCruise: %d/%s", nbForOperation, operationLimitation == null ? "\u221e" : operationLimitation, nbForZone, zoneLimitation == null ? "\u221e" : zoneLimitation, nbForCruise, maxByLenghtStep == null ? "\u221e" : maxByLenghtStep));
                }
                boolean operationValueUpperMax = CalcifiedPiecesSamplingDefinitions.isOperationValueUpperMax((CalcifiedPiecesSamplingDefinition)cpsDef, (int)nbForOperation);
                boolean zoneValueUpperMax = CalcifiedPiecesSamplingDefinitions.isZoneValueUpperMax((CalcifiedPiecesSamplingDefinition)cpsDef, (int)nbForZone);
                boolean cruiseValueUpperMax = CalcifiedPiecesSamplingDefinitions.isCruiseValueUpperMax((CalcifiedPiecesSamplingDefinition)cpsDef, (int)nbForCruise);
                boolean bl = showSamplingWarning = !operationValueUpperMax && !zoneValueUpperMax && !cruiseValueUpperMax;
                if (log.isInfoEnabled()) {
                    log.info((Object)("showSamplingWarning " + showSamplingWarning));
                }
                IndividualObservationUICache.this.ui.getSamplingWarningLabel().setVisible(showSamplingWarning);
                String nbForOperationLabel = this.getLabelForSamplingNumber(operationValueUpperMax, nbForOperation, operationLimitation);
                String nbForZoneLabel = this.getLabelForSamplingNumber(zoneValueUpperMax, nbForZone, zoneLimitation);
                String nbForCruiseLabel = this.getLabelForSamplingNumber(cruiseValueUpperMax, nbForCruise, maxByLenghtStep);
                String key = event.getLengthStep() + " " + uiModel.getLengthStepCaracteristicUnit();
                if (event.getGender() != null) {
                    key = key + " " + event.getGender().getDescription();
                }
                if (event.getMaturity() != null) {
                    key = event.getMaturity() != false ? key + " " + I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.mature", (Object[])new Object[0]) : key + " " + I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.immature", (Object[])new Object[0]);
                }
                IndividualObservationUICache.this.ui.getSamplingResumeLabel().setText(I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.resume", (Object[])new Object[]{key, nbForOperationLabel, nbForZoneLabel, nbForCruiseLabel}));
            }

            String getLabelForSamplingNumber(boolean valueUpperMax, int value, Integer max) {
                String result = valueUpperMax ? I18n.t((String)"tutti.editSpeciesFrequencies.samplingNeeded.max", (Object[])new Object[0]) : String.valueOf(Math.max(0, value - 1));
                return result;
            }
        };
    }

    public void init(SpeciesFrequencyUI ui, SpeciesBatchRowModel speciesEditRow, FishingOperation fishingOperation) {
        Objects.requireNonNull(ui);
        Objects.requireNonNull(speciesEditRow);
        Objects.requireNonNull(speciesEditRow.getSpecies());
        Objects.requireNonNull(fishingOperation);
        this.ui = ui;
        this.speciesEditRow = speciesEditRow;
        this.species = speciesEditRow.getSpecies();
        this.fishingOperation = fishingOperation;
        if (this.samplingCache.isPresent()) {
            this.samplingCache.get().addSamplingListener(this.samplingListener);
        }
    }

    @Override
    public void close() {
        this.ui = null;
        this.speciesEditRow = null;
        this.species = null;
        this.fishingOperation = null;
        if (this.samplingCache.isPresent()) {
            this.samplingCache.get().removeSamplingListener(this.samplingListener);
        }
    }

    public void increments(IndividualObservationBatchRowModel row) {
        this.increments(row.getGender(this.sexCaracteristic), row.getMaturityState(), row.getSize().floatValue());
    }

    public void increments(CaracteristicQualitativeValue gender, Optional<CaracteristicQualitativeValue> maturityQualitativeValue, float lengthStep) {
        if (!this.on) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache is off, skip increments individual observations in cache.");
            }
            return;
        }
        Boolean maturity = this.samplingCache.get().getMaturity(this.uiModel.getBatch().getSpecies().getReferenceTaxonId(), maturityQualitativeValue);
        this.samplingCache.get().addIndividualObservation(this.fishingOperation, this.species, gender, maturity, this.uiModel.getLengthStep(lengthStep));
    }

    public void decrements(IndividualObservationBatchRowModel row) {
        this.decrements(row.getGender(this.sexCaracteristic), row.getMaturityState(), row.getSize().floatValue());
    }

    public void decrements(CaracteristicQualitativeValue gender, Optional<CaracteristicQualitativeValue> maturityQualitativeValue, float lengthStep) {
        if (!this.on) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache is off, skip decrements individual observations in cache.");
            }
            return;
        }
        Boolean maturity = this.samplingCache.get().getMaturity(this.uiModel.getBatch().getSpecies().getReferenceTaxonId(), maturityQualitativeValue);
        this.samplingCache.get().removeIndividualObservation(this.fishingOperation, this.species, gender, maturity, Float.valueOf(this.uiModel.getLengthStep(lengthStep)));
    }

    public void decrementsAll() {
        if (!this.on) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache is off, skip decrements all individual observations in cache.");
            }
            return;
        }
        this.uiModel.getIndividualObservationRows().stream().filter(IndividualObservationBatchRowModel::withSize).forEach(this::decrements);
    }

    public void reset() {
        if (!this.on) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache is off, skip reset individual observations in cache.");
            }
            return;
        }
        this.decrementsAll();
        this.speciesEditRow.getIndividualObservation().stream().filter(IndividualObservationBatchRowModel::withSize).forEach(this::increments);
    }
}

