/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class IndividualObservationBatchRowModel
extends AbstractTuttiBeanUIModel<IndividualObservationBatch, IndividualObservationBatchRowModel>
implements AttachmentModelAware,
IndividualObservationBatch,
CaracteristicMapColumnRowModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DEFAULT_CARACTERISTICS = "defaultCaracteristics";
    public static final String PROPERTY_SAMPLING_CODE_PREFIX = "samplingCodePrefix";
    public static final String PROPERTY_SAMPLING_CODE_ID = "samplingCodeId";
    protected final IndividualObservationBatch editObject = IndividualObservationBatchs.newIndividualObservationBatch();
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected CaracteristicMap defaultCaracteristics = new CaracteristicMap();
    protected final WeightUnit weightUnit;
    protected Optional<Caracteristic> maturityCaracteristic = Optional.empty();
    protected Integer samplingCodeId;
    protected String samplingCodePrefix;
    protected static final Binder<IndividualObservationBatch, IndividualObservationBatchRowModel> fromBeanBinder = BinderFactory.newBinder(IndividualObservationBatch.class, IndividualObservationBatchRowModel.class);
    protected static final Binder<IndividualObservationBatchRowModel, IndividualObservationBatch> toBeanBinder = BinderFactory.newBinder(IndividualObservationBatchRowModel.class, IndividualObservationBatch.class);

    public IndividualObservationBatchRowModel(WeightUnit weightUnit, CaracteristicMap defaultCaracteristicMap) {
        super(fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
        if (this.getCaracteristics() == null) {
            this.setCaracteristics(new CaracteristicMap());
        }
        this.setDefaultCaracteristics(CaracteristicMap.copy((CaracteristicMap)defaultCaracteristicMap));
    }

    public IndividualObservationBatchRowModel(WeightUnit weightUnit, Collection<Caracteristic> defaultCaracteristicsSet, IndividualObservationBatch entity) {
        this(weightUnit, CaracteristicMap.fromCollection(defaultCaracteristicsSet));
        this.fromEntity(entity);
    }

    public CaracteristicMap getDefaultCaracteristics() {
        return this.defaultCaracteristics;
    }

    public void setDefaultCaracteristics(CaracteristicMap defaultCaracteristics) {
        CaracteristicMap oldValue = CaracteristicMap.copy((CaracteristicMap)this.getDefaultCaracteristics());
        this.defaultCaracteristics = defaultCaracteristics;
        this.firePropertyChange(PROPERTY_DEFAULT_CARACTERISTICS, oldValue, defaultCaracteristics);
    }

    @Override
    public void fromEntity(IndividualObservationBatch entity) {
        super.fromEntity(entity);
        this.setWeight(this.weightUnit.fromEntity(this.getWeight()));
        CaracteristicMap caracteristics = this.getCaracteristics();
        if (caracteristics == null) {
            this.setCaracteristics(new CaracteristicMap());
        } else {
            for (Caracteristic caracteristic : this.getDefaultCaracteristics().keySet()) {
                if (!caracteristics.containsKey((Object)caracteristic)) continue;
                Serializable value = (Serializable)caracteristics.remove((Object)caracteristic);
                this.defaultCaracteristics.put(caracteristic, value);
            }
        }
    }

    public static List<IndividualObservationBatchRowModel> fromEntity(WeightUnit weightUnit, Collection<Caracteristic> defaultCaracteristicsSet, List<IndividualObservationBatch> entities) {
        ArrayList result = Lists.newArrayList();
        for (IndividualObservationBatch entity : entities) {
            IndividualObservationBatchRowModel row = new IndividualObservationBatchRowModel(weightUnit, defaultCaracteristicsSet, entity);
            result.add(row);
        }
        return result;
    }

    @Override
    public IndividualObservationBatch toEntity() {
        Serializable value;
        IndividualObservationBatch result = (IndividualObservationBatch)super.toEntity();
        result.setWeight(this.weightUnit.toEntity(this.getWeight()));
        CaracteristicMap caracteristics = new CaracteristicMap();
        result.setCaracteristics(caracteristics);
        for (Map.Entry entry : this.getCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put((Caracteristic)entry.getKey(), value);
        }
        for (Map.Entry entry : this.getDefaultCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put((Caracteristic)entry.getKey(), value);
        }
        return result;
    }

    public static List<IndividualObservationBatch> toEntity(List<IndividualObservationBatchRowModel> rows, SpeciesBatch batch) {
        ArrayList result = Lists.newArrayList();
        for (IndividualObservationBatchRowModel row : rows) {
            IndividualObservationBatch entity = row.toEntity();
            entity.setBatchId(batch.getIdAsInt());
            entity.setFishingOperation(batch.getFishingOperation());
            entity.setSpecies(batch.getSpecies());
            result.add(entity);
        }
        return result;
    }

    @Override
    protected IndividualObservationBatch newEntity() {
        return IndividualObservationBatchs.newIndividualObservationBatch();
    }

    public Integer getBatchId() {
        return this.editObject.getBatchId();
    }

    public void setBatchId(Integer batchId) {
        this.editObject.setBatchId(batchId);
    }

    public FishingOperation getFishingOperation() {
        return this.editObject.getFishingOperation();
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.editObject.setFishingOperation(fishingOperation);
    }

    public Float getWeight() {
        return this.editObject.getWeight();
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.editObject.setWeight(weight);
        this.firePropertyChange("weight", oldValue, weight);
    }

    public boolean withWeight() {
        return this.getWeight() != null;
    }

    @Override
    public Species getSpecies() {
        return this.editObject.getSpecies();
    }

    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        this.editObject.setSpecies(species);
        this.firePropertyChange("species", oldValue, species);
    }

    public Float getSize() {
        return this.editObject.getSize();
    }

    public void setSize(Float size) {
        Float oldValue = this.getSize();
        this.editObject.setSize(size);
        this.firePropertyChange("size", oldValue, size);
    }

    public boolean withSize() {
        return this.getSize() != null;
    }

    @Override
    public Caracteristic getLengthStepCaracteristic() {
        return this.editObject.getLengthStepCaracteristic();
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.editObject.setLengthStepCaracteristic(lengthStepCaracteristic);
        this.firePropertyChange("lengthStepCaracteristic", oldValue, lengthStepCaracteristic);
    }

    @Override
    public CaracteristicMap getCaracteristics() {
        return this.editObject.getCaracteristics();
    }

    @Override
    public void setCaracteristics(CaracteristicMap caracteristics) {
        CaracteristicMap oldValue = this.getCaracteristics();
        this.editObject.setCaracteristics(caracteristics);
        this.firePropertyChange("caracteristics", oldValue, caracteristics);
    }

    public String getComment() {
        return this.editObject.getComment();
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    public Integer getRankOrder() {
        return this.editObject.getRankOrder();
    }

    public void setRankOrder(Integer rankOrder) {
        this.editObject.setRankOrder(rankOrder);
    }

    public String getSynchronizationStatus() {
        return this.editObject.getSynchronizationStatus();
    }

    public void setSynchronizationStatus(String synchronizationStatus) {
        String oldValue = this.getSynchronizationStatus();
        this.editObject.setSynchronizationStatus(synchronizationStatus);
        this.firePropertyChange("synchronizationStatus", oldValue, synchronizationStatus);
    }

    public CopyIndividualObservationMode getCopyIndividualObservationMode() {
        return this.editObject.getCopyIndividualObservationMode();
    }

    public void setCopyIndividualObservationMode(CopyIndividualObservationMode copyIndividualObservationMode) {
        this.editObject.setCopyIndividualObservationMode(copyIndividualObservationMode);
    }

    public String getSamplingCode() {
        return this.editObject.getSamplingCode();
    }

    public void setSamplingCode(String samplingCode) {
        String oldValue = this.getSamplingCode();
        this.editObject.setSamplingCode(samplingCode);
        this.firePropertyChange("samplingCode", oldValue, samplingCode);
        this.extractSamplingCodeIdFromSamplingCode();
    }

    protected void setSamplingCode() {
        if (this.withSamplingCodeId()) {
            this.setSamplingCode(this.samplingCodePrefix + this.samplingCodeId);
        } else {
            this.setSamplingCode(null);
        }
    }

    public Integer getSamplingCodeId() {
        return this.samplingCodeId;
    }

    public void setSamplingCodeId(Integer samplingCodeId) {
        Integer oldValue = this.getSamplingCodeId();
        this.samplingCodeId = samplingCodeId;
        this.firePropertyChange(PROPERTY_SAMPLING_CODE_ID, oldValue, samplingCodeId);
        this.setSamplingCode();
    }

    public String getSamplingCodePrefix() {
        return this.samplingCodePrefix;
    }

    public void setSamplingCodePrefix(String samplingCodePrefix) {
        String oldValue = this.getSamplingCodePrefix();
        this.samplingCodePrefix = samplingCodePrefix;
        this.firePropertyChange(PROPERTY_SAMPLING_CODE_PREFIX, oldValue, samplingCodePrefix);
        this.setSamplingCode();
    }

    public void extractSamplingCodeIdFromSamplingCode() {
        if (this.withSamplingCode() && this.withSamplingCodePrefix() && !this.withSamplingCodeId()) {
            this.setSamplingCodeId(Integer.valueOf(this.getSamplingCode().replace(this.samplingCodePrefix, "")));
        }
    }

    public boolean withSamplingCode() {
        return StringUtils.isNotBlank((CharSequence)this.getSamplingCode());
    }

    public boolean withSamplingCodePrefix() {
        return this.samplingCodePrefix != null;
    }

    public boolean withSamplingCodeId() {
        return this.samplingCodeId != null;
    }

    @Override
    public ObjectTypeCode getObjectType() {
        return ObjectTypeCode.SAMPLE;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public boolean isEmpty() {
        return this.isEmpty(Collections.emptySet());
    }

    public boolean isEmpty(Collection<Caracteristic> caracteristicsToIgnore) {
        return !(this.getSize() != null || this.getWeight() != null || this.getCaracteristics() != null && this.getCaracteristics().hasNonNullValues(caracteristicsToIgnore) || this.getDefaultCaracteristics() != null && this.getDefaultCaracteristics().hasNonNullValues(caracteristicsToIgnore) || !StringUtils.isBlank((CharSequence)this.getSamplingCode()) || this.getComment() != null || this.getAttachment() != null && !this.getAttachment().isEmpty());
    }

    public void copy(IndividualObservationBatchRowModel source) {
        this.setId(source.getId());
        this.setLengthStepCaracteristic(source.getLengthStepCaracteristic());
        this.setSize(source.getSize());
        this.setWeight(source.getWeight());
        this.setBatchId(source.getBatchId());
        this.setCaracteristics(source.getCaracteristics());
        this.setDefaultCaracteristics(source.getDefaultCaracteristics());
        this.setComment(source.getComment());
        this.setSamplingCode(source.getSamplingCode());
        this.setCopyIndividualObservationMode(source.getCopyIndividualObservationMode());
        this.addAllAttachment(source.getAttachment());
    }

    public Serializable getCaracteristicValue(Caracteristic caracteristic) {
        CaracteristicMap allCaracteristics = CaracteristicMap.copy((CaracteristicMap)this.defaultCaracteristics);
        allCaracteristics.putAll((Map)this.getCaracteristics());
        return (Serializable)allCaracteristics.get((Object)caracteristic);
    }

    public CaracteristicQualitativeValue getGender(Caracteristic sexCaracteristic) {
        return (CaracteristicQualitativeValue)this.getCaracteristicValue(sexCaracteristic);
    }

    public Optional<Caracteristic> getMaturityCaracteristic() {
        return this.maturityCaracteristic;
    }

    public void setMaturityCaracteristic(Optional<Caracteristic> maturityCaracteristic) {
        this.maturityCaracteristic = maturityCaracteristic;
    }

    public Optional<CaracteristicQualitativeValue> getMaturityState() {
        if (!this.maturityCaracteristic.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable((CaracteristicQualitativeValue)this.getCaracteristicValue(this.maturityCaracteristic.get()));
    }
}

