/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModelCache;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.data.xy.XYSeries;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class SpeciesFrequencyTableModel
extends AbstractApplicationTableModel<SpeciesFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId((String)"lengthStep", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> NUMBER = ColumnIdentifier.newId((String)"number", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> RTP_COMPUTED_WEIGHT = ColumnIdentifier.newId((String)"rtpComputedWeight", (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.rtpComputedWeight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editSpeciesFrequencies.table.header.rtpComputedWeight", (Object[])new Object[0]));
    private final SpeciesFrequencyUIModel uiModel;
    private final SpeciesFrequencyUIModelCache modelCache;
    protected final WeightUnit weightUnit;
    protected final WeightUnit individualObservationWeightUnit;
    protected transient PropertyChangeListener onLengthStepChangedListener;
    protected transient PropertyChangeListener onWeightChangedListener;
    protected transient PropertyChangeListener onNumberChangedListener;
    protected final XYSeries frequenciesSeries;
    protected final XYSeries averageWeightsSeries;

    public SpeciesFrequencyTableModel(WeightUnit weightUnit, WeightUnit individualObservationWeightUnit, TableColumnModelExt columnModel, SpeciesFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.weightUnit = weightUnit;
        this.individualObservationWeightUnit = individualObservationWeightUnit;
        this.uiModel = uiModel;
        this.modelCache = uiModel.cache;
        this.frequenciesSeries = uiModel.frequenciesDataset.getSeries(0);
        this.averageWeightsSeries = uiModel.averageWeightsDataset.getSeries(0);
        this.setNoneEditableCols(new ColumnIdentifier[]{RTP_COMPUTED_WEIGHT});
    }

    public boolean isCreateNewRow() {
        return this.uiModel.isCopyIndividualObservationNothing() && super.isCreateNewRow();
    }

    public SpeciesFrequencyRowModel createNewRow() {
        return this.createNewRow(true, true);
    }

    public SpeciesFrequencyRowModel createNewRow(boolean useDefaultStep, boolean attachListeners) {
        SpeciesFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (useDefaultStep && rowCount > 0 && (lengthStep = (rowModel = (SpeciesFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep().floatValue()));
        }
        SpeciesFrequencyRowModel result = new SpeciesFrequencyRowModel(this.weightUnit);
        if (attachListeners) {
            this.attachListeners(result);
        }
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(defaultStep != null);
        return result;
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName) {
        CopyIndividualObservationMode copyIndividualObservationMode = this.uiModel.getCopyIndividualObservationMode();
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result && copyIndividualObservationMode != null) {
            switch (copyIndividualObservationMode) {
                case ALL: {
                    result = false;
                    break;
                }
                case NOTHING: {
                    result = !WEIGHT.equals(propertyName) || !this.uiModel.isCopyRtpWeights();
                    break;
                }
                case SIZE: {
                    result = WEIGHT.equals(propertyName) && !this.uiModel.isCopyRtpWeights();
                }
            }
        }
        return result;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName, SpeciesFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, (Serializable)entry);
        this.uiModel.setModify(true);
    }

    protected void onRowAdded(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
    }

    protected void onRowUpdated(int rowIndex, SpeciesFrequencyRowModel row) {
        this.uiModel.recomputeCanEditLengthStep();
        this.uiModel.setModify(true);
    }

    protected void onRowRemoved(int rowIndex, SpeciesFrequencyRowModel row) {
        this.dettachListeners(row);
        this.uiModel.recomputeCanEditLengthStep();
    }

    protected void onBeforeRowsChanged(List<SpeciesFrequencyRowModel> oldRows) {
        if (oldRows != null) {
            for (SpeciesFrequencyRowModel row : oldRows) {
                this.dettachListeners(row);
            }
        }
    }

    protected void onRowsChanged(List<SpeciesFrequencyRowModel> newRows) {
        if (newRows != null) {
            for (SpeciesFrequencyRowModel row : newRows) {
                this.dettachListeners(row);
                this.attachListeners(row);
            }
        }
        this.uiModel.recomputeCanEditLengthStep();
    }

    public void decrementNumberForLengthStep(Float lengthStep) {
        SpeciesFrequencyRowModel row = this.modelCache.getRowCache().get(lengthStep);
        if (row != null) {
            Integer number = row.getNumber();
            if (number != null) {
                if (number > 1) {
                    row.setNumber(number - 1);
                } else {
                    row.setNumber(null);
                }
                int rowIndex = this.getRowIndex(row);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            this.uiModel.recomputeCanEditLengthStep();
        }
    }

    private PropertyChangeListener getOnLengthStepChangedListener() {
        if (this.onLengthStepChangedListener == null) {
            this.onLengthStepChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Float newValue;
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    SpeciesFrequencyTableModel.this.uiModel.computeRowWeightWithRtp(row);
                    Float oldValue = (Float)evt.getOldValue();
                    if (oldValue != null) {
                        SpeciesFrequencyTableModel.this.modelCache.removeLengthStep(oldValue);
                        if (SpeciesFrequencyTableModel.this.frequenciesSeries.indexOf((Number)oldValue) >= 0) {
                            SpeciesFrequencyTableModel.this.frequenciesSeries.remove((Number)oldValue);
                        }
                        if (SpeciesFrequencyTableModel.this.averageWeightsSeries.indexOf((Number)oldValue) >= 0) {
                            SpeciesFrequencyTableModel.this.averageWeightsSeries.remove((Number)oldValue);
                        }
                    }
                    if ((newValue = (Float)evt.getNewValue()) != null) {
                        SpeciesFrequencyTableModel.this.modelCache.addLengthStep(row);
                        if (row.withNumber()) {
                            SpeciesFrequencyTableModel.this.frequenciesSeries.addOrUpdate((Number)newValue, (Number)row.getNumber());
                            Float weight = SpeciesFrequencyTableModel.this.individualObservationWeightUnit.convertWeight(row.computeAverageWeight(), SpeciesFrequencyTableModel.this.weightUnit);
                            SpeciesFrequencyTableModel.this.averageWeightsSeries.addOrUpdate((Number)newValue, (Number)weight);
                        }
                    }
                    SpeciesFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    SpeciesFrequencyTableModel.this.fireTableDataChanged();
                }
            };
        }
        return this.onLengthStepChangedListener;
    }

    private PropertyChangeListener getOnNumberChangedListener() {
        if (this.onNumberChangedListener == null) {
            this.onNumberChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    SpeciesFrequencyTableModel.this.uiModel.computeRowWeightWithRtp(row);
                    Float lengthStep = row.getLengthStep();
                    if (lengthStep != null) {
                        if (!row.withNumber()) {
                            if (SpeciesFrequencyTableModel.this.frequenciesSeries.indexOf((Number)lengthStep) >= 0) {
                                SpeciesFrequencyTableModel.this.frequenciesSeries.remove((Number)lengthStep);
                            }
                            if (SpeciesFrequencyTableModel.this.averageWeightsSeries.indexOf((Number)lengthStep) >= 0) {
                                SpeciesFrequencyTableModel.this.averageWeightsSeries.remove((Number)lengthStep);
                            }
                        } else {
                            SpeciesFrequencyTableModel.this.frequenciesSeries.addOrUpdate((Number)lengthStep, (Number)row.getNumber());
                            Float weight = SpeciesFrequencyTableModel.this.individualObservationWeightUnit.convertWeight(row.computeAverageWeight(), SpeciesFrequencyTableModel.this.weightUnit);
                            SpeciesFrequencyTableModel.this.averageWeightsSeries.addOrUpdate((Number)lengthStep, (Number)weight);
                        }
                    }
                    SpeciesFrequencyTableModel.this.uiModel.recomputeCanEditLengthStep();
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowValidState(row);
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                    SpeciesFrequencyTableModel.this.fireTableDataChanged();
                }
            };
        }
        return this.onNumberChangedListener;
    }

    private PropertyChangeListener getOnWeightChangedListener() {
        if (this.onWeightChangedListener == null) {
            this.onWeightChangedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)evt.getSource();
                    SpeciesFrequencyTableModel.this.modelCache.updateRowWithWeight(row);
                    Float lengthStep = row.getLengthStep();
                    if (lengthStep != null) {
                        if (!row.withWeight()) {
                            if (SpeciesFrequencyTableModel.this.averageWeightsSeries.indexOf((Number)lengthStep) >= 0) {
                                SpeciesFrequencyTableModel.this.averageWeightsSeries.remove((Number)lengthStep);
                            }
                        } else {
                            Float weight = SpeciesFrequencyTableModel.this.individualObservationWeightUnit.convertWeight(row.computeAverageWeight(), SpeciesFrequencyTableModel.this.weightUnit);
                            SpeciesFrequencyTableModel.this.averageWeightsSeries.addOrUpdate((Number)lengthStep, (Number)weight);
                        }
                    }
                    SpeciesFrequencyTableModel.this.uiModel.recomputeRowsValidateState();
                    SpeciesFrequencyTableModel.this.uiModel.updateEmptyRow(row);
                    SpeciesFrequencyTableModel.this.uiModel.recomputeTotalNumberAndWeight();
                }
            };
        }
        return this.onWeightChangedListener;
    }

    private void dettachListeners(SpeciesFrequencyRowModel result) {
        result.removePropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.removePropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.removePropertyChangeListener("number", this.getOnNumberChangedListener());
    }

    private void attachListeners(SpeciesFrequencyRowModel result) {
        result.addPropertyChangeListener("lengthStep", this.getOnLengthStepChangedListener());
        result.addPropertyChangeListener("weight", this.getOnWeightChangedListener());
        result.addPropertyChangeListener("number", this.getOnNumberChangedListener());
    }
}

