/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchDecoratorComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowHelper;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortableRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataTableCell;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JTables;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.validator.NuitonValidatorResult;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel, SpeciesBatchTableModel, SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    private EnumMap<TableViewMode, RowFilter<SpeciesBatchTableModel, Integer>> tableFilters;
    protected SampleCategoryModel sampleCategoryModel;
    protected Integer qualitative_unsorted_id;
    protected SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;

    public SpeciesBatchUIHandler() {
        super("speciesToConfirm", "species", "weight", "number", "comment", "attachment", "sampleCategoryWeight", "frequency");
    }

    @Override
    protected ColumnIdentifier<SpeciesBatchRowModel> getCommentIdentifier() {
        return SpeciesBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<SpeciesBatchRowModel> getAttachementIdentifier() {
        return SpeciesBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                BatchContainer<SpeciesBatch> rootSpeciesBatch = this.speciesOrBenthosBatchUISupport.getRootSpeciesBatch(bean.getIdAsInt());
                List<SpeciesBatch> catches = rootSpeciesBatch.getChildren();
                Integer firstCategoryId = this.sampleCategoryModel.getFirstCategoryId();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((boolean)firstCategoryId.equals(aBatch.getSampleCategoryId()), (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryId()));
                    this.loadBatch(aBatch, null, rows);
                }
            }
            SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = this.getSpeciesColumnDecorator();
            SpeciesSortMode speciesSortMode = model.getSpeciesSortMode();
            SpeciesBatchRowHelper.sortSpeciesRows(this.getTable(), decorator, rows, speciesSortMode);
        }
        model.setRows(rows);
    }

    public SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        boolean result;
        SpeciesBatch batch = this.convertRowToEntity(row, true);
        NuitonValidatorResult validator = this.getValidationService().validateEditSpeciesBatch(batch);
        boolean bl = result = !validator.hasErrorMessagess();
        if (result && "validate".equals(this.getContext().getValidationContext()) && row.isBatchLeaf()) {
            List<SpeciesBatchFrequency> frequencies = SpeciesFrequencyRowModel.toEntity(row.getFrequency(), batch);
            result = this.getValidateCruiseOperationsService().isSpeciesBatchValid(batch, frequencies);
        }
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        SpeciesBatchTableModel tableModel = this.getTableModel();
        if ("sampleCategoryWeight".equals(propertyName)) {
            SampleCategory sampleCategory = (SampleCategory)newValue;
            Integer sampleCategoryId = sampleCategory.getCategoryId();
            SampleCategoryAble firstAncestorRow = row.getFirstAncestor(sampleCategory);
            int firstAncestorIndex = tableModel.getRowIndex((Serializable)((Object)firstAncestorRow));
            if (rowIndex != firstAncestorIndex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sample category " + sampleCategoryId + " weight was modified, First ancestor row: " + firstAncestorIndex + " will save it"));
                }
                this.saveRow((SpeciesBatchRowModel)firstAncestorRow);
                this.cleanrRowMonitor();
                return;
            }
        } else if ("speciesToConfirm".equals(propertyName)) {
            HashSet shell = Sets.newHashSet();
            row.collectShell(shell);
            boolean newVal = newValue == null ? false : (Boolean)newValue;
            for (SpeciesBatchRowModel rowToupdate : shell) {
                rowToupdate.setSpeciesToConfirm(newVal);
            }
            tableModel.fireTableRowUpdatedShell(shell);
        }
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(row.getSpecies(), row, "Sauvegarde des modifications du lot Capture - Esp\u00e8ces : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setRootNumber(0);
        model.setDistinctSortedSpeciesCount(0);
        model.setDistinctUnsortedSpeciesCount(0);
        for (SpeciesBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
        this.getTable().clearSelection();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EVEN, HighlightPredicate.EDITABLE}), (Color)Color.WHITE);
        table.addHighlighter(evenHighlighter);
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.EDITABLE, (renderer, adapter) -> {
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
            return row.isSpeciesToConfirm();
        }}), (Color)toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED), HighlightPredicate.READ_ONLY, (renderer, adapter) -> {
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)this.getTableModel().getEntry(adapter.convertRowIndexToModel(adapter.row));
            return row.isSpeciesToConfirm() && !adapter.isEditable();
        }}), (Color)toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableChangeSampleCategory = false;
        boolean enableAddSampleCategory = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        boolean enableEditFrequencies = false;
        if (rowIndex != -1) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            enableSplit = true;
            enableRemove = true;
            enableRemoveSub = selectedRowCount == 1;
            enableRename = selectedRowCount == 1;
            enableEditFrequencies = selectedRowCount == 1;
            enableChangeSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            enableAddSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            boolean bl = enableCreateMelag = selectedRowCount > 1;
            if (enableSplit) {
                Integer lastSamplingId = this.sampleCategoryModel.getLastCategoryId();
                enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && ObjectUtils.notEqual((Object)lastSamplingId, (Object)row.getFinestCategory().getCategoryId()) && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            boolean firstCategory = false;
            Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
            ArrayList available = null;
            if (sampleCategoryId != null) {
                firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
                SampleCategoryModelEntry category = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
                if (category.getCaracteristic().isNumericType()) {
                    available = Collections.emptyList();
                } else {
                    SpeciesBatchRowModel firstAncestorRow = row.getFirstAncestor(sampleCategoryId);
                    Set<Serializable> used = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
                    available = Lists.newArrayList(category.getCaracteristic().getQualitativeValue());
                    available.removeAll(used);
                    if (firstCategory) {
                        CaracteristicQualitativeValues.removeQualitativeValue(available, this.qualitative_unsorted_id);
                    }
                }
            }
            if (enableChangeSampleCategory) {
                enableChangeSampleCategory = sampleCategoryId == null ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableAddSampleCategory) {
                enableAddSampleCategory = sampleCategoryId == null || firstCategory ? false : CollectionUtils.isNotEmpty(available);
            }
            if (enableEditFrequencies) {
                enableEditFrequencies = row.isBatchLeaf();
            }
            if (enableRename && (enableRename = row.isBatchRoot())) {
                boolean bl2 = enableRename = !row.containsIndividualObservations();
            }
            if (enableRemove) {
                String tip;
                String text;
                if (selectedRowCount == 1) {
                    text = I18n.t((String)"tutti.editSpeciesBatch.action.removeBatch", (Object[])new Object[0]);
                    tip = I18n.t((String)"tutti.editBenthosBatch.action.removeBatch.tip", (Object[])new Object[0]);
                } else {
                    text = I18n.t((String)"tutti.editSpeciesBatch.action.removeBatches", (Object[])new Object[0]);
                    tip = I18n.t((String)"tutti.editSpeciesBatch.action.removeBatches.tip", (Object[])new Object[0]);
                }
                ((SpeciesBatchUI)this.ui).getRemoveSpeciesBatchMenu().setText(text);
                ((SpeciesBatchUI)this.ui).getRemoveSpeciesBatchMenu().setToolTipText(tip);
            }
            if (enableRemoveSub) {
                enableRemoveSub = !row.isBatchLeaf();
            }
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setSplitBatchEnabled(enableSplit);
        model.setChangeSampleCategoryEnabled(enableChangeSampleCategory);
        model.setAddSampleCategoryEnabled(enableAddSampleCategory);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
        model.setEditFrequenciesEnabled(enableEditFrequencies);
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("actions for (" + rowIndex + "," + columnIndex + "):");
            builder.append("\nenableSplit:                ").append(enableSplit);
            builder.append("\nenableChangeSampleCategory: ").append(enableChangeSampleCategory);
            builder.append("\nenableAddSampleCategory:    ").append(enableAddSampleCategory);
            builder.append("\nenableRemove:               ").append(enableRemove);
            builder.append("\nenableRemoveSub:            ").append(enableRemoveSub);
            builder.append("\nenableRename:               ").append(enableRename);
            builder.append("\nenableCreateMelag:          ").append(enableCreateMelag);
            builder.append("\nenableEditFrequencies:      ").append(enableEditFrequencies);
            log.debug((Object)builder.toString());
        }
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return ((SpeciesBatchUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + ui));
        }
        this.qualitative_unsorted_id = QualitativeValueId.UNSORTED.getValue();
        this.sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        this.tableFilters = new EnumMap(TableViewMode.class);
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
        this.speciesOrBenthosBatchUISupport = ui.getContextValue(SpeciesOrBenthosBatchUISupport.class, ui.getSpeciesOrBenthosContext());
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(this.speciesOrBenthosBatchUISupport);
        model.setTableViewMode(TableViewMode.ALL);
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
        ui.setContextValue(model);
    }

    public void afterInit(SpeciesBatchUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + ui));
        }
        WeightUnit weightUnit = this.getWeightUnit();
        this.initUI(ui);
        List<Integer> samplingOrder = this.sampleCategoryModel.getSamplingOrder();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Number> numberDecorator = this.getDecorator(Number.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        this.addIdColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.ID, (JTable)table);
        TableColumnExt speciesColumn = this.addColumnToModel((TableColumnModel)columnModel, null, null, SpeciesBatchTableModel.SPECIES);
        speciesColumn.setSortable(true);
        SpeciesBatchDecorator speciesDecorator = SpeciesBatchDecorator.newDecorator();
        speciesColumn.putClientProperty((Object)"decorator", speciesDecorator);
        speciesColumn.setCellRenderer(this.newTableCellRender((Decorator)speciesDecorator));
        for (SampleCategoryModelEntry sampleCategoryDef : this.sampleCategoryModel.getCategory()) {
            SampleCategoryColumnIdentifier columnIdentifier = SampleCategoryColumnIdentifier.newId(sampleCategoryDef.getLabel(), sampleCategoryDef.getCategoryId(), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]), I18n.n((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]));
            Object decorator = sampleCategoryDef.getCaracteristic().isNumericType() ? numberDecorator : caracteristicDecorator;
            this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, columnIdentifier, (Decorator)decorator, defaultRenderer, weightUnit);
        }
        this.addColumnToModel((TableColumnModel)columnModel, ComputableDataTableCell.newEditor(Float.class, weightUnit, computedDataColor), ComputableDataTableCell.newRender(defaultRenderer, weightUnit, computedDataColor), SpeciesBatchTableModel.WEIGHT, weightUnit);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyCellComponent.newEditor(ui, computedDataColor), SpeciesFrequencyCellComponent.newRender(computedDataColor), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), SpeciesBatchTableModel.ATTACHMENT);
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel(weightUnit, this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", evt -> {
            TableViewMode tableViewMode = (TableViewMode)((Object)((Object)evt.getNewValue()));
            if (tableViewMode == null) {
                tableViewMode = TableViewMode.ALL;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
            }
            RowFilter<SpeciesBatchTableModel, Integer> filter = this.tableFilters.get((Object)tableViewMode);
            this.getTable().setRowFilter(filter);
        });
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("speciesSortMode", evt -> {
            SpeciesSortMode newValue = (SpeciesSortMode)((Object)((Object)evt.getNewValue()));
            if (log.isInfoEnabled()) {
                log.info((Object)("New species sort mode: " + (Object)((Object)newValue)));
            }
            this.selectFishingOperation(((SpeciesBatchUIModel)this.getModel()).getFishingOperation());
        });
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("speciesDecoratorContextIndex", evt -> {
            int newValue = (Integer)evt.getNewValue();
            if (log.isInfoEnabled()) {
                log.info((Object)("New species decorator context index: " + newValue));
            }
            this.getSpeciesColumnDecorator().setContextIndex(newValue);
            this.selectFishingOperation(((SpeciesBatchUIModel)this.getModel()).getFishingOperation());
        });
    }

    @Override
    protected void initBatchTable(JXTable table, TableColumnModelExt columnModel, SpeciesBatchTableModel tableModel) {
        super.initBatchTable(table, columnModel, tableModel);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumnExt speciesColumn = table.getColumnExt(SpeciesBatchTableModel.SPECIES);
        tableModel.addTableModelListener(e -> {
            SpeciesBatchTableModel tableModel1 = (SpeciesBatchTableModel)((Object)((Object)e.getSource()));
            int type = e.getType();
            if (type == -1 || type == 1 || e.getLastRow() == Integer.MAX_VALUE) {
                SpeciesBatchDecoratorComparator<SpeciesBatchRowModel> comparator = this.getSpeciesRowComparator();
                SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = this.getSpeciesColumnDecorator();
                comparator.init((JXPathDecorator<SpeciesBatchRowModel>)decorator, tableModel1.getRows());
            }
        });
        SpeciesBatchRowHelper.installSpeciesColumnComparatorPopup(table, speciesColumn, (SpeciesSortableRowModel)this.getModel(), I18n.t((String)"tutti.species.surveyCode.tip", (Object[])new Object[0]), I18n.t((String)"tutti.species.name.tip", (Object[])new Object[0]));
    }

    protected JComponent getComponentToFocus() {
        return ((SpeciesBatchUI)this.getUI()).getTable();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((SpeciesBatchUI)this.ui).getSpeciesBatchAttachmentsButton().onCloseUI();
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public Integer getQualitative_unsorted_id() {
        return this.qualitative_unsorted_id;
    }

    public SpeciesBatchRowModel addBatch(CreateSpeciesBatchUIModel batchRootRowModel) {
        SpeciesBatchRowModel result = null;
        if (batchRootRowModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            Species species = batchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            newRow.setNumber(batchRootRowModel.getBatchCount());
            CaracteristicQualitativeValue sampleCategory = batchRootRowModel.getSampleCategory();
            SampleCategory<?> category = newRow.getFirstSampleCategory();
            category.setCategoryValue(sampleCategory);
            category.setCategoryWeight(batchRootRowModel.getBatchSampleCategoryWeight());
            newRow.setSampleCategory(category);
            newRow.setWeight(batchRootRowModel.getBatchWeight());
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            int insertIndex = SpeciesBatchRowHelper.getIndexToInsert(tableModel.getRows(), newRow, ((SpeciesBatchUIModel)this.getModel()).getSpeciesSortMode(), this.getSpeciesColumnDecorator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will insert at index: " + insertIndex));
            }
            tableModel.addNewRow(insertIndex, newRow);
            JTables.doSelectCell((JTable)this.getTable(), (int)insertIndex, (int)0);
            this.addToSpeciesUsed(newRow);
            if (batchRootRowModel.getBatchCount() == null && batchRootRowModel.getSelectedCategory() != null) {
                this.splitBatch(batchRootRowModel.getSelectedCategory(), batchRootRowModel.getRows(), batchRootRowModel.getSampleWeight());
            }
            batchRootRowModel.setLastSampleCategoryUsed(batchRootRowModel.getSampleCategory());
            result = newRow;
        }
        return result;
    }

    public void splitBatch(SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        JXTable table = this.getTable();
        int insertRow = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(insertRow);
        Float parentWeight = parentBatch.getFinestCategory().getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight(parentWeight.floatValue(), totalRowWeight.floatValue());
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            newBatch.getFinestCategory().setSubSample(subSample);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(++insertRow, newBatch);
            JTables.selectFirstCellOnRow((JTable)this.getTable(), (int)insertRow, (boolean)false);
        }
        parentBatch.setChildBatch(newBatches);
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
    }

    public void addSampleCategoryBatch(SpeciesBatchRowModel parentBatch, SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        SpeciesBatchTableModel tableModel = this.getTableModel();
        int insertRow = tableModel.getNextChildRowIndex(parentBatch);
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isEditable() || !row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(insertRow++, newBatch);
        }
        List<SpeciesBatchRowModel> childBatch = parentBatch.getChildBatch();
        childBatch.addAll(newBatches);
        parentBatch.setChildBatch(childBatch);
        int categoryIndex = this.sampleCategoryModel.indexOf(sampleCategoryDef);
        Float parentWeight = parentBatch.getSampleCategoryByIndex(categoryIndex - 1).getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && Weights.isGreaterWeight(parentWeight.floatValue(), totalRowWeight.floatValue());
        HashSet shell = Sets.newHashSet();
        parentBatch.collectShell(shell);
        for (SpeciesBatchRowModel rowModel : shell) {
            rowModel.getSampleCategoryByIndex(categoryIndex).setSubSample(subSample);
        }
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        tableModel.updateShell(shell, SwingUtil.getSelectedModelColumn((JTable)this.getTable()));
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.recomputeRowValidState(row);
            this.saveRow(row);
        }
    }

    public String getFilterSpeciesBatchRootButtonText(int rootNumber) {
        return I18n.t((String)"tutti.editSpeciesBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    public void collectChildren(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public SpeciesBatchRowModel loadBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        List speciesList;
        int i;
        WeightUnit weightUnit = this.getWeightUnit();
        Integer id = aBatch.getIdAsInt();
        List frequencies = this.getPersistenceService().getAllSpeciesBatchFrequency(id);
        List individualObservations = this.getPersistenceService().getAllIndividualObservationBatchsForBatch(id);
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(weightUnit, this.getConfig().getIndividualObservationWeightUnit(), this.sampleCategoryModel, aBatch, frequencies, individualObservations, this.getDataContext().getDefaultIndividualObservationCaracteristics());
        for (IndividualObservationBatchRowModel obsRow : newRow.getIndividualObservation()) {
            List attachments = this.getPersistenceService().getAllAttachments(obsRow.getObjectType(), obsRow.getObjectId());
            obsRow.addAllAttachment(attachments);
        }
        List attachments = this.getPersistenceService().getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        if (parentRow == null && this.getContext().isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        Preconditions.checkNotNull((Object)sampleCategoryId, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryId, aBatch.getSampleCategoryValue(), weightUnit.fromEntity(aBatch.getSampleCategoryWeight()), weightUnit.fromEntity(aBatch.getSampleCategoryComputedWeight()));
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            Float childrenWeights = Float.valueOf(0.0f);
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                if (childrenWeights != null) {
                    Float weight = childRow.getFinestCategory().getNotNullWeight();
                    childrenWeights = weight == null ? null : Float.valueOf(childrenWeights.floatValue() + weight.floatValue());
                }
                batchChilds.add(childRow);
            }
            Float rowWeight = newRow.getFinestCategory().getNotNullWeight();
            boolean subSample = rowWeight != null && childrenWeights != null && Weights.isSmallerWeight(childrenWeights.floatValue(), rowWeight.floatValue());
            for (SpeciesBatchRowModel childRow : batchChilds) {
                childRow.getFinestCategory().setSubSample(subSample);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    protected WeightUnit getWeightUnit() {
        return this.speciesOrBenthosBatchUISupport.getWeightUnit();
    }

    public void removeFromSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        Preconditions.checkNotNull(firstSampleCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove from speciesUsed: " + this.decorate(categoryValue) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)categoryValue, (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
            if (QualitativeValueId.SORTED_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
                model.decDistinctSortedSpeciesCount();
            } else if (QualitativeValueId.SORTED_HORS_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
                model.decDistinctUnsortedSpeciesCount();
            }
        }
    }

    public void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = ((SpeciesBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory sampleCategory = row.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull(sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = row.toEntity();
        WeightUnit weightUnit = this.getWeightUnit();
        Float weight = catchBean.getWeight();
        catchBean.setWeight(weightUnit.toEntity(weight));
        catchBean.setFishingOperation(fishingOperation);
        SpeciesBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch(parent.toEntity());
        }
        catchBean.setSampleCategoryId(sampleCategory.getCategoryId());
        catchBean.setSampleCategoryValue((Serializable)sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        catchBean.setSampleCategoryWeight(weightUnit.toEntity(categoryWeight));
        if (TuttiEntities.isNew(catchBean)) {
            Integer parentBatchId = null;
            if (parent != null) {
                parentBatchId = parent.getIdAsInt();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.speciesOrBenthosBatchUISupport.createBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.speciesOrBenthosBatchUISupport.saveBatch(catchBean);
        }
        this.fireBatchSaved(row);
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List<SpeciesBatchFrequency> frequency = SpeciesFrequencyRowModel.toEntity(frequencyRows, catchBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.speciesOrBenthosBatchUISupport.saveBatchFrequencies(catchBean.getIdAsInt(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromEntity(weightUnit, frequency);
        row.setFrequency(frequencyRows);
        List<IndividualObservationBatchRowModel> obsRows = row.getIndividualObservation().stream().filter(obsRow -> !obsRow.isEmpty()).collect(Collectors.toList());
        List obs = IndividualObservationBatchRowModel.toEntity(obsRows, catchBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will save " + obs.size() + " observations."));
        }
        obs = this.getPersistenceService().saveBatchIndividualObservation(catchBean.getIdAsInt(), obs);
        List<IndividualObservationBatchRowModel> savedObsRows = IndividualObservationBatchRowModel.fromEntity(this.getConfig().getIndividualObservationWeightUnit(), this.getDataContext().getDefaultIndividualObservationCaracteristics(), obs);
        int n = obsRows.size();
        for (int i = 0; i < n; ++i) {
            IndividualObservationBatchRowModel obsRow2 = obsRows.get(i);
            IndividualObservationBatchRowModel savedObsRow = savedObsRows.get(i);
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            for (Attachment attachment : obsRow2.getAttachment()) {
                if (TuttiEntities.isNew(attachment)) {
                    File file = new File(attachment.getPath());
                    attachment.setObjectId(savedObsRow.getObjectId());
                    attachment = this.getPersistenceService().createAttachment(attachment, file);
                }
                attachments.add(attachment);
            }
            savedObsRow.addAllAttachment(attachments);
        }
        row.setIndividualObservation(savedObsRows);
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, Integer sampleCategoryId, Serializable categoryValue, Float categoryWeight, Float categoryComputedWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategoryById(sampleCategoryId);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        sampleCategory.setComputedWeight(categoryComputedWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            if (parentRow.isSpeciesToConfirm()) {
                newRow.setSpeciesToConfirm(true);
            }
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            for (Integer id : this.sampleCategoryModel.getSamplingOrder()) {
                if (id.equals(sampleCategoryId)) continue;
                newRow.setSampleCategory(parentRow.getSampleCategoryById(id));
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer, WeightUnit weightUnit) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator, weightUnit), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights(), weightUnit), columnIdentifier, weightUnit);
    }

    protected void addToSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Preconditions.checkNotNull(firstSampleCategory);
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate(categoryValue) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)categoryValue, (Object)row.getSpecies());
        if (QualitativeValueId.SORTED_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
            model.incDistinctSortedSpeciesCount();
        } else if (QualitativeValueId.SORTED_HORS_VRAC.getValue().equals(categoryValue.getIdAsInt())) {
            model.incDistinctUnsortedSpeciesCount();
        }
        model.setRootNumber(model.getRootNumber() + 1);
    }

    protected SpeciesBatch convertRowToEntity(SpeciesBatchRowModel row, boolean convertParent) {
        Preconditions.checkNotNull((Object)row.getFinestCategory());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryId());
        Preconditions.checkNotNull(row.getFinestCategory().getCategoryValue());
        SpeciesBatch catchBean = row.toEntity();
        if (convertParent && row.getParentBatch() != null) {
            SpeciesBatch parent = this.convertRowToEntity(row.getParentBatch(), true);
            catchBean.setParentBatch(parent);
        }
        return catchBean;
    }

    public Set<Serializable> getSampleUsedValues(SpeciesBatchRowModel row, int sampleCategoryId) {
        List<Object> childs;
        HashSet usedValues = Sets.newHashSet();
        if (row.isBatchRoot()) {
            Species species = row.getSpecies();
            childs = Lists.newArrayList();
            for (SpeciesBatchRowModel rowToScan : ((SpeciesBatchUIModel)this.getModel()).getRows()) {
                if (!rowToScan.isBatchRoot() || !species.equals(rowToScan.getSpecies())) continue;
                childs.add(rowToScan);
            }
        } else {
            SpeciesBatchRowModel parentBatch = row.getParentBatch();
            childs = parentBatch.getChildBatch();
        }
        for (SpeciesBatchRowModel speciesBatchRowModel : childs) {
            SampleCategory<?> category = speciesBatchRowModel.getSampleCategoryById(sampleCategoryId);
            usedValues.add(category.getCategoryValue());
        }
        return usedValues;
    }

    protected SpeciesBatchDecoratorComparator<SpeciesBatchRowModel> getSpeciesRowComparator() {
        boolean comparatorNull;
        TableColumnExt speciesColumn = this.getTable().getColumnExt(SpeciesBatchTableModel.SPECIES);
        SpeciesBatchDecoratorComparator comparator = (SpeciesBatchDecoratorComparator)((Object)speciesColumn.getComparator());
        SpeciesBatchDecorator<SpeciesBatchRowModel> decorator = this.getSpeciesColumnDecorator();
        boolean bl = comparatorNull = comparator == null;
        if (comparatorNull) {
            comparator = (SpeciesBatchDecoratorComparator)decorator.getCurrentComparator();
        }
        if (comparatorNull) {
            speciesColumn.setComparator((Comparator)((Object)comparator));
        }
        return comparator;
    }

    protected SpeciesBatchDecorator<SpeciesBatchRowModel> getSpeciesColumnDecorator() {
        TableColumnExt speciesColumn = this.getTable().getColumnExt(SpeciesBatchTableModel.SPECIES);
        return (SpeciesBatchDecorator)SpeciesBatchRowHelper.getSpeciesColumnDecorator(speciesColumn);
    }
}

