/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class IndividualObservationBatchTableModel
extends AbstractApplicationTableModel<IndividualObservationBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> RANK = ColumnIdentifier.newId((String)"rankOrder", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.rank", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.rank.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> WEIGHT = ColumnIdentifier.newId((String)"weight", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.weight", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.weight.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SIZE = ColumnIdentifier.newId((String)"size", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.size.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> OTHER_CARACTERISTICS = ColumnIdentifier.newId((String)"caracteristics", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SAMPLING_CODE = ColumnIdentifier.newId((String)"samplingCode", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.samplingCode", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.samplingCode.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> COMMENT = ColumnIdentifier.newId((String)"comment", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.comment", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.comment.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<IndividualObservationBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId((String)"attachment", (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.file", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editIndividualObservationBatch.table.header.file.tip", (Object[])new Object[0]));
    protected final WeightUnit weightUnit;
    protected final CaracteristicMap defaultCaracteristicsMap;
    protected Species species;
    protected String samplingCodePrefix;
    protected Caracteristic lengthstepCaracteristic;
    protected Optional<Caracteristic> maturityCaracteristic;

    public IndividualObservationBatchTableModel(WeightUnit weightUnit, Collection<Caracteristic> defaultCaracteristicsSet, TableColumnModelExt columnModel) {
        super(columnModel, true, false);
        this.weightUnit = weightUnit;
        this.defaultCaracteristicsMap = CaracteristicMap.fromCollection(defaultCaracteristicsSet);
        columnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TableColumnModelExt columnModel = (TableColumnModelExt)e.getSource();
                TableColumnExt column = columnModel.getColumnExt(e.getToIndex());
                IndividualObservationBatchTableModel.this.identifiers.add((ColumnIdentifier)column.getIdentifier());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                TableColumnModelExt columnModel = (TableColumnModelExt)e.getSource();
                TableColumnExt column = columnModel.getColumnExt(e.getFromIndex());
                IndividualObservationBatchTableModel.this.identifiers.remove(column);
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.setNoneEditableCols(new ColumnIdentifier[]{RANK});
    }

    public void setSpecies(Species species) {
        this.species = species;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setSpecies(species));
        }
    }

    public void setSamplingCodePrefix(String samplingCodePrefix) {
        this.samplingCodePrefix = samplingCodePrefix;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setSamplingCodePrefix(samplingCodePrefix));
        }
    }

    public void setLengthstepCaracteristic(Caracteristic lengthstepCaracteristic) {
        this.lengthstepCaracteristic = lengthstepCaracteristic;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setLengthStepCaracteristic(lengthstepCaracteristic));
        }
    }

    public void setMaturityCaracteristic(Optional<Caracteristic> maturityCaracteristic) {
        this.maturityCaracteristic = maturityCaracteristic;
        if (this.rows != null) {
            this.rows.forEach(row -> row.setLengthStepCaracteristic(this.lengthstepCaracteristic));
        }
    }

    public void setDefaultCaracteristicValues(CaracteristicMap defaultCaracteristicValues) {
        this.defaultCaracteristicsMap.replaceAll((caracteristic, serializable) -> (Serializable)defaultCaracteristicValues.get(caracteristic));
    }

    public IndividualObservationBatchRowModel createNewRow() {
        IndividualObservationBatchRowModel result = new IndividualObservationBatchRowModel(this.weightUnit, this.defaultCaracteristicsMap);
        result.setValid(false);
        result.setRankOrder(this.getRowCount() + 1);
        result.setSpecies(this.species);
        result.setSamplingCodePrefix(this.samplingCodePrefix);
        result.setLengthStepCaracteristic(this.lengthstepCaracteristic);
        result.setMaturityCaracteristic(this.maturityCaracteristic);
        return result;
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<IndividualObservationBatchRowModel> columnIdentifier) {
        CaracteristicColumnIdentifier caracteristicColumnIdentifier;
        Caracteristic caracteristic;
        Serializable defaultValue;
        boolean editable = columnIdentifier instanceof CaracteristicColumnIdentifier ? (defaultValue = (Serializable)this.defaultCaracteristicsMap.get(caracteristic = (caracteristicColumnIdentifier = (CaracteristicColumnIdentifier)columnIdentifier).getCaracteristic())) == null : (SAMPLING_CODE.equals(columnIdentifier) ? this.getValueAt(rowIndex, columnIndex) == null : super.isCellEditable(rowIndex, columnIndex, columnIdentifier));
        return editable;
    }

    public IndividualObservationBatchRowModel getEmptyRow() {
        IndividualObservationBatchRowModel result = null;
        for (int i = this.rows.size() - 1; i >= 0; --i) {
            IndividualObservationBatchRowModel row = (IndividualObservationBatchRowModel)this.rows.get(i);
            this.defaultCaracteristicsMap.keySet().stream().filter(key -> this.defaultCaracteristicsMap.get(key) != null).collect(Collectors.toSet());
            if (!row.isEmpty()) break;
            result = row;
        }
        return result;
    }
}

