/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.samplingCache.CruiseSamplingCacheLoader;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EditCatchesSupportAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(EditCatchesSupportAction.class);
    protected boolean loadReferential;
    protected boolean loadSamplingCache;

    public EditCatchesSupportAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_FISHING_OPERATION);
    }

    protected abstract boolean isLoadReferential();

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        TuttiDataContext dataContext = this.getDataContext();
        if (doAction) {
            this.loadReferential = this.isLoadReferential();
            this.loadSamplingCache = dataContext.isCanUseCruiseSamplingCache() && (!dataContext.isCruiseSamplingCacheLoaded() || !dataContext.isCruiseSamplingCacheUpToDate());
            int totalSteps = 1;
            if (this.loadReferential) {
                totalSteps += 5;
            }
            if (this.loadSamplingCache) {
                long cruiseFishingOperationIds = this.getDataContext().getCruiseFishingOperationIds().stream().count();
                totalSteps = (int)((long)totalSteps + cruiseFishingOperationIds);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Found " + cruiseFishingOperationIds + " fishing operations to load in sampling cache."));
                }
            }
            if (totalSteps > 1) {
                ProgressionModel progressionModel = new ProgressionModel();
                progressionModel.setTotal(totalSteps);
                this.setProgressionModel(progressionModel);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)this.getContext().isCruiseFilled());
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit operations of cruise: " + this.getContext().getCruiseId()));
        }
        this.getContext().setValidationContext("edit");
        if (this.loadReferential) {
            this.loadReferantials(false);
        }
        if (this.loadSamplingCache) {
            CruiseSamplingCacheLoader cruiseSamplingCacheLoader = new CruiseSamplingCacheLoader(this.getContext().getPersistenceService(), this.getContext().getDecoratorService(), this.getProgressionModel());
            this.getDataContext().loadCruiseSamplingCache(cruiseSamplingCacheLoader);
        }
        super.doAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        SwingUtilities.invokeLater(() -> {
            FishingOperationsUI currentBody = (FishingOperationsUI)((MainUIHandler)this.getHandler()).getCurrentBody();
            BeanFilterableComboBox<FishingOperation> comboBox = currentBody.getFishingOperationComboBox();
            if (!comboBox.isEmpty()) {
                FishingOperation selectedOperation = (FishingOperation)comboBox.getData().get(0);
                currentBody.getModel().setSelectedFishingOperation(selectedOperation);
            }
            EditFishingOperationUI fishingOperationTabContent = currentBody.getFishingOperationTabContent();
            JComponent componentToFocus = fishingOperationTabContent.getHandler().getComponentToFocus();
            componentToFocus.requestFocusInWindow();
        });
    }
}

