/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.samplingCache;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.samplingCache.CruiseSamplingCache;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;

public class CruiseSamplingCacheLoader {
    private static final Log log = LogFactory.getLog(CruiseSamplingCacheLoader.class);
    private final PersistenceService persistenceService;
    private final DecoratorService decoratorService;
    private final ProgressionModel progressionModel;

    public CruiseSamplingCacheLoader(PersistenceService persistenceService, DecoratorService decoratorService, ProgressionModel progressionModel) {
        this.persistenceService = persistenceService;
        this.decoratorService = decoratorService;
        this.progressionModel = progressionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CruiseSamplingCache loadCruiseSamplingCache(TuttiProtocol protocol, Integer cruiseId) {
        Caracteristic sexCaracteristic = this.persistenceService.getSexCaracteristic();
        List<Caracteristic> maturityCaracteristics = this.persistenceService.getMaturityCaracteristics(this.persistenceService.getAllCaracteristic());
        CruiseSamplingCache cruiseSamplingCache = new CruiseSamplingCache(cruiseId, protocol, sexCaracteristic, maturityCaracteristics);
        cruiseSamplingCache.setLoading(true);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading cruise sampling cache: " + cruiseSamplingCache));
            }
            Decorator<FishingOperation> fishingOperationDecorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
            this.persistenceService.getAllFishingOperationIds(cruiseId).forEach(fishingOperationId -> {
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation((Integer)fishingOperationId);
                this.progressionModel.increments("Chargement du cache d'\u00e9chantillons pour le trait : " + fishingOperationDecorator.toString((Object)fishingOperation));
                List<IndividualObservationBatch> allIndividualObservationBatchsForFishingOperation = this.persistenceService.getAllIndividualObservationBatchsForFishingOperation((Integer)fishingOperationId);
                Optional<Zone> optionalZone = cruiseSamplingCache.tryFindZone(fishingOperation);
                allIndividualObservationBatchsForFishingOperation.forEach(individualObservationBatch -> cruiseSamplingCache.addIndividualObservation((Integer)fishingOperationId, optionalZone, (IndividualObservationBatch)individualObservationBatch));
            });
            if (log.isInfoEnabled()) {
                log.info((Object)("cruise sampling cache loaded: " + cruiseSamplingCache));
            }
            CruiseSamplingCache cruiseSamplingCache2 = cruiseSamplingCache;
            return cruiseSamplingCache2;
        }
        finally {
            cruiseSamplingCache.setLoading(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCruiseSamplingCacheForFishingOperation(CruiseSamplingCache cruiseSamplingCache, FishingOperation fishingOperation) {
        cruiseSamplingCache.setLoading(true);
        try {
            Integer fishingOperationId = fishingOperation.getIdAsInt();
            Optional<Zone> optionalZone = cruiseSamplingCache.tryFindZone(fishingOperation);
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading cruise sampling cache for fishing operation: " + fishingOperationId + " - " + cruiseSamplingCache));
            }
            List<IndividualObservationBatch> allIndividualObservationBatchsForFishingOperation = this.persistenceService.getAllIndividualObservationBatchsForFishingOperation(fishingOperationId);
            allIndividualObservationBatchsForFishingOperation.forEach(individualObservationBatch -> cruiseSamplingCache.addIndividualObservation(fishingOperationId, optionalZone, (IndividualObservationBatch)individualObservationBatch));
            if (log.isInfoEnabled()) {
                log.info((Object)("Cruise sampling cache loaded for fishing operation: " + fishingOperationId + " - " + cruiseSamplingCache));
            }
        }
        finally {
            cruiseSamplingCache.setLoading(false);
        }
    }
}

