/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.CarrouselImportRequestResult;
import fr.ifremer.tutti.service.pupitri.PupitriSpeciesContext;
import fr.ifremer.tutti.service.pupitri.Signs;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.util.Weights;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class PupitriImportResult {
    private static final Log log = LogFactory.getLog(PupitriImportResult.class);
    private int nbTrunkImported;
    private int nbTrunkNotImported;
    private int nbCarrousselImported;
    private Float sortedWeight;
    private Float rejectedWeight;
    private Float carrouselSortedWeight;
    private Float carrouselUnsortedWeight;
    private final List<PupitriSpeciesContext> catches = new ArrayList<PupitriSpeciesContext>();
    private final Set<String> notImportedSpeciesIds = new LinkedHashSet<String>();
    private MutableFloat melagTotalWeight;
    private Float editedMelagTotalWeight;
    private MutableFloat melagSortedWeight;
    private String melagComment;
    private String reportAttachmentId;
    private String reportAttachmentFilename;

    public boolean isFishingOperationFound() {
        return this.nbTrunkImported + this.nbCarrousselImported > 0;
    }

    public int getNbTrunkImported() {
        return this.nbTrunkImported;
    }

    public int getNbTrunkNotImported() {
        return this.nbTrunkNotImported;
    }

    public int getNbCarrousselImported() {
        return this.nbCarrousselImported;
    }

    public int getNbCarrousselNotImported() {
        return this.notImportedSpeciesIds.size();
    }

    public Float getSortedWeight() {
        return this.sortedWeight;
    }

    public Float getRejectedWeight() {
        return this.rejectedWeight;
    }

    public Float getCarrouselSortedWeight() {
        return this.carrouselSortedWeight;
    }

    public Float getCarrouselUnsortedWeight() {
        return this.carrouselUnsortedWeight;
    }

    public List<PupitriSpeciesContext> getCatches() {
        return this.catches;
    }

    public Float getMelagTotalWeight() {
        return this.melagTotalWeight == null ? null : Float.valueOf(this.melagTotalWeight.floatValue());
    }

    public void setMelagTotalWeight(float melagTotalWeight) {
        this.melagTotalWeight.setValue(melagTotalWeight);
    }

    public Float getEditedMelagTotalWeight() {
        return this.editedMelagTotalWeight;
    }

    public void setEditedMelagTotalWeight(float editedMelagTotalWeight) {
        this.editedMelagTotalWeight = Float.valueOf(editedMelagTotalWeight);
    }

    public Float getMelagSortedWeight() {
        return this.melagSortedWeight == null ? null : Float.valueOf(this.melagSortedWeight.floatValue());
    }

    public String getMelagComment() {
        return this.melagComment;
    }

    public Set<String> getNotImportedSpeciesIds() {
        return ImmutableSet.copyOf(this.notImportedSpeciesIds);
    }

    public String getReportAttachmentId() {
        return this.reportAttachmentId;
    }

    public String getReportAttachmentFilename() {
        return this.reportAttachmentFilename;
    }

    public boolean isFoundTotalMelag() {
        return this.melagTotalWeight != null;
    }

    public boolean isFoundSortedMelag() {
        return this.melagSortedWeight != null;
    }

    void incrementNbTrunkImported() {
        ++this.nbTrunkImported;
    }

    void incrementNbTrunkNotImported() {
        ++this.nbTrunkNotImported;
    }

    void setSortedWeight(Float sortedWeight) {
        this.sortedWeight = sortedWeight;
    }

    void setRejectedWeight(Float rejectedWeight) {
        this.rejectedWeight = rejectedWeight;
    }

    void setReportAttachmentId(String reportAttachmentId) {
        this.reportAttachmentId = reportAttachmentId;
    }

    void setReportAttachmentFilename(String reportAttachmentFilename) {
        this.reportAttachmentFilename = reportAttachmentFilename;
    }

    void flushCarrouselResult(CarrouselImportRequestResult carrouselImportRequestResult) {
        this.carrouselSortedWeight = WeightUnit.KG.round(Float.valueOf(carrouselImportRequestResult.getCarrouselSortedWeight()));
        this.carrouselUnsortedWeight = WeightUnit.KG.round(Float.valueOf(carrouselImportRequestResult.getCarrouselUnsortedWeight()));
        this.nbCarrousselImported = carrouselImportRequestResult.getNbCarrousselImported();
        this.notImportedSpeciesIds.addAll(carrouselImportRequestResult.getNotImportedSpeciesIds());
        List<PupitriSpeciesContext> incomingCatches = carrouselImportRequestResult.getCatches();
        for (PupitriSpeciesContext aCatch : incomingCatches) {
            this.addCatch(aCatch);
        }
    }

    void prepareMelag(Decorator<Species> speciesDecorator) {
        boolean useMelag = this.isFoundTotalMelag() && this.isFoundSortedMelag();
        float melagRatio = 1.0f;
        if (useMelag) {
            melagRatio = this.melagSortedWeight.floatValue() / this.editedMelagTotalWeight.floatValue();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use Melag (sorted weight: " + this.melagSortedWeight.floatValue() + " / total weight: " + this.editedMelagTotalWeight + ")"));
            }
        }
        String unitLabel = WeightUnit.KG.getShortLabel();
        StringBuilder melagCommentBuilder = new StringBuilder(I18n.t((String)"tutti.service.pupitri.import.createMelag.comment.part1", (Object[])new Object[0]) + "\n");
        Iterator<PupitriSpeciesContext> iterator = this.catches.iterator();
        while (iterator.hasNext()) {
            PupitriSpeciesContext aCatch = iterator.next();
            if (useMelag && aCatch.isMelagMetaSpecies()) {
                iterator.remove();
                continue;
            }
            if (!aCatch.isForMelag()) continue;
            if (useMelag) {
                Float sampleWeight = Float.valueOf(aCatch.getWeight(Signs.MELAG));
                Float weight = WeightUnit.KG.round(Float.valueOf(sampleWeight.floatValue() / melagRatio));
                if (!aCatch.containsSign(Signs.BIG)) {
                    aCatch.setMelagElevatedWeight(Signs.DEFAULT, weight);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Add melag batch for " + aCatch + " as default (no G found) : " + weight));
                    }
                } else {
                    aCatch.setMelagElevatedWeight(Signs.SMALL, weight);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Add melag batch for " + aCatch + " as small (G found) : " + weight));
                    }
                }
                melagCommentBuilder.append(I18n.t((String)"tutti.service.pupitri.import.createMelag.comment.part2", (Object[])new Object[]{sampleWeight, unitLabel, speciesDecorator.toString((Object)aCatch.getSpecies())})).append("\n");
                continue;
            }
            aCatch.moveMelagToDefaultSign();
        }
        if (useMelag) {
            melagCommentBuilder.append(I18n.t((String)"tutti.service.pupitri.import.createMelag.comment.part3", (Object[])new Object[]{this.editedMelagTotalWeight, unitLabel})).append("\n");
            if (Weights.isNotEqualWeight((float)this.editedMelagTotalWeight.floatValue(), (float)this.melagTotalWeight.floatValue())) {
                melagCommentBuilder.append(I18n.t((String)"tutti.service.pupitri.import.createMelag.comment.part4", (Object[])new Object[]{Float.valueOf(this.melagTotalWeight.floatValue()), unitLabel, this.editedMelagTotalWeight, unitLabel})).append("\n");
            }
            this.melagComment = melagCommentBuilder.toString();
            if (log.isInfoEnabled()) {
                log.info((Object)("Melag comment:\n" + this.melagComment));
            }
        }
    }

    private void addCatch(PupitriSpeciesContext aCatch) {
        this.catches.add(aCatch);
        if (aCatch.isMelagMetaSpecies()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found a MELAG catch: " + aCatch));
            }
            this.addMelagTotalWeight(aCatch.getWeight(Signs.DEFAULT));
        }
        if (aCatch.isForMelag()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found a catch used in MELAG: " + aCatch));
            }
            this.addMelagSortedWeight(aCatch.getWeight(Signs.MELAG));
        }
    }

    private void addMelagTotalWeight(float weight) {
        if (this.melagTotalWeight == null) {
            this.melagTotalWeight = new MutableFloat();
        }
        this.melagTotalWeight.add(weight);
    }

    private void addMelagSortedWeight(float weight) {
        if (this.melagSortedWeight == null) {
            this.melagSortedWeight = new MutableFloat();
        }
        this.melagSortedWeight.add(weight);
    }
}

