/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.protocol.CalcifiedPiecesSamplingRow;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class CalcifiedPiecesSamplingRowModel
extends AbstractTuttiImportExportModel<CalcifiedPiecesSamplingRow> {
    public CalcifiedPiecesSamplingRowModel(char separator) {
        super(separator);
    }

    public static CalcifiedPiecesSamplingRowModel forExport(char separator) {
        CalcifiedPiecesSamplingRowModel result = new CalcifiedPiecesSamplingRowModel(separator);
        result.newColumnForExport("species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species species) {
                return String.valueOf(species.getReferenceTaxonId());
            }
        });
        result.newColumnForExport("maturity", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        result.newColumnForExport("sex", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_BOOLEAN);
        result.newColumnForExport("minSize", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        result.newColumnForExport("maxSize", (ValueFormatter)TuttiCsvUtil.INTEGER);
        result.newColumnForExport("maxByLenghtStep", (ValueFormatter)TuttiCsvUtil.INTEGER);
        result.newColumnForExport("samplingInterval", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        result.newColumnForExport("operationLimitation", (ValueFormatter)TuttiCsvUtil.INTEGER);
        result.newColumnForExport("zoneLimitation", (ValueFormatter)TuttiCsvUtil.INTEGER);
        return result;
    }

    public static CalcifiedPiecesSamplingRowModel forImport(char separator, Map<String, Species> allSpecies) {
        CalcifiedPiecesSamplingRowModel result = new CalcifiedPiecesSamplingRowModel(separator);
        result.newForeignKeyColumn("species", Species.class, "referenceTaxonId", allSpecies);
        result.newMandatoryColumn("maturity", (ValueParser)TuttiCsvUtil.BOOLEAN);
        result.newMandatoryColumn("sex", (ValueParser)TuttiCsvUtil.PRIMITIVE_BOOLEAN);
        result.newMandatoryColumn("minSize", (ValueParser)TuttiCsvUtil.PRIMITIVE_INTEGER);
        result.newMandatoryColumn("maxSize", (ValueParser)TuttiCsvUtil.INTEGER);
        result.newMandatoryColumn("maxByLenghtStep", (ValueParser)TuttiCsvUtil.INTEGER);
        result.newMandatoryColumn("samplingInterval", (ValueParser)TuttiCsvUtil.PRIMITIVE_INTEGER);
        result.newMandatoryColumn("operationLimitation", (ValueParser)TuttiCsvUtil.INTEGER);
        result.newMandatoryColumn("zoneLimitation", (ValueParser)TuttiCsvUtil.INTEGER);
        return result;
    }

    public CalcifiedPiecesSamplingRow newEmptyInstance() {
        return new CalcifiedPiecesSamplingRow();
    }
}

