/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForCatch;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportCatchAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportCatchAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportCatchAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid() && (this.importContext.getImportRequest().isImportSpecies() || this.importContext.getImportRequest().isImportBenthos());
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.catches", (Object[])new Object[0]));
        if (!this.importContext.getImportRequest().isImportSpecies() && !this.importContext.getImportRequest().isImportBenthos()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getCatchFileResult();
            importFileResult.setSkipped(true);
        }
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import catch.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.catches", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getCatchFileResult();
        try (CsvConsumerForCatch consumer = this.importContext.loadCatches(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext == null) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close catch.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (this.importContext.getImportRequest().isImportSpecies()) {
            this.persistSpeciesBatches();
        }
        if (this.importContext.getImportRequest().isImportBenthos()) {
            this.persistBenthosBatches();
        }
    }

    public void persistSpeciesBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    Collection<SpeciesBatch> batches;
                    this.deleteSpeciesBatches(fishingOperationContext);
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    ImportCatchAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.speciesBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (fishingOperationContext.withSpeciesBatches(true)) {
                        batches = fishingOperationContext.getSpeciesBatches(true);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + batches.size() + " VRAC root species batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        this.persistSpeciesBatches(fishingOperationContext, batches, null);
                    }
                    if (!fishingOperationContext.withSpeciesBatches(false)) continue;
                    batches = fishingOperationContext.getSpeciesBatches(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + batches.size() + " HORS VRAC root species batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    this.persistSpeciesBatches(fishingOperationContext, batches, null);
                }
            }

            private void persistSpeciesBatches(GenericFormatImportOperationContext fishingOperationContext, Collection<SpeciesBatch> batches, Integer parentId) {
                int rankOrder = 1;
                for (SpeciesBatch batch : batches) {
                    batch.setRankOrder(Integer.valueOf(rankOrder++));
                    Integer batchObjectId = fishingOperationContext.getBatchObjectId(batch.getIdAsInt());
                    List<SpeciesBatchFrequency> frequencies = fishingOperationContext.getSpeciesFrequencies(batch);
                    batch.setId((Integer)null);
                    SpeciesBatch createdBatch = ImportCatchAction.this.persistenceHelper.createSpeciesBatch(batch, parentId);
                    Collection<AttachmentRow> attachmentRows = ImportCatchAction.this.importContext.popAttachmentRows(ObjectTypeCode.BATCH, batchObjectId);
                    ImportCatchAction.this.persistenceHelper.persistAttachments(createdBatch.getIdAsInt(), attachmentRows);
                    if (CollectionUtils.isNotEmpty(frequencies)) {
                        Integer batchId = batch.getIdAsInt();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + frequencies.size() + " frequency(ies) (species batch: " + batchId + ") of " + fishingOperationContext.getFishingOperationLabel() + " for cruise: " + ImportCatchAction.this.importContext.decorate(fishingOperationContext.getFishingOperation().getCruise())));
                        }
                        ImportCatchAction.this.persistenceHelper.saveSpeciesBatchFrequency(batchId, frequencies);
                    }
                    if (batch.isChildBatchsEmpty()) continue;
                    this.persistSpeciesBatches(fishingOperationContext, batch.getChildBatchs(), createdBatch.getIdAsInt());
                }
            }

            private void deleteSpeciesBatches(GenericFormatImportOperationContext fishingOperationContext) {
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                ImportCatchAction.this.persistenceHelper.deleteSpeciesBatchForFishingOperation(fishingOperation.getIdAsInt());
            }
        });
    }

    public void persistBenthosBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    Collection<SpeciesBatch> batches;
                    this.deleteBenthosBatches(fishingOperationContext);
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    ImportCatchAction.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.benthosBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (fishingOperationContext.withBenthosBatches(true)) {
                        batches = fishingOperationContext.getBenthosBatches(true);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + batches.size() + " VRAC benthos batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        this.persistBenthosBatches(fishingOperationContext, batches, null);
                    }
                    if (!fishingOperationContext.withBenthosBatches(false)) continue;
                    batches = fishingOperationContext.getBenthosBatches(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + batches.size() + " HORS VRAC benthos batch(es) of " + operationStr + " for cruise: " + cruiseContext.getCruiseLabel()));
                    }
                    this.persistBenthosBatches(fishingOperationContext, batches, null);
                }
            }

            private void persistBenthosBatches(GenericFormatImportOperationContext fishingOperationContext, Collection<SpeciesBatch> batches, Integer parentId) {
                int rankOrder = 1;
                for (SpeciesBatch batch : batches) {
                    batch.setRankOrder(Integer.valueOf(rankOrder++));
                    Integer batchObjectId = fishingOperationContext.getBatchObjectId(batch.getIdAsInt());
                    List<SpeciesBatchFrequency> frequencies = fishingOperationContext.getBenthosFrequencies(batch);
                    batch.setId((Integer)null);
                    SpeciesBatch createdBatch = ImportCatchAction.this.persistenceHelper.createBenthosBatch(batch, parentId);
                    Collection<AttachmentRow> attachmentRows = ImportCatchAction.this.importContext.popAttachmentRows(ObjectTypeCode.BATCH, batchObjectId);
                    ImportCatchAction.this.persistenceHelper.persistAttachments(createdBatch.getIdAsInt(), attachmentRows);
                    if (CollectionUtils.isNotEmpty(frequencies)) {
                        Integer batchId = batch.getIdAsInt();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + frequencies.size() + " frequency(ies) (benthos batch: " + batchId + ") of " + fishingOperationContext.getFishingOperationLabel() + " for cruise: " + ImportCatchAction.this.importContext.decorate(fishingOperationContext.getFishingOperation().getCruise())));
                        }
                        ImportCatchAction.this.persistenceHelper.saveBenthosBatchFrequency(batchId, frequencies);
                    }
                    if (batch.isChildBatchsEmpty()) continue;
                    this.persistBenthosBatches(fishingOperationContext, batch.getChildBatchs(), createdBatch.getIdAsInt());
                }
            }

            private void deleteBenthosBatches(GenericFormatImportOperationContext fishingOperationContext) {
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                ImportCatchAction.this.persistenceHelper.deleteBenthosBatchForFishingOperation(fishingOperation.getIdAsInt());
            }
        });
    }
}

