/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class GenericFormatImportOperationContext
implements Closeable {
    public static final Function<GenericFormatImportOperationContext, FishingOperation> TO_FISHING_OPERATION_FUNCTION = GenericFormatImportOperationContext::getFishingOperation;
    private final FishingOperation fishingOperation;
    private final CatchBatch catchBatch;
    private final OperationDataModel existingFishingOperationData;
    private final String fishingOperationLabel;
    private final Collection<MarineLitterBatch> marineLitterBatches;
    private final Map<Integer, AccidentalBatch> accidentalBatchesById;
    private final Map<Integer, IndividualObservationBatch> individualObservationBatchesById;
    private final Map<Integer, SpeciesBatch> vracSpeciesBatches;
    private final Map<Integer, SpeciesBatch> horsVracSpeciesBatches;
    private final ArrayListMultimap<Integer, SpeciesBatchFrequency> speciesFrequencies;
    private final Map<Integer, SpeciesBatch> vracBenthosBatches;
    private final Map<Integer, SpeciesBatch> horsVracBenthosBatches;
    private final Map<Integer, Integer> batchesObjectIds;
    private final ArrayListMultimap<Integer, SpeciesBatchFrequency> benthosFrequencies;
    private final CaracteristicMap gearUseFeatures;
    private final CaracteristicMap vesselUseFeatures;
    private final Set<String> checkErrors;
    private boolean weightsDeleted;

    public GenericFormatImportOperationContext(FishingOperation fishingOperation, CatchBatch catchBatch, OperationDataModel existingFishingOperationData, String fishingOperationLabel) {
        this.fishingOperation = fishingOperation;
        this.catchBatch = catchBatch;
        this.existingFishingOperationData = existingFishingOperationData;
        this.fishingOperationLabel = fishingOperationLabel;
        this.marineLitterBatches = new ArrayList<MarineLitterBatch>();
        this.accidentalBatchesById = new TreeMap<Integer, AccidentalBatch>();
        this.individualObservationBatchesById = new TreeMap<Integer, IndividualObservationBatch>();
        this.vracSpeciesBatches = new TreeMap<Integer, SpeciesBatch>();
        this.horsVracSpeciesBatches = new TreeMap<Integer, SpeciesBatch>();
        this.speciesFrequencies = ArrayListMultimap.create();
        this.vracBenthosBatches = new TreeMap<Integer, SpeciesBatch>();
        this.horsVracBenthosBatches = new TreeMap<Integer, SpeciesBatch>();
        this.benthosFrequencies = ArrayListMultimap.create();
        this.gearUseFeatures = new CaracteristicMap();
        this.vesselUseFeatures = new CaracteristicMap();
        this.checkErrors = new LinkedHashSet<String>();
        this.batchesObjectIds = new TreeMap<Integer, Integer>();
    }

    public boolean isOverride() {
        return this.existingFishingOperationData != null;
    }

    public OperationDataModel getExistingFishingOperationData() {
        return this.existingFishingOperationData;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public String getFishingOperationLabel() {
        return this.fishingOperationLabel;
    }

    public boolean withGearFeatures() {
        return MapUtils.isNotEmpty((Map)this.gearUseFeatures);
    }

    public boolean withVesselFeatures() {
        return MapUtils.isNotEmpty((Map)this.vesselUseFeatures);
    }

    public boolean withMarineLitterBatches() {
        return CollectionUtils.isNotEmpty(this.marineLitterBatches);
    }

    public boolean withAccidentalBatches() {
        return MapUtils.isNotEmpty(this.accidentalBatchesById);
    }

    public boolean withIndividualObservationBatches() {
        return MapUtils.isNotEmpty(this.individualObservationBatchesById);
    }

    public boolean withSpeciesBatches(boolean vrac) {
        return MapUtils.isNotEmpty(this.getSpeciesBatchMap(vrac));
    }

    public boolean withBenthosBatches(boolean vrac) {
        return MapUtils.isNotEmpty(this.getBenthosBatchMap(vrac));
    }

    public AccidentalBatch getAccidentalBatchById(Integer accidentalBatchId) {
        return this.accidentalBatchesById.get(accidentalBatchId);
    }

    public IndividualObservationBatch getIndividualObservationBatchesById(Integer individualObservationBatchId) {
        return this.individualObservationBatchesById.get(individualObservationBatchId);
    }

    public SpeciesBatch getSpeciesBatch(boolean vrac, Integer referenceTaxonId) {
        return this.getSpeciesBatchMap(vrac).get(referenceTaxonId);
    }

    public SpeciesBatch getBenthosBatch(boolean vrac, Integer referenceTaxonId) {
        return this.getBenthosBatchMap(vrac).get(referenceTaxonId);
    }

    public void addGearUseFeature(Caracteristic caracteristic, Serializable value) {
        this.gearUseFeatures.put(caracteristic, value);
    }

    public void addVesselUseFeature(Caracteristic caracteristic, Serializable value) {
        this.vesselUseFeatures.put(caracteristic, value);
    }

    public void addMarineLitterBatch(MarineLitterBatch marineLitterBatch) {
        this.marineLitterBatches.add(marineLitterBatch);
    }

    public void addAccidentalBatch(Integer batchId, AccidentalBatch accidentalBatch) {
        this.accidentalBatchesById.put(batchId, accidentalBatch);
    }

    public void addIndividualObservationBatch(Integer batchId, IndividualObservationBatch individualObservationBatch) {
        this.individualObservationBatchesById.put(batchId, individualObservationBatch);
    }

    public void addSpeciesBatch(boolean vrac, SpeciesBatch speciesBatch) {
        this.getSpeciesBatchMap(vrac).put(speciesBatch.getSpecies().getReferenceTaxonId(), speciesBatch);
    }

    public void addBenthosBatch(boolean vrac, SpeciesBatch benthosBatch) {
        this.getBenthosBatchMap(vrac).put(benthosBatch.getSpecies().getReferenceTaxonId(), benthosBatch);
    }

    public void addSpeciesFrequency(SpeciesBatch batch, SpeciesBatchFrequency frequency) {
        this.speciesFrequencies.put((Object)batch.getIdAsInt(), (Object)frequency);
    }

    public void addBenthosFrequency(SpeciesBatch batch, SpeciesBatchFrequency frequency) {
        this.benthosFrequencies.put((Object)batch.getIdAsInt(), (Object)frequency);
    }

    public void addCheckErrors(Set<String> checkErrors) {
        this.checkErrors.addAll(checkErrors);
    }

    public Collection<MarineLitterBatch> getMarineLitterBatches() {
        return ImmutableList.copyOf(this.marineLitterBatches);
    }

    public Collection<AccidentalBatch> getAccidentalBatches() {
        return ImmutableList.copyOf(this.accidentalBatchesById.values());
    }

    public Collection<IndividualObservationBatch> getIndividualObservationBatches() {
        return ImmutableList.copyOf(this.individualObservationBatchesById.values());
    }

    public int getNbSpeciesTaxon() {
        HashSet speciesSet = new HashSet();
        SpeciesBatchs.grabSpeciesChildBatchs(this.vracSpeciesBatches.values(), speciesSet);
        SpeciesBatchs.grabSpeciesChildBatchs(this.horsVracSpeciesBatches.values(), speciesSet);
        return speciesSet.size();
    }

    public int getNbBenthosTaxon() {
        HashSet speciesSet = new HashSet();
        SpeciesBatchs.grabSpeciesChildBatchs(this.vracBenthosBatches.values(), speciesSet);
        SpeciesBatchs.grabSpeciesChildBatchs(this.horsVracBenthosBatches.values(), speciesSet);
        return speciesSet.size();
    }

    public Collection<SpeciesBatch> getSpeciesBatches(boolean vrac) {
        return ImmutableList.copyOf(this.getSpeciesBatchMap(vrac).values());
    }

    public Collection<SpeciesBatch> getBenthosBatches(boolean vrac) {
        return ImmutableList.copyOf(this.getBenthosBatchMap(vrac).values());
    }

    public List<SpeciesBatchFrequency> getBenthosFrequencies(SpeciesBatch benthosBatch) {
        return this.benthosFrequencies.get((Object)benthosBatch.getIdAsInt());
    }

    public List<SpeciesBatchFrequency> getSpeciesFrequencies(SpeciesBatch speciesBatch) {
        return this.speciesFrequencies.get((Object)speciesBatch.getIdAsInt());
    }

    public CaracteristicMap getGearUseFeatures() {
        return this.gearUseFeatures;
    }

    public CaracteristicMap getVesselUseFeatures() {
        return this.vesselUseFeatures;
    }

    private Map<Integer, SpeciesBatch> getSpeciesBatchMap(boolean vrac) {
        return vrac ? this.vracSpeciesBatches : this.horsVracSpeciesBatches;
    }

    private Map<Integer, SpeciesBatch> getBenthosBatchMap(boolean vrac) {
        return vrac ? this.vracBenthosBatches : this.horsVracBenthosBatches;
    }

    public Set<String> getCheckErrors() {
        return this.checkErrors;
    }

    @Override
    public void close() {
        this.gearUseFeatures.clear();
        this.vesselUseFeatures.clear();
        this.marineLitterBatches.clear();
        this.individualObservationBatchesById.clear();
        this.accidentalBatchesById.clear();
        this.benthosFrequencies.clear();
        this.vracBenthosBatches.clear();
        this.horsVracBenthosBatches.clear();
        this.speciesFrequencies.clear();
        this.vracSpeciesBatches.clear();
        this.horsVracSpeciesBatches.clear();
    }

    public void registerBatchObjectId(Integer batchId, Integer objectId) {
        if (objectId != null) {
            this.batchesObjectIds.put(batchId, objectId);
        }
    }

    public Integer getBatchObjectId(Integer batchId) {
        return this.batchesObjectIds.get(batchId);
    }

    public void setWeightsDeleted(boolean weightsDeleted) {
        this.weightsDeleted = weightsDeleted;
    }

    public boolean isWeightsDeleted() {
        return this.weightsDeleted;
    }
}

