/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.layout.content.ItemExecutorWrapper;
import org.eclipse.birt.report.engine.layout.content.LineStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class BlockStackingExecutor
extends ReportItemExecutorBase {
    protected IContent content;
    protected IReportItemExecutor executor;
    protected IReportItemExecutor childExecutor;
    protected IContent childContent;
    protected boolean needUpdate = true;
    protected boolean hasNext = false;

    public BlockStackingExecutor(IContent content, IReportItemExecutor executor) {
        this.content = content;
        this.executor = executor;
    }

    @Override
    public void close() throws BirtException {
        this.executor.close();
    }

    @Override
    public IContent execute() {
        return this.content;
    }

    @Override
    public IReportItemExecutor getNextChild() throws BirtException {
        ReportItemExecutorBase ret = null;
        if (this.childContent != null) {
            ret = new ItemExecutorWrapper(this.childExecutor, this.childContent);
            this.childContent = null;
            this.childExecutor = null;
        } else {
            IContent childContent;
            IReportItemExecutor childExecutor = this.executor.getNextChild();
            if (childExecutor != null && (childContent = childExecutor.execute()) != null) {
                ret = PropertyUtil.isInlineElement(childContent) ? new LineStackingExecutor(new ItemExecutorWrapper(childExecutor, childContent), this) : new ItemExecutorWrapper(childExecutor, childContent);
            }
        }
        this.needUpdate = true;
        return ret;
    }

    @Override
    public boolean hasNextChild() throws BirtException {
        if (this.needUpdate) {
            this.hasNext = this.childContent != null ? true : this.executor.hasNextChild();
            this.needUpdate = false;
        }
        return this.hasNext;
    }

    public IReportItemExecutor nextInline() throws BirtException {
        if (this.executor.hasNextChild()) {
            IReportItemExecutor nextExecutor = this.executor.getNextChild();
            IContent nextContent = nextExecutor.execute();
            if (PropertyUtil.isInlineElement(nextContent)) {
                return new ItemExecutorWrapper(nextExecutor, nextContent);
            }
            this.childContent = nextContent;
            this.childExecutor = nextExecutor;
        }
        return null;
    }
}

