/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import winstone.AuthenticationPrincipal;
import winstone.HostConfiguration;
import winstone.HostGroup;
import winstone.Launcher;
import winstone.Logger;
import winstone.ServletConfiguration;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;
import winstone.WinstoneInputStream;
import winstone.WinstoneSession;

public class WinstoneRequest
implements HttpServletRequest {
    protected static DateFormat headerDF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    protected static Random rnd = null;
    static final String CONTENT_LENGTH_HEADER = "Content-Length";
    static final String CONTENT_TYPE_HEADER = "Content-Type";
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String LOCALE_HEADER = "Accept-Language";
    static final String HOST_HEADER = "Host";
    static final String IN_COOKIE_HEADER1 = "Cookie";
    static final String IN_COOKIE_HEADER2 = "Cookie2";
    static final String METHOD_HEAD = "HEAD";
    static final String METHOD_GET = "GET";
    static final String METHOD_POST = "POST";
    static final String POST_PARAMETERS = "application/x-www-form-urlencoded";
    protected Map attributes = new Hashtable();
    protected Map parameters = new Hashtable();
    protected Stack attributesStack;
    protected Stack parametersStack;
    protected String[] headers;
    protected Cookie[] cookies;
    protected String method;
    protected String scheme;
    protected String serverName;
    protected String requestURI;
    protected String servletPath;
    protected String pathInfo;
    protected String queryString;
    protected String protocol;
    protected int contentLength = -1;
    protected String contentType;
    protected String encoding;
    protected int serverPort;
    protected String remoteIP;
    protected String remoteName;
    protected int remotePort;
    protected String localAddr;
    protected String localName;
    protected int localPort;
    protected Boolean parsedParameters;
    protected Map requestedSessionIds;
    protected Map currentSessionIds;
    protected String deadRequestedSessionId;
    protected List locales = new ArrayList();
    protected String authorization;
    protected boolean isSecure = false;
    protected WinstoneInputStream inputData;
    protected BufferedReader inputReader;
    protected ServletConfiguration servletConfig;
    protected WebAppConfiguration webappConfig;
    protected HostGroup hostGroup;
    protected AuthenticationPrincipal authenticatedUser;
    protected ServletRequestAttributeListener[] requestAttributeListeners;
    protected ServletRequestListener[] requestListeners;
    private MessageDigest md5Digester;
    private Set usedSessions;

    public WinstoneRequest() throws IOException {
        this.attributesStack = new Stack();
        this.parametersStack = new Stack();
        this.requestedSessionIds = new Hashtable();
        this.currentSessionIds = new Hashtable();
        this.usedSessions = new HashSet();
        try {
            this.md5Digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException err) {
            throw new WinstoneException("MD5 digester unavailable - what the ...?");
        }
    }

    public void cleanUp() {
        this.requestListeners = null;
        this.requestAttributeListeners = null;
        this.attributes.clear();
        this.parameters.clear();
        this.attributesStack.clear();
        this.parametersStack.clear();
        this.usedSessions.clear();
        this.headers = null;
        this.cookies = null;
        this.method = null;
        this.scheme = null;
        this.serverName = null;
        this.requestURI = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.queryString = null;
        this.protocol = null;
        this.contentLength = -1;
        this.contentType = null;
        this.encoding = null;
        this.inputData = null;
        this.inputReader = null;
        this.servletConfig = null;
        this.webappConfig = null;
        this.hostGroup = null;
        this.serverPort = -1;
        this.remoteIP = null;
        this.remoteName = null;
        this.remotePort = -1;
        this.localAddr = null;
        this.localName = null;
        this.localPort = -1;
        this.parsedParameters = null;
        this.requestedSessionIds.clear();
        this.currentSessionIds.clear();
        this.deadRequestedSessionId = null;
        this.locales.clear();
        this.authorization = null;
        this.isSecure = false;
        this.authenticatedUser = null;
    }

    private String extractFirstHeader(String name) {
        for (int n = 0; n < this.headers.length; ++n) {
            if (!this.headers[n].toUpperCase().startsWith(name.toUpperCase() + ':')) continue;
            return this.headers[n].substring(name.length() + 1).trim();
        }
        return null;
    }

    private Collection extractHeaderNameList() {
        HashSet<String> headerNames = new HashSet<String>();
        for (int n = 0; n < this.headers.length; ++n) {
            String name = this.headers[n];
            int colonPos = name.indexOf(58);
            headerNames.add(name.substring(0, colonPos));
        }
        return headerNames;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Stack getAttributesStack() {
        return this.attributesStack;
    }

    public Stack getParametersStack() {
        return this.parametersStack;
    }

    public Map getCurrentSessionIds() {
        return this.currentSessionIds;
    }

    public Map getRequestedSessionIds() {
        return this.requestedSessionIds;
    }

    public String getDeadRequestedSessionId() {
        return this.deadRequestedSessionId;
    }

    public HostGroup getHostGroup() {
        return this.hostGroup;
    }

    public WebAppConfiguration getWebAppConfig() {
        return this.webappConfig;
    }

    public ServletConfiguration getServletConfig() {
        return this.servletConfig;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Boolean getParsedParameters() {
        return this.parsedParameters;
    }

    public List getListLocales() {
        return this.locales;
    }

    public void setInputStream(WinstoneInputStream inputData) {
        this.inputData = inputData;
    }

    public void setHostGroup(HostGroup hostGroup) {
        this.hostGroup = hostGroup;
    }

    public void setWebAppConfig(WebAppConfiguration webappConfig) {
        this.webappConfig = webappConfig;
    }

    public void setServletConfig(ServletConfiguration servletConfig) {
        this.servletConfig = servletConfig;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void setRemoteIP(String remoteIP) {
        this.remoteIP = remoteIP;
    }

    public void setRemoteName(String name) {
        this.remoteName = name;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public void setLocalAddr(String ip) {
        this.localName = ip;
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setIsSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setProtocol(String protocolString) {
        this.protocol = protocolString;
    }

    public void setRemoteUser(AuthenticationPrincipal user) {
        this.authenticatedUser = user;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setAuthorization(String auth) {
        this.authorization = auth;
    }

    public void setLocales(List locales) {
        this.locales = locales;
    }

    public void setCurrentSessionIds(Map currentSessionIds) {
        this.currentSessionIds = currentSessionIds;
    }

    public void setRequestedSessionIds(Map requestedSessionIds) {
        this.requestedSessionIds = requestedSessionIds;
    }

    public void setDeadRequestedSessionId(String deadRequestedSessionId) {
        this.deadRequestedSessionId = deadRequestedSessionId;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setParsedParameters(Boolean parsed) {
        this.parsedParameters = parsed;
    }

    public void setRequestListeners(ServletRequestListener[] rl) {
        this.requestListeners = rl;
    }

    public void setRequestAttributeListeners(ServletRequestAttributeListener[] ral) {
        this.requestAttributeListeners = ral;
    }

    public static void extractParameters(String urlEncodedParams, String encoding, Map outputParams, boolean overwrite) {
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParsingParameters", new String[]{urlEncodedParams, encoding});
        StringTokenizer st = new StringTokenizer(urlEncodedParams, "&", false);
        HashSet<String> overwrittenParamNames = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int equalPos = token.indexOf(61);
            try {
                String decodedName = WinstoneRequest.decodeURLToken(equalPos == -1 ? token : token.substring(0, equalPos), encoding == null ? "UTF-8" : encoding);
                String decodedValue = equalPos == -1 ? "" : WinstoneRequest.decodeURLToken(token.substring(equalPos + 1), encoding == null ? "UTF-8" : encoding);
                Object already = null;
                if (overwrite) {
                    if (overwrittenParamNames == null) {
                        overwrittenParamNames = new HashSet<String>();
                    }
                    if (!overwrittenParamNames.contains(decodedName)) {
                        overwrittenParamNames.add(decodedName);
                        outputParams.remove(decodedName);
                    }
                }
                if ((already = outputParams.get(decodedName)) == null) {
                    outputParams.put(decodedName, decodedValue);
                    continue;
                }
                if (already instanceof String) {
                    String[] pair = new String[]{already, decodedValue};
                    outputParams.put(decodedName, pair);
                    continue;
                }
                if (already instanceof String[]) {
                    String[] alreadyArray = already;
                    String[] oneMore = new String[alreadyArray.length + 1];
                    System.arraycopy(alreadyArray, 0, oneMore, 0, alreadyArray.length);
                    oneMore[oneMore.length - 1] = decodedValue;
                    outputParams.put(decodedName, oneMore);
                    continue;
                }
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.UnknownParameterType", decodedName + " = " + decodedValue.getClass());
            }
            catch (UnsupportedEncodingException err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WinstoneRequest.ErrorParameters", err);
            }
        }
    }

    public static String decodeURLToken(String in) {
        return WinstoneRequest.decodeURLToken(in, true);
    }

    public static String decodeURLToken(String in, String encoding) throws UnsupportedEncodingException {
        return WinstoneRequest.decodeURLToken(in, encoding, true);
    }

    public static String decodeURLToken(String in, boolean isQueryString) {
        try {
            return WinstoneRequest.decodeURLToken(in, "UTF-8", isQueryString);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public static String decodeURLToken(String in, String encoding, boolean isQueryString) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int n = 0; n < in.length(); ++n) {
            char thisChar = in.charAt(n);
            if (thisChar == '+' && isQueryString) {
                baos.write(32);
                continue;
            }
            if (thisChar == '%') {
                String token = in.substring(Math.min(n + 1, in.length()), Math.min(n + 3, in.length()));
                try {
                    int decoded = Integer.parseInt(token, 16);
                    baos.write(decoded);
                    n += 2;
                }
                catch (RuntimeException err) {
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.InvalidURLTokenChar", token);
                    baos.write(thisChar);
                }
                continue;
            }
            baos.write(thisChar);
        }
        return new String(baos.toByteArray(), encoding);
    }

    public void discardRequestBody() {
        block7: {
            if (this.getContentLength() > 0) {
                try {
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.ForceBodyParsing");
                    if (this.parsedParameters != null && !this.parsedParameters.equals(Boolean.FALSE)) break block7;
                    try {
                        ServletInputStream in = this.getInputStream();
                        byte[] buffer = new byte[2048];
                        while (in.read(buffer) != -1) {
                        }
                    }
                    catch (IllegalStateException err) {
                        BufferedReader in = this.getReader();
                        char[] buffer = new char[2048];
                        while (in.read(buffer) != -1) {
                        }
                    }
                }
                catch (IOException err) {
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneResponse.ErrorForceBodyParsing", err);
                }
            }
        }
    }

    public void parseRequestParameters() {
        if (this.parsedParameters != null && !this.parsedParameters.booleanValue()) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.BothMethods");
            this.parsedParameters = Boolean.TRUE;
        } else if (this.parsedParameters == null) {
            HashMap workingParameters = new HashMap();
            try {
                if ((this.method.equals(METHOD_GET) || this.method.equals(METHOD_HEAD) || this.method.equals(METHOD_POST)) && this.queryString != null) {
                    WinstoneRequest.extractParameters(this.queryString, this.encoding, workingParameters, false);
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParamLine", "" + workingParameters);
                }
                if (this.method.equals(METHOD_POST) && this.contentType != null && (this.contentType.equals(POST_PARAMETERS) || this.contentType.startsWith("application/x-www-form-urlencoded;"))) {
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParsingBodyParameters");
                    byte[] paramBuffer = new byte[this.contentLength];
                    int readCount = this.inputData.readAsMuchAsPossible(paramBuffer, 0, this.contentLength);
                    if (readCount != this.contentLength) {
                        Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.IncorrectContentLength", new String[]{this.contentLength + "", readCount + ""});
                    }
                    String paramLine = this.encoding == null ? new String(paramBuffer) : new String(paramBuffer, this.encoding);
                    WinstoneRequest.extractParameters(paramLine.trim(), this.encoding, workingParameters, false);
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParamLine", "" + workingParameters);
                }
                this.parameters.putAll(workingParameters);
                this.parsedParameters = Boolean.TRUE;
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WinstoneRequest.ErrorBodyParameters", err);
                this.parsedParameters = null;
            }
        }
    }

    public void parseHeaders(List headerList) {
        ArrayList<String> outHeaderList = new ArrayList<String>();
        ArrayList cookieList = new ArrayList();
        Iterator i = headerList.iterator();
        while (i.hasNext()) {
            String header = (String)i.next();
            int colonPos = header.indexOf(58);
            String name = header.substring(0, colonPos);
            String value = header.substring(colonPos + 1).trim();
            outHeaderList.add(header);
            if (name.equalsIgnoreCase(AUTHORIZATION_HEADER)) {
                this.authorization = value;
                continue;
            }
            if (name.equalsIgnoreCase(LOCALE_HEADER)) {
                this.locales = this.parseLocales(value);
                continue;
            }
            if (name.equalsIgnoreCase(CONTENT_LENGTH_HEADER)) {
                this.contentLength = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase(HOST_HEADER)) {
                int nextColonPos = value.indexOf(58);
                if (nextColonPos == -1 || nextColonPos == value.length() - 1) {
                    this.serverName = value;
                    if (this.scheme == null) continue;
                    if (this.scheme.equals("http")) {
                        this.serverPort = 80;
                        continue;
                    }
                    if (!this.scheme.equals("https")) continue;
                    this.serverPort = 443;
                    continue;
                }
                this.serverName = value.substring(0, nextColonPos);
                this.serverPort = Integer.parseInt(value.substring(nextColonPos + 1));
                continue;
            }
            if (name.equalsIgnoreCase(CONTENT_TYPE_HEADER)) {
                String encodingClause;
                this.contentType = value;
                int semicolon = value.lastIndexOf(59);
                if (semicolon == -1 || !(encodingClause = value.substring(semicolon + 1).trim()).startsWith("charset=")) continue;
                this.encoding = encodingClause.substring(8);
                continue;
            }
            if (!name.equalsIgnoreCase(IN_COOKIE_HEADER1) && !name.equalsIgnoreCase(IN_COOKIE_HEADER2)) continue;
            this.parseCookieLine(value, cookieList);
        }
        this.headers = outHeaderList.toArray(new String[0]);
        this.cookies = cookieList.isEmpty() ? null : cookieList.toArray(new Cookie[0]);
    }

    private static String nextToken(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    private void parseCookieLine(String headerValue, List cookieList) {
        int equalPos;
        StringTokenizer st = new StringTokenizer(headerValue, ";", false);
        int version = 0;
        String cookieLine = WinstoneRequest.nextToken(st);
        if (cookieLine != null && cookieLine.startsWith("$Version=")) {
            equalPos = cookieLine.indexOf(61);
            try {
                version = Integer.parseInt(WinstoneRequest.extractFromQuotes(cookieLine.substring(equalPos + 1).trim()));
            }
            catch (NumberFormatException err) {
                version = 0;
            }
            cookieLine = WinstoneRequest.nextToken(st);
        }
        while (cookieLine != null) {
            equalPos = (cookieLine = cookieLine.trim()).indexOf(61);
            if (equalPos == -1) {
                cookieLine = WinstoneRequest.nextToken(st);
                continue;
            }
            String name = cookieLine.substring(0, equalPos);
            String value = WinstoneRequest.extractFromQuotes(cookieLine.substring(equalPos + 1));
            Cookie thisCookie = new Cookie(name, value);
            thisCookie.setVersion(version);
            thisCookie.setSecure(this.isSecure());
            cookieList.add(thisCookie);
            cookieLine = WinstoneRequest.nextToken(st);
            while (cookieLine != null && cookieLine.trim().startsWith("$")) {
                String attrValue;
                equalPos = (cookieLine = cookieLine.trim()).indexOf(61);
                String string = attrValue = equalPos == -1 ? "" : cookieLine.substring(equalPos + 1).trim();
                if (cookieLine.startsWith("$Path")) {
                    thisCookie.setPath(WinstoneRequest.extractFromQuotes(attrValue));
                } else if (cookieLine.startsWith("$Domain")) {
                    thisCookie.setDomain(WinstoneRequest.extractFromQuotes(attrValue));
                }
                cookieLine = WinstoneRequest.nextToken(st);
            }
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.CookieFound", thisCookie.toString());
            if (!thisCookie.getName().equals("JSESSIONID")) continue;
            HostConfiguration hostConfig = this.hostGroup.getHostByName(this.serverName);
            WebAppConfiguration ownerContext = hostConfig.getWebAppBySessionKey(thisCookie.getValue());
            if (ownerContext != null) {
                this.requestedSessionIds.put(ownerContext.getContextPath(), thisCookie.getValue());
                this.currentSessionIds.put(ownerContext.getContextPath(), thisCookie.getValue());
            } else {
                this.deadRequestedSessionId = thisCookie.getValue();
            }
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.SessionCookieFound", new String[]{thisCookie.getValue(), ownerContext == null ? "" : "prefix:" + ownerContext.getContextPath()});
        }
    }

    private static String extractFromQuotes(String input) {
        if (input != null && input.startsWith("\"") && input.endsWith("\"")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    private List parseLocales(String header) {
        StringBuffer lb = new StringBuffer();
        for (int n = 0; n < header.length(); ++n) {
            char c = header.charAt(n);
            if (Character.isWhitespace(c)) continue;
            lb.append(c);
        }
        HashMap<Float, ArrayList<Locale>> localeEntries = new HashMap<Float, ArrayList<Locale>>();
        StringTokenizer commaTK = new StringTokenizer(lb.toString(), ",", false);
        while (commaTK.hasMoreTokens()) {
            String clause = commaTK.nextToken();
            Float quality = new Float(1.0f);
            if (clause.indexOf(";q=") != -1) {
                int pos = clause.indexOf(";q=");
                try {
                    quality = new Float(clause.substring(pos + 3));
                }
                catch (NumberFormatException err) {
                    quality = new Float(0.0f);
                }
                clause = clause.substring(0, pos);
            }
            String language = "";
            String country = "";
            String variant = "";
            int dpos = clause.indexOf(45);
            if (dpos == -1) {
                language = clause;
            } else {
                language = clause.substring(0, dpos);
                String remainder = clause.substring(dpos + 1);
                int d2pos = remainder.indexOf(45);
                if (d2pos == -1) {
                    country = remainder;
                } else {
                    country = remainder.substring(0, d2pos);
                    variant = remainder.substring(d2pos + 1);
                }
            }
            Locale loc = new Locale(language, country, variant);
            ArrayList<Locale> localeList = (ArrayList<Locale>)localeEntries.get(quality);
            if (localeList == null) {
                localeList = new ArrayList<Locale>();
                localeEntries.put(quality, localeList);
            }
            localeList.add(loc);
        }
        Object[] orderKeys = localeEntries.keySet().toArray(new Float[0]);
        Arrays.sort(orderKeys);
        ArrayList outputLocaleList = new ArrayList();
        for (int n = 0; n < orderKeys.length; ++n) {
            int reversedIndex = orderKeys.length - 1 - n;
            if (((Float)orderKeys[reversedIndex]).floatValue() <= 0.0f || ((Float)orderKeys[reversedIndex]).floatValue() > 1.0f) continue;
            List localeList = (List)localeEntries.get(orderKeys[reversedIndex]);
            Iterator i = localeList.iterator();
            while (i.hasNext()) {
                outputLocaleList.add(i.next());
            }
        }
        return outputLocaleList;
    }

    public void addIncludeQueryParameters(String queryString) {
        Hashtable lastParams = new Hashtable();
        if (!this.parametersStack.isEmpty()) {
            lastParams.putAll((Map)this.parametersStack.peek());
        }
        HashMap newQueryParams = new HashMap();
        if (queryString != null) {
            WinstoneRequest.extractParameters(queryString, this.encoding, newQueryParams, false);
        }
        lastParams.putAll(newQueryParams);
        this.parametersStack.push(lastParams);
    }

    public void addIncludeAttributes(String requestURI, String contextPath, String servletPath, String pathInfo, String queryString) {
        HashMap<String, String> includeAttributes = new HashMap<String, String>();
        if (requestURI != null) {
            includeAttributes.put("javax.servlet.include.request_uri", requestURI);
        }
        if (contextPath != null) {
            includeAttributes.put("javax.servlet.include.context_path", contextPath);
        }
        if (servletPath != null) {
            includeAttributes.put("javax.servlet.include.servlet_path", servletPath);
        }
        if (pathInfo != null) {
            includeAttributes.put("javax.servlet.include.path_info", pathInfo);
        }
        if (queryString != null) {
            includeAttributes.put("javax.servlet.include.query_string", queryString);
        }
        this.attributesStack.push(includeAttributes);
    }

    public void removeIncludeQueryString() {
        if (!this.parametersStack.isEmpty()) {
            this.parametersStack.pop();
        }
    }

    public void clearIncludeStackForForward() {
        this.parametersStack.clear();
        this.attributesStack.clear();
    }

    public void setForwardQueryString(String forwardQueryString) {
        if (forwardQueryString != null) {
            String oldQueryString = this.queryString == null ? "" : this.queryString;
            boolean needJoiner = !forwardQueryString.equals("") && !oldQueryString.equals("");
            this.queryString = forwardQueryString + (needJoiner ? "&" : "") + oldQueryString;
            if (this.parsedParameters != null) {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParsingParameters", new String[]{forwardQueryString, this.encoding});
                WinstoneRequest.extractParameters(forwardQueryString, this.encoding, this.parameters, true);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneRequest.ParamLine", "" + this.parameters);
            }
        }
    }

    public void removeIncludeAttributes() {
        if (!this.attributesStack.isEmpty()) {
            this.attributesStack.pop();
        }
    }

    public Object getAttribute(String name) {
        Map includedAttributes;
        Object value;
        if (!this.attributesStack.isEmpty() && (value = (includedAttributes = (Map)this.attributesStack.peek()).get(name)) != null) {
            return value;
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        HashMap attributes = new HashMap(this.attributes);
        if (!this.attributesStack.isEmpty()) {
            Map includedAttributes = (Map)this.attributesStack.peek();
            attributes.putAll(includedAttributes);
        }
        return Collections.enumeration(attributes.keySet());
    }

    public void removeAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value == null) {
            return;
        }
        if (this.requestAttributeListeners != null) {
            for (int n = 0; n < this.requestAttributeListeners.length; ++n) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getWebAppConfig().getLoader());
                this.requestAttributeListeners[n].attributeRemoved(new ServletRequestAttributeEvent(this.webappConfig, this, name, value));
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        if (name != null && o != null) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, o);
            if (this.requestAttributeListeners != null) {
                if (oldValue == null) {
                    for (int n = 0; n < this.requestAttributeListeners.length; ++n) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getWebAppConfig().getLoader());
                        this.requestAttributeListeners[n].attributeAdded(new ServletRequestAttributeEvent(this.webappConfig, this, name, o));
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                } else {
                    for (int n = 0; n < this.requestAttributeListeners.length; ++n) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getWebAppConfig().getLoader());
                        this.requestAttributeListeners[n].attributeReplaced(new ServletRequestAttributeEvent(this.webappConfig, this, name, oldValue));
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            }
        } else if (name != null) {
            this.removeAttribute(name);
        }
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        "blah".getBytes(encoding);
        if (this.inputReader == null) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneRequest.SetCharEncoding", new String[]{this.encoding, encoding});
            this.encoding = encoding;
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locales.isEmpty() ? Locale.getDefault() : (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        List sendLocales = this.locales;
        if (sendLocales.isEmpty()) {
            sendLocales.add(Locale.getDefault());
        }
        return Collections.enumeration(sendLocales);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputReader != null) {
            return this.inputReader;
        }
        if (this.parsedParameters != null) {
            if (this.parsedParameters.equals(Boolean.TRUE)) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.BothMethodsReader");
            } else {
                throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneRequest.CalledReaderAfterStream"));
            }
        }
        this.inputReader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)this.inputData, this.encoding)) : new BufferedReader(new InputStreamReader(this.inputData));
        this.parsedParameters = new Boolean(false);
        return this.inputReader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputReader != null) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneRequest.CalledStreamAfterReader"));
        }
        if (this.parsedParameters != null && this.parsedParameters.equals(Boolean.TRUE)) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneRequest.BothMethods");
        }
        this.parsedParameters = new Boolean(false);
        return this.inputData;
    }

    public String getParameter(String name) {
        this.parseRequestParameters();
        Object param = null;
        if (!this.parametersStack.isEmpty()) {
            param = ((Map)this.parametersStack.peek()).get(name);
        }
        if (param == null) {
            param = this.parameters.get(name);
        }
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            return (String)param;
        }
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        return param.toString();
    }

    public Enumeration getParameterNames() {
        this.parseRequestParameters();
        HashSet parameterKeys = new HashSet(this.parameters.keySet());
        if (!this.parametersStack.isEmpty()) {
            parameterKeys.addAll(((Map)this.parametersStack.peek()).keySet());
        }
        return Collections.enumeration(parameterKeys);
    }

    public String[] getParameterValues(String name) {
        this.parseRequestParameters();
        Object param = null;
        if (!this.parametersStack.isEmpty()) {
            param = ((Map)this.parametersStack.peek()).get(name);
        }
        if (param == null) {
            param = this.parameters.get(name);
        }
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            return new String[]{(String)param};
        }
        if (param instanceof String[]) {
            return (String[])param;
        }
        throw new WinstoneException(Launcher.RESOURCES.getString("WinstoneRequest.UnknownParameterType", name + " - " + param.getClass()));
    }

    public Map getParameterMap() {
        Hashtable<String, String[]> paramMap = new Hashtable<String, String[]>();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramMap.put(name, this.getParameterValues(name));
        }
        return paramMap;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getRemoteAddr() {
        return this.remoteIP;
    }

    public String getRemoteHost() {
        return this.remoteName;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path.startsWith("/")) {
            return this.webappConfig.getRequestDispatcher(path);
        }
        String fullPath = this.getServletPath() + (this.getPathInfo() == null ? "" : this.getPathInfo());
        int lastSlash = fullPath.lastIndexOf(47);
        String currentDir = lastSlash == -1 ? "/" : fullPath.substring(0, lastSlash + 1);
        return this.webappConfig.getRequestDispatcher(currentDir + path);
    }

    public String getContextPath() {
        return this.webappConfig.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateHeader(String name) {
        String dateHeader = this.getHeader(name);
        if (dateHeader == null) {
            return -1L;
        }
        try {
            Date date = null;
            DateFormat dateFormat = headerDF;
            synchronized (dateFormat) {
                date = headerDF.parse(dateHeader);
            }
            return date.getTime();
        }
        catch (ParseException err) {
            throw new IllegalArgumentException(Launcher.RESOURCES.getString("WinstoneRequest.BadDate", dateHeader));
        }
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public String getHeader(String name) {
        return this.extractFirstHeader(name);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.extractHeaderNameList());
    }

    public Enumeration getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int n = 0; n < this.headers.length; ++n) {
            if (!this.headers[n].toUpperCase().startsWith(name.toUpperCase() + ':')) continue;
            headers.add(this.headers[n].substring(name.length() + 1).trim());
        }
        return Collections.enumeration(headers);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.webappConfig.getRealPath(this.pathInfo);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getRequestedSessionId() {
        String actualSessionId = (String)this.requestedSessionIds.get(this.webappConfig.getContextPath());
        if (actualSessionId != null) {
            return actualSessionId;
        }
        return this.deadRequestedSessionId;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        url.append(this.getScheme()).append("://");
        url.append(this.getServerName());
        if (!(this.getServerPort() == 80 && this.getScheme().equals("http") || this.getServerPort() == 443 && this.getScheme().equals("https"))) {
            url.append(':').append(this.getServerPort());
        }
        url.append(this.getRequestURI());
        return url;
    }

    public Principal getUserPrincipal() {
        return this.authenticatedUser;
    }

    public boolean isUserInRole(String role) {
        if (this.authenticatedUser == null) {
            return false;
        }
        if (this.servletConfig.getSecurityRoleRefs() == null) {
            return this.authenticatedUser.isUserIsInRole(role);
        }
        String replacedRole = (String)this.servletConfig.getSecurityRoleRefs().get(role);
        return this.authenticatedUser.isUserIsInRole(replacedRole == null ? role : replacedRole);
    }

    public String getAuthType() {
        return this.authenticatedUser == null ? null : this.authenticatedUser.getAuthType();
    }

    public String getRemoteUser() {
        return this.authenticatedUser == null ? null : this.authenticatedUser.getName();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequestedSessionId() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        String requestedId = this.getRequestedSessionId();
        if (requestedId == null) {
            return false;
        }
        WinstoneSession ws = this.webappConfig.getSessionById(requestedId, false);
        return ws != null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        WinstoneSession session;
        String cookieValue = (String)this.currentSessionIds.get(this.webappConfig.getContextPath());
        if (cookieValue == null) {
            if (!create) {
                return null;
            }
            cookieValue = this.makeNewSession().getId();
        }
        if ((session = this.webappConfig.getSessionById(cookieValue, false)) != null) {
            // empty if block
        }
        if (create && session == null) {
            session = this.makeNewSession();
        }
        if (session != null) {
            this.usedSessions.add(session);
            session.addUsed(this);
        }
        return session;
    }

    private WinstoneSession makeNewSession() {
        String cookieValue = "Winstone_" + this.remoteIP + "_" + this.serverPort + "_" + System.currentTimeMillis() + rnd.nextLong();
        byte[] digestBytes = this.md5Digester.digest(cookieValue.getBytes());
        char[] outArray = new char[32];
        for (int n = 0; n < digestBytes.length; ++n) {
            int hiNibble = (digestBytes[n] & 0xFF) >> 4;
            int loNibble = digestBytes[n] & 0xF;
            outArray[2 * n] = hiNibble > 9 ? (char)(hiNibble + 87) : (char)(hiNibble + 48);
            outArray[2 * n + 1] = loNibble > 9 ? (char)(loNibble + 87) : (char)(loNibble + 48);
        }
        String newSessionId = new String(outArray);
        this.currentSessionIds.put(this.webappConfig.getContextPath(), newSessionId);
        return this.webappConfig.makeNewSession(newSessionId);
    }

    public void markSessionsAsRequestFinished(long lastAccessedTime, boolean saveSessions) {
        Iterator i = this.usedSessions.iterator();
        while (i.hasNext()) {
            WinstoneSession session = (WinstoneSession)i.next();
            session.setLastAccessedDate(lastAccessedTime);
            session.removeUsed(this);
            if (!saveSessions) continue;
            session.saveToTemp();
        }
        this.usedSessions.clear();
    }

    public String getRealPath(String path) {
        return this.webappConfig.getRealPath(path);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    static {
        headerDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        rnd = new Random(System.currentTimeMillis());
    }
}

