/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.ContactFilter;
import fr.ifremer.suiviobsmer.bean.ContactFilterImpl;
import fr.ifremer.suiviobsmer.bean.ContactState;
import fr.ifremer.suiviobsmer.bean.ImportResults;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceContact;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.ui.base.AbstractFilteredPage;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.services.ContactModelFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/contacts.css"})
public class Contacts
extends AbstractFilteredPage
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private User user;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Persist(value="flash")
    private String editableContactId;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Zone importExportZone;
    @Property
    @Persist(value="flash")
    private boolean filtersVisible;
    private boolean reset;
    @Property
    private UploadedFile contactsCsvFile;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ContactModelFactory contactModelFactory;
    @Persist
    private Map<String, Contact> contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<User> userSelectModel;
    @Property
    @Persist(value="flash")
    private String contactUserId;
    private ContactState contactState;
    private boolean even = true;
    private boolean contactEdited;
    private boolean contactDeleted;
    @Persist(value="flash")
    private String contactSelectedId;
    @InjectComponent
    private Form contactsForm;
    @InjectComponent
    private Field beginDate;
    @InjectComponent
    private Field endDate;
    @InjectComponent
    private Field nbObservants;
    @InjectComponent
    private Field comment;
    @InjectComponent
    private Field inputDate;

    public boolean isOnlyForAdmin() {
        return false;
    }

    void setupRender() throws SuiviObsmerException {
        this.initFilter();
        this.contacts = null;
        this.getContacts();
        this.contactsForm.clearErrors();
    }

    public ContactFilter getContactFilter() throws SuiviObsmerException {
        if (this.contactFilter == null) {
            this.contactFilter = new ContactFilterImpl();
        }
        return this.contactFilter;
    }

    protected BoatFilter getFilter() throws SuiviObsmerException {
        return this.getContactFilter();
    }

    protected void resetFilter() {
        this.contactFilter = null;
    }

    protected boolean getAvailableDataForFiltersOnly() {
        return true;
    }

    void onSuccessFromSearchBoat() {
    }

    Object onActionFromShowFilters() {
        this.contactFilter = null;
        return this.filtersZone.getBody();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    @Log
    void onSuccessFromFiltersForm() throws SuiviObsmerException {
        if (this.reset) {
            this.contactFilter = null;
        } else {
            this.filtersVisible = true;
        }
    }

    @Log
    void onSuccessFromImportContacts() throws SuiviObsmerException {
        try {
            ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
            this.contacts = null;
            this.layout.getFeedBack().addInfo(result.getNbRowsImported() + " contacts import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
            for (String error : result.getErrors()) {
                this.layout.getFeedBack().addInfo(error);
            }
        }
        catch (SuiviObsmerBusinessException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Map<String, Contact> getContacts() throws SuiviObsmerException {
        if (this.contacts == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getContactsByFilter]");
            }
            this.contacts = this.serviceContact.getContactsByFilter(this.getContactFilter());
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            this.contactModel = this.user.getAdmin() ? this.contactModelFactory.buildAdminContactModel(this.beanModelSource, this.resources) : this.contactModelFactory.buildContactModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public ContactState getContactState() {
        if (this.contactState == null) {
            this.contactState = ContactState.createContactStateEnum((String)this.contact.getState());
        }
        return this.contactState;
    }

    public GenericSelectModel<User> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.user.getCompany().getUser();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, User.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public void setContactState(ContactState contactState) {
        this.contactState = contactState;
    }

    public String getSampleRowDescription() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return BusinessUtils.getTooltipBoat((Boat)this.contact.getBoat());
    }

    public String getGridClass() {
        return this.user.getAdmin() ? "admin" : "user";
    }

    public String getRowClass() {
        String result = BusinessUtils.getCSSColorClassForContact((Contact)this.contact, (boolean)this.user.getAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean isEditionMode() {
        return this.contact.getTopiaId().equals(this.editableContactId);
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public boolean hasActions() {
        return !this.user.getAdmin() && this.contact.getValidationCompany() == null;
    }

    public boolean canValidate() {
        boolean boardingDone;
        ContactState state = ContactState.createContactStateEnum((String)this.contact.getState());
        boolean bl = boardingDone = state.equals((Object)ContactState.BOARDING_DONE) && this.contact.getDataInputDate() != null;
        if (!this.user.getAdmin()) {
            return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || boardingDone);
        }
        return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
    }

    public boolean canUnvalidate() {
        if (!this.user.getAdmin()) {
            return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
        }
        return this.contact.getValidationProgram() != null;
    }

    void onSelectedFromAcceptContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        if (this.user.getAdmin()) {
            this.contact.setValidationProgram(Boolean.TRUE);
        } else {
            this.contact.getSampleRow().addRealTideTime(this.contact);
            this.contact.setValidationCompany(Boolean.TRUE);
        }
    }

    void onSelectedFromRefuseContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        if (this.user.getAdmin()) {
            this.contact.getSampleRow().removeRealTideTime(this.contact);
            this.contact.setValidationProgram(Boolean.FALSE);
        } else {
            this.contact.setValidationCompany(Boolean.FALSE);
        }
    }

    void onSelectedFromUnvalidateContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        if (this.user.getAdmin()) {
            if (BooleanUtils.isFalse((Boolean)this.contact.getValidationProgram())) {
                this.contact.getSampleRow().addRealTideTime(this.contact);
            }
            this.contact.setValidationProgram(null);
        } else {
            if (BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany())) {
                this.contact.getSampleRow().removeRealTideTime(this.contact);
            }
            this.contact.setValidationCompany(null);
        }
    }

    void onSelectedFromEditContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        this.contactUserId = this.contact.getUser().getTopiaId();
        this.editableContactId = contactId;
        this.contactSelectedId = contactId;
        this.contactEdited = true;
    }

    void onSelectedFromDeleteContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        this.contactDeleted = true;
    }

    void onSelectedFromSaveContact(String contactId) throws SuiviObsmerException {
        this.contact = (Contact)this.getContacts().get(contactId);
        this.contact.setState(this.contactState.toString());
        User contactUser = (User)this.getUserSelectModel().findObject(this.contactUserId);
        this.contact.setUser(contactUser);
    }

    void onSelectedFromCancelEditContact() throws SuiviObsmerException {
        this.contactEdited = true;
    }

    @Log
    void onValidateFormFromContactsForm() {
        this.contactsForm.clearErrors();
        if (!this.contactEdited && this.contactState != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("For state : " + this.contactState);
            }
            Date begin = this.contact.getTideBeginDate();
            Date end = this.contact.getTideEndDate();
            Date input = this.contact.getDataInputDate();
            SampleRow row = this.contact.getSampleRow();
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
            if (begin != null && !row.isValid(begin)) {
                this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de la mar\u00e9e doit correspondre \u00e0 un mois valide (non vide) de la ligne " + row.getCode());
            }
            if (begin != null && end != null && end.before(begin)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre ant\u00e9rieure \u00e0 celle de d\u00e9but");
            }
            Date current = SuiviObsmerContext.getCurrentDate();
            if (end != null && end.after(current)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (end != null && input != null && end.after(input)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre ant\u00e9rieure \u00e0 la date de fin de la mar\u00e9e");
            }
            if (input != null && input.after(current)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (this.contactState.isUnfinishedState()) {
                if (!StringUtils.isEmpty((String)this.contact.getComment())) {
                    this.contact.setTideBeginDate(null);
                    this.contact.setTideEndDate(null);
                    this.contact.setNbObservants(0);
                    this.contact.setMammalsCapture(false);
                    this.contact.setMammalsObservation(false);
                } else {
                    this.contactsForm.recordError(this.comment, "Le commentaire est obligatoire pour l'\u00e9tat '" + this.contactState + "'");
                }
            } else if (this.contactState.equals((Object)ContactState.BOARDING_DONE)) {
                if (begin == null) {
                    this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de mar\u00e9e est obligatoire pour l'\u00e9tat '" + this.contactState + "'");
                }
                if (end == null) {
                    this.contactsForm.recordError(this.endDate, "La date de fin de mar\u00e9e est obligatoire pour l'\u00e9tat '" + this.contactState + "'");
                }
                if (this.contact.getNbObservants() == 0) {
                    this.contactsForm.recordError(this.nbObservants, "Il ne peut y avoir aucun observateur pour l'\u00e9tat '" + this.contactState + "'");
                }
            }
        }
    }

    @Log
    Object onSuccessFromContactsForm() {
        if (!this.contactEdited) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Contact save : " + this.contact);
                }
                this.serviceContact.saveContact(this.contact, this.contactDeleted);
                this.contactSelectedId = this.contact.getTopiaId();
            }
            catch (SuiviObsmerException eee) {
                this.layout.getFeedBack().addError(eee.getMessage());
            }
        }
        return this;
    }

    @Log
    Object onFailureFromContactsForm() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Contact can't be saved with errors");
        }
        this.contactEdited = true;
        this.editableContactId = this.contact.getTopiaId();
        return this.contactsForm;
    }

    public void createNewContact(Boat boat, SampleRow sampleRow) throws SuiviObsmerException {
        this.contact = this.serviceContact.getNewContact(this.user, sampleRow, boat);
        this.serviceContact.saveContact(this.contact, Boolean.FALSE.booleanValue());
        this.contactSelectedId = this.contact.getTopiaId();
    }

    static /* synthetic */ User access$000(Contacts x0) {
        return x0.user;
    }

    static /* synthetic */ ServiceContact access$100(Contacts x0) {
        return x0.serviceContact;
    }
}

