/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.bean.ContactState;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class BusinessUtils {
    public static String getTooltipSampleRow(SampleRow row) {
        String result = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result = result + "<strong>M\u00e9tier : </strong>" + profession.getCodeDCF5();
        if (!StringUtils.isEmpty((String)profession.getMeshSize())) {
            result = result + " " + profession.getMeshSize();
        }
        if (!StringUtils.isEmpty((String)profession.getSize())) {
            result = result + " " + profession.getSize();
        }
        if (!StringUtils.isEmpty((String)profession.getOther())) {
            result = result + " " + profession.getOther();
        }
        result = result + " - " + profession.getLibelle();
        if (!StringUtils.isEmpty((String)profession.getSpecies())) {
            result = result + "<br /><strong>Esp\u00e8ces cibles : </strong>" + profession.getSpecies();
        }
        result = result + "<br /><strong>Programme : </strong>" + row.getProgramName();
        result = result + "<br /><strong>P\u00e9riode : </strong> du " + dateFormat.format(row.getPeriodBegin()) + " au " + dateFormat.format(row.getPeriodEnd());
        for (FishingZone zone : row.getFishingZone()) {
            result = result + "<br /><strong>Zone de p\u00eache : </strong>" + zone.getCode();
        }
        return result;
    }

    public static String getTooltipBoat(Boat boat) {
        String result = "";
        result = result + "<strong>" + boat.getImmatriculation() + "</strong>";
        result = result + "<br /><strong>Quartier : </strong>" + boat.getDistrictCode();
        result = result + "<br /><strong>Longueur : </strong>" + boat.getBoatLength() + " m";
        result = result + "<br /><strong>Ann\u00e9e de construction : </strong>" + boat.getBuildYear();
        return result;
    }

    public static String getCSSColorClassForContact(Contact contact, boolean admin) {
        String result = "";
        ContactState state = ContactState.createContactStateEnum((String)contact.getState());
        result = BooleanUtils.isFalse((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isFalse((Boolean)contact.getValidationCompany()) ? "refused" : (BooleanUtils.isTrue((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isTrue((Boolean)contact.getValidationCompany()) ? "accepted" : (state.isUnfinishedState() ? "unfinished" : (state.equals((Object)ContactState.BOARDING_DONE) ? "even" : "odd")));
        return result;
    }
}

