/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.metier;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MetierSeasonInfoTargetSpeciesTableModel
extends AbstractTableModel
implements TableCellRenderer,
SensitivityTableModel {
    private static Log log = LogFactory.getLog(MetierSeasonInfoTargetSpeciesTableModel.class);
    private static final long serialVersionUID = 3169786638868209920L;
    public static final String[] COLUMN_NAMES = new String[]{I18n.t((String)"isisfish.metierSeasonInfoSpecies.species", (Object[])new Object[0]), I18n.t((String)"isisfish.metierSeasonInfoSpecies.targetFactor", (Object[])new Object[0]), I18n.t((String)"isisfish.metierSeasonInfoSpecies.mainSpecies", (Object[])new Object[0])};
    protected List<TargetSpecies> targetSpeciesList;

    public MetierSeasonInfoTargetSpeciesTableModel() {
        this(null);
    }

    public MetierSeasonInfoTargetSpeciesTableModel(List<TargetSpecies> targetSpeciesList) {
        this.targetSpeciesList = targetSpeciesList;
    }

    public void setTargetSpecies(List<TargetSpecies> targetSpeciesList) {
        this.targetSpeciesList = targetSpeciesList;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        int rows = 0;
        if (this.targetSpeciesList != null) {
            rows = this.targetSpeciesList.size();
        }
        return rows;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TargetSpecies targetSpecies = this.targetSpeciesList.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> targetSpecies.getSpecies().getName();
            case 1 -> targetSpecies.getTargetFactorEquation();
            case 2 -> targetSpecies.isPrimaryCatch();
            default -> throw new IndexOutOfBoundsException("No such column " + columnIndex);
        };
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> String.class;
            case 1 -> Equation.class;
            case 2 -> Boolean.class;
            default -> throw new IndexOutOfBoundsException("No such column " + columnIndex);
        };
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + String.valueOf(value)));
        }
        TargetSpecies targetSpecies = this.targetSpeciesList.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                Equation eq = (Equation)value;
                targetSpecies.setTargetFactorEquation(null);
                targetSpecies.setTargetFactorEquation(eq);
                break;
            }
            case 2: {
                Boolean bValue = (Boolean)value;
                targetSpecies.setPrimaryCatch(bValue);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c;
        switch (column) {
            case 0: {
                c = new JLabel(value.toString());
                break;
            }
            case 1: {
                Equation equation = (Equation)value;
                c = new JButton(equation.getName() + "(" + equation.getCategory() + ")");
                break;
            }
            case 2: {
                Boolean bValue = (Boolean)value;
                c = new JCheckBox();
                ((JCheckBox)c).setSelected(bValue);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + column);
            }
        }
        return c;
    }

    @Override
    public String getPropertyAtColumn(int column) {
        String property = null;
        if (column == 1) {
            property = "targetFactorEquation";
        }
        return property;
    }

    @Override
    public Object getBeanAtRow(int rowIndex) {
        TargetSpecies value = this.targetSpeciesList.get(rowIndex);
        return value;
    }
}

