/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.gear;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.gear.GearPopulationSelectivityModel;
import fr.ifremer.isisfish.ui.input.gear.SelectivityUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;
import fr.ifremer.isisfish.util.ErrorHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectivityHandler
extends InputContentHandler<SelectivityUI> {
    private static final Log log = LogFactory.getLog(SelectivityHandler.class);

    protected SelectivityHandler(SelectivityUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((SelectivityUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((SelectivityUI)this.inputContentUI).setPopulation(null);
                ((SelectivityUI)this.inputContentUI).selectivityTable.setModel(new GearPopulationSelectivityModel());
            }
            if (evt.getNewValue() != null) {
                this.refresh();
            }
        });
    }

    public void refresh() {
        if (((SelectivityUI)this.inputContentUI).getBean() != null) {
            this.setSelectivityTableModel();
            ((SelectivityUI)this.inputContentUI).fieldSelectivityPopulation.setModel(this.getSelectivityPopulationModel());
        }
    }

    protected void setSelectivityTableModel() {
        ArrayList<Selectivity> selectivitiesList = new ArrayList<Selectivity>();
        if (((SelectivityUI)this.inputContentUI).getBean().getPopulationSelectivity() != null) {
            for (Selectivity oneSelectivity : ((SelectivityUI)this.inputContentUI).getBean().getPopulationSelectivity()) {
                ((SelectivityUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(oneSelectivity);
                selectivitiesList.add(oneSelectivity);
                oneSelectivity.addPropertyChangeListener(evt -> ((SelectivityUI)this.inputContentUI).changeModel.setStayChanged(true));
            }
        }
        GearPopulationSelectivityModel model = new GearPopulationSelectivityModel(selectivitiesList);
        ((SelectivityUI)this.inputContentUI).selectivityTable.setModel(model);
        ((SelectivityUI)this.inputContentUI).selectivityTable.setDefaultRenderer(Equation.class, model);
        ((SelectivityUI)this.inputContentUI).selectivityTable.setDefaultEditor(Equation.class, new EquationTableEditor());
    }

    protected void addSelectivity() {
        this.addSelectivity(((SelectivityUI)this.inputContentUI).getPopulation(), ((SelectivityUI)this.inputContentUI).selectivityEquation.getEditor().getText(), ((SelectivityUI)this.inputContentUI).getBean());
        this.setSelectivityTableModel();
    }

    protected void removeSelectivity() {
        GearPopulationSelectivityModel model = (GearPopulationSelectivityModel)((SelectivityUI)this.inputContentUI).selectivityTable.getModel();
        Selectivity selectedSelectivity = model.getSelectivities().get(((SelectivityUI)this.inputContentUI).selectivityTable.getSelectedRow());
        this.removeSelectivity(((SelectivityUI)this.inputContentUI).getBean(), selectedSelectivity);
        ((SelectivityUI)this.inputContentUI).getSaveVerifier().removeCurrentEntity(selectedSelectivity.getTopiaId());
        this.setSelectivityTableModel();
        ((SelectivityUI)this.inputContentUI).removeSelectivityButton.setEnabled(false);
    }

    protected void addSelectivity(Population pop, String equation, Gear gear) {
        try {
            SelectivityDAO dao = IsisFishDAOHelper.getSelectivityDAO(pop.getTopiaContext());
            Selectivity selectivity = (Selectivity)dao.create(new Object[0]);
            selectivity.setGear(gear);
            selectivity.setPopulation(pop);
            selectivity.getEquation().setContent(equation);
            selectivity.update();
            gear.addPopulationSelectivity(selectivity);
            gear.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add selectivity", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
    }

    protected void removeSelectivity(Gear gear, Selectivity selectivity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeSelectivity called: " + String.valueOf(selectivity)));
        }
        try {
            if (gear != null && selectivity != null) {
                gear.removePopulationSelectivity(selectivity);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
    }

    protected GenericComboModel<Population> getSelectivityPopulationModel() {
        List<Species> species = ((SelectivityUI)this.inputContentUI).getFisheryRegion().getSpecies();
        ArrayList<Population> populations = new ArrayList<Population>();
        if (species != null) {
            for (Species s : species) {
                if (s.getPopulation() == null) continue;
                populations.addAll(s.getPopulation());
            }
        }
        GenericComboModel<Population> selectivityPopulationModel = new GenericComboModel<Population>(populations);
        return selectivityPopulationModel;
    }

    protected void selectivityChanged() {
        ((SelectivityUI)this.inputContentUI).setPopulation((Population)((SelectivityUI)this.inputContentUI).fieldSelectivityPopulation.getSelectedItem());
    }
}

