/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.equation;

import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.equation.EquationEditorPaneUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.widget.text.SyntaxEditor;
import fr.ifremer.isisfish.util.ErrorHelper;
import fr.ifremer.isisfish.util.IsisFileUtil;
import fr.ifremer.isisfish.util.UIUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class InputOneEquationHandler
extends InputContentHandler<InputOneEquationUI> {
    private static final Log log = LogFactory.getLog(InputOneEquationHandler.class);
    protected DocumentListener listener = null;

    protected InputOneEquationHandler(InputOneEquationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((InputOneEquationUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            block4: {
                if (evt.getNewValue() == null) {
                    ((InputOneEquationUI)this.inputContentUI).formuleComboBox.setModel(new DefaultComboBoxModel());
                    try {
                        File nullFile = IsisFileUtil.getTempFile("", ".java");
                        ((InputOneEquationUI)this.inputContentUI).editor.open(nullFile);
                        ((InputOneEquationUI)this.inputContentUI).editor.setEnabled(false);
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block4;
                        log.error((Object)"Error on property change", (Throwable)e);
                    }
                }
            }
            if (evt.getNewValue() != null) {
                this.refresh();
            }
        });
        if (this.listener == null) {
            this.listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    InputOneEquationHandler.this.setEquation();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    InputOneEquationHandler.this.setEquation();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        this.setComboModel();
    }

    protected Equation getEquation() {
        Equation result;
        block3: {
            result = null;
            try {
                if (((InputOneEquationUI)this.inputContentUI).bean != null && ((InputOneEquationUI)this.inputContentUI).beanProperty != null) {
                    String localBeanProperty = StringUtils.capitalize((String)((InputOneEquationUI)this.inputContentUI).beanProperty);
                    Method m = ((InputOneEquationUI)this.inputContentUI).bean.getClass().getMethod("get" + localBeanProperty, new Class[0]);
                    result = (Equation)m.invoke((Object)((InputOneEquationUI)this.inputContentUI).bean, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't get equation", (Throwable)e);
            }
        }
        return result;
    }

    protected void setEquation() {
        block6: {
            try {
                if (((InputOneEquationUI)this.inputContentUI).bean != null && ((InputOneEquationUI)this.inputContentUI).beanProperty != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Saving equation content (" + ((InputOneEquationUI)this.inputContentUI).bean.getClass().getSimpleName() + "#" + ((InputOneEquationUI)this.inputContentUI).beanProperty + ")"));
                    }
                    String localBeanProperty = StringUtils.capitalize((String)((InputOneEquationUI)this.inputContentUI).beanProperty);
                    Method m = ((InputOneEquationUI)this.inputContentUI).bean.getClass().getMethod("set" + localBeanProperty + "Content", String.class);
                    m.invoke((Object)((InputOneEquationUI)this.inputContentUI).bean, ((InputOneEquationUI)this.inputContentUI).editor.getText());
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No bean property defined, skipping content saving");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't set equation content", (Throwable)e);
            }
        }
    }

    public void refresh() {
        block5: {
            if (((InputOneEquationUI)this.inputContentUI).getText() == null) {
                ((InputOneEquationUI)this.inputContentUI).setText(I18n.t((String)"isisfish.common.equation", (Object[])new Object[0]));
            }
            ((InputOneEquationUI)this.inputContentUI).editor.removeDocumentListener(this.listener);
            try {
                File equationContentFile = IsisFileUtil.getTempFile("", ".java");
                ((InputOneEquationUI)this.inputContentUI).editor.open(equationContentFile);
                ((InputOneEquationUI)this.inputContentUI).editor.setEnabled(((InputOneEquationUI)this.inputContentUI).isActive());
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't refresh editor", (Throwable)ex);
            }
        }
        if (((InputOneEquationUI)this.inputContentUI).formuleCategory != null) {
            ((InputOneEquationUI)this.inputContentUI).selectedEquation = this.getEquation();
            this.setComboModel();
            ((InputOneEquationUI)this.inputContentUI).setFormule((Formule)((InputOneEquationUI)this.inputContentUI).formuleComboBox.getSelectedItem());
            this.setEditorText();
        }
        if (((InputOneEquationUI)this.inputContentUI).autoSaveModification.booleanValue()) {
            ((InputOneEquationUI)this.inputContentUI).editor.addDocumentListener(this.listener);
        }
    }

    protected void setComboModel() {
        if (((InputOneEquationUI)this.inputContentUI).getBean() != null) {
            TopiaContext isisContext = ((InputOneEquationUI)this.inputContentUI).getBean().getTopiaContext();
            if (((InputOneEquationUI)this.inputContentUI).formuleCategory != null) {
                List<Formule> formules = FormuleStorage.getFormules(isisContext, ((InputOneEquationUI)this.inputContentUI).formuleCategory);
                GenericComboModel<Formule> formulesModel = new GenericComboModel<Formule>(formules);
                ((InputOneEquationUI)this.inputContentUI).formuleComboBox.setModel(formulesModel);
                ((InputOneEquationUI)this.inputContentUI).formuleComboBox.setSelectedItem(((InputOneEquationUI)this.inputContentUI).selectedEquation);
            }
        }
    }

    protected void saveModel() {
        this.saveAsModel(((InputOneEquationUI)this.inputContentUI).formuleCategory, "java", ((InputOneEquationUI)this.inputContentUI).editor.getText());
        this.setComboModel();
        ((InputOneEquationUI)this.inputContentUI).setInfoText(I18n.t((String)"isisfish.message.saveModel.finished", (Object[])new Object[0]));
    }

    protected void saveAsModel(String category, String language, String content) {
        try {
            String name = JOptionPane.showInputDialog(this.inputContentUI, I18n.t((String)"isisfish.message.saveModel.dialog", (Object[])new Object[0]), I18n.t((String)"isisfish.common.saveModel", (Object[])new Object[0]), 3);
            if (name != null) {
                FormuleStorage storage = FormuleStorage.createFormule(category, name, language);
                storage.setContent(content);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save equation as model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.equation.savemodel", (Object[])new Object[0]), eee);
        }
    }

    protected void openEditor() {
        Formule e = (Formule)((InputOneEquationUI)this.inputContentUI).formuleComboBox.getSelectedItem();
        if (e != null) {
            this.openEditor((InputOneEquationUI)this.inputContentUI, e.getCategory(), e.getName(), ((InputOneEquationUI)this.inputContentUI).clazz, e.getContent(), ((InputOneEquationUI)this.inputContentUI).editor);
        } else {
            this.openEditor((InputOneEquationUI)this.inputContentUI, ((InputOneEquationUI)this.inputContentUI).formuleCategory, "new", ((InputOneEquationUI)this.inputContentUI).clazz, ((InputOneEquationUI)this.inputContentUI).editor.getText(), ((InputOneEquationUI)this.inputContentUI).editor);
        }
    }

    public void openEditor(InputOneEquationUI ui, String category, String name, Class<?> javaInterface, String content, SyntaxEditor editor) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"openEditor");
        }
        try {
            EquationEditorPaneUI pane = new EquationEditorPaneUI((JAXXContext)ui);
            pane.getHandler().setEquation(category, name, javaInterface, content);
            pane.pack();
            pane.setLocationRelativeTo(ui);
            UIUtil.setIconImage(pane);
            pane.setVisible(true);
            if (pane.isResultOk().booleanValue() && editor != null) {
                editor.setText(pane.getEditor().getText());
            }
            pane.dispose();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't open editor", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.equation.openeditor", (Object[])new Object[0]), eee);
        }
    }

    protected void setEditorText() {
        block4: {
            if (((InputOneEquationUI)this.inputContentUI).getFormule() != null) {
                ((InputOneEquationUI)this.inputContentUI).editor.setText(((InputOneEquationUI)this.inputContentUI).getFormule().getContent());
            } else {
                try {
                    File nullFile = IsisFileUtil.getTempFile("", ".java");
                    ((InputOneEquationUI)this.inputContentUI).editor.open(nullFile);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Open editor", (Throwable)e);
                }
            }
        }
    }

    protected void formuleChanged() {
        Formule selectedFormule = (Formule)((InputOneEquationUI)this.inputContentUI).formuleComboBox.getSelectedItem();
        ((InputOneEquationUI)this.inputContentUI).setFormule(selectedFormule);
        this.setEditorText();
    }
}

