package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class AdvancedParamsUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AJOUT = "ajout";
    public static final String PROPERTY_CHANGED = "changed";
    public static final String PROPERTY_REMOVE = "remove";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXTW8jNRjHnbBJmpZdlu22W/ZFtN0IIYQm27KsEC3L9oVCQ1hWmy5U5IIn4yQuk/HU9nTDBXHnwkeAOxckbpwQB84cuCC+AkIcuCJsT5LJpBPHyD3MtOPn+c3//4ztx/3uT1BgFKydwH7foVHAcQ85tZ3j4w/dE9Ti+4i1KA45oSD+yeVBvgkWvNFzxsHtZl2mVwfp1T3SC0mAgrHsrTqYZ/xzH7EuQpyDW+mMFmPVxmh4qx9GdEgdicqifvP3X/mvvS+/zQPQD4W6irCyOisrcXKhDvLY4+CKeNMZrPow6AgZFAcdofeifLbnQ8Yewh46BV+AUh0UQ0gFjIN1c8uKofL7IQelyhF0fXSHg402dXCboh4Sd4ZZG7OuE2GH4V7kQ0FwdrwzGLSQ9whS2GNPDsNQcYocFOAJiYSM56VIRwp3dgnxEQySmKJAkzOl/FLytNTqimjkTTyeq9Tq0EW+0HVFMvsOeyrq4MRPZVB5FLvexsj3GlKmUBiLawxFN5Av5g0HSymKqI9Ldkk/DbqegCDHJGhwcWMcn0boHKCLWp+dA1ydAOzBVlcZvpGOG7rbkH8vpcduT3NTJ50Oou9QSigHKyk1j6GHya74ACQwLE0M+xhSlbD+v7IOgzbJyJohfB+5UScjbViLzYxaVLKQaj6PFcNUyljeFN+z0qYYn6VylvPXMpyvZTDr2NXbXtUlTfGszZliWCtumtvBRrOh5u7YjhhPYTWWXZ67o/K8lYwpBUeww8FyaiUcoT4/kGMT8QPW6xmsecX6CPqRErCfHi1XavHCEjvRYupVyXpLoi9WauLLE99/BAO5p15LZSRD6axLXLoXbpQINrnljWpTP69K7SDvT5G8mTE4Y5W+S0kkusJ6xieSXTjmqqDQeP6rcBl7HJpNoVQCBTdSYkRvdpLenDTPXBMUaOTL8q00z7fzx2IobuQrE41cAtXov8uLv/34xw8Hw+59T7x7KTN07PAhumpISYgox/LVz8WtO+LYr34Aw60mKDPVgdTJ5GaGsMZgWIgT74sbqEx33oOsKxCF0u8//bz86a/PgPwBmPcJ9A6gjD8EZd6logrE9/rh2w+UomefzonrZamNgwtcLAYxmbZx4OMArUIuzhJuxNH9vijDzYwyjLS45V/+WWx8/2BYipyQ9sLU8KQchU9AMX6bOsoMTimZR5eFkKHII8lpJOt8kpP3q8O55qprO8troUc85IultO1BDlddHHhizgqjMuNEOZC/+Qp4zQA4F3+2+GByms25PpMjH3flBdsQzjQabllrsCe8aFDPBTfZOjSoNeuCmBF0dswIX2kIFWsXZgSdCzOCzsVL1i7MCDoXZgSdi5etXZgRdC7sCa9Y1+FV6zqYEXQuzAg6F461CzOCzoUZQefijrULM4LOhRlB52LT2oUZQefCnnDXug73rOtgRtC5MCPoXLxh7cKMoHNhRtC5eNPahRlB58KMoHOxbe3CjKBzMZvAQdEl1ENUo+O+tY4da8KBgZMSCuR/2brTfs1aiBEht6HR0LDWYETQanhirUES/gPIRNtd6RcAAA==";
    private static final Log log = LogFactory.getLog(AdvancedParamsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean ajout;
    protected Boolean changed;
    protected JRadioButton fieldSimulAdvParamsLibLoggerDebug;
    protected JRadioButton fieldSimulAdvParamsLibLoggerError;
    protected JAXXButtonGroup fieldSimulAdvParamsLibLoggerGroup;
    protected JRadioButton fieldSimulAdvParamsLibLoggerInfo;
    protected JRadioButton fieldSimulAdvParamsLibLoggerWarn;
    protected JRadioButton fieldSimulAdvParamsScriptLoggerDebug;
    protected JRadioButton fieldSimulAdvParamsScriptLoggerError;
    protected JAXXButtonGroup fieldSimulAdvParamsScriptLoggerGroup;
    protected JRadioButton fieldSimulAdvParamsScriptLoggerInfo;
    protected JRadioButton fieldSimulAdvParamsScriptLoggerWarn;
    protected JRadioButton fieldSimulAdvParamsSimulLoggerDebug;
    protected JRadioButton fieldSimulAdvParamsSimulLoggerError;
    protected JAXXButtonGroup fieldSimulAdvParamsSimulLoggerGroup;
    protected JRadioButton fieldSimulAdvParamsSimulLoggerInfo;
    protected JRadioButton fieldSimulAdvParamsSimulLoggerWarn;
    protected JComboBox fieldSimulAdvParamsSimulatorSelect;
    protected JCheckBox fieldSimulationCache;
    protected JCheckBox fieldSimulationStatistique;
    protected JTextField fieldTag;
    protected JTextField fieldValue;
    protected Boolean remove;
    protected JTable tableTagValues;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private AdvancedParamsUI $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            /**
             * Listener to enable/disable remove button.
             */
            tableTagValues.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
                @Override
                public void valueChanged(ListSelectionEvent e) {
                    setRemove(tableTagValues.getSelectedRow() != -1);
                }
            });
        
            refresh();
        }
        
        public void refresh() {
            fieldSimulAdvParamsSimulatorSelect.setSelectedItem(getContextValue(SimulAction.class).getSimulationParameter().getSimulatorName());
            fieldSimulationStatistique.setSelected(getContextValue(SimulAction.class).getSimulationParameter().getUseStatistic());
            fieldSimulationCache.setSelected(getContextValue(SimulAction.class).getSimulationParameter().getUseCache());
    
            fieldSimulAdvParamsSimulLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulErrorLevel());
            fieldSimulAdvParamsSimulLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulWarnLevel());
            fieldSimulAdvParamsSimulLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulInfoLevel());
            fieldSimulAdvParamsSimulLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulDebugLevel());
    
            fieldSimulAdvParamsScriptLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptErrorLevel());
            fieldSimulAdvParamsScriptLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptWarnLevel());
            fieldSimulAdvParamsScriptLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptInfoLevel());
            fieldSimulAdvParamsScriptLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptDebugLevel());
    
            fieldSimulAdvParamsLibLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibErrorLevel());
            fieldSimulAdvParamsLibLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibWarnLevel());
            fieldSimulAdvParamsLibLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibInfoLevel());
            fieldSimulAdvParamsLibLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibDebugLevel());
    
            setTableTagValues();
        }
    
        protected void addTagValue() {
            getContextValue(SimulAction.class).addTagValue(fieldTag.getText(), fieldValue.getText());
            setTableTagValues();
            valueChanged(true);
        }
    
        protected void removeTagValue() {
            getContextValue(SimulAction.class).removeTagValue(tableTagValues.getValueAt(tableTagValues.getSelectedRow(),0).toString());
            setTableTagValues();
            valueChanged(true);
        }
    
        protected void saveTagValues() {
            if (fieldSimulAdvParamsSimulatorSelect.getSelectedIndex() != -1) {
                getContextValue(SimulAction.class).saveTagValue(fieldSimulAdvParamsSimulatorSelect.getSelectedItem().toString());    
            }
            valueChanged(false);
        }
    
        protected void setSimulatorName() {
            if (fieldSimulAdvParamsSimulatorSelect.getSelectedIndex() != -1) {
                getContextValue(SimulAction.class).getSimulationParameter().setSimulatorName(fieldSimulAdvParamsSimulatorSelect.getSelectedItem().toString());
                valueChanged(true);
            }
        }
    
        protected void setTableTagValues() {
            Map<String, String> tagValues = getContextValue(SimulAction.class).getSimulationParameter().getTagValue();
            
            // TODO make a table model for it
            String columnName[] = { t("isisfish.common.tag"), t("isisfish.common.value")};
            if (tagValues != null) {
                DefaultTableModel model = new DefaultTableModel(columnName, tagValues.size()) {
                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                Set<Entry<String, String>> set = tagValues.entrySet();
                int row = 0;
                for (Iterator<String> it = tagValues.keySet().iterator(); it.hasNext();) {
                    String name = it.next();
                    model.setValueAt(name, row, 0);
                    model.setValueAt(tagValues.get(name), row, 1);
                    row++;
                }
                tableTagValues.setModel(model);
            }
        }
    
        protected void valueChanged(boolean b) {
             setChanged(b);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdvancedParamsUI(SimulAction action) {
        setContextValue(action);
            $initialize();
    }

    public AdvancedParamsUI() {
        $initialize();
    }

    public AdvancedParamsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addTagValue();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeTagValue();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveTagValues();
    }

    public void doActionPerformed__on__fieldSimulAdvParamsLibLoggerDebug(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setLibLogLevel("debug");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsLibLoggerError(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setLibLogLevel("error");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsLibLoggerInfo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setLibLogLevel("info");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsLibLoggerWarn(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setLibLogLevel("warn");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsScriptLoggerDebug(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setScriptLogLevel("debug");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsScriptLoggerError(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setScriptLogLevel("error");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsScriptLoggerInfo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setScriptLogLevel("info");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsScriptLoggerWarn(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setScriptLogLevel("warn");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsSimulLoggerDebug(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setSimulLogLevel("debug");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsSimulLoggerError(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setSimulLogLevel("error");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsSimulLoggerInfo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setSimulLogLevel("info");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsSimulLoggerWarn(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setSimulLogLevel("warn");
    }

    public void doActionPerformed__on__fieldSimulAdvParamsSimulatorSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSimulatorName();
    }

    public void doActionPerformed__on__fieldSimulationCache(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setUseCache(fieldSimulationCache.isSelected());
    }

    public void doActionPerformed__on__fieldSimulationStatistique(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getContextValue(SimulAction.class).getSimulationParameter().setUseStatistic(fieldSimulationStatistique.isSelected());
    }

    public void doKeyTyped__on__fieldTag(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAjout(true);
    }

    public void doKeyTyped__on__fieldValue(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setAjout(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAjout() {
        return ajout;
    }

    public Boolean getChanged() {
        return changed;
    }

    public JRadioButton getFieldSimulAdvParamsLibLoggerDebug() {
        return fieldSimulAdvParamsLibLoggerDebug;
    }

    public JRadioButton getFieldSimulAdvParamsLibLoggerError() {
        return fieldSimulAdvParamsLibLoggerError;
    }

    public JAXXButtonGroup getFieldSimulAdvParamsLibLoggerGroup() {
        return fieldSimulAdvParamsLibLoggerGroup;
    }

    public JRadioButton getFieldSimulAdvParamsLibLoggerInfo() {
        return fieldSimulAdvParamsLibLoggerInfo;
    }

    public JRadioButton getFieldSimulAdvParamsLibLoggerWarn() {
        return fieldSimulAdvParamsLibLoggerWarn;
    }

    public JRadioButton getFieldSimulAdvParamsScriptLoggerDebug() {
        return fieldSimulAdvParamsScriptLoggerDebug;
    }

    public JRadioButton getFieldSimulAdvParamsScriptLoggerError() {
        return fieldSimulAdvParamsScriptLoggerError;
    }

    public JAXXButtonGroup getFieldSimulAdvParamsScriptLoggerGroup() {
        return fieldSimulAdvParamsScriptLoggerGroup;
    }

    public JRadioButton getFieldSimulAdvParamsScriptLoggerInfo() {
        return fieldSimulAdvParamsScriptLoggerInfo;
    }

    public JRadioButton getFieldSimulAdvParamsScriptLoggerWarn() {
        return fieldSimulAdvParamsScriptLoggerWarn;
    }

    public JRadioButton getFieldSimulAdvParamsSimulLoggerDebug() {
        return fieldSimulAdvParamsSimulLoggerDebug;
    }

    public JRadioButton getFieldSimulAdvParamsSimulLoggerError() {
        return fieldSimulAdvParamsSimulLoggerError;
    }

    public JAXXButtonGroup getFieldSimulAdvParamsSimulLoggerGroup() {
        return fieldSimulAdvParamsSimulLoggerGroup;
    }

    public JRadioButton getFieldSimulAdvParamsSimulLoggerInfo() {
        return fieldSimulAdvParamsSimulLoggerInfo;
    }

    public JRadioButton getFieldSimulAdvParamsSimulLoggerWarn() {
        return fieldSimulAdvParamsSimulLoggerWarn;
    }

    public JComboBox getFieldSimulAdvParamsSimulatorSelect() {
        return fieldSimulAdvParamsSimulatorSelect;
    }

    public JCheckBox getFieldSimulationCache() {
        return fieldSimulationCache;
    }

    public JCheckBox getFieldSimulationStatistique() {
        return fieldSimulationStatistique;
    }

    public JTextField getFieldTag() {
        return fieldTag;
    }

    public JTextField getFieldValue() {
        return fieldValue;
    }

    public Boolean getRemove() {
        return remove;
    }

    public JTable getTableTagValues() {
        return tableTagValues;
    }

    public Boolean isAjout() {
        return ajout !=null && ajout;
    }

    public Boolean isChanged() {
        return changed !=null && changed;
    }

    public Boolean isRemove() {
        return remove !=null && remove;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAjout(Boolean ajout) {
        Boolean oldValue = this.ajout;
        this.ajout = ajout;
        firePropertyChange(PROPERTY_AJOUT, oldValue, ajout);
    }

    public void setChanged(Boolean changed) {
        Boolean oldValue = this.changed;
        this.changed = changed;
        firePropertyChange(PROPERTY_CHANGED, oldValue, changed);
    }

    public void setRemove(Boolean remove) {
        Boolean oldValue = this.remove;
        this.remove = remove;
        firePropertyChange(PROPERTY_REMOVE, oldValue, remove);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFieldSimulAdvParamsLibLoggerDebug() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsLibLoggerGroup; fieldSimulAdvParamsLibLoggerDebug.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsLibLoggerDebug); }
    }

    protected void addChildrenToFieldSimulAdvParamsLibLoggerError() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsLibLoggerGroup; fieldSimulAdvParamsLibLoggerError.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsLibLoggerError); }
    }

    protected void addChildrenToFieldSimulAdvParamsLibLoggerInfo() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsLibLoggerGroup; fieldSimulAdvParamsLibLoggerInfo.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsLibLoggerInfo); }
    }

    protected void addChildrenToFieldSimulAdvParamsLibLoggerWarn() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsLibLoggerGroup; fieldSimulAdvParamsLibLoggerWarn.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsLibLoggerWarn); }
    }

    protected void addChildrenToFieldSimulAdvParamsScriptLoggerDebug() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsScriptLoggerGroup; fieldSimulAdvParamsScriptLoggerDebug.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsScriptLoggerDebug); }
    }

    protected void addChildrenToFieldSimulAdvParamsScriptLoggerError() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsScriptLoggerGroup; fieldSimulAdvParamsScriptLoggerError.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsScriptLoggerError); }
    }

    protected void addChildrenToFieldSimulAdvParamsScriptLoggerInfo() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsScriptLoggerGroup; fieldSimulAdvParamsScriptLoggerInfo.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsScriptLoggerInfo); }
    }

    protected void addChildrenToFieldSimulAdvParamsScriptLoggerWarn() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsScriptLoggerGroup; fieldSimulAdvParamsScriptLoggerWarn.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsScriptLoggerWarn); }
    }

    protected void addChildrenToFieldSimulAdvParamsSimulLoggerDebug() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsSimulLoggerGroup; fieldSimulAdvParamsSimulLoggerDebug.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsSimulLoggerDebug); }
    }

    protected void addChildrenToFieldSimulAdvParamsSimulLoggerError() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsSimulLoggerGroup; fieldSimulAdvParamsSimulLoggerError.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsSimulLoggerError); }
    }

    protected void addChildrenToFieldSimulAdvParamsSimulLoggerInfo() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsSimulLoggerGroup; fieldSimulAdvParamsSimulLoggerInfo.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsSimulLoggerInfo); }
    }

    protected void addChildrenToFieldSimulAdvParamsSimulLoggerWarn() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fieldSimulAdvParamsSimulLoggerGroup; fieldSimulAdvParamsSimulLoggerWarn.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSimulAdvParamsSimulLoggerWarn); }
    }

    protected void createAjout() {
        $objectMap.put("ajout", ajout = false);
    }

    protected void createChanged() {
        $objectMap.put("changed", changed = false);
    }

    protected void createFieldSimulAdvParamsLibLoggerDebug() {
        $objectMap.put("fieldSimulAdvParamsLibLoggerDebug", fieldSimulAdvParamsLibLoggerDebug = new JRadioButton());
        
        fieldSimulAdvParamsLibLoggerDebug.setName("fieldSimulAdvParamsLibLoggerDebug");
        fieldSimulAdvParamsLibLoggerDebug.setText(t("isisfish.common.debug"));
        fieldSimulAdvParamsLibLoggerDebug.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsLibLoggerDebug"));
    }

    protected void createFieldSimulAdvParamsLibLoggerError() {
        $objectMap.put("fieldSimulAdvParamsLibLoggerError", fieldSimulAdvParamsLibLoggerError = new JRadioButton());
        
        fieldSimulAdvParamsLibLoggerError.setName("fieldSimulAdvParamsLibLoggerError");
        fieldSimulAdvParamsLibLoggerError.setText(t("isisfish.common.error"));
        fieldSimulAdvParamsLibLoggerError.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsLibLoggerError"));
    }

    protected void createFieldSimulAdvParamsLibLoggerGroup() {
        $objectMap.put("fieldSimulAdvParamsLibLoggerGroup", fieldSimulAdvParamsLibLoggerGroup = new JAXXButtonGroup());
    }

    protected void createFieldSimulAdvParamsLibLoggerInfo() {
        $objectMap.put("fieldSimulAdvParamsLibLoggerInfo", fieldSimulAdvParamsLibLoggerInfo = new JRadioButton());
        
        fieldSimulAdvParamsLibLoggerInfo.setName("fieldSimulAdvParamsLibLoggerInfo");
        fieldSimulAdvParamsLibLoggerInfo.setText(t("isisfish.common.info"));
        fieldSimulAdvParamsLibLoggerInfo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsLibLoggerInfo"));
    }

    protected void createFieldSimulAdvParamsLibLoggerWarn() {
        $objectMap.put("fieldSimulAdvParamsLibLoggerWarn", fieldSimulAdvParamsLibLoggerWarn = new JRadioButton());
        
        fieldSimulAdvParamsLibLoggerWarn.setName("fieldSimulAdvParamsLibLoggerWarn");
        fieldSimulAdvParamsLibLoggerWarn.setText(t("isisfish.common.warn"));
        fieldSimulAdvParamsLibLoggerWarn.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsLibLoggerWarn"));
    }

    protected void createFieldSimulAdvParamsScriptLoggerDebug() {
        $objectMap.put("fieldSimulAdvParamsScriptLoggerDebug", fieldSimulAdvParamsScriptLoggerDebug = new JRadioButton());
        
        fieldSimulAdvParamsScriptLoggerDebug.setName("fieldSimulAdvParamsScriptLoggerDebug");
        fieldSimulAdvParamsScriptLoggerDebug.setText(t("isisfish.common.debug"));
        fieldSimulAdvParamsScriptLoggerDebug.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsScriptLoggerDebug"));
    }

    protected void createFieldSimulAdvParamsScriptLoggerError() {
        $objectMap.put("fieldSimulAdvParamsScriptLoggerError", fieldSimulAdvParamsScriptLoggerError = new JRadioButton());
        
        fieldSimulAdvParamsScriptLoggerError.setName("fieldSimulAdvParamsScriptLoggerError");
        fieldSimulAdvParamsScriptLoggerError.setText(t("isisfish.common.error"));
        fieldSimulAdvParamsScriptLoggerError.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsScriptLoggerError"));
    }

    protected void createFieldSimulAdvParamsScriptLoggerGroup() {
        $objectMap.put("fieldSimulAdvParamsScriptLoggerGroup", fieldSimulAdvParamsScriptLoggerGroup = new JAXXButtonGroup());
    }

    protected void createFieldSimulAdvParamsScriptLoggerInfo() {
        $objectMap.put("fieldSimulAdvParamsScriptLoggerInfo", fieldSimulAdvParamsScriptLoggerInfo = new JRadioButton());
        
        fieldSimulAdvParamsScriptLoggerInfo.setName("fieldSimulAdvParamsScriptLoggerInfo");
        fieldSimulAdvParamsScriptLoggerInfo.setText(t("isisfish.common.info"));
        fieldSimulAdvParamsScriptLoggerInfo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsScriptLoggerInfo"));
    }

    protected void createFieldSimulAdvParamsScriptLoggerWarn() {
        $objectMap.put("fieldSimulAdvParamsScriptLoggerWarn", fieldSimulAdvParamsScriptLoggerWarn = new JRadioButton());
        
        fieldSimulAdvParamsScriptLoggerWarn.setName("fieldSimulAdvParamsScriptLoggerWarn");
        fieldSimulAdvParamsScriptLoggerWarn.setText(t("isisfish.common.warn"));
        fieldSimulAdvParamsScriptLoggerWarn.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsScriptLoggerWarn"));
    }

    protected void createFieldSimulAdvParamsSimulLoggerDebug() {
        $objectMap.put("fieldSimulAdvParamsSimulLoggerDebug", fieldSimulAdvParamsSimulLoggerDebug = new JRadioButton());
        
        fieldSimulAdvParamsSimulLoggerDebug.setName("fieldSimulAdvParamsSimulLoggerDebug");
        fieldSimulAdvParamsSimulLoggerDebug.setText(t("isisfish.common.debug"));
        fieldSimulAdvParamsSimulLoggerDebug.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsSimulLoggerDebug"));
    }

    protected void createFieldSimulAdvParamsSimulLoggerError() {
        $objectMap.put("fieldSimulAdvParamsSimulLoggerError", fieldSimulAdvParamsSimulLoggerError = new JRadioButton());
        
        fieldSimulAdvParamsSimulLoggerError.setName("fieldSimulAdvParamsSimulLoggerError");
        fieldSimulAdvParamsSimulLoggerError.setText(t("isisfish.common.error"));
        fieldSimulAdvParamsSimulLoggerError.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsSimulLoggerError"));
    }

    protected void createFieldSimulAdvParamsSimulLoggerGroup() {
        $objectMap.put("fieldSimulAdvParamsSimulLoggerGroup", fieldSimulAdvParamsSimulLoggerGroup = new JAXXButtonGroup());
    }

    protected void createFieldSimulAdvParamsSimulLoggerInfo() {
        $objectMap.put("fieldSimulAdvParamsSimulLoggerInfo", fieldSimulAdvParamsSimulLoggerInfo = new JRadioButton());
        
        fieldSimulAdvParamsSimulLoggerInfo.setName("fieldSimulAdvParamsSimulLoggerInfo");
        fieldSimulAdvParamsSimulLoggerInfo.setText(t("isisfish.common.info"));
        fieldSimulAdvParamsSimulLoggerInfo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsSimulLoggerInfo"));
    }

    protected void createFieldSimulAdvParamsSimulLoggerWarn() {
        $objectMap.put("fieldSimulAdvParamsSimulLoggerWarn", fieldSimulAdvParamsSimulLoggerWarn = new JRadioButton());
        
        fieldSimulAdvParamsSimulLoggerWarn.setName("fieldSimulAdvParamsSimulLoggerWarn");
        fieldSimulAdvParamsSimulLoggerWarn.setText(t("isisfish.common.warn"));
        fieldSimulAdvParamsSimulLoggerWarn.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsSimulLoggerWarn"));
    }

    protected void createFieldSimulAdvParamsSimulatorSelect() {
        $objectMap.put("fieldSimulAdvParamsSimulatorSelect", fieldSimulAdvParamsSimulatorSelect = new JComboBox());
        
        fieldSimulAdvParamsSimulatorSelect.setName("fieldSimulAdvParamsSimulatorSelect");
        fieldSimulAdvParamsSimulatorSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulAdvParamsSimulatorSelect"));
    }

    protected void createFieldSimulationCache() {
        $objectMap.put("fieldSimulationCache", fieldSimulationCache = new JCheckBox());
        
        fieldSimulationCache.setName("fieldSimulationCache");
        fieldSimulationCache.setText(t("isisfish.advancedParams.simulationCache"));
        fieldSimulationCache.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulationCache"));
    }

    protected void createFieldSimulationStatistique() {
        $objectMap.put("fieldSimulationStatistique", fieldSimulationStatistique = new JCheckBox());
        
        fieldSimulationStatistique.setName("fieldSimulationStatistique");
        fieldSimulationStatistique.setText(t("isisfish.advancedParams.simulationStatistique"));
        fieldSimulationStatistique.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulationStatistique"));
    }

    protected void createFieldTag() {
        $objectMap.put("fieldTag", fieldTag = new JTextField());
        
        fieldTag.setName("fieldTag");
        fieldTag.setColumns(15);
        fieldTag.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyTyped", this, "doKeyTyped__on__fieldTag"));
    }

    protected void createFieldValue() {
        $objectMap.put("fieldValue", fieldValue = new JTextField());
        
        fieldValue.setName("fieldValue");
        fieldValue.setColumns(15);
        fieldValue.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyTyped", this, "doKeyTyped__on__fieldValue"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = false);
    }

    protected void createTableTagValues() {
        $objectMap.put("tableTagValues", tableTagValues = new JTable());
        
        tableTagValues.setName("tableTagValues");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsSimulatorSelect, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulationStatistique, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulationCache, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsSimulLoggerError, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsSimulLoggerWarn, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsSimulLoggerInfo, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsSimulLoggerDebug, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsScriptLoggerError, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsScriptLoggerWarn, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsScriptLoggerInfo, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsScriptLoggerDebug, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsLibLoggerError, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsLibLoggerWarn, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsLibLoggerInfo, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSimulAdvParamsLibLoggerDebug, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(0, 5, 5, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFieldSimulAdvParamsSimulLoggerError();
        addChildrenToFieldSimulAdvParamsSimulLoggerWarn();
        addChildrenToFieldSimulAdvParamsSimulLoggerInfo();
        addChildrenToFieldSimulAdvParamsSimulLoggerDebug();
        addChildrenToFieldSimulAdvParamsScriptLoggerError();
        addChildrenToFieldSimulAdvParamsScriptLoggerWarn();
        addChildrenToFieldSimulAdvParamsScriptLoggerInfo();
        addChildrenToFieldSimulAdvParamsScriptLoggerDebug();
        addChildrenToFieldSimulAdvParamsLibLoggerError();
        addChildrenToFieldSimulAdvParamsLibLoggerWarn();
        addChildrenToFieldSimulAdvParamsLibLoggerInfo();
        addChildrenToFieldSimulAdvParamsLibLoggerDebug();
        // inline complete setup of $Table1
        $Table1.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldTag, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldValue, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton2, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(tableTagValues);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        fieldSimulAdvParamsSimulatorSelect.setModel(new DefaultComboBoxModel(getContextValue(SimulAction.class).getSimulatorNames().toArray()));
        fieldSimulationStatistique.setSelected(getContextValue(SimulAction.class).getSimulationParameter().getUseStatistic());
        fieldSimulationCache.setSelected(getContextValue(SimulAction.class).getSimulationParameter().getUseCache());
        fieldSimulAdvParamsSimulLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulErrorLevel());
        fieldSimulAdvParamsSimulLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulWarnLevel());
        fieldSimulAdvParamsSimulLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulInfoLevel());
        fieldSimulAdvParamsSimulLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isSimulDebugLevel());
        fieldSimulAdvParamsScriptLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptErrorLevel());
        fieldSimulAdvParamsScriptLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptWarnLevel());
        fieldSimulAdvParamsScriptLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptInfoLevel());
        fieldSimulAdvParamsScriptLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isScriptDebugLevel());
        fieldSimulAdvParamsLibLoggerError.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibErrorLevel());
        fieldSimulAdvParamsLibLoggerWarn.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibWarnLevel());
        fieldSimulAdvParamsLibLoggerInfo.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibInfoLevel());
        fieldSimulAdvParamsLibLoggerDebug.setSelected(getContextValue(SimulAction.class).getSimulationParameter().isLibDebugLevel());
        $Table1.setBorder(BorderFactory.createTitledBorder(t("isisfish.advancedParams.freeParameters")));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAjout();
        createRemove();
        createChanged();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.advancedParams.simulatorUse"));
        createFieldSimulAdvParamsSimulatorSelect();
        createFieldSimulationStatistique();
        createFieldSimulationCache();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.advancedParams.simulLevelLogger"));
        createFieldSimulAdvParamsSimulLoggerError();
        createFieldSimulAdvParamsSimulLoggerWarn();
        createFieldSimulAdvParamsSimulLoggerInfo();
        createFieldSimulAdvParamsSimulLoggerDebug();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.advancedParams.scriptLevelLogger"));
        createFieldSimulAdvParamsScriptLoggerError();
        createFieldSimulAdvParamsScriptLoggerWarn();
        createFieldSimulAdvParamsScriptLoggerInfo();
        createFieldSimulAdvParamsScriptLoggerDebug();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.advancedParams.libLevelLogger"));
        createFieldSimulAdvParamsLibLoggerError();
        createFieldSimulAdvParamsLibLoggerWarn();
        createFieldSimulAdvParamsLibLoggerInfo();
        createFieldSimulAdvParamsLibLoggerDebug();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.common.tag"));
        createFieldTag();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.common.value"));
        createFieldValue();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.common.add"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableTagValues();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("isisfish.common.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("isisfish.common.saveNextSimulation"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        createFieldSimulAdvParamsSimulLoggerGroup();
        createFieldSimulAdvParamsScriptLoggerGroup();
        createFieldSimulAdvParamsLibLoggerGroup();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"ajout") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isAjout());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"remove") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isRemove());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"changed") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isChanged());
            }
        });
    }

}