/*
 * #%L
 * IsisFish
 * 
 * $Id: ChooseFileAction.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2005 - 2010 Ifremer, Code Lutin, Cedric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script.action;

import static org.nuiton.i18n.I18n.t;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import java.awt.event.ActionEvent;
import java.io.File;

/**
 * Choose file action.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 * 
 * @deprecated as of 20090819 unused
 */
public class ChooseFileAction extends AbstractAction {

    private static final long serialVersionUID = -5004217809548352109L;

    protected JTextField file;

    protected JDialog dialog;

    public ChooseFileAction(JDialog dialog, JTextField file) {
        super("...");
        this.dialog = dialog;
        this.file = file;
    }

    public File getDestination() {
        return new File(file.getText());
    }

    public void actionPerformed(ActionEvent e) {

        File dir = new File(file.getText());
        String name = "";
        if (dir.isFile() || !dir.exists()) {
            name = dir.getName();
            dir = dir.getParentFile();
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int ret = chooser.showDialog(dialog,
                t("isisfish.message.choose.archive"));
        if (ret == JFileChooser.APPROVE_OPTION) {
            File newFile = chooser.getSelectedFile();
            String path;
            if (newFile.isFile()) {
                path = newFile.getAbsolutePath();
            } else {
                path = newFile.getAbsolutePath();
                if (!"".equals(name)) {
                    path += File.separator + name;
                }
            }
            file.setText(path);
        }
    }
}
