/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlanListModel.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.simulationplan;

import java.util.List;

import javax.swing.AbstractListModel;

import fr.ifremer.isisfish.simulator.SimulationPlan;

/**
 * Model pour la liste des instances de plans de simulation.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class SimulationPlanListModel extends AbstractListModel<SimulationPlan> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<SimulationPlan> plans;

    /**
     * Empty constructor.
     */
    public SimulationPlanListModel() {
        this(null);
    }

    /**
     * Constructor with plan list.
     * 
     * @param plans plans
     */
    public SimulationPlanListModel(List<SimulationPlan> plans) {
        setSimulationPlan(plans);
    }

    /**
     * Get plans list.
     * 
     * @return the plans
     */
    public List<SimulationPlan> getSimulationPlans() {
        return plans;
    }

    /**
     * Set plans list.
     * 
     * @param plans the plans to set
     */
    public void setSimulationPlan(List<SimulationPlan> plans) {
        this.plans = plans;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public SimulationPlan getElementAt(int index) {
        return plans.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (plans != null) {
            size = plans.size();
        }
        return size;
    }
}
