/*
 * #%L
 * IsisFish
 * 
 * $Id: FormuleComboModel.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.formule;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.Formule;

/**
 * Model pour la liste des {@link Formule}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: chatellier $
 */
public class FormuleComboModel extends DefaultComboBoxModel<Formule> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Formules list */
    protected List<Formule> formules;

    /**
     * Constructor with formules list.
     * 
     * @param formules formules list
     */
    public FormuleComboModel(List<Formule> formules) {
        this.formules = formules;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Formule getElementAt(int index) {
        return formules.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (formules != null) {
            size = formules.size();
        }
        return size;
    }
}
