package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class StrategyMonthInfoUI extends InputContentUI<fr.ifremer.isisfish.entities.Strategy> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_STRATEGY_MONTH_INFO0 = "strategyMonthInfo0";
    public static final String PROPERTY_STRATEGY_MONTH_INFO1 = "strategyMonthInfo1";
    public static final String PROPERTY_STRATEGY_MONTH_INFO10 = "strategyMonthInfo10";
    public static final String PROPERTY_STRATEGY_MONTH_INFO11 = "strategyMonthInfo11";
    public static final String PROPERTY_STRATEGY_MONTH_INFO2 = "strategyMonthInfo2";
    public static final String PROPERTY_STRATEGY_MONTH_INFO3 = "strategyMonthInfo3";
    public static final String PROPERTY_STRATEGY_MONTH_INFO4 = "strategyMonthInfo4";
    public static final String PROPERTY_STRATEGY_MONTH_INFO5 = "strategyMonthInfo5";
    public static final String PROPERTY_STRATEGY_MONTH_INFO6 = "strategyMonthInfo6";
    public static final String PROPERTY_STRATEGY_MONTH_INFO7 = "strategyMonthInfo7";
    public static final String PROPERTY_STRATEGY_MONTH_INFO8 = "strategyMonthInfo8";
    public static final String PROPERTY_STRATEGY_MONTH_INFO9 = "strategyMonthInfo9";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_STRATEGY_PROPORTION_ENABLED = "fieldStrategyProportion.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_STRATEGY_APRIL_ACTIVE = "strategyApril.active";
    public static final String BINDING_STRATEGY_APRIL_BEAN = "strategyApril.bean";
    public static final String BINDING_STRATEGY_APRIL_STRATEGY_MONTH_INFO = "strategyApril.strategyMonthInfo";
    public static final String BINDING_STRATEGY_AUGUST_ACTIVE = "strategyAugust.active";
    public static final String BINDING_STRATEGY_AUGUST_BEAN = "strategyAugust.bean";
    public static final String BINDING_STRATEGY_AUGUST_STRATEGY_MONTH_INFO = "strategyAugust.strategyMonthInfo";
    public static final String BINDING_STRATEGY_DECEMBER_ACTIVE = "strategyDecember.active";
    public static final String BINDING_STRATEGY_DECEMBER_BEAN = "strategyDecember.bean";
    public static final String BINDING_STRATEGY_DECEMBER_STRATEGY_MONTH_INFO = "strategyDecember.strategyMonthInfo";
    public static final String BINDING_STRATEGY_FEBUARY_ACTIVE = "strategyFebuary.active";
    public static final String BINDING_STRATEGY_FEBUARY_BEAN = "strategyFebuary.bean";
    public static final String BINDING_STRATEGY_FEBUARY_STRATEGY_MONTH_INFO = "strategyFebuary.strategyMonthInfo";
    public static final String BINDING_STRATEGY_JANUARY_ACTIVE = "strategyJanuary.active";
    public static final String BINDING_STRATEGY_JANUARY_BEAN = "strategyJanuary.bean";
    public static final String BINDING_STRATEGY_JANUARY_STRATEGY_MONTH_INFO = "strategyJanuary.strategyMonthInfo";
    public static final String BINDING_STRATEGY_JULY_ACTIVE = "strategyJuly.active";
    public static final String BINDING_STRATEGY_JULY_BEAN = "strategyJuly.bean";
    public static final String BINDING_STRATEGY_JULY_STRATEGY_MONTH_INFO = "strategyJuly.strategyMonthInfo";
    public static final String BINDING_STRATEGY_JUNE_ACTIVE = "strategyJune.active";
    public static final String BINDING_STRATEGY_JUNE_BEAN = "strategyJune.bean";
    public static final String BINDING_STRATEGY_JUNE_STRATEGY_MONTH_INFO = "strategyJune.strategyMonthInfo";
    public static final String BINDING_STRATEGY_MARCH_ACTIVE = "strategyMarch.active";
    public static final String BINDING_STRATEGY_MARCH_BEAN = "strategyMarch.bean";
    public static final String BINDING_STRATEGY_MARCH_STRATEGY_MONTH_INFO = "strategyMarch.strategyMonthInfo";
    public static final String BINDING_STRATEGY_MAY_ACTIVE = "strategyMay.active";
    public static final String BINDING_STRATEGY_MAY_BEAN = "strategyMay.bean";
    public static final String BINDING_STRATEGY_MAY_STRATEGY_MONTH_INFO = "strategyMay.strategyMonthInfo";
    public static final String BINDING_STRATEGY_NOVEMBER_ACTIVE = "strategyNovember.active";
    public static final String BINDING_STRATEGY_NOVEMBER_BEAN = "strategyNovember.bean";
    public static final String BINDING_STRATEGY_NOVEMBER_STRATEGY_MONTH_INFO = "strategyNovember.strategyMonthInfo";
    public static final String BINDING_STRATEGY_OCTOBER_ACTIVE = "strategyOctober.active";
    public static final String BINDING_STRATEGY_OCTOBER_BEAN = "strategyOctober.bean";
    public static final String BINDING_STRATEGY_OCTOBER_STRATEGY_MONTH_INFO = "strategyOctober.strategyMonthInfo";
    public static final String BINDING_STRATEGY_SEPTEMBER_ACTIVE = "strategySeptember.active";
    public static final String BINDING_STRATEGY_SEPTEMBER_BEAN = "strategySeptember.bean";
    public static final String BINDING_STRATEGY_SEPTEMBER_STRATEGY_MONTH_INFO = "strategySeptember.strategyMonthInfo";
    public static final String BINDING_VALIDATOR0_BEAN = "validator0.bean";
    public static final String BINDING_VALIDATOR10_BEAN = "validator10.bean";
    public static final String BINDING_VALIDATOR11_BEAN = "validator11.bean";
    public static final String BINDING_VALIDATOR1_BEAN = "validator1.bean";
    public static final String BINDING_VALIDATOR2_BEAN = "validator2.bean";
    public static final String BINDING_VALIDATOR3_BEAN = "validator3.bean";
    public static final String BINDING_VALIDATOR4_BEAN = "validator4.bean";
    public static final String BINDING_VALIDATOR5_BEAN = "validator5.bean";
    public static final String BINDING_VALIDATOR6_BEAN = "validator6.bean";
    public static final String BINDING_VALIDATOR7_BEAN = "validator7.bean";
    public static final String BINDING_VALIDATOR8_BEAN = "validator8.bean";
    public static final String BINDING_VALIDATOR9_BEAN = "validator9.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWYz28bRRTHxyZOmrgtSSNKEUUKECQEaJ02/ZEqVWlJsHCwk6hOq6hGqLPesT1lPbudnXU2Qipw5QIHLtzgzgWJGyfEgTMHLhX/AkIceq14s7bXP7I7O9LmsLbmfeczb777PPs2P/2DCh5Hrz/CQWBwnwnaJcbOncPDPfMRaYpt4jU5dYXDUf8vl0f5Bipa0bgn0JuNqpxeGkwvbTld12GEjc3erKIFTxzbxOsQIgR6bXJG0/NK9Si8Gbg+H1KjpOKoP/z3b/5b68sf8wgFLmRXgq2spM0a7WSmivLUEugcrNTDJRuzNqTBKWtDvmfk2JaNPW8Xd8lj9ATNVdGsiznABHpDf8shI5wfuAItrlaY64sthwmQ36usCbTW4gZtcdIl8OlRr0W9juFTg0qhAQlhQdrHNZjRqbCWc6/iuiFvVqAZk2Am0FtxBMBTQYkXEUbTznnTUEjD0IJEM1S0SzKypFJcTlWspyqupCqupiqupSqupyo2UhU3phTLJx1bS5dMuzrfwza1MNSaQO9OVH0UMLwjqGajLq/3h4MjwkIkDJd/Jy5yKTFyOTGynhi5khi5mhi5lhi5nhjZSIzcmIoURzudNmEsNO1CsdmB04LUHIvYAr2t/AVvjaTjv1zHOoZakadMMLhNO/uYjWvmVg+waRP4bV6YuL19dRiTynI04cVh0exg5mMO/HWts2WPkbHjRcIqJ5llYkqmHN6dlJyJahXzZkcluONyascIiiNC3AKno335jKjjdtz8s9H6ftv3RIxiaaioE1eQrkl4jCiyYq8pnHjJ4lCy6/SSMJFmmzSTNKdWd6rYJPbadImEo5Pal1uU2NbwXu5zx4UTgcL9RO85vG0wnwqHGV0sOvLCaWC0oQJq4dew4j60QMEnoYPaC+v+48kqm/Fwj8AJNZHXB76AVaTis0g428Ss2c/WGUQ4enWilOHJb4ye/KNHc66BCtyHYaj9xslm4S6E+m3Chak2QQLD6PPzy3/9+vcv5WFvsAFrvxQrHWtt4Jntgn+Ey2ce3PB+Y+ALapdq2N1soHmP2NAXhX3PxZjE6oMwJAfrLcnphpxufIS9DiAKc09/+/38wz9fQPkyWrAdbJWx1FfQvOhwcMGxrcB9/3aY0emjU3BdlLnBDemfONCunL0JZxJeMSmzwPpbAbhwMcaFKBVz/o9ny/Wfbw+dyEFmryTKR24UHqBZymzKSNgnDVqg2L6o6HrEt5xRqxPX/OTk57Y7ON+OwuvncVsthOeuDD8JfPnxRZi1/PaVNmQWfKU9oqDUNChhg5WRMewHaP+QPSCByEhcOtEcZALK4a8VhH0twjeZCd9lJnyfmaDy4W5mH/QIKh/0CCof9AgqHw4y+6BHUPmgR1D5oEdQ+XA/sw96BJUPegSVD3oElQ+HmX3QI6h80COofNAjqHx4kNkHPYLKBz2Cygc9gsqHTzL7oEdQ+aBHUPmgR1D58GlmH/QIKh/0CCof9AgqHx5m9kGPoPJBj6DyQY+g8sHM7IMeQeWDHkHlgx5B5YOV2Qc9gsoHPYLKh3QCvD4IaPbhDeBm/z1qBQt46TZ9QW7FM1sazDnC5Ju56v2I6mwud6AgMC2C/KdFbi8LQZXD48w5SML/yX8du+IYAAA=";
    private static final Log log = LogFactory.getLog(StrategyMonthInfoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Strategy bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected MatrixPanelEditor fieldStrategyProportion;
    protected JButton save;
    protected StrategyOneMonthInfoUI strategyApril;
    protected StrategyOneMonthInfoUI strategyAugust;
    protected StrategyOneMonthInfoUI strategyDecember;
    protected StrategyOneMonthInfoUI strategyFebuary;
    protected StrategyOneMonthInfoUI strategyJanuary;
    protected StrategyOneMonthInfoUI strategyJuly;
    protected StrategyOneMonthInfoUI strategyJune;
    protected StrategyOneMonthInfoUI strategyMarch;
    protected StrategyOneMonthInfoUI strategyMay;
    protected StrategyMonthInfo strategyMonthInfo0;
    protected StrategyMonthInfo strategyMonthInfo1;
    protected StrategyMonthInfo strategyMonthInfo10;
    protected StrategyMonthInfo strategyMonthInfo11;
    protected StrategyMonthInfo strategyMonthInfo2;
    protected StrategyMonthInfo strategyMonthInfo3;
    protected StrategyMonthInfo strategyMonthInfo4;
    protected StrategyMonthInfo strategyMonthInfo5;
    protected StrategyMonthInfo strategyMonthInfo6;
    protected StrategyMonthInfo strategyMonthInfo7;
    protected StrategyMonthInfo strategyMonthInfo8;
    protected StrategyMonthInfo strategyMonthInfo9;
    protected StrategyOneMonthInfoUI strategyNovember;
    protected StrategyOneMonthInfoUI strategyOctober;
    protected StrategyOneMonthInfoUI strategySeptember;
    @Validator( validatorId = "validator")
    protected SwingValidator<Strategy> validator;
    @Validator( validatorId = "validator0")
    protected SwingValidator<StrategyMonthInfo> validator0;
    @Validator( validatorId = "validator1")
    protected SwingValidator<StrategyMonthInfo> validator1;
    @Validator( validatorId = "validator10")
    protected SwingValidator<StrategyMonthInfo> validator10;
    @Validator( validatorId = "validator11")
    protected SwingValidator<StrategyMonthInfo> validator11;
    @Validator( validatorId = "validator2")
    protected SwingValidator<StrategyMonthInfo> validator2;
    @Validator( validatorId = "validator3")
    protected SwingValidator<StrategyMonthInfo> validator3;
    @Validator( validatorId = "validator4")
    protected SwingValidator<StrategyMonthInfo> validator4;
    @Validator( validatorId = "validator5")
    protected SwingValidator<StrategyMonthInfo> validator5;
    @Validator( validatorId = "validator6")
    protected SwingValidator<StrategyMonthInfo> validator6;
    @Validator( validatorId = "validator7")
    protected SwingValidator<StrategyMonthInfo> validator7;
    @Validator( validatorId = "validator8")
    protected SwingValidator<StrategyMonthInfo> validator8;
    @Validator( validatorId = "validator9")
    protected SwingValidator<StrategyMonthInfo> validator9;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StrategyMonthInfoUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    setStrategyMonthInfo0(null);
                    setStrategyMonthInfo1(null);
                    setStrategyMonthInfo2(null);
                    setStrategyMonthInfo3(null);
                    setStrategyMonthInfo4(null);
                    setStrategyMonthInfo5(null);
                    setStrategyMonthInfo6(null);
                    setStrategyMonthInfo7(null);
                    setStrategyMonthInfo8(null);
                    setStrategyMonthInfo9(null);
                    setStrategyMonthInfo10(null);
                    setStrategyMonthInfo11(null);
                    fieldStrategyProportion.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    setStrategyMonthInfo0(getBean().getStrategyMonthInfo().get(0));
                    setStrategyMonthInfo1(getBean().getStrategyMonthInfo().get(1));
                    setStrategyMonthInfo2(getBean().getStrategyMonthInfo().get(2));
                    setStrategyMonthInfo3(getBean().getStrategyMonthInfo().get(3));
                    setStrategyMonthInfo4(getBean().getStrategyMonthInfo().get(4));
                    setStrategyMonthInfo5(getBean().getStrategyMonthInfo().get(5));
                    setStrategyMonthInfo6(getBean().getStrategyMonthInfo().get(6));
                    setStrategyMonthInfo7(getBean().getStrategyMonthInfo().get(7));
                    setStrategyMonthInfo8(getBean().getStrategyMonthInfo().get(8));
                    setStrategyMonthInfo9(getBean().getStrategyMonthInfo().get(9));
                    setStrategyMonthInfo10(getBean().getStrategyMonthInfo().get(10));
                    setStrategyMonthInfo11(getBean().getStrategyMonthInfo().get(11));
                    setProportionMetierMatrix();
                }
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    /*@Override
    public void refresh() {
        //getSaveVerifier().addCurrentPanel(strategyJanuary, strategyFebuary, strategyMarch,
        //      strategyApril, strategyMay, strategyJune,
        //      strategyJuly, strategyAugust, strategySeptember,
        //      strategyOctober, strategyNovember, strategyDecember);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        strategyJanuary.setLayer(active);
        strategyFebuary.setLayer(active);
        strategyMarch.setLayer(active);
        strategyApril.setLayer(active);
        strategyMay.setLayer(active);
        strategyJune.setLayer(active);
        strategyJuly.setLayer(active);
        strategyAugust.setLayer(active);
        strategySeptember.setLayer(active);
        strategyOctober.setLayer(active);
        strategyNovember.setLayer(active);
        strategyDecember.setLayer(active);
    }
    protected void setProportionMetierMatrix() {
        MatrixND prop = getBean().getProportionMetier();
        if (prop != null) {
            fieldStrategyProportion.setMatrix(prop.copy());
        }
        else {
            fieldStrategyProportion.setMatrix(null);
        }
    }
    protected void strategyProportionMatrixChanged(MatrixPanelEvent event) {
        MatrixND mat = fieldStrategyProportion.getMatrix();
        if (getBean() != null && mat != null) {
            getBean().setProportionMetier(mat.copy());
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StrategyMonthInfoUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyMonthInfoUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StrategyMonthInfoUI() {
        $initialize();
    }

    public StrategyMonthInfoUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public StrategyMonthInfoUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StrategyMonthInfoUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyMonthInfoUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public StrategyMonthInfoUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);validator0.setChanged(false);validator1.setChanged(false);validator2.setChanged(false);validator3.setChanged(false);validator4.setChanged(false);validator5.setChanged(false);validator6.setChanged(false);validator7.setChanged(false);validator8.setChanged(false);validator9.setChanged(false);validator10.setChanged(false);validator11.setChanged(false);
    }

    public void doMatrixChanged__on__fieldStrategyProportion(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        strategyProportionMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Strategy getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public MatrixPanelEditor getFieldStrategyProportion() {
        return fieldStrategyProportion;
    }

    public JButton getSave() {
        return save;
    }

    public StrategyOneMonthInfoUI getStrategyApril() {
        return strategyApril;
    }

    public StrategyOneMonthInfoUI getStrategyAugust() {
        return strategyAugust;
    }

    public StrategyOneMonthInfoUI getStrategyDecember() {
        return strategyDecember;
    }

    public StrategyOneMonthInfoUI getStrategyFebuary() {
        return strategyFebuary;
    }

    public StrategyOneMonthInfoUI getStrategyJanuary() {
        return strategyJanuary;
    }

    public StrategyOneMonthInfoUI getStrategyJuly() {
        return strategyJuly;
    }

    public StrategyOneMonthInfoUI getStrategyJune() {
        return strategyJune;
    }

    public StrategyOneMonthInfoUI getStrategyMarch() {
        return strategyMarch;
    }

    public StrategyOneMonthInfoUI getStrategyMay() {
        return strategyMay;
    }

    public StrategyMonthInfo getStrategyMonthInfo0() {
        return strategyMonthInfo0;
    }

    public StrategyMonthInfo getStrategyMonthInfo1() {
        return strategyMonthInfo1;
    }

    public StrategyMonthInfo getStrategyMonthInfo10() {
        return strategyMonthInfo10;
    }

    public StrategyMonthInfo getStrategyMonthInfo11() {
        return strategyMonthInfo11;
    }

    public StrategyMonthInfo getStrategyMonthInfo2() {
        return strategyMonthInfo2;
    }

    public StrategyMonthInfo getStrategyMonthInfo3() {
        return strategyMonthInfo3;
    }

    public StrategyMonthInfo getStrategyMonthInfo4() {
        return strategyMonthInfo4;
    }

    public StrategyMonthInfo getStrategyMonthInfo5() {
        return strategyMonthInfo5;
    }

    public StrategyMonthInfo getStrategyMonthInfo6() {
        return strategyMonthInfo6;
    }

    public StrategyMonthInfo getStrategyMonthInfo7() {
        return strategyMonthInfo7;
    }

    public StrategyMonthInfo getStrategyMonthInfo8() {
        return strategyMonthInfo8;
    }

    public StrategyMonthInfo getStrategyMonthInfo9() {
        return strategyMonthInfo9;
    }

    public StrategyOneMonthInfoUI getStrategyNovember() {
        return strategyNovember;
    }

    public StrategyOneMonthInfoUI getStrategyOctober() {
        return strategyOctober;
    }

    public StrategyOneMonthInfoUI getStrategySeptember() {
        return strategySeptember;
    }

    public SwingValidator<Strategy> getValidator() {
        return validator;
    }

    public SwingValidator<StrategyMonthInfo> getValidator0() {
        return validator0;
    }

    public SwingValidator<StrategyMonthInfo> getValidator1() {
        return validator1;
    }

    public SwingValidator<StrategyMonthInfo> getValidator10() {
        return validator10;
    }

    public SwingValidator<StrategyMonthInfo> getValidator11() {
        return validator11;
    }

    public SwingValidator<StrategyMonthInfo> getValidator2() {
        return validator2;
    }

    public SwingValidator<StrategyMonthInfo> getValidator3() {
        return validator3;
    }

    public SwingValidator<StrategyMonthInfo> getValidator4() {
        return validator4;
    }

    public SwingValidator<StrategyMonthInfo> getValidator5() {
        return validator5;
    }

    public SwingValidator<StrategyMonthInfo> getValidator6() {
        return validator6;
    }

    public SwingValidator<StrategyMonthInfo> getValidator7() {
        return validator7;
    }

    public SwingValidator<StrategyMonthInfo> getValidator8() {
        return validator8;
    }

    public SwingValidator<StrategyMonthInfo> getValidator9() {
        return validator9;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Strategy bean) {
        Strategy oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setStrategyMonthInfo0(StrategyMonthInfo strategyMonthInfo0) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo0;
        this.strategyMonthInfo0 = strategyMonthInfo0;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO0, oldValue, strategyMonthInfo0);
    }

    public void setStrategyMonthInfo1(StrategyMonthInfo strategyMonthInfo1) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo1;
        this.strategyMonthInfo1 = strategyMonthInfo1;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO1, oldValue, strategyMonthInfo1);
    }

    public void setStrategyMonthInfo10(StrategyMonthInfo strategyMonthInfo10) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo10;
        this.strategyMonthInfo10 = strategyMonthInfo10;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO10, oldValue, strategyMonthInfo10);
    }

    public void setStrategyMonthInfo11(StrategyMonthInfo strategyMonthInfo11) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo11;
        this.strategyMonthInfo11 = strategyMonthInfo11;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO11, oldValue, strategyMonthInfo11);
    }

    public void setStrategyMonthInfo2(StrategyMonthInfo strategyMonthInfo2) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo2;
        this.strategyMonthInfo2 = strategyMonthInfo2;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO2, oldValue, strategyMonthInfo2);
    }

    public void setStrategyMonthInfo3(StrategyMonthInfo strategyMonthInfo3) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo3;
        this.strategyMonthInfo3 = strategyMonthInfo3;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO3, oldValue, strategyMonthInfo3);
    }

    public void setStrategyMonthInfo4(StrategyMonthInfo strategyMonthInfo4) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo4;
        this.strategyMonthInfo4 = strategyMonthInfo4;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO4, oldValue, strategyMonthInfo4);
    }

    public void setStrategyMonthInfo5(StrategyMonthInfo strategyMonthInfo5) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo5;
        this.strategyMonthInfo5 = strategyMonthInfo5;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO5, oldValue, strategyMonthInfo5);
    }

    public void setStrategyMonthInfo6(StrategyMonthInfo strategyMonthInfo6) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo6;
        this.strategyMonthInfo6 = strategyMonthInfo6;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO6, oldValue, strategyMonthInfo6);
    }

    public void setStrategyMonthInfo7(StrategyMonthInfo strategyMonthInfo7) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo7;
        this.strategyMonthInfo7 = strategyMonthInfo7;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO7, oldValue, strategyMonthInfo7);
    }

    public void setStrategyMonthInfo8(StrategyMonthInfo strategyMonthInfo8) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo8;
        this.strategyMonthInfo8 = strategyMonthInfo8;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO8, oldValue, strategyMonthInfo8);
    }

    public void setStrategyMonthInfo9(StrategyMonthInfo strategyMonthInfo9) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo9;
        this.strategyMonthInfo9 = strategyMonthInfo9;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO9, oldValue, strategyMonthInfo9);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0, BorderLayout.CENTER);
        body.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator0() {
        if (!allComponentsCreated) {
            return;
        }
        validator0.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator1() {
        if (!allComponentsCreated) {
            return;
        }
        validator1.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator10() {
        if (!allComponentsCreated) {
            return;
        }
        validator10.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator11() {
        if (!allComponentsCreated) {
            return;
        }
        validator11.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator2() {
        if (!allComponentsCreated) {
            return;
        }
        validator2.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator3() {
        if (!allComponentsCreated) {
            return;
        }
        validator3.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator4() {
        if (!allComponentsCreated) {
            return;
        }
        validator4.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator5() {
        if (!allComponentsCreated) {
            return;
        }
        validator5.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator6() {
        if (!allComponentsCreated) {
            return;
        }
        validator6.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator7() {
        if (!allComponentsCreated) {
            return;
        }
        validator7.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator8() {
        if (!allComponentsCreated) {
            return;
        }
        validator8.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidator9() {
        if (!allComponentsCreated) {
            return;
        }
        validator9.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldStrategyProportion() {
        $objectMap.put("fieldStrategyProportion", fieldStrategyProportion = new MatrixPanelEditor());
        
        fieldStrategyProportion.setName("fieldStrategyProportion");
        fieldStrategyProportion.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldStrategyProportion"));
        fieldStrategyProportion.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Strategy.class);
        fieldStrategyProportion.putClientProperty("sensitivityMethod", "ProportionMetier");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createStrategyApril() {
        $objectMap.put("strategyApril", strategyApril = new StrategyOneMonthInfoUI(this));
        
        strategyApril.setName("strategyApril");
    }

    protected void createStrategyAugust() {
        $objectMap.put("strategyAugust", strategyAugust = new StrategyOneMonthInfoUI(this));
        
        strategyAugust.setName("strategyAugust");
    }

    protected void createStrategyDecember() {
        $objectMap.put("strategyDecember", strategyDecember = new StrategyOneMonthInfoUI(this));
        
        strategyDecember.setName("strategyDecember");
    }

    protected void createStrategyFebuary() {
        $objectMap.put("strategyFebuary", strategyFebuary = new StrategyOneMonthInfoUI(this));
        
        strategyFebuary.setName("strategyFebuary");
    }

    protected void createStrategyJanuary() {
        $objectMap.put("strategyJanuary", strategyJanuary = new StrategyOneMonthInfoUI(this));
        
        strategyJanuary.setName("strategyJanuary");
    }

    protected void createStrategyJuly() {
        $objectMap.put("strategyJuly", strategyJuly = new StrategyOneMonthInfoUI(this));
        
        strategyJuly.setName("strategyJuly");
    }

    protected void createStrategyJune() {
        $objectMap.put("strategyJune", strategyJune = new StrategyOneMonthInfoUI(this));
        
        strategyJune.setName("strategyJune");
    }

    protected void createStrategyMarch() {
        $objectMap.put("strategyMarch", strategyMarch = new StrategyOneMonthInfoUI(this));
        
        strategyMarch.setName("strategyMarch");
    }

    protected void createStrategyMay() {
        $objectMap.put("strategyMay", strategyMay = new StrategyOneMonthInfoUI(this));
        
        strategyMay.setName("strategyMay");
    }

    protected void createStrategyMonthInfo0() {
        $objectMap.put("strategyMonthInfo0", strategyMonthInfo0 = null);
    }

    protected void createStrategyMonthInfo1() {
        $objectMap.put("strategyMonthInfo1", strategyMonthInfo1 = null);
    }

    protected void createStrategyMonthInfo10() {
        $objectMap.put("strategyMonthInfo10", strategyMonthInfo10 = null);
    }

    protected void createStrategyMonthInfo11() {
        $objectMap.put("strategyMonthInfo11", strategyMonthInfo11 = null);
    }

    protected void createStrategyMonthInfo2() {
        $objectMap.put("strategyMonthInfo2", strategyMonthInfo2 = null);
    }

    protected void createStrategyMonthInfo3() {
        $objectMap.put("strategyMonthInfo3", strategyMonthInfo3 = null);
    }

    protected void createStrategyMonthInfo4() {
        $objectMap.put("strategyMonthInfo4", strategyMonthInfo4 = null);
    }

    protected void createStrategyMonthInfo5() {
        $objectMap.put("strategyMonthInfo5", strategyMonthInfo5 = null);
    }

    protected void createStrategyMonthInfo6() {
        $objectMap.put("strategyMonthInfo6", strategyMonthInfo6 = null);
    }

    protected void createStrategyMonthInfo7() {
        $objectMap.put("strategyMonthInfo7", strategyMonthInfo7 = null);
    }

    protected void createStrategyMonthInfo8() {
        $objectMap.put("strategyMonthInfo8", strategyMonthInfo8 = null);
    }

    protected void createStrategyMonthInfo9() {
        $objectMap.put("strategyMonthInfo9", strategyMonthInfo9 = null);
    }

    protected void createStrategyNovember() {
        $objectMap.put("strategyNovember", strategyNovember = new StrategyOneMonthInfoUI(this));
        
        strategyNovember.setName("strategyNovember");
    }

    protected void createStrategyOctober() {
        $objectMap.put("strategyOctober", strategyOctober = new StrategyOneMonthInfoUI(this));
        
        strategyOctober.setName("strategyOctober");
    }

    protected void createStrategySeptember() {
        $objectMap.put("strategySeptember", strategySeptember = new StrategyOneMonthInfoUI(this));
        
        strategySeptember.setName("strategySeptember");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Strategy.class, "month"));
    }

    protected void createValidator0() {
        $objectMap.put("validator0", validator0 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator1() {
        $objectMap.put("validator1", validator1 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator10() {
        $objectMap.put("validator10", validator10 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator11() {
        $objectMap.put("validator11", validator11 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator2() {
        $objectMap.put("validator2", validator2 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator3() {
        $objectMap.put("validator3", validator3 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator4() {
        $objectMap.put("validator4", validator4 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator5() {
        $objectMap.put("validator5", validator5 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator6() {
        $objectMap.put("validator6", validator6 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator7() {
        $objectMap.put("validator7", validator7 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator8() {
        $objectMap.put("validator8", validator8 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    protected void createValidator9() {
        $objectMap.put("validator9", validator9 = SwingValidator.newValidator(StrategyMonthInfo.class, "month"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidator0();
        addChildrenToValidator1();
        addChildrenToValidator2();
        addChildrenToValidator3();
        addChildrenToValidator4();
        addChildrenToValidator5();
        addChildrenToValidator6();
        addChildrenToValidator7();
        addChildrenToValidator8();
        addChildrenToValidator9();
        addChildrenToValidator10();
        addChildrenToValidator11();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(strategyJanuary, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyFebuary, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyMarch, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyApril, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyMay, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyJune, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyJuly, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyAugust, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategySeptember, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyOctober, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyNovember, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(strategyDecember, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldStrategyProportion), new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 54 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        strategyJanuary.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.january")));
        strategyFebuary.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.february")));
        strategyMarch.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.march")));
        strategyApril.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.april")));
        strategyMay.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.may")));
        strategyJune.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.june")));
        strategyJuly.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.july")));
        strategyAugust.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.august")));
        strategySeptember.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.september")));
        strategyOctober.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.october")));
        strategyNovember.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.november")));
        strategyDecember.setStrategieMonthText(StringUtils.capitalize(t("isisfish.month.december")));
        // late initializer
        // register 13 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createStrategyMonthInfo0();
        createStrategyMonthInfo1();
        createStrategyMonthInfo2();
        createStrategyMonthInfo3();
        createStrategyMonthInfo4();
        createStrategyMonthInfo5();
        createStrategyMonthInfo6();
        createStrategyMonthInfo7();
        createStrategyMonthInfo8();
        createStrategyMonthInfo9();
        createStrategyMonthInfo10();
        createStrategyMonthInfo11();
        createValidator();
        createValidator0();
        createValidator1();
        createValidator2();
        createValidator3();
        createValidator4();
        createValidator5();
        createValidator6();
        createValidator7();
        createValidator8();
        createValidator9();
        createValidator10();
        createValidator11();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createStrategyJanuary();
        createStrategyFebuary();
        createStrategyMarch();
        createStrategyApril();
        createStrategyMay();
        createStrategyJune();
        createStrategyJuly();
        createStrategyAugust();
        createStrategySeptember();
        createStrategyOctober();
        createStrategyNovember();
        createStrategyDecember();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.strategy.proportionMetierLabel"));
        createFieldStrategyProportion();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 54 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 54 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR0_BEAN, true ,"strategyMonthInfo0") {
        
            @Override
            public void processDataBinding() {
                validator0.setBean(getStrategyMonthInfo0());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR1_BEAN, true ,"strategyMonthInfo1") {
        
            @Override
            public void processDataBinding() {
                validator1.setBean(getStrategyMonthInfo1());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR2_BEAN, true ,"strategyMonthInfo2") {
        
            @Override
            public void processDataBinding() {
                validator2.setBean(getStrategyMonthInfo2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR3_BEAN, true ,"strategyMonthInfo3") {
        
            @Override
            public void processDataBinding() {
                validator3.setBean(getStrategyMonthInfo3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR4_BEAN, true ,"strategyMonthInfo4") {
        
            @Override
            public void processDataBinding() {
                validator4.setBean(getStrategyMonthInfo4());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR5_BEAN, true ,"strategyMonthInfo5") {
        
            @Override
            public void processDataBinding() {
                validator5.setBean(getStrategyMonthInfo5());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR6_BEAN, true ,"strategyMonthInfo6") {
        
            @Override
            public void processDataBinding() {
                validator6.setBean(getStrategyMonthInfo6());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR7_BEAN, true ,"strategyMonthInfo7") {
        
            @Override
            public void processDataBinding() {
                validator7.setBean(getStrategyMonthInfo7());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR8_BEAN, true ,"strategyMonthInfo8") {
        
            @Override
            public void processDataBinding() {
                validator8.setBean(getStrategyMonthInfo8());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR9_BEAN, true ,"strategyMonthInfo9") {
        
            @Override
            public void processDataBinding() {
                validator9.setBean(getStrategyMonthInfo9());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR10_BEAN, true ,"strategyMonthInfo10") {
        
            @Override
            public void processDataBinding() {
                validator10.setBean(getStrategyMonthInfo10());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR11_BEAN, true ,"strategyMonthInfo11") {
        
            @Override
            public void processDataBinding() {
                validator11.setBean(getStrategyMonthInfo11());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator0 != null) {
                    validator0.addPropertyChangeListener("changed", this);
                }
                if (validator1 != null) {
                    validator1.addPropertyChangeListener("changed", this);
                }
                if (validator2 != null) {
                    validator2.addPropertyChangeListener("changed", this);
                }
                if (validator3 != null) {
                    validator3.addPropertyChangeListener("changed", this);
                }
                if (validator4 != null) {
                    validator4.addPropertyChangeListener("changed", this);
                }
                if (validator5 != null) {
                    validator5.addPropertyChangeListener("changed", this);
                }
                if (validator6 != null) {
                    validator6.addPropertyChangeListener("changed", this);
                }
                if (validator7 != null) {
                    validator7.addPropertyChangeListener("changed", this);
                }
                if (validator8 != null) {
                    validator8.addPropertyChangeListener("changed", this);
                }
                if (validator9 != null) {
                    validator9.addPropertyChangeListener("changed", this);
                }
                if (validator10 != null) {
                    validator10.addPropertyChangeListener("changed", this);
                }
                if (validator11 != null) {
                    validator11.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator0 != null && validator1 != null && validator2 != null && validator3 != null && validator4 != null && validator5 != null && validator6 != null && validator7 != null && validator8 != null && validator9 != null && validator10 != null && validator11 != null) {
                    changeModel.setChanged(validator0.isChanged() || validator1.isChanged() || validator2.isChanged() || validator3.isChanged() || validator4.isChanged() || validator5.isChanged() || validator6.isChanged() || validator7.isChanged() || validator8.isChanged() || validator9.isChanged() || validator10.isChanged() || validator11.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator0 != null) {
                    validator0.removePropertyChangeListener("changed", this);
                }
                if (validator1 != null) {
                    validator1.removePropertyChangeListener("changed", this);
                }
                if (validator2 != null) {
                    validator2.removePropertyChangeListener("changed", this);
                }
                if (validator3 != null) {
                    validator3.removePropertyChangeListener("changed", this);
                }
                if (validator4 != null) {
                    validator4.removePropertyChangeListener("changed", this);
                }
                if (validator5 != null) {
                    validator5.removePropertyChangeListener("changed", this);
                }
                if (validator6 != null) {
                    validator6.removePropertyChangeListener("changed", this);
                }
                if (validator7 != null) {
                    validator7.removePropertyChangeListener("changed", this);
                }
                if (validator8 != null) {
                    validator8.removePropertyChangeListener("changed", this);
                }
                if (validator9 != null) {
                    validator9.removePropertyChangeListener("changed", this);
                }
                if (validator10 != null) {
                    validator10.removePropertyChangeListener("changed", this);
                }
                if (validator11 != null) {
                    validator11.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator0 != null) {
                    validator0.addPropertyChangeListener("valid", this);
                }
                if (validator1 != null) {
                    validator1.addPropertyChangeListener("valid", this);
                }
                if (validator2 != null) {
                    validator2.addPropertyChangeListener("valid", this);
                }
                if (validator3 != null) {
                    validator3.addPropertyChangeListener("valid", this);
                }
                if (validator4 != null) {
                    validator4.addPropertyChangeListener("valid", this);
                }
                if (validator5 != null) {
                    validator5.addPropertyChangeListener("valid", this);
                }
                if (validator6 != null) {
                    validator6.addPropertyChangeListener("valid", this);
                }
                if (validator7 != null) {
                    validator7.addPropertyChangeListener("valid", this);
                }
                if (validator8 != null) {
                    validator8.addPropertyChangeListener("valid", this);
                }
                if (validator9 != null) {
                    validator9.addPropertyChangeListener("valid", this);
                }
                if (validator10 != null) {
                    validator10.addPropertyChangeListener("valid", this);
                }
                if (validator11 != null) {
                    validator11.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator0 != null && validator1 != null && validator2 != null && validator3 != null && validator4 != null && validator5 != null && validator6 != null && validator7 != null && validator8 != null && validator9 != null && validator10 != null && validator11 != null) {
                    changeModel.setValid(validator0.isValid() && validator1.isValid() && validator2.isValid() && validator3.isValid() && validator4.isValid() && validator5.isValid() && validator6.isValid() && validator7.isValid() && validator8.isValid() && validator9.isValid() && validator10.isValid() && validator11.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator0 != null) {
                    validator0.removePropertyChangeListener("valid", this);
                }
                if (validator1 != null) {
                    validator1.removePropertyChangeListener("valid", this);
                }
                if (validator2 != null) {
                    validator2.removePropertyChangeListener("valid", this);
                }
                if (validator3 != null) {
                    validator3.removePropertyChangeListener("valid", this);
                }
                if (validator4 != null) {
                    validator4.removePropertyChangeListener("valid", this);
                }
                if (validator5 != null) {
                    validator5.removePropertyChangeListener("valid", this);
                }
                if (validator6 != null) {
                    validator6.removePropertyChangeListener("valid", this);
                }
                if (validator7 != null) {
                    validator7.removePropertyChangeListener("valid", this);
                }
                if (validator8 != null) {
                    validator8.removePropertyChangeListener("valid", this);
                }
                if (validator9 != null) {
                    validator9.removePropertyChangeListener("valid", this);
                }
                if (validator10 != null) {
                    validator10.removePropertyChangeListener("valid", this);
                }
                if (validator11 != null) {
                    validator11.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JANUARY_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyJanuary.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JANUARY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyJanuary.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JANUARY_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo0") {
        
            @Override
            public void processDataBinding() {
                strategyJanuary.setStrategyMonthInfo(getStrategyMonthInfo0());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_FEBUARY_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyFebuary.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_FEBUARY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyFebuary.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_FEBUARY_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo1") {
        
            @Override
            public void processDataBinding() {
                strategyFebuary.setStrategyMonthInfo(getStrategyMonthInfo1());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MARCH_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyMarch.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MARCH_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyMarch.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MARCH_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo2") {
        
            @Override
            public void processDataBinding() {
                strategyMarch.setStrategyMonthInfo(getStrategyMonthInfo2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_APRIL_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyApril.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_APRIL_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyApril.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_APRIL_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo3") {
        
            @Override
            public void processDataBinding() {
                strategyApril.setStrategyMonthInfo(getStrategyMonthInfo3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MAY_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyMay.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MAY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyMay.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MAY_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo4") {
        
            @Override
            public void processDataBinding() {
                strategyMay.setStrategyMonthInfo(getStrategyMonthInfo4());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JUNE_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyJune.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JUNE_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyJune.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JUNE_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo5") {
        
            @Override
            public void processDataBinding() {
                strategyJune.setStrategyMonthInfo(getStrategyMonthInfo5());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JULY_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyJuly.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JULY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyJuly.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_JULY_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo6") {
        
            @Override
            public void processDataBinding() {
                strategyJuly.setStrategyMonthInfo(getStrategyMonthInfo6());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_AUGUST_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyAugust.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_AUGUST_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyAugust.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_AUGUST_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo7") {
        
            @Override
            public void processDataBinding() {
                strategyAugust.setStrategyMonthInfo(getStrategyMonthInfo7());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_SEPTEMBER_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategySeptember.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_SEPTEMBER_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategySeptember.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_SEPTEMBER_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo8") {
        
            @Override
            public void processDataBinding() {
                strategySeptember.setStrategyMonthInfo(getStrategyMonthInfo8());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_OCTOBER_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyOctober.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_OCTOBER_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyOctober.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_OCTOBER_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo9") {
        
            @Override
            public void processDataBinding() {
                strategyOctober.setStrategyMonthInfo(getStrategyMonthInfo9());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_NOVEMBER_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyNovember.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_NOVEMBER_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyNovember.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_NOVEMBER_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo10") {
        
            @Override
            public void processDataBinding() {
                strategyNovember.setStrategyMonthInfo(getStrategyMonthInfo10());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_DECEMBER_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyDecember.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_DECEMBER_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyDecember.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_DECEMBER_STRATEGY_MONTH_INFO, true ,"strategyMonthInfo11") {
        
            @Override
            public void processDataBinding() {
                strategyDecember.setStrategyMonthInfo(getStrategyMonthInfo11());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_PROPORTION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyProportion.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}