package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Wed Jan 28 10:52:10 CET 2015")
public abstract class TripTypeDAOAbstract<E extends TripType> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TripType.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.TripType;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<VesselType> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from vesselType main, triptype_vesseltype secondary " +
                    "where main.topiaid=secondary.vesselType" +
                    " and secondary.tripType='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(VesselType.class)).list();

            for (VesselType item : list) {
                item.removeTripType(entity);
            }
        }

                                        {
                                        List<StrategyMonthInfo> list = getContext()
                                                    .getDAO(StrategyMonthInfo.class)
                                                    .findAllByProperties(StrategyMonthInfo.PROPERTY_TRIP_TYPE, entity);
                                            for (StrategyMonthInfo item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTripType())) {
                                                    item.setTripType(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_NAME, v);
        return result;
    }

    public E findByTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_TRIP_DURATION, v);
        return result;
    }

    public List<E> findAllByTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_TRIP_DURATION, v);
        return result;
    }

    public E findByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    public List<E> findAllByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_COMMENT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == StrategyMonthInfo.class) {
            StrategyMonthInfoDAO dao = (StrategyMonthInfoDAO)
                getContext().getDAO(StrategyMonthInfo.class);
            tmp = dao.findAllByTripType(entity);
            result.addAll(tmp);
        }

        if (type == VesselType.class) {
            VesselTypeDAO dao = (VesselTypeDAO)
                getContext().getDAO(VesselType.class);
            tmp = dao.findAllContainsTripType(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(StrategyMonthInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(StrategyMonthInfo.class, list);
        }

        list = findUsages(VesselType.class, entity);
        if (!list.isEmpty()) {
            result.put(VesselType.class, list);
        }

        return result;
    }

} //TripTypeDAOAbstract<E extends TripType>
