/*
 * #%L
 * $Id: IsisMatrixSemanticMapper.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.0/src/main/java/fr/ifremer/isisfish/util/IsisMatrixSemanticMapper.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.simulator.SimulationContext;

/**
 * Implementation du mapper de semantique pour Isis pour que l'import/export
 * des matrices en N dimensions de nuiton matrix fonctionne.
 * 
 * @author chatellier
 * @version $Revision: 3798 $
 * 
 * Last update : $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * By : $Author: echatellier $
 */
public class IsisMatrixSemanticMapper extends SemanticMapper {

    /** Logger for this class. */
    private static Log log = LogFactory.getLog(IsisMatrixSemanticMapper.class);

    /**
     * Return class for type identified by typeName.
     * 
     * For example : "Population" can return "fr.ifremer.entities.Population.class"
     * 
     * Return {@code String} by default.
     * 
     * @param typeName type to get class.
     * @return type for typeId
     */
    public Class getType(String typeName) {

        // In simulation context :
        Class clazz = null;
        try {
            clazz = Class.forName("fr.ifremer.isisfish.entities." + typeName);
        } catch (Exception ex) {
            try {
                clazz = Class.forName("fr.ifremer.isisfish.types." + typeName);
            } catch (Exception ex2) {
                log.warn("Can't find class for name " + typeName, ex2);
                clazz = String.class;
            }
            
        }
        return clazz;
    }

    /**
     * Return value identified by valueId and type {@code type}.
     * 
     * Return {@code valueId} by default;
     * 
     * @param type
     * @param valueId
     * @return value identified by {valueId}
     */
    public Object getValue(Class type, String valueId) {

        // In simulation context :
        Object value = null;
        try {
            // les populations groupes sont speciaux car ils n'ont pas de
            // noms. Dans l'import il sont composé du nom de la population
            // et du numero de groupe séparé par +.
            if (PopulationGroup.class.isAssignableFrom(type)) {
                int separatorIndex = valueId.indexOf('+');
                if (separatorIndex >= 0) {
                    String popName = valueId.substring(0, separatorIndex);
                    int groupId = Integer.parseInt(valueId.substring(separatorIndex + 1));

                    TopiaContext context = SimulationContext.get().getDB();
                    PopulationDAO populationDao = IsisFishDAOHelper.getPopulationDAO(context);
                    PopulationGroupDAO populationGroupDAO = IsisFishDAOHelper.getPopulationGroupDAO(context);
                    Population population = populationDao.findByName(popName);
                    value = populationGroupDAO.findByProperties(
                            PopulationGroup.PROPERTY_POPULATION, population,
                            PopulationGroup.PROPERTY_ID, groupId);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn("PopulationGroup identifiant doesn't contains '+' separator");
                    }
                    value = valueId;
                }
            }
            else if (TopiaEntity.class.isAssignableFrom(type)) {
                TopiaContext context = SimulationContext.get().getDB();
                TopiaDAO dao = IsisFishDAOHelper.getDAO(context, type);
                value = dao.findByProperty("name", valueId);
            } else {
                value = ConverterUtil.getConverter(null).convert(valueId, type);
            }
        } catch (Exception ex) {
            log.warn("Can't get value for " + valueId, ex);
            value = valueId;
        }
        return value;

        //return valueId;
    }
}
