package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import static org.nuiton.i18n.I18n.t;

public class PreScriptsUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI2TQU8TQRTHXwstFFCBRoKKBrCejFPvEARRIqQqoZoQe3HKTumQ6e4481aWi/Ej+BH07sXEmyfjwbMHL8avYIwHr8Y307IFXKM97Hbnzfu9/3vzn9ffoGANzO3xJGEmDlF2BNtY2d6+39wTO3hL2B0jNUYGur9cHvINGA3SdYtwuVFz6dVeenU16ugoFOGR7IUajFg8UMK2hUCEi8czdqyt1tPwQqJjc0hNRWVRX/74nn8RPH+VB0g0qRukVmb/ldXvZLAGeRkgTFKlp7yqeLhLMowMd0nvKbe2qri193hHPIFnMFSDouaGYAjz/9+yZ/j8RCMMVzY2eSjUdYRrLcNky4iOoLeVtiVtm8WSWdmJFScE2zSi7nH24brWHlJEmKhsPRAJUiRSysGIdSUyu6wlW8IBDFKYhHJ2YqMDlFJOuSWFCuquWloI4eoxkj0IkSd9Xt1/O+oKfTvQWMorVTZuxohRSHrKbnoJs/s0TNZb7lU3cOHYEdHhs/7h908n14CCiWkZYbrxp1+2KNR1yvQJpzigj/6aKn9+9/Xt2qE9Bqj22cytR9xNx6ZNpIVB6Uqf6XojRqmqd7leaEDJCkVXw1t/JkNYvRcmcVRvwqUzl87ucNsmRGHoy/sPU48/DUB+DUZUxIM17vavQwnbhqYQqSDRN5a9orH9YXqOO20IRcUPIholnF4MOPLZpgwDmu9SQkOYyRhCqqRZ+vizXH+zfDiIHAk799ft/WEUHkFRhkqGwt+U3iXIvBmj2oo4iPpmz7J/zr1HdM/K5/3zUlank13f3Q4kUoPeHW7vXBK717xvwf2reOL4fxAHnYcJvNjtZ5YjXfRmjGIpm1km5m9PqoHFHQUAAA==";
    private static final Log log = LogFactory.getLog(PreScriptsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected RSyntaxTextArea fieldSimulPreScript;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private PreScriptsUI $JPanel0 = this;
    private RTextScrollPane $RTextScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
            protected void save() {
                getContextValue(SimulAction.class).getSimulationParameter().setPreScript(fieldSimulPreScript.getText());
            }
    
            protected void refresh() {
            
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PreScriptsUI(SimulAction action) {
        setContextValue(action);
            $initialize();
    }

    public PreScriptsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PreScriptsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PreScriptsUI() {
        $initialize();
    }

    public PreScriptsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PreScriptsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PreScriptsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PreScriptsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PreScriptsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(fr.ifremer.isisfish.ui.SimulationUI.class).selectParametersTab();
    }

    public void doFocusLost__on__fieldSimulPreScript(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public RSyntaxTextArea getFieldSimulPreScript() {
        return fieldSimulPreScript;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected RTextScrollPane get$RTextScrollPane0() {
        return $RTextScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createFieldSimulPreScript() {
        $objectMap.put("fieldSimulPreScript", fieldSimulPreScript = new RSyntaxTextArea());
        
        fieldSimulPreScript.setName("fieldSimulPreScript");
        fieldSimulPreScript.setColumns(15);
        fieldSimulPreScript.setLineWrap(true);
        fieldSimulPreScript.setWrapStyleWord(true);
        fieldSimulPreScript.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__fieldSimulPreScript"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($RTextScrollPane0, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
        // inline complete setup of $RTextScrollPane0
        $RTextScrollPane0.getViewport().add(fieldSimulPreScript);
        
        // apply 2 property setters
        fieldSimulPreScript.setSyntaxEditingStyle(org.fife.ui.rsyntaxtextarea.SyntaxConstants.SYNTAX_STYLE_JAVA);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        // inline creation of $RTextScrollPane0
        $objectMap.put("$RTextScrollPane0", $RTextScrollPane0 = new RTextScrollPane());
        
        $RTextScrollPane0.setName("$RTextScrollPane0");
        createFieldSimulPreScript();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.preScript.backParameter"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        /*protected void backParameter() {
                    SimulUI simul = getParentContainer(SimulUI.class);
                    simul.selTab(0);
                }*/;$completeSetup();
    }

}