package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.models.sensitivityanalysis.SensitivityAnalysisComboModel;
import fr.ifremer.isisfish.ui.models.sensitivityanalysis.SensitivityAnalysisComboRenderer;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportListModel;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportListRenderer;
import fr.ifremer.isisfish.ui.models.sensitivityexport.SensitivityExportNameListRenderer;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorCardinalityTableModel;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivityChooserUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz28TRxTHJy5O4kCAOM0PIEEB0kql6rqBSiAFFUIgJMGUCLcSwhfG3rE9aLyznZlNNhyq/gEc6H8Ady5I3DhVPXDmwKXqv4AQB66IN7POrtfebFa1D2t7Zt7nfd+bme++eI/yUqAzj7DvW8JzFG0Ta3Pl/v27tUekrm4QWRfUVVyg4DOUQ7kqOmyH41Khc9WyDi91wkurvO1yhzhd0ctlNCbVLiOyRYhSaD4eUZeyVAmnl33XE3vUUFQS9dnHD7mn9p/Pcwj5LqibglIWDoqKKjlURjlqK1SETNu4xLDTBBmCOk3QO67HVhmW8hfcJr+jP9BIGQ27WABMobPZSzYME++7Co0s/oprjPyo0KWGsGhDkDaBb0llg8qW5VFLEkdSRbep2rUq0e/VFueSiN82XNfQhhUaXdws4xphACtqtb4ld0C8FYzqRYVw7ekGJczu4q04mO1C2gphsNEKTcUIUFCNX+d+HDK+uFmpC87YFnZ0CTOxmGgqHjUvadtjCam3sMDtXu2mPTqyGAKmG7gOHV3FwqYQCgSdhPVGmsF46r0OLen/R/VjNpw71UeNF/B1fPlE33I9MaMf8335LoT5Ii2dnV9SaDZ2RAP1Ydn7dHsplHQuqgCqp0wHdjX3pu9yoeBaTsSPBJVKh33bq8dI/SYOPoZtO+Bc95TijkKTMVgwqhd/H8YU4STzbdIdpmdKPavqjGDR0bjvqljlFxIqPynNqSV2f+F6xXn9+CkZdzHERZ2eICbWnEcZ7oTZ28sueMqp2IaBW1mRW0V2MlRFeeHBMOxwtd/g7sFUYG2zPdamgWb28/Tku9f/vVrb87MZyD2VuLTLjsFnXMFdIhTVqY8FZuYpykp3sLtcRYWgWcar5xKEVTrTIA7ymWNj6XBrHcsWIPIj//79z/TDt1+h3BoaYxzba+YqbKCCagnoAme27169ZhQd2RmF53GtTaFDivhgLcUr1GHUIQtYgbvWPEV+9qENcwltCLXUCm8+TVZeXttrxRBIO7Hv8qgd+QdoOMhmzL3j24lmftiVxLN55M9Jjj2kv8fdjumumOfNpFrzbW5rTzp6xcYKL9SoAz7RhEJ1xIapQP+6bYDHMwBH4U1jE0GEXrH1/zkFwXfWCW22zP1fTwZNZwANM7zLPZUi50QWSo0LO7WouQyUsQa40g9mt1KqykKabHFBHwMNsxVGm04b3uIDIfXwrYEJd1MatJCJ8CBFQzZCWhVnM7T2SJ0wdu/gU/zdwB05mABvgcAGKXfuwE0dEDZCHP2asFM6ZA3c42yEv1IISwNryEZI03BxYA3ZCE9StvTSwDdmGQhfAExDqh4tDQAA";
    private static final Log log = LogFactory.getLog(SensitivityChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addExportButton;
    protected JList availableSensitivityExports;
    protected JButton clearExportsButton;
    protected JTable exportParamsTable;
    protected JTable factorCardinality;
    protected JPanel factorCardinalityPanel;
    protected JScrollPane factorCardinalityScrollPane;
    protected JComboBox fieldSensitivityAnalysisSelect;
    protected JButton removeExportButton;
    protected JList selectedSensitivityExports;
    protected JTable simulSensitivityAnalysisParam;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private SensitivityChooserUI $Table0 = this;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // listener to listen for modification on sensitivity analysis
        StorageChangeListener sensitivityAnalysisListener;
    // listener to listen for modification on sensitivity exports
        StorageChangeListener sensitivityExportListener;
    
        
    
        protected SimulAction getSimulAction() {
            return getContextValue(SimulAction.class);
        }
    
        public ComboBoxModel getSensitivityAnalysisModel() {
            List<String> sensitivityNames = getSimulAction().getSensitivityAnalysisNames();
            SensitivityAnalysisComboModel model = new SensitivityAnalysisComboModel(sensitivityNames);
            return model;
        }
    
        /**
         * Auto select analysis in JComboBox
         * with analysis selected in SimulAction.
         *
         * Used by "reloadOldSimulation" operation.
         */
        public void refreshSelectedSensitivityAnalysis() {
            SensitivityAnalysis sensitivityAnalysis = getSimulAction().getSensitivityAnalysis();
            if (sensitivityAnalysis != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Refreshing sensitivity analysis list");
                }
                // TODO it's not getSimpleName() here !
                fieldSensitivityAnalysisSelect.setSelectedItem(sensitivityAnalysis.getClass().getSimpleName());
            }
        }
        
        protected void sensitivityAnalysisChanged() {
    
            String sensitivityName = (String)fieldSensitivityAnalysisSelect.getSelectedItem();
            
            // when analysis is changed by refreshSelectedSensitivityAnalysis
            // this event is thrown by build a new Analysis instance
            // and parameter are lost
            // fix it with a small class name test
            SensitivityAnalysis sensitivityAnalysis = getSimulAction().getSensitivityAnalysis();
            if (sensitivityAnalysis != null && sensitivityAnalysis.getClass().getSimpleName().equals(sensitivityName)) {
                sensitivityAnalysis = getSimulAction().getSensitivityAnalysis();
            } else {
                sensitivityAnalysis = getSimulAction().getSensitivityAnalysisInstance(sensitivityName);
            }
            
            // can be null for example if analysis can't be compiled
            if (sensitivityAnalysis != null) {
                getSimulAction().setSensitivityAnalysis(sensitivityAnalysis);
                
                CardLayout factorPanelLayout = (CardLayout)factorCardinalityPanel.getLayout();
                if (sensitivityAnalysis.canManageCardinality()) {
                    factorPanelLayout.show(factorCardinalityPanel, "factorCardinalitySupported");
                } else {
                    factorPanelLayout.show(factorCardinalityPanel, "factorCardinalityNotSupported");
                }
    
                // update model
                ScriptParametersTableModel parametersTableModel = new ScriptParametersTableModel(sensitivityAnalysis);
                simulSensitivityAnalysisParam.setModel(parametersTableModel);
                simulSensitivityAnalysisParam.getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(sensitivityAnalysis));
                simulSensitivityAnalysisParam.getColumnModel().getColumn(1).setCellEditor(new ScriptParametersTableCellEditor(sensitivityAnalysis));
            }
        }
    
        public void setFactorCardinalityTableModel() {
            List<Factor> factors = getSimulAction().getFactorGroup().getFactors();
            List<Factor> factorsContinue = new ArrayList<Factor>();
            /* get sublist with only Continous factor */
            for (Factor f : factors) {
                Domain domain = f.getDomain();
                if (ContinuousDomain.class.isInstance(domain)) {
                    ContinuousDomain continuousDomain = (ContinuousDomain)domain;
                    factorsContinue.add(f);
                }
            }
            FactorCardinalityTableModel model = new FactorCardinalityTableModel(factorsContinue);
            factorCardinality.setModel(model);
        }
    
        protected GenericListModel<String> getAvailableExportListModel() {
            List<String> exportNames = getSimulAction().getSensitivityExportNames();
            GenericListModel<String> model = new GenericListModel<String>(exportNames);
            return model;
        }
    
        /**
         * Add multiples export.
         *
         * Export name can be duplicated.
         */
        protected void addExports() {
            Object[] exportNames = (Object[])availableSensitivityExports.getSelectedValues();
            for (Object exportName : exportNames) {
                getSimulAction().addSensitivityExport(this, (String)exportName);
            }
            setSensitivityExportListModel();
        }
        
        /**
         * Remove multiple export.
         */
        protected void removeExports() {
            Object[] exports = (Object[])selectedSensitivityExports.getSelectedValues();
            for (Object export : exports) {
                getSimulAction().removeSensitivityExport((SensitivityExport)export);
            }
            setSensitivityExportListModel();
        }
        
        /**
         * Clear all export.
         */
        protected void clearExports() {
            getSimulAction().clearSensitivityExport();
            setSensitivityExportListModel();
        }
        
        /**
         * Set model (refresh export JList).
         */
        public void setSensitivityExportListModel() {
            java.util.List<SensitivityExport> exports = getSimulAction().getSensitivityExports();
            SensitivityExportListModel model = new SensitivityExportListModel(exports);
            selectedSensitivityExports.setModel(model);
            selectedSensitivityExports.setCellRenderer(new SensitivityExportListRenderer());
    
            clearExportsButton.setEnabled(!exports.isEmpty());
        }
    
        /**
         * When selection change on available export list.
         */
        protected void availableSensitivityExportSelection() {
            addExportButton.setEnabled(availableSensitivityExports.getSelectedIndices().length != 0);
        }
        
        /**
         * When selection change on choosen export list.
         */
        protected void selectedSensitivityExportSelection() {
            if (log.isDebugEnabled()) {
                log.debug("Sensitivity export selection change"); 
            }
            setExportParams();
            removeExportButton.setEnabled(selectedSensitivityExports.getSelectedIndices().length != 0);
        }
        
        /**
         * Fill export parameters names and values in table.
         */ 
        protected void setExportParams() {
            SimulAction simulAction = getContextValue(SimulAction.class);
    
            if (selectedSensitivityExports.getSelectedIndices().length == 1) {
                SensitivityExport export = (SensitivityExport)selectedSensitivityExports.getSelectedValue();
                ScriptParametersTableModel model = new ScriptParametersTableModel(export);
                exportParamsTable.setModel(model);
                exportParamsTable.getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(export));
                ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(export);
                cellEditor.setRegionStorage(getContextValue(RegionStorage.class));
                exportParamsTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
            }
            else {
                exportParamsTable.setModel(new DefaultTableModel());
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityChooserUI() {
        $initialize();
    }

    public SensitivityChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addExportButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addExports();
    }

    public void doActionPerformed__on__clearExportsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        clearExports();
    }

    public void doActionPerformed__on__fieldSensitivityAnalysisSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        sensitivityAnalysisChanged();
    }

    public void doActionPerformed__on__removeExportButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeExports();
    }

    public void doValueChanged__on__availableSensitivityExports(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        availableSensitivityExportSelection();
    }

    public void doValueChanged__on__selectedSensitivityExports(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectedSensitivityExportSelection();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddExportButton() {
        return addExportButton;
    }

    public JList getAvailableSensitivityExports() {
        return availableSensitivityExports;
    }

    public JButton getClearExportsButton() {
        return clearExportsButton;
    }

    public JTable getExportParamsTable() {
        return exportParamsTable;
    }

    public JTable getFactorCardinality() {
        return factorCardinality;
    }

    public JPanel getFactorCardinalityPanel() {
        return factorCardinalityPanel;
    }

    public JScrollPane getFactorCardinalityScrollPane() {
        return factorCardinalityScrollPane;
    }

    public JComboBox getFieldSensitivityAnalysisSelect() {
        return fieldSensitivityAnalysisSelect;
    }

    public JButton getRemoveExportButton() {
        return removeExportButton;
    }

    public JList getSelectedSensitivityExports() {
        return selectedSensitivityExports;
    }

    public JTable getSimulSensitivityAnalysisParam() {
        return simulSensitivityAnalysisParam;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFactorCardinalityPanel() {
        if (!allComponentsCreated) {
            return;
        }
        factorCardinalityPanel.add($JLabel1, "factorCardinalitySupported");
        factorCardinalityPanel.add(factorCardinalityScrollPane, "factorCardinalityNotSupported");
    }

    protected void addChildrenToFactorCardinalityScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        factorCardinalityScrollPane.getViewport().add(factorCardinality);
    }

    protected void createAddExportButton() {
        $objectMap.put("addExportButton", addExportButton = new JButton());
        
        addExportButton.setName("addExportButton");
        addExportButton.setEnabled(false);
        addExportButton.setText(t("isisfish.common.add"));
        addExportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addExportButton"));
    }

    protected void createAvailableSensitivityExports() {
        $objectMap.put("availableSensitivityExports", availableSensitivityExports = new JList());
        
        availableSensitivityExports.setName("availableSensitivityExports");
        availableSensitivityExports.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__availableSensitivityExports"));
    }

    protected void createClearExportsButton() {
        $objectMap.put("clearExportsButton", clearExportsButton = new JButton());
        
        clearExportsButton.setName("clearExportsButton");
        clearExportsButton.setEnabled(false);
        clearExportsButton.setText(t("isisfish.common.clear"));
        clearExportsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearExportsButton"));
    }

    protected void createExportParamsTable() {
        $objectMap.put("exportParamsTable", exportParamsTable = new JTable());
        
        exportParamsTable.setName("exportParamsTable");
        exportParamsTable.setRowHeight(24);
    }

    protected void createFactorCardinality() {
        $objectMap.put("factorCardinality", factorCardinality = new JTable());
        
        factorCardinality.setName("factorCardinality");
        factorCardinality.setRowHeight(24);
    }

    protected void createFactorCardinalityPanel() {
        $objectMap.put("factorCardinalityPanel", factorCardinalityPanel = new JPanel());
        
        factorCardinalityPanel.setName("factorCardinalityPanel");
        factorCardinalityPanel.setLayout(new CardLayout());
    }

    protected void createFactorCardinalityScrollPane() {
        $objectMap.put("factorCardinalityScrollPane", factorCardinalityScrollPane = new JScrollPane());
        
        factorCardinalityScrollPane.setName("factorCardinalityScrollPane");
    }

    protected void createFieldSensitivityAnalysisSelect() {
        $objectMap.put("fieldSensitivityAnalysisSelect", fieldSensitivityAnalysisSelect = new JComboBox());
        
        fieldSensitivityAnalysisSelect.setName("fieldSensitivityAnalysisSelect");
        fieldSensitivityAnalysisSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSensitivityAnalysisSelect"));
    }

    protected void createRemoveExportButton() {
        $objectMap.put("removeExportButton", removeExportButton = new JButton());
        
        removeExportButton.setName("removeExportButton");
        removeExportButton.setEnabled(false);
        removeExportButton.setText(t("isisfish.common.remove"));
        removeExportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeExportButton"));
    }

    protected void createSelectedSensitivityExports() {
        $objectMap.put("selectedSensitivityExports", selectedSensitivityExports = new JList());
        
        selectedSensitivityExports.setName("selectedSensitivityExports");
        selectedSensitivityExports.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedSensitivityExports"));
    }

    protected void createSimulSensitivityAnalysisParam() {
        $objectMap.put("simulSensitivityAnalysisParam", simulSensitivityAnalysisParam = new JTable());
        
        simulSensitivityAnalysisParam.setName("simulSensitivityAnalysisParam");
        simulSensitivityAnalysisParam.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldSensitivityAnalysisSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(factorCardinalityPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane3, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(simulSensitivityAnalysisParam);
        addChildrenToFactorCardinalityPanel();
        addChildrenToFactorCardinalityScrollPane();
        // inline complete setup of $Table1
        $Table1.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Table2, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(availableSensitivityExports);
        // inline complete setup of $Table2
        $Table2.add(addExportButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(removeExportButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(clearExportsButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectedSensitivityExports);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(exportParamsTable);
        
        // apply 9 property setters
        fieldSensitivityAnalysisSelect.setModel(getSensitivityAnalysisModel());
        fieldSensitivityAnalysisSelect.setRenderer(new SensitivityAnalysisComboRenderer());
        $JLabel1.setBorder(BorderFactory.createEtchedBorder());
        factorCardinality.setModel(new FactorCardinalityTableModel());
        availableSensitivityExports.setCellRenderer(new SensitivityExportNameListRenderer());
        availableSensitivityExports.setModel(getAvailableExportListModel());
        availableSensitivityExports.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedSensitivityExports.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.sensitivity.select"));
        createFieldSensitivityAnalysisSelect();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSimulSensitivityAnalysisParam();
        createFactorCardinalityPanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        if ($JLabel1.getFont() != null) {
            $JLabel1.setFont($JLabel1.getFont().deriveFont($JLabel1.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel1.setHorizontalAlignment(0);
        $JLabel1.setText(t("isisfish.sensitivity.methodfactorsupported"));
        createFactorCardinalityScrollPane();
        createFactorCardinality();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.sensitivity.export"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createAvailableSensitivityExports();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createAddExportButton();
        createRemoveExportButton();
        createClearExportsButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectedSensitivityExports();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createExportParamsTable();
        // inline creation of $Table0
        setName("$Table0");
        
        sensitivityAnalysisListener = new StorageChangeListener() {
              @Override
              public void versionDataChanged(StorageChangeEvent e) {
                fieldSensitivityAnalysisSelect.setModel(getSensitivityAnalysisModel());
              }
            };SensitivityAnalysisStorage.addStorageChangeListener(sensitivityAnalysisListener);sensitivityExportListener = new StorageChangeListener() {
              @Override
              public void versionDataChanged(StorageChangeEvent e) {
                availableSensitivityExports.setModel(getAvailableExportListModel());
              }
            };SensitivityExportStorage.addStorageChangeListener(sensitivityExportListener);$completeSetup();
    }

}