/*
 * #%L
 * $Id: SumByYearMatrixFilter.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.0/src/main/java/fr/ifremer/isisfish/ui/result/SumByYearMatrixFilter.java $
 * %%
 * Copyright (C) 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n.t;

import java.util.ArrayList;
import java.util.List;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixFilter;

/**
 * Filtre qui change le nom des semantiques dans le cas d'une somme
 * par années.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class SumByYearMatrixFilter implements MatrixFilter {

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixFilter#filter(org.nuiton.math.matrix.MatrixND)
     */
    @Override
    public MatrixND filter(MatrixND matrix) {
        return matrix;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixFilter#filterDimension(org.nuiton.math.matrix.MatrixND, int, int)
     */
    @Override
    public MatrixND filterDimension(MatrixND matrix, int dim, int sumStep) {
        
        if (dim == 0) { // in isis 0 = time step
            int semCount = matrix.getSemantic(0).size();
            List<String> newSems = new ArrayList<String>(semCount);
            for (int i = 0; i < semCount ; i++) {
                newSems.add(t("isisfish.result.matrix.sumbyyearlabel", i));
            }
            matrix.setSemantic(0, newSems);
        }
        return matrix;
    }
}
