package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.model.TripTypeListModel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class VesselTypeUI extends InputContentUI<VesselType> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_ACTIVITY_RANGE_ENABLED = "fieldVesselTypeActivityRange.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_ACTIVITY_RANGE_TEXT = "fieldVesselTypeActivityRange.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_COMMENT_ENABLED = "fieldVesselTypeComment.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_COMMENT_TEXT = "fieldVesselTypeComment.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_LENGTH_ENABLED = "fieldVesselTypeLength.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_LENGTH_TEXT = "fieldVesselTypeLength.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_MAX_TRIP_DURATION_ENABLED = "fieldVesselTypeMaxTripDuration.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_MAX_TRIP_DURATION_TEXT = "fieldVesselTypeMaxTripDuration.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_MIN_CREW_SIZE_ENABLED = "fieldVesselTypeMinCrewSize.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_MIN_CREW_SIZE_TEXT = "fieldVesselTypeMinCrewSize.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_NAME_ENABLED = "fieldVesselTypeName.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_NAME_TEXT = "fieldVesselTypeName.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_SPEED_ENABLED = "fieldVesselTypeSpeed.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_SPEED_TEXT = "fieldVesselTypeSpeed.text";
    public static final String BINDING_FIELD_VESSEL_TYPE_UNIT_FUEL_COST_OF_TRAVEL_ENABLED = "fieldVesselTypeUnitFuelCostOfTravel.enabled";
    public static final String BINDING_FIELD_VESSEL_TYPE_UNIT_FUEL_COST_OF_TRAVEL_TEXT = "fieldVesselTypeUnitFuelCostOfTravel.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VESSEL_TYPE_TRIP_TYPE_ENABLED = "vesselTypeTripType.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";
    private static final String BINDING_$JLABEL6_ENABLED = "$JLabel6.enabled";
    private static final String BINDING_$JLABEL7_ENABLED = "$JLabel7.enabled";
    private static final String BINDING_$JLABEL8_ENABLED = "$JLabel8.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWTW8bRRjHJyYvTdNCSUgaaGhTElRVVdd9oRRIVJq6BGIcArFTKixext7H8VTr3WVm1nE4ID4CHwHuXJC4cUIcOPfABfEVEOqhV8Qz67fsZjseaXLYTeZ5nt/8578z8+Snf8iE4OTiI9rpODzyJWuBU9x4+HCn9gjq8j6IOmehDDjp/ozlSK5KZtzBuJBkpVpS5fleeb4QtMLAB/9I9VqJnBTy0APRBJCSvJqsqAuRLw/Ca50w4n3qQFQW9Ycn/+a+d7/7MUdIJ0R1F3Apy6OqhisZL5EccyWZxZnaNO9Rfx9lcObvo97TaqzgUSE+oi34mnxLpkpkMqQcYZK8Zr7kmBHXd0JJzqxu+WEkC4EvMX1v65oklxvcYQ0OLcC3YKLBRNOJmMNUovMAhACvchjC3lYYxqBJScZrQH1JLmWVIpdJBuJI6bBwuk095lIUKMmVhFWDgCMO0AKnrJ4P+oNHpw7cQzRN+dPp5RY/pj54w5yp1QqteYCLW0zM0c2OYypzNl1wXf15Vj3mB6ETq8USrYF3LT1nPKqSFge5cw0Gnjtct/p0kiwkyirQkZsqLVnanyaWsJSMzaewJfD3ZVMFL2RDbmRAXkpByiGAq2HczGCcTzG2aaeC2+1+xKlkga+hvZFBW0rRNuqStZk83MWDABrWrQzWK2llzC9wOCizb3SkNzNIKynSns/kZgReIRByp1HhtN396s9A3s5Anl4tlus88Dy1TXEfnU1siGEoWTXbHmhQJqu3JC8mtyATUmW/c0zGW6NkxPtsPZmwkFo6Xiut+LqZP7aDNzhQVXUvfYRuZByhcYGm4elIUO5FUna3zPuDxMk69etdez9MR3BCCVkRFzxIRjg5lzj2eL87w/t9eAGPVckEj3AY74nq8Zawi6FuM1hMNQMFjKP/Lcz9+evfv2z2O8BVnHs+M/VIA8ObOeRBCFzdkpK80L3+I8m8/DYN16pkGv3H7hd3t6UMYeVeGMXhfPGWcFS58wEVTURMTP312+8LXz1+juQ2yUkvoO4mVflbZFo2OboQeG4nfPdurOjUwQl8nlHa8COCrz4iNqXn1/Hepcs15rv4ue500IWlDBcGUmrTfzydK/98t+/EGCp7+ZnpQzcmPiOTzPeYD3E37DW6zO43EwqI3GDY0LJa3Jh6nwt7veDT+FnNWuq4xG2Mp2y9O/syldh6a5EEXKsq+jJehPqNGjLV8Ofq8UU24bwRAawJOg0XzTU0bAg6DSvWPpgRdBpet/bBjKDTcMnaBzOCTsNlax/MCDoNVwxO64wMAq+CXRAPrUbMaNQoS80IuuVctbbUjKDTkLf2wYyg03Dd2gczgk7DTWsfzAg6DbesfTAj6DTctvbBjKDT8La1D6MJkpzC/x+9XfBd4MA1au5Yr8eesGHtiBlBp+E9651hRtBpKFr7YEbQadi21mBG0GnYsdZgRtBp+MRagyL8D1Guc5PYEwAA";
    private static final Log log = LogFactory.getLog(VesselTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected VesselType bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextField fieldVesselTypeActivityRange;
    protected JTextArea fieldVesselTypeComment;
    protected JTextField fieldVesselTypeLength;
    protected JTextField fieldVesselTypeMaxTripDuration;
    protected JTextField fieldVesselTypeMinCrewSize;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldVesselTypeName")
    protected JTextField fieldVesselTypeName;
    protected JTextField fieldVesselTypeSpeed;
    protected JTextField fieldVesselTypeUnitFuelCostOfTravel;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<VesselType> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JList vesselTypeTripType;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VesselTypeUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected boolean init;
    
    
    protected void $afterCompleteSetup() {
        setButtonTitle(t("isisfish.input.continueSetOfVessels"));
        setNextPath(n("isisfish.input.tree.setofvessels"));
    
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldVesselTypeName.setText("");
                    fieldVesselTypeLength.setText("");
                    fieldVesselTypeSpeed.setText("");
                    fieldVesselTypeMaxTripDuration.setText("");
                    fieldVesselTypeActivityRange.setText("");
                    fieldVesselTypeMinCrewSize.setText("");
                    fieldVesselTypeSpeed.setText("");
                    fieldVesselTypeUnitFuelCostOfTravel.setText("");
                    fieldVesselTypeComment.setText("");
                }
                if (evt.getNewValue() != null) {
                    setTripTypeListModel();
                }
            }
        });
    }
    
    /*public void refresh() {
        VesselType vesselType = getSaveVerifier().getEntity(VesselType.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(vesselType);
    
        if (getBean() != null) {
            setListModel();
            
            // NumberEditor is not working
            //fieldVesselTypeLength.init();
            //fieldVesselTypeLength.init();
            //fieldVesselTypeSpeed.init();
            //fieldVesselTypeActivityRange.init();
            //fieldVesselTypeMinCrewSize.init();
            //fieldVesselTypeSpeed.init();
            //fieldVesselTypeUnitFuelCostOfTravel.init();
        }
    }*/
    
    protected void setTripTypeListModel() {
        init = true;
        List<TripType> tripTypes = getFisheryRegion().getTripType();
        TripTypeListModel tripTypeModel = new TripTypeListModel(tripTypes);
        vesselTypeTripType.setModel(tripTypeModel);
        
        if (getBean() != null && getBean().getTripType() != null) {
            for (TripType tripType : getBean().getTripType()) {
                int index = tripTypes.indexOf(tripType);
                vesselTypeTripType.addSelectionInterval(index, index);
            }
        }
        init = false;
    }
    protected void tripTypeChanged() {
        if (!init) {
            java.util.List<TripType> tripTypes = new java.util.ArrayList<TripType>();
            for (Object o : vesselTypeTripType.getSelectedValues()) {
                tripTypes.add((TripType)o);
            }
            getBean().setTripType(tripTypes);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VesselTypeUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VesselTypeUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VesselTypeUI() {
        $initialize();
    }

    public VesselTypeUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public VesselTypeUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public VesselTypeUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VesselTypeUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public VesselTypeUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(VesselType.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldVesselTypeActivityRange(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setActivityRange(Double.parseDouble(fieldVesselTypeActivityRange.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldVesselTypeComment.getText());
    }

    public void doKeyReleased__on__fieldVesselTypeLength(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setLength(Integer.parseInt(fieldVesselTypeLength.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeMaxTripDuration(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMaxTripDuration(new TimeUnit(Double.parseDouble(fieldVesselTypeMaxTripDuration.getText()) * 3600));
    }

    public void doKeyReleased__on__fieldVesselTypeMinCrewSize(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMinCrewSize(Integer.parseInt(fieldVesselTypeMinCrewSize.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldVesselTypeName.getText());
    }

    public void doKeyReleased__on__fieldVesselTypeSpeed(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setSpeed(Double.parseDouble(fieldVesselTypeSpeed.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeUnitFuelCostOfTravel(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setUnitFuelCostOfTravel(Double.parseDouble(fieldVesselTypeUnitFuelCostOfTravel.getText()));
    }

    public void doValueChanged__on__vesselTypeTripType(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        tripTypeChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public VesselType getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextField getFieldVesselTypeActivityRange() {
        return fieldVesselTypeActivityRange;
    }

    public JTextArea getFieldVesselTypeComment() {
        return fieldVesselTypeComment;
    }

    public JTextField getFieldVesselTypeLength() {
        return fieldVesselTypeLength;
    }

    public JTextField getFieldVesselTypeMaxTripDuration() {
        return fieldVesselTypeMaxTripDuration;
    }

    public JTextField getFieldVesselTypeMinCrewSize() {
        return fieldVesselTypeMinCrewSize;
    }

    public JTextField getFieldVesselTypeName() {
        return fieldVesselTypeName;
    }

    public JTextField getFieldVesselTypeSpeed() {
        return fieldVesselTypeSpeed;
    }

    public JTextField getFieldVesselTypeUnitFuelCostOfTravel() {
        return fieldVesselTypeUnitFuelCostOfTravel;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<VesselType> getValidator() {
        return validator;
    }

    public JList getVesselTypeTripType() {
        return vesselTypeTripType;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(VesselType bean) {
        VesselType oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldVesselTypeActivityRange() {
        $objectMap.put("fieldVesselTypeActivityRange", fieldVesselTypeActivityRange = new JTextField());
        
        fieldVesselTypeActivityRange.setName("fieldVesselTypeActivityRange");
        fieldVesselTypeActivityRange.setColumns(15);
        fieldVesselTypeActivityRange.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeActivityRange"));
        fieldVesselTypeActivityRange.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeActivityRange.putClientProperty("sensitivityMethod", "ActivityRange");
    }

    protected void createFieldVesselTypeComment() {
        $objectMap.put("fieldVesselTypeComment", fieldVesselTypeComment = new JTextArea());
        
        fieldVesselTypeComment.setName("fieldVesselTypeComment");
        fieldVesselTypeComment.setColumns(15);
        fieldVesselTypeComment.setLineWrap(true);
        fieldVesselTypeComment.setWrapStyleWord(true);
        fieldVesselTypeComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeComment"));
    }

    protected void createFieldVesselTypeLength() {
        $objectMap.put("fieldVesselTypeLength", fieldVesselTypeLength = new JTextField());
        
        fieldVesselTypeLength.setName("fieldVesselTypeLength");
        fieldVesselTypeLength.setColumns(15);
        fieldVesselTypeLength.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeLength"));
        fieldVesselTypeLength.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeLength.putClientProperty("sensitivityMethod", "Length");
    }

    protected void createFieldVesselTypeMaxTripDuration() {
        $objectMap.put("fieldVesselTypeMaxTripDuration", fieldVesselTypeMaxTripDuration = new JTextField());
        
        fieldVesselTypeMaxTripDuration.setName("fieldVesselTypeMaxTripDuration");
        fieldVesselTypeMaxTripDuration.setColumns(15);
        fieldVesselTypeMaxTripDuration.setToolTipText(t("isisfish.common.duration.inhours"));
        fieldVesselTypeMaxTripDuration.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeMaxTripDuration"));
        fieldVesselTypeMaxTripDuration.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeMaxTripDuration.putClientProperty("sensitivityMethod", "MaxTripDuration");
    }

    protected void createFieldVesselTypeMinCrewSize() {
        $objectMap.put("fieldVesselTypeMinCrewSize", fieldVesselTypeMinCrewSize = new JTextField());
        
        fieldVesselTypeMinCrewSize.setName("fieldVesselTypeMinCrewSize");
        fieldVesselTypeMinCrewSize.setColumns(15);
        fieldVesselTypeMinCrewSize.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeMinCrewSize"));
        fieldVesselTypeMinCrewSize.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeMinCrewSize.putClientProperty("sensitivityMethod", "MinCrewSize");
    }

    protected void createFieldVesselTypeName() {
        $objectMap.put("fieldVesselTypeName", fieldVesselTypeName = new JTextField());
        
        fieldVesselTypeName.setName("fieldVesselTypeName");
        fieldVesselTypeName.setColumns(15);
        fieldVesselTypeName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeName"));
    }

    protected void createFieldVesselTypeSpeed() {
        $objectMap.put("fieldVesselTypeSpeed", fieldVesselTypeSpeed = new JTextField());
        
        fieldVesselTypeSpeed.setName("fieldVesselTypeSpeed");
        fieldVesselTypeSpeed.setColumns(15);
        fieldVesselTypeSpeed.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeSpeed"));
        fieldVesselTypeSpeed.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeSpeed.putClientProperty("sensitivityMethod", "Speed");
    }

    protected void createFieldVesselTypeUnitFuelCostOfTravel() {
        $objectMap.put("fieldVesselTypeUnitFuelCostOfTravel", fieldVesselTypeUnitFuelCostOfTravel = new JTextField());
        
        fieldVesselTypeUnitFuelCostOfTravel.setName("fieldVesselTypeUnitFuelCostOfTravel");
        fieldVesselTypeUnitFuelCostOfTravel.setColumns(15);
        fieldVesselTypeUnitFuelCostOfTravel.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldVesselTypeUnitFuelCostOfTravel"));
        fieldVesselTypeUnitFuelCostOfTravel.putClientProperty("sensitivityBean", VesselType.class);
        fieldVesselTypeUnitFuelCostOfTravel.putClientProperty("sensitivityMethod", "UnitFuelCostOfTravel");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(VesselType.class, null));
    }

    protected void createVesselTypeTripType() {
        $objectMap.put("vesselTypeTripType", vesselTypeTripType = new JList());
        
        vesselTypeTripType.setName("vesselTypeTripType");
        vesselTypeTripType.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__vesselTypeTripType"));
        vesselTypeTripType.putClientProperty("sensitivityBean", VesselType.class);
        vesselTypeTripType.putClientProperty("sensitivityMethod", "TripType");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeName)), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeLength), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeSpeed), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeMaxTripDuration), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeActivityRange), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeMinCrewSize), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeUnitFuelCostOfTravel), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(vesselTypeTripType));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldVesselTypeComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 31 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        vesselTypeTripType.setCellRenderer(new fr.ifremer.isisfish.ui.input.renderer.TripTypeListRenderer());
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.vesselType.name"));
        createFieldVesselTypeName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.vesselType.length"));
        createFieldVesselTypeLength();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.vesselType.speed"));
        createFieldVesselTypeSpeed();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.vesselType.maxDuration"));
        createFieldVesselTypeMaxTripDuration();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.vesselType.activityRange"));
        createFieldVesselTypeActivityRange();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.vesselType.miniCrew"));
        createFieldVesselTypeMinCrewSize();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("isisfish.vesselType.fuelCost"));
        createFieldVesselTypeUnitFuelCostOfTravel();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("isisfish.common.tripType"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVesselTypeTripType();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("isisfish.vesselType.comments"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldVesselTypeComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 31 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 31 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_LENGTH_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeLength.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_LENGTH_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeLength, String.valueOf(getBean().getLength()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_SPEED_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeSpeed.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_SPEED_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeSpeed, String.valueOf(getBean().getSpeed()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_MAX_TRIP_DURATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeMaxTripDuration.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_MAX_TRIP_DURATION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getMaxTripDuration() != null) {
                    SwingUtil.setText(fieldVesselTypeMaxTripDuration, String.valueOf(getBean().getMaxTripDuration().getHour()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_ACTIVITY_RANGE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeActivityRange.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_ACTIVITY_RANGE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeActivityRange, String.valueOf(getBean().getActivityRange()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_MIN_CREW_SIZE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeMinCrewSize.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_MIN_CREW_SIZE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeMinCrewSize, String.valueOf(getBean().getMinCrewSize()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL6_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel6.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_UNIT_FUEL_COST_OF_TRAVEL_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeUnitFuelCostOfTravel.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_UNIT_FUEL_COST_OF_TRAVEL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeUnitFuelCostOfTravel, String.valueOf(getBean().getUnitFuelCostOfTravel()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VESSEL_TYPE_TRIP_TYPE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                vesselTypeTripType.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL8_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel8.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldVesselTypeComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_VESSEL_TYPE_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldVesselTypeComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}