package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.ui.input.model.PortComboModel;
import fr.ifremer.isisfish.ui.input.model.VesselTypeComboModel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SetOfVesselsBasicsUI extends InputContentUI<SetOfVessels> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_COMMENT_ENABLED = "fieldSetOfVesselsComment.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_COMMENT_TEXT = "fieldSetOfVesselsComment.text";
    public static final String BINDING_FIELD_SET_OF_VESSELS_FIXED_COSTS_ENABLED = "fieldSetOfVesselsFixedCosts.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_FIXED_COSTS_TEXT = "fieldSetOfVesselsFixedCosts.text";
    public static final String BINDING_FIELD_SET_OF_VESSELS_NAME_ENABLED = "fieldSetOfVesselsName.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_NAME_TEXT = "fieldSetOfVesselsName.text";
    public static final String BINDING_FIELD_SET_OF_VESSELS_NUMBER_OF_VESSELS_ENABLED = "fieldSetOfVesselsNumberOfVessels.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_NUMBER_OF_VESSELS_TEXT = "fieldSetOfVesselsNumberOfVessels.text";
    public static final String BINDING_FIELD_SET_OF_VESSELS_PORT_ENABLED = "fieldSetOfVesselsPort.enabled";
    public static final String BINDING_FIELD_SET_OF_VESSELS_VESSEL_TYPE_ENABLED = "fieldSetOfVesselsVesselType.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TECHNICAL_EFFICIENCY_ACTIVE = "technicalEfficiency.active";
    public static final String BINDING_TECHNICAL_EFFICIENCY_BEAN = "technicalEfficiency.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28bRRTHJyZOmv6gBSshNAXSYhVVFeumpRIohbYxMTgyJMJJKFggZnfH8VTj2e3MbLrJAfEn8CfAnQsSN06IA2cOXBD/AkIcuCLe7Nq7WXvYrLQ5rO2Z9z7zfW/evpfv/kRVKdDVxzgMLRFwRYfE2nr46NG2/Zg46l0iHUF95QkU/81UUKWHzrnJulTo1V5HuzdG7o2mN/Q9TvgJ7/UOOivVESNyQIhS6KWshyNlo5tsr4d+IMbURJSJ+s3ff1W+dr/6toJQ6IO6yxDK6mleaSSzHVShrkLPw0mHuMEwPwAZgvID0HtBrzUZlvJDPCRP0JdovoPmfCwAptC14iFHjMg/9BW6VG9zP1BNjysw32vfUmitLyzaF2RI4FNS2adyYAXUotrQ6hK13d8nUhImN7Ckjtxr+34EnFNo1iaYK3TDhAA+VZTIDCJ1XTjEjLoYpCp0M5O0ZMOSTyEZVlc/98eLKaFW70bBtjmcA9vHREA41yOWAxmhDOTE+bCmLE/G4LlHcAs64eHoyK0dzAlLbebru9hmBPDLGamxdbSnLRcnHdb0z8v6sZxsnalvdbBN2K3JM6NVbbSS2C72KWHuyQTqalBoKeO4S0LV0oZZ5/FBkYhXTgPvwEXAegYMdWV7G15o5t42cFemuPHH7pEfZeg1M+qOAbU6HXswtIlIfmq7a2beG4WktWhI3KYnlQlVU8QZcOpgttnvU4cS7kCVNHJflujd2uZk80mAFfX4Xtss765B3oX6FhSpx5guPaiNFzI3kW5lvZangoI7G0Y9YnGqRh4KgrXfW5NlettQprMSH0Kl1TKUjUApj2uL+4nhnIO5Exduc3IHDlTEtOMSRrI7Aq1kXi1oylbalNOuOdNDVRHAMgTfm+7jH8FW3MGXJzq4Bka7/y7Vfvvxjx9a47Zdh7MXjaYnpg60U194PhG6pSl0Me7ZgaKs8QH213toAZIPIysaSVcMwrqjbRAH5z2n3S3tbr2P5QAQ1fnff/p56Ytfn0GVFjrLPOy2sLZvowU1EJAFj7mhf/9BpOj80zPwvKS1wSUSri8RJsmz96BF4lWbcheu650QsnDFkIVEir3wyz+17vcPxpmYAWUv/q95mo3qp2iOckY5iUbYaDoZR9Y5X5LA9dIpZJpLM/rzZX/Ub7ejZ9cU6qyCMoa+eS8+fRUrmJd2oAjEqp0+joLQ3z4pyNTLe/qxbyZcLUT4rDQhT0O9uIbPyxDyNFwvTbhROopihDwNN0sTXi8dRTFCnoZG6ZosRsjTsFY6D8UIeRrulM7D6QSYVdCG6SHJodwt0rn0f8olGec1YyeeQkc5mS3CqjoMHx+XFHSx74khzMkmTPkDT5TTdFq9FCPk1cubpTUUI+RpeLt0zRYj5GnYKJ2HYoQ8DZulNRQj5Gl4r7SGYoQ8De3SGjThP/VwqGJIEQAA";
    private static final Log log = LogFactory.getLog(SetOfVesselsBasicsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldSetOfVesselsComment;
    protected JTextField fieldSetOfVesselsFixedCosts;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldSetOfVesselsName")
    protected JTextField fieldSetOfVesselsName;
    protected JTextField fieldSetOfVesselsNumberOfVessels;
    protected JComboBox fieldSetOfVesselsPort;
    protected JComboBox fieldSetOfVesselsVesselType;
    protected JButton save;
    protected InputOneEquationUI technicalEfficiency;
    @Validator( validatorId = "validator")
    protected SwingValidator<SetOfVessels> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SetOfVesselsBasicsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    
                }
                if (evt.getNewValue() != null) {
                    init = true;
    
                    PortComboModel modelPort = new PortComboModel(getFisheryRegion().getPort());
                    fieldSetOfVesselsPort.setModel(modelPort);
                    fieldSetOfVesselsPort.setSelectedItem(getBean().getPort());
    
                    VesselTypeComboModel modelVessel = new VesselTypeComboModel(getFisheryRegion().getVesselType());
                    fieldSetOfVesselsVesselType.setModel(modelVessel);
                    fieldSetOfVesselsVesselType.setSelectedItem(getBean().getVesselType());
    
                    init=false;
                }
            }
        });
    }
    
    /*public void refresh() {
        SetOfVessels setOfVessels = (SetOfVessels)getSaveVerifier().getEntity(SetOfVessels.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(setOfVessels);
    
        if (getBean() != null) {
            init = true;
            jaxx.runtime.SwingUtil.fillComboBox(fieldSetOfVesselsPort,getFisheryRegion().getPort(), getBean().getPort(), true);
            jaxx.runtime.SwingUtil.fillComboBox(fieldSetOfVesselsVesselType,getFisheryRegion().getVesselType(), getBean().getVesselType(), true);
            init=false;
            getSaveVerifier().addCurrentPanel(technicalEfficiency);
            
            // NumberEditor is not working
            //fieldSetOfVesselsNumberOfVessels.init();
            //fieldSetOfVesselsFixedCosts.init();
        }
    }*/
    
    protected void portChanged() {
        if (!init) {
            getBean().setPort((Port)fieldSetOfVesselsPort.getSelectedItem());
        }
    }
    protected void vesselTypeChanged() {
        if (!init) {
            getBean().setVesselType((VesselType)fieldSetOfVesselsVesselType.getSelectedItem());
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVesselsBasicsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsBasicsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SetOfVesselsBasicsUI() {
        $initialize();
    }

    public SetOfVesselsBasicsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsBasicsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsBasicsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsBasicsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsBasicsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(SetOfVessels.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doItemStateChanged__on__fieldSetOfVesselsPort(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        portChanged();
    }

    public void doItemStateChanged__on__fieldSetOfVesselsVesselType(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        vesselTypeChanged();
    }

    public void doKeyReleased__on__fieldSetOfVesselsComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldSetOfVesselsComment.getText());
    }

    public void doKeyReleased__on__fieldSetOfVesselsFixedCosts(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setFixedCosts(Double.parseDouble(fieldSetOfVesselsFixedCosts.getText()));
    }

    public void doKeyReleased__on__fieldSetOfVesselsName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldSetOfVesselsName.getText());
    }

    public void doKeyReleased__on__fieldSetOfVesselsNumberOfVessels(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setNumberOfVessels(Integer.parseInt(fieldSetOfVesselsNumberOfVessels.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldSetOfVesselsComment() {
        return fieldSetOfVesselsComment;
    }

    public JTextField getFieldSetOfVesselsFixedCosts() {
        return fieldSetOfVesselsFixedCosts;
    }

    public JTextField getFieldSetOfVesselsName() {
        return fieldSetOfVesselsName;
    }

    public JTextField getFieldSetOfVesselsNumberOfVessels() {
        return fieldSetOfVesselsNumberOfVessels;
    }

    public JComboBox getFieldSetOfVesselsPort() {
        return fieldSetOfVesselsPort;
    }

    public JComboBox getFieldSetOfVesselsVesselType() {
        return fieldSetOfVesselsVesselType;
    }

    public JButton getSave() {
        return save;
    }

    public InputOneEquationUI getTechnicalEfficiency() {
        return technicalEfficiency;
    }

    public SwingValidator<SetOfVessels> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldSetOfVesselsComment() {
        $objectMap.put("fieldSetOfVesselsComment", fieldSetOfVesselsComment = new JTextArea());
        
        fieldSetOfVesselsComment.setName("fieldSetOfVesselsComment");
        fieldSetOfVesselsComment.setColumns(15);
        fieldSetOfVesselsComment.setLineWrap(true);
        fieldSetOfVesselsComment.setWrapStyleWord(true);
        fieldSetOfVesselsComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSetOfVesselsComment"));
    }

    protected void createFieldSetOfVesselsFixedCosts() {
        $objectMap.put("fieldSetOfVesselsFixedCosts", fieldSetOfVesselsFixedCosts = new JTextField());
        
        fieldSetOfVesselsFixedCosts.setName("fieldSetOfVesselsFixedCosts");
        fieldSetOfVesselsFixedCosts.setColumns(15);
        fieldSetOfVesselsFixedCosts.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSetOfVesselsFixedCosts"));
        fieldSetOfVesselsFixedCosts.putClientProperty("sensitivityBean", SetOfVessels.class);
        fieldSetOfVesselsFixedCosts.putClientProperty("sensitivityMethod", "FixedCosts");
    }

    protected void createFieldSetOfVesselsName() {
        $objectMap.put("fieldSetOfVesselsName", fieldSetOfVesselsName = new JTextField());
        
        fieldSetOfVesselsName.setName("fieldSetOfVesselsName");
        fieldSetOfVesselsName.setColumns(15);
        fieldSetOfVesselsName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSetOfVesselsName"));
    }

    protected void createFieldSetOfVesselsNumberOfVessels() {
        $objectMap.put("fieldSetOfVesselsNumberOfVessels", fieldSetOfVesselsNumberOfVessels = new JTextField());
        
        fieldSetOfVesselsNumberOfVessels.setName("fieldSetOfVesselsNumberOfVessels");
        fieldSetOfVesselsNumberOfVessels.setColumns(15);
        fieldSetOfVesselsNumberOfVessels.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSetOfVesselsNumberOfVessels"));
        fieldSetOfVesselsNumberOfVessels.putClientProperty("sensitivityBean", SetOfVessels.class);
        fieldSetOfVesselsNumberOfVessels.putClientProperty("sensitivityMethod", "NumberOfVessels");
    }

    protected void createFieldSetOfVesselsPort() {
        $objectMap.put("fieldSetOfVesselsPort", fieldSetOfVesselsPort = new JComboBox());
        
        fieldSetOfVesselsPort.setName("fieldSetOfVesselsPort");
        fieldSetOfVesselsPort.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSetOfVesselsPort"));
    }

    protected void createFieldSetOfVesselsVesselType() {
        $objectMap.put("fieldSetOfVesselsVesselType", fieldSetOfVesselsVesselType = new JComboBox());
        
        fieldSetOfVesselsVesselType.setName("fieldSetOfVesselsVesselType");
        fieldSetOfVesselsVesselType.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSetOfVesselsVesselType"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createTechnicalEfficiency() {
        $objectMap.put("technicalEfficiency", technicalEfficiency = new InputOneEquationUI(this));
        
        technicalEfficiency.setName("technicalEfficiency");
        technicalEfficiency.setBeanProperty("TechnicalEfficiencyEquation");
        technicalEfficiency.setFormuleCategory("TechnicalEfficiency");
        technicalEfficiency.setText(t("isisfish.setOfVessels.technicalEfficiency"));
        technicalEfficiency.putClientProperty("sensitivityBean", SetOfVessels.class);
        technicalEfficiency.putClientProperty("sensitivityMethod", "TechnicalEfficiencyEquation");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SetOfVessels.class, "basics"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsName)), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsPort), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsVesselType), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsNumberOfVessels), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsFixedCosts), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(technicalEfficiency), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldSetOfVesselsComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        technicalEfficiency.setClazz(fr.ifremer.isisfish.equation.SoVTechnicalEfficiencyEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        init = false;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.setOfVessels.name"));
        createFieldSetOfVesselsName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.common.port"));
        createFieldSetOfVesselsPort();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.setOfVessels.vesselType"));
        createFieldSetOfVesselsVesselType();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.setOfVessels.numberOfVessels"));
        createFieldSetOfVesselsNumberOfVessels();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.setOfVessels.fixedCosts"));
        createFieldSetOfVesselsFixedCosts();
        createTechnicalEfficiency();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.setOfVessels.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldSetOfVesselsComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSetOfVesselsName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_PORT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsPort.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_VESSEL_TYPE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsVesselType.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_NUMBER_OF_VESSELS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsNumberOfVessels.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_NUMBER_OF_VESSELS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSetOfVesselsNumberOfVessels, String.valueOf(getBean().getNumberOfVessels()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_FIXED_COSTS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsFixedCosts.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_FIXED_COSTS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSetOfVesselsFixedCosts, String.valueOf(getBean().getFixedCosts()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TECHNICAL_EFFICIENCY_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                technicalEfficiency.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TECHNICAL_EFFICIENCY_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                technicalEfficiency.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSetOfVesselsComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SET_OF_VESSELS_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSetOfVesselsComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}