package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class CellUI extends InputContentUI<Cell> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_CELL_MAP = "cellMap";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CELL_MAP_ENABLED = "cellMap.enabled";
    public static final String BINDING_CELL_MAP_FISHERY_REGION = "cellMap.fisheryRegion";
    public static final String BINDING_CELL_MAP_SELECTED_CELLS = "cellMap.selectedCells";
    public static final String BINDING_FIELD_CELL_COMMENT_ENABLED = "fieldCellComment.enabled";
    public static final String BINDING_FIELD_CELL_COMMENT_TEXT = "fieldCellComment.text";
    public static final String BINDING_FIELD_CELL_ENABLED = "fieldCell.enabled";
    public static final String BINDING_FIELD_CELL_LAND_ENABLED = "fieldCellLand.enabled";
    public static final String BINDING_FIELD_CELL_LAND_SELECTED = "fieldCellLand.selected";
    public static final String BINDING_FIELD_CELL_LATITUDE_ENABLED = "fieldCellLatitude.enabled";
    public static final String BINDING_FIELD_CELL_LATITUDE_TEXT = "fieldCellLatitude.text";
    public static final String BINDING_FIELD_CELL_LONGITUDE_ENABLED = "fieldCellLongitude.enabled";
    public static final String BINDING_FIELD_CELL_LONGITUDE_TEXT = "fieldCellLongitude.text";
    public static final String BINDING_FIELD_CELL_NAME_ENABLED = "fieldCellName.enabled";
    public static final String BINDING_FIELD_CELL_NAME_TEXT = "fieldCellName.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XzW8bRRSfuEncNA2ksZKmahFp61YVoHUoHwdSQr6IcOQWFCdVhC/M7o7tKeOZZXY23fSAOHPiT4A7FyRunBAHzhy4IP4FhDhwRX2za+96k83uiq0P/pj33m9+7zfz3lt//xeaciW6+QT7viE9ruiAGHubR0cfm0+IpXaIa0nqKCFR+JqooEoHzdrRuqvQ7U5LhzeG4Y1tMXAEJ3wseq2FLrnqhBG3T4hS6JVkhOW6jXZkXvMdT45QI1JpqN/+83flG/ur7yoI+Q6wW4ZUVvKi4kwmW6hCbYUWYKdj3GCY94CGpLwHfOf02jbDrvsID8gX6EtUbaFpB0sAU+hW8ZQDjCDedxSarze546ltwRW4HzZXQb+uNGhXkgGBT5e6Xer2DY8aVDsa24Sxw6bjBBDTCk2aBHOFbqYFASJVlLhBUBwyc4wZtTGQUuj1hDyRwXCfQtpGW78/Hi3GCLV6O0iryQEfzM+IBOJ3AywLcqcMaISZG2c8x7kL+wT01tL6wy33PsGcjJG9XN9rO4wqvQx7LCV8I4t2XoxiqvUDbDLtvpxIL4wKbNpzOVakSwmztUoKLSZ2gJM0xZbwteP1yP9ifa+FTcJWT5MPVpO+cxG2vjinMzggvtrVDukbvKl/307arkSALQzn69lBMnfTAe6nACzEAIL38hDeSkGYG6PA7TOa9Yn1+bmavZ2GB4dsScHY8JSvJk85MiWj5iMWcEqDoA4Xz4i7KQnW/u/Gt87Fx3AOtYTrlqeU4En8aQtzKzzO9aTlwgA7+uvV5DWqgjd7iJ1zahiCjCb8AI8tKFodtBnFzg5jm7wrFKpDFRmmyQ3hEB7EwbIcwHkLvkMY6el6HAJIdD1xy6F7GnH3jNvbRAdNSQ+WoSw6ZxvuPpjCVrt8qtVqwMD631Lt95/+/HF31F/vwN6Lqa5j4wH6niMhDak7kUIvh83VU5Q1IN21DppxISErnB03Uoi1h2YgB/td0eGGDjc+wm4fIKaqf/z8y9Jnv11AlV10iQls72Lt30Qzqi9BBcFs3/lgI2B0+elFeJ/X3ICLTY+pTWRLWIGyUBoPKGeUkxWsoPGbniLrPihyI0WRiJY58+u/tfYPGyNVJoDltXPdY2WmPkXT4W7B3BmOlNQ5M+u4xLNFPDrShsmE/rzmDFvno+B9Py3tBRhNB8Kz+h/6DpTvqB0e+p7+eBykoL8dFUacFZJC/QUiloSqEq4JQVN56QFMHbxiUm5Dia6nQ75aAHJqIOywjHv/F0QvdzMQbhWgMamgHWWok4+Rx+JOIQSvNEIWh3vFOZyjQz4CDBNiU5VzcV8rnUsxhCw9y3N4o7SexRC+zkAwSmdRDCFLyfIcVksrWQwhi8P9Inc7nIfELoWTx+SdAkxqfejrz2AuYrbJaI/rZ6wMefIh8wQuhpCV1nulL1oxhCwO75fWoRhCFoeN0hzyEeAJmeET4akMHlulM9kpwGNOP18TebJPesMnkDJgo/rT/yzcFwMGrB6K8G9WBthzHqFnfn4RAAA=";
    private static final Log log = LogFactory.getLog(CellUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Cell bean;
    protected JButton cancel;
    protected IsisMapBean cellMap;
    protected InformationDelegator cellMapInfo;
    protected JComboBox fieldCell;
    protected JTextArea fieldCellComment;
    protected JCheckBox fieldCellLand;
    protected JTextField fieldCellLatitude;
    protected JTextField fieldCellLongitude;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldCellName")
    protected JTextField fieldCellName;
    protected JPanel map;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Cell> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CellUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    boolean cellChanged;
    
    
    protected void $afterCompleteSetup() {
        setButtonTitle(t("isisfish.input.continueZones"));
        setNextPath(n("isisfish.input.tree.zones"));
    
        //cellMap.init(cellMapInfo);
        new OpenMapEvents(cellMap, new SelectMouseMode(false), CellSelectionLayer.SINGLE_SELECTION) {
            @Override
            public boolean mouseClicked(MouseEvent e) {
                boolean result = false;
                // TODO a fixer, le clic droit du menu contextuel
                // passe aussi par ici et change la selection
                //if (e.getButton() == MouseEvent.BUTTON1) {
                    if (getBean() != null) { // impossible de desactiver la carte :(
                        for (Cell c : cellMap.getSelectedCells()) {
                            if (!c.getTopiaId().equals(getBean().getTopiaId())) {
                                fieldCell.setSelectedItem(c);
                                result = true;
                            }
                        }
                    }
                //}
                return result;
            }
        };
    
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldCellName.setText("");
                    fieldCellLatitude.setText("");
                    fieldCellLongitude.setText("");
                    fieldCellComment.setText("");
                    fieldCellLand.setSelected(false);
                }
                if (evt.getNewValue() != null) {
                    cellChanged = false;
                    jaxx.runtime.SwingUtil.fillComboBox(fieldCell, getFisheryRegion().getCell(), getBean());
                    cellChanged = true;
                }
            }
        });
    }
    
    /*public void refresh() {
        Cell cell = getSaveVerifier().getEntity(Cell.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(cell);
    
        // reload region in map
        refreshRegionInMap(cellMap);
    }*/
    
    protected void fieldCellChanged(ItemEvent event) {
        if (cellChanged && event.getStateChange() == ItemEvent.SELECTED) {
            Cell c = (Cell)fieldCell.getSelectedItem();
            if (c==null) {
                return;
            }
            Cell oldC = getBean();
            if (oldC != null && c.getTopiaId().equals(oldC.getTopiaId())) {
                // avoid reentrant code
                return;
            }
            
            // FIXME il ne faut pas appeler le parent
            // on ne sais jamais de quel type est le parent
            InputUI inputUI = getParentContainer(InputUI.class);
            if (inputUI != null) {
                inputUI.getHandler().setTreeSelection(this, c.getTopiaId());
            }
            else {
                SensitivityTabUI sensitivityTabUI = getParentContainer(SensitivityTabUI.class);
                sensitivityTabUI.getHandler().setTreeSelection(this, c.getTopiaId());
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CellUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CellUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CellUI() {
        $initialize();
    }

    public CellUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CellUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CellUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CellUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CellUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__fieldCellLand(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setLand(fieldCellLand.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doItemStateChanged__on__fieldCell(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        fieldCellChanged(event);
    }

    public void doKeyReleased__on__fieldCellComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldCellComment.getText());
    }

    public void doKeyReleased__on__fieldCellName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldCellName.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Cell getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public IsisMapBean getCellMap() {
        return cellMap;
    }

    public InformationDelegator getCellMapInfo() {
        return cellMapInfo;
    }

    public JComboBox getFieldCell() {
        return fieldCell;
    }

    public JTextArea getFieldCellComment() {
        return fieldCellComment;
    }

    public JCheckBox getFieldCellLand() {
        return fieldCellLand;
    }

    public JTextField getFieldCellLatitude() {
        return fieldCellLatitude;
    }

    public JTextField getFieldCellLongitude() {
        return fieldCellLongitude;
    }

    public JTextField getFieldCellName() {
        return fieldCellName;
    }

    public JPanel getMap() {
        return map;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Cell> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Cell bean) {
        Cell oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCellMap(IsisMapBean cellMap) {
        IsisMapBean oldValue = this.cellMap;
        this.cellMap = cellMap;
        firePropertyChange(PROPERTY_CELL_MAP, oldValue, cellMap);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JSplitPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(SwingUtil.boxComponentWithJxLayer(cellMap), BorderLayout.CENTER);
        map.add(cellMapInfo, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCellMap() {
        $objectMap.put("cellMap", cellMap = new fr.ifremer.isisfish.map.IsisMapBean());
        
        cellMap.setName("cellMap");
    }

    protected void createCellMapInfo() {
        $objectMap.put("cellMapInfo", cellMapInfo = new InformationDelegator());
        
        cellMapInfo.setName("cellMapInfo");
    }

    protected void createFieldCell() {
        $objectMap.put("fieldCell", fieldCell = new JComboBox());
        
        fieldCell.setName("fieldCell");
        fieldCell.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldCell"));
    }

    protected void createFieldCellComment() {
        $objectMap.put("fieldCellComment", fieldCellComment = new JTextArea());
        
        fieldCellComment.setName("fieldCellComment");
        fieldCellComment.setColumns(15);
        fieldCellComment.setLineWrap(true);
        fieldCellComment.setWrapStyleWord(true);
        fieldCellComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldCellComment"));
    }

    protected void createFieldCellLand() {
        $objectMap.put("fieldCellLand", fieldCellLand = new JCheckBox());
        
        fieldCellLand.setName("fieldCellLand");
        fieldCellLand.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldCellLand"));
    }

    protected void createFieldCellLatitude() {
        $objectMap.put("fieldCellLatitude", fieldCellLatitude = new JTextField());
        
        fieldCellLatitude.setName("fieldCellLatitude");
        fieldCellLatitude.setColumns(15);
        fieldCellLatitude.setEditable(false);
    }

    protected void createFieldCellLongitude() {
        $objectMap.put("fieldCellLongitude", fieldCellLongitude = new JTextField());
        
        fieldCellLongitude.setName("fieldCellLongitude");
        fieldCellLongitude.setColumns(15);
        fieldCellLongitude.setEditable(false);
    }

    protected void createFieldCellName() {
        $objectMap.put("fieldCellName", fieldCellName = new JTextField());
        
        fieldCellName.setName("fieldCellName");
        fieldCellName.setColumns(15);
        fieldCellName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldCellName"));
    }

    protected void createMap() {
        $objectMap.put("map", map = new JPanel());
        
        map.setName("map");
        map.setLayout(new BorderLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Cell.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add(map, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add(fieldCell, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldCellName)), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldCellLatitude), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldCellLongitude), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldCellLand), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldCellComment));
        addChildrenToMap();
        
        // apply 22 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        fieldCell.setModel(new DefaultComboBoxModel());
        cellMap.setSelectionMode(fr.ifremer.isisfish.map.CellSelectionLayer.SINGLE_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        cellChanged = true;
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldCell();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.cell.name"));
        createFieldCellName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.cell.latitude"));
        createFieldCellLatitude();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.cell.longitude"));
        createFieldCellLongitude();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.cell.land"));
        createFieldCellLand();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setHorizontalAlignment(0);
        $JLabel4.setText(t("isisfish.cell.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldCellComment();
        createSave();
        createCancel();
        createMap();
        createCellMap();
        createCellMapInfo();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 22 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 22 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                fieldCell.setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldCellName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellName, jaxx.runtime.SwingUtil.getStringValue(getBean().getName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LATITUDE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldCellLatitude.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LATITUDE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellLatitude, String.valueOf(getBean().getLatitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LONGITUDE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldCellLongitude.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LONGITUDE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellLongitude, String.valueOf(getBean().getLongitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LAND_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldCellLand.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LAND_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldCellLand.setSelected(getBean().getLand());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldCellComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CELL_MAP_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                cellMap.setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CELL_MAP_FISHERY_REGION, true ,"fisheryRegion") {
        
            @Override
            public void processDataBinding() {
                cellMap.setFisheryRegion(getFisheryRegion());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CELL_MAP_SELECTED_CELLS, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                cellMap.setSelectedCells(getBean());
            }
        });
    }

}