/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.util.MatrixConverter;
import fr.ifremer.isisfish.util.MonthConverter;
import fr.ifremer.isisfish.util.RangeOfValuesConverter;
import fr.ifremer.isisfish.util.StringConverter;
import fr.ifremer.isisfish.util.TimeStepConverter;
import fr.ifremer.isisfish.util.TimeUnitConverter;
import fr.ifremer.isisfish.util.TopiaEntityConverter;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ConverterUtil {
    protected static ConvertUtilsBean nullConverter = ConverterUtil.getConverterNoCache(null);

    public static ConvertUtilsBean getConverter(TopiaContext context) {
        ConvertUtilsBean result = context == null ? nullConverter : ConverterUtil.getConverterNoCache(context);
        return result;
    }

    protected static ConvertUtilsBean getConverterNoCache(TopiaContext context) {
        BeanUtilsBean bub = BeanUtilsBean.getInstance();
        ConvertUtilsBean result = bub.getConvertUtils();
        result.register((Converter)new TopiaEntityConverter(context), TopiaEntity.class);
        result.register((Converter)new TimeStepConverter(), TimeStep.class);
        result.register((Converter)new MonthConverter(), Month.class);
        result.register((Converter)new TimeUnitConverter(), TimeUnit.class);
        result.register((Converter)new RangeOfValuesConverter(), RangeOfValues.class);
        result.register((Converter)new MatrixConverter(), MatrixND.class);
        result.register((Converter)new MatrixConverter(), MatrixNDImpl.class);
        result.register((Converter)new StringConverter(), String.class);
        return result;
    }
}

