/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.action;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.ui.util.IsisAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BackupAction
extends IsisAction {
    private static final long serialVersionUID = -7574218899996427656L;
    private static Log log = LogFactory.getLog(BackupAction.class);
    protected File src;
    protected File dst;
    protected List<String> paths;

    public BackupAction(File src, File dst, List<String> paths) {
        this.src = src;
        this.dst = dst;
        this.paths = paths;
    }

    @Override
    protected boolean prepare() {
        return this.src != null && this.dst != null && this.paths != null && this.src.exists() && !this.paths.isEmpty();
    }

    @Override
    protected void perform(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Backup directory is : " + this.dst));
        }
        String suffix = "_" + IsisFish.config.getBackupSessionDirectory().getName();
        try {
            for (String path : this.paths) {
                this.backup(new File(this.src, path), path, suffix);
            }
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't backup scripts", ex);
        }
    }

    protected void backup(File src, String path, String suffix) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            File dst = new File(this.dst, path);
            dst.mkdirs();
        } else {
            int extension = path.lastIndexOf(".");
            File dst = new File(this.dst, path = extension != -1 ? path.substring(0, extension) + suffix + "." + path.substring(extension + 1) : path + suffix);
            if (!dst.getParentFile().exists()) {
                dst.getParentFile().mkdirs();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Copying " + src.getName() + " to " + dst));
            }
            FileUtils.copyFile((File)src, (File)dst);
        }
    }
}

