/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

public class RuleParametersFactorTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -1655744662816030649L;
    private static Log log = LogFactory.getLog(RuleParametersFactorTableCellEditor.class);
    protected RuleChooser ruleChooser;
    protected Rule rule;

    public RuleParametersFactorTableCellEditor(RuleChooser ruleChooser, Rule rule) {
        this.ruleChooser = ruleChooser;
        this.rule = rule;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent comp;
        block4: {
            comp = null;
            final String paramName = (String)value;
            try {
                Class paramType = RuleStorage.getParameterType(this.rule, paramName);
                SensitivityInputHandler handler = this.ruleChooser.getContextValue(SensitivityInputHandler.class);
                boolean canBeFactor = handler.canBeFactor(paramType);
                if (canBeFactor) {
                    JButton button = new JButton(Resource.getIcon((String)"/icons/building_add.png"));
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RuleParametersFactorTableCellEditor.this.cancelCellEditing();
                            SimulAction simulAction = RuleParametersFactorTableCellEditor.this.ruleChooser.getContextValue(SimulAction.class);
                            simulAction.addRuleParameterFactor(RuleParametersFactorTableCellEditor.this.ruleChooser, RuleParametersFactorTableCellEditor.this.rule, paramName);
                        }
                    });
                    comp = button;
                }
            }
            catch (IsisFishException ex) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"Can't get value type", (Throwable)ex);
            }
        }
        if (comp == null) {
            comp = new JLabel();
        }
        return comp;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }
}

