/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.optimization;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class OptimizationComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Optimization> optimizationCache = new HashMap<String, Optimization>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String optimizationName = (String)value;
        c.setText(optimizationName);
        try {
            Optimization optim = this.optimizationCache.get(optimizationName);
            if (optim == null) {
                OptimizationStorage storage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                optim = (Optimization)storage.getNewInstance();
                this.optimizationCache.put(optimizationName, optim);
            }
            c.setToolTipText(optim.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n.t((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{optimizationName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

