/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.common;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ScriptParametersTableModel
extends AbstractTableModel {
    private static Log log = LogFactory.getLog(ScriptParametersTableModel.class);
    private static final long serialVersionUID = 3169786638868209920L;
    public static final String[] COLUMN_NAMES = new String[]{I18n.t((String)"isisfish.common.name", (Object[])new Object[0]), I18n.t((String)"isisfish.common.value", (Object[])new Object[0]), I18n.t((String)"isisfish.common.ellipsis", (Object[])new Object[0])};
    protected Object script;
    protected List<String> scriptParametersNames;
    protected boolean showFactorColumn;

    public ScriptParametersTableModel() {
    }

    public ScriptParametersTableModel(Object script) {
        this();
        this.setScript(script);
    }

    public void setShowFactorColumn(boolean showFactorColumn) {
        this.showFactorColumn = showFactorColumn;
        this.fireTableStructureChanged();
    }

    public void setScript(Object script) {
        this.script = script;
        this.scriptParametersNames = new ArrayList<String>();
        if (script != null) {
            Map<String, Class<?>> ruleParametersNamesAndTypes = JavaSourceStorage.getParameterNames(script);
            for (String names : ruleParametersNamesAndTypes.keySet()) {
                this.scriptParametersNames.add(names);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        int result = 2;
        if (this.showFactorColumn) {
            result = 3;
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.scriptParametersNames != null) {
            result = this.scriptParametersNames.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        String name = this.scriptParametersNames.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = name;
                break;
            }
            case 1: {
                try {
                    result = JavaSourceStorage.getParameterValue(this.script, name);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break;
                    log.debug((Object)"Can't get parameters value", (Throwable)e);
                }
                break;
            }
            case 2: {
                result = name;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Object.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + value));
        }
        String name = this.scriptParametersNames.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                try {
                    JavaSourceStorage.setParameterValue(this.script, name, value);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break;
                    log.error((Object)"Can't set parameter value", (Throwable)e);
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }
}

