/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.EquationEditorPaneUI;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.check.CheckRegion;
import fr.ifremer.isisfish.ui.input.check.CheckResult;
import fr.ifremer.isisfish.ui.input.check.CheckResultFrame;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.util.CellPointcomparator;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.SwingUtil;
import org.nuiton.widget.editor.Editor;

public class InputAction {
    private static Log log = LogFactory.getLog(InputAction.class);

    public Object saveAsModel(String category, String language, String content) {
        try {
            String name = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.saveModel.dialog", (Object[])new Object[0]));
            if (name != null) {
                FormuleStorage storage = FormuleStorage.createFormule(category, name, language);
                storage.setContent(content);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save equation as model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.equation.savemodel", (Object[])new Object[0]), eee);
        }
        return null;
    }

    public Object openEditor(InputOneEquationUI ui, String category, String name, Class<?> javaInterface, String content, Editor editor) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"openEditor");
        }
        try {
            EquationEditorPaneUI pane = new EquationEditorPaneUI((JAXXContext)ui);
            pane.setEquation(category, name, javaInterface, content);
            pane.setLocationRelativeTo(ui);
            pane.setVisible(true);
            if (pane.isResultOk().booleanValue() && editor != null) {
                editor.setText(pane.getEditor().getText());
            }
            pane.dispose();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't open editor", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.equation.openeditor", (Object[])new Object[0]), eee);
        }
        return null;
    }

    protected List<Formule> getFormules(TopiaContext isisContext, String name) {
        return FormuleStorage.getFormules(isisContext, name);
    }

    public Object addSelectivity(Population pop, String equation, Gear gear) {
        try {
            SelectivityDAO dao = IsisFishDAOHelper.getSelectivityDAO(pop.getTopiaContext());
            Selectivity selectivity = (Selectivity)dao.create(new Object[0]);
            selectivity.setGear(gear);
            selectivity.setPopulation(pop);
            selectivity.getEquation().setContent(equation);
            selectivity.update();
            gear.addPopulationSelectivity(selectivity);
            gear.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add selectivity", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
        return null;
    }

    public Object removeSelectivity(Gear gear, Selectivity selectivity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeSelectivity called: " + selectivity));
        }
        try {
            if (gear != null && selectivity != null) {
                gear.removePopulationSelectivity(selectivity);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"Selectivity"}), eee);
        }
        return null;
    }

    public Object addTargetSpecies(Metier metier, MetierSeasonInfo m, Species species, String targetFactorEquationContent, boolean primaryCatch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addTargetSpecies called: " + metier + " " + species + " " + primaryCatch + " " + targetFactorEquationContent));
        }
        try {
            String targetFactorEquationName = metier.getName() + "-" + species.getName() + "(" + m.getFirstMonth() + "-" + m.getLastMonth() + ")";
            TargetSpeciesDAO dao = IsisFishDAOHelper.getTargetSpeciesDAO(metier.getTopiaContext());
            TargetSpecies targetSpecies = (TargetSpecies)dao.create(new Object[0]);
            targetSpecies.setSpecies(species);
            targetSpecies.getTargetFactorEquation().setName(targetFactorEquationName);
            targetSpecies.getTargetFactorEquation().setContent(targetFactorEquationContent);
            targetSpecies.setPrimaryCatch(primaryCatch);
            m.addSpeciesTargetSpecies(targetSpecies);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
        return null;
    }

    public Object removeTargetSpecies(MetierSeasonInfo m, TargetSpecies targetSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeTargetSpecies called: " + targetSpecies));
        }
        try {
            if (targetSpecies != null) {
                m.removeSpeciesTargetSpecies(targetSpecies);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove TargetSpecies", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"TargetSpecies"}), eee);
        }
        return null;
    }

    public void addEffortDescription(SetOfVessels setOfVessels, Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addEffortDescription called: " + setOfVessels + " metier: " + metier));
        }
        try {
            EffortDescriptionDAO effortDescriptionPS = IsisFishDAOHelper.getEffortDescriptionDAO(metier.getTopiaContext());
            EffortDescription effortDescription = (EffortDescription)effortDescriptionPS.create(new Object[0]);
            effortDescription.setSetOfVessels(setOfVessels);
            effortDescription.setPossibleMetiers(metier);
            effortDescription.update();
            setOfVessels.addPossibleMetiers(effortDescription);
            setOfVessels.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create EffortDescription", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }

    public Object removeEffortDescription(SetOfVessels sov, EffortDescription effort) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeEffortDescription called");
        }
        try {
            sov.removePossibleMetiers(effort);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't remove entity: " + effort), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
        return null;
    }

    public Population createPopulation(TopiaContext context, Species species) {
        Population pop = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"createPopulation called");
        }
        try {
            String name = "Population_new";
            PopulationDAO dao = IsisFishDAOHelper.getPopulationDAO(context);
            pop = (Population)dao.create(new Object[0]);
            pop.setName(name);
            species.addPopulation(pop);
            pop.setSpecies(species);
            species.update();
            pop.update();
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Population"}), eee);
        }
        return pop;
    }

    public PopulationSeasonInfo createPopulationSeasonInfo(Population pop) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createSeasonInfo called");
        }
        PopulationSeasonInfo seasonInfo = null;
        try {
            PopulationSeasonInfoDAO dao = IsisFishDAOHelper.getPopulationSeasonInfoDAO(pop.getTopiaContext());
            seasonInfo = (PopulationSeasonInfo)dao.create(new Object[0]);
            seasonInfo.setFirstMonth(Month.MONTH[0]);
            seasonInfo.setLastMonth(Month.MONTH[3]);
            pop.addPopulationSeasonInfo(seasonInfo);
            seasonInfo.setPopulation(pop);
            seasonInfo.update();
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
        return seasonInfo;
    }

    public void removePopulationSeasonInfo(Population pop, PopulationSeasonInfo populationSeasonInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removePopulationSeasonInfo called");
        }
        try {
            pop.removePopulationSeasonInfo(populationSeasonInfo);
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
    }

    public MetierSeasonInfo createMetierSeasonInfo(Metier metier) {
        MetierSeasonInfo metierSeasonInfo = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMetierSeasonInfo called");
        }
        try {
            MetierSeasonInfoDAO metierSeasonInfoPS = IsisFishDAOHelper.getMetierSeasonInfoDAO(metier.getTopiaContext());
            metierSeasonInfo = (MetierSeasonInfo)metierSeasonInfoPS.create(new Object[0]);
            metierSeasonInfo.setFirstMonth(Month.MONTH[0]);
            metierSeasonInfo.setLastMonth(Month.MONTH[3]);
            metier.addMetierSeasonInfo(metierSeasonInfo);
            metierSeasonInfo.update();
            metier.update();
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't create MetierSeasonInfo", eee);
        }
        return metierSeasonInfo;
    }

    public void removeMetierSeasonInfo(Metier metier, MetierSeasonInfo info) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMetierSeasonInfo called");
        }
        try {
            metier.removeMetierSeasonInfo(info);
            metier.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove MetierSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"MetierSeasonInfo"}), eee);
        }
    }

    public void createRecruitmentDistribution(Population pop) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("createRecruitmentDistributionon called: " + pop));
        }
        try {
            int num;
            block10: {
                String val = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.recruitment.number.month", (Object[])new Object[0]));
                num = -1;
                if (val != null && !"".equals(val)) {
                    try {
                        num = Integer.parseInt(val);
                    }
                    catch (RuntimeException eee) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)("Can't parse val: " + val), (Throwable)eee);
                    }
                }
            }
            if (num > 0) {
                ArrayList<String> sem = new ArrayList<String>(num);
                for (int i = 0; i < num; ++i) {
                    sem.add(I18n.t((String)"isisfish.common.month", (Object[])new Object[]{i}));
                }
                MatrixND newMat = MatrixFactory.getInstance().create(new List[]{sem});
                MatrixND mat = pop.getRecruitmentDistribution();
                if (mat != null) {
                    newMat.paste(mat);
                }
                pop.setRecruitmentDistribution(newMat);
                pop.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove RecruitmentDistribution", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"RecruitmentDistribution"}), eee);
        }
    }

    public void createObservationValueMatrix(Observation observation) {
        try {
            String val = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.observation.value.dimensions", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)val)) {
                String[] values = val.trim().split("(,|;|\\*|x|\\s)");
                ArrayList<Integer> dims = new ArrayList<Integer>();
                for (String value : values) {
                    if (value.isEmpty() || !StringUtils.isNumeric((CharSequence)value)) continue;
                    dims.add(Integer.valueOf(value));
                }
                int[] dim = new int[dims.size()];
                for (int i = 0; i < dims.size(); ++i) {
                    dim[i] = (Integer)dims.get(i);
                }
                MatrixND newMat = MatrixFactory.getInstance().create(dim);
                MatrixND mat = observation.getValue();
                if (mat != null) {
                    newMat.paste(mat);
                }
                observation.setValue(newMat);
                observation.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove RecruitmentDistribution", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"RecruitmentDistribution"}), eee);
        }
    }

    public Object addMigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addMigration called");
        }
        try {
            MatrixND mat = info.getMigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, (Object)arrival, coeff);
            info.setMigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add migration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Migration"}), eee);
        }
        return null;
    }

    public Object addEmigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addEmigration called");
        }
        try {
            MatrixND mat = info.getEmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, coeff);
            info.setEmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add emigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Emigration"}), eee);
        }
        return null;
    }

    public Object addImmigration(PopulationSeasonInfo info, PopulationGroup group, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addImmigration called");
        }
        try {
            MatrixND mat = info.getImmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)arrival, coeff);
            info.setImmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add immigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Immigration"}), eee);
        }
        return null;
    }

    public void addMap(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"AddMap called");
        }
        String[] fileFormats = new String[]{".*\\.shp", "ESRI Shapefiles (.shp)", ".*\\.dcw", "Digital Chart of the World (.dcw)", ".*\\.vpf", "Vector Product Format (.vpf)", ".*\\.vmap", "Vector Map (.vmap)", ".*\\.cadrg", "Compressed ARC Digitized Raster Graphics (.cadrg)", ".*\\.cib", "Controlled Image Base (.cib)", ".*\\.rpf", "Raster Product Format (.rpf)", ".*\\.mif", "MapInfo (.mif)", ".*\\.e00", "ArcInfo (.e00)"};
        File inputMap = FileUtil.getFile((String[])fileFormats);
        try {
            if (inputMap != null) {
                String filename = inputMap.getName();
                RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
                File destDir = regionStorage.getMapRepository();
                File destMap = new File(destDir, filename);
                FileUtils.copyFile((File)inputMap, (File)destMap);
                List<String> maps = fisheryRegion.getMapFileList();
                maps.add(filename);
                fisheryRegion.setMapFileList(maps);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't copy map file for : " + inputMap), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.addmap", (Object[])new Object[0]), eee);
        }
    }

    public void removeMap(FisheryRegion fisheryRegion, Object[] selectedMaps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeMap called");
        }
        try {
            List<String> maps = fisheryRegion.getMapFileList();
            RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
            File mapDir = regionStorage.getMapRepository();
            for (Object selectedMap : selectedMaps) {
                String mapName = (String)selectedMap;
                maps.remove(mapName);
                File mapFile = new File(mapDir, mapName);
                mapFile.delete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing map file : " + mapFile));
                }
                if (!mapName.endsWith(".shp")) continue;
                String indexName = mapName.replaceAll("\\.shp$", ".ssx");
                File indexFile = new File(mapDir, indexName);
                indexFile.delete();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removing index file : " + indexFile));
            }
            fisheryRegion.setMapFileList(maps);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove map", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.removemap", (Object[])new Object[0]), eee);
        }
    }

    public void saveFisheryRegion(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"save called");
        }
        try {
            TopiaContext isisContext = fisheryRegion.getTopiaContext();
            int latNumber = Math.round((fisheryRegion.getMaxLatitude() - fisheryRegion.getMinLatitude()) / fisheryRegion.getCellLengthLatitude());
            int lonNumber = Math.round((fisheryRegion.getMaxLongitude() - fisheryRegion.getMinLongitude()) / fisheryRegion.getCellLengthLongitude());
            boolean progresscpt = false;
            CellPointcomparator cellPointcomparator = new CellPointcomparator();
            CellDAO cellPS = IsisFishDAOHelper.getCellDAO(isisContext);
            List cells = cellPS.findAll();
            Collections.sort(cells, cellPointcomparator);
            Point2D.Float point = new Point2D.Float();
            for (float lati = fisheryRegion.getMinLatitude(); lati < fisheryRegion.getMaxLatitude(); lati += fisheryRegion.getCellLengthLatitude()) {
                lati = Math.round(lati * 1000.0f);
                lati /= 1000.0f;
                for (float longi = fisheryRegion.getMinLongitude(); longi < fisheryRegion.getMaxLongitude(); longi += fisheryRegion.getCellLengthLongitude()) {
                    longi = (float)Math.round(longi * 1000.0f) / 1000.0f;
                    point.setLocation(lati, longi);
                    int position = Collections.binarySearch(cells, point, cellPointcomparator);
                    if (position >= 0) {
                        cells.remove(position);
                        continue;
                    }
                    Cell cell = (Cell)cellPS.create(new Object[0]);
                    cell.setName("La" + lati + "Lo" + longi);
                    cell.setLatitude(lati);
                    cell.setLongitude(longi);
                    cell.setLand(false);
                    cell.update();
                }
            }
            fisheryRegion.update();
            progresscpt = false;
            for (Cell cell : cells) {
                cellPS.delete(cell);
            }
            isisContext.commitTransaction();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.region.save", (Object[])new Object[0]), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.save", (Object[])new Object[0]), eee);
        }
    }

    public void checkFisheryRegion(FisheryRegion fisheryRegion) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"check called: ");
            }
            CheckResult result = new CheckResult();
            CheckRegion.check(fisheryRegion, result);
            CheckResultFrame dialog = new CheckResultFrame();
            dialog.setCheckResult(result);
            SwingUtil.center((Component)dialog);
            dialog.setVisible(true);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.region.check", (Object[])new Object[0]), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.check", (Object[])new Object[0]), eee);
        }
    }
}

