/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.io;

import fr.ifremer.isisfish.logging.io.LineReader;
import fr.ifremer.isisfish.logging.io.OffsetReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileOffsetReader
extends OffsetReader {
    protected static final Log log = LogFactory.getLog(FileOffsetReader.class);
    protected File offsetFile;
    protected RandomAccessFile offsetReader;
    protected RandomAccessFile writer;

    public FileOffsetReader(File file) {
        this.offsetFile = file;
    }

    @Override
    public long getOffset(long position) throws IOException {
        long result;
        this.offsetReader.seek(position * 8L);
        try {
            result = this.offsetReader.readLong();
        }
        catch (EOFException e) {
            result = -1L;
        }
        return result;
    }

    @Override
    public void open(LineReader reader) throws IOException {
        super.open(reader);
        try {
            this.offsetReader = new RandomAccessFile(this.offsetFile, "r");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        if (!this.needCreate()) {
            this.nbLines = this.offsetReader.length() / 8L;
        }
    }

    @Override
    public void close() throws IOException {
        IOException error = null;
        if (this.offsetReader != null) {
            try {
                this.offsetReader.close();
            }
            catch (IOException e) {
                error = e;
            }
            this.offsetReader = null;
        }
        this.offsetFile.deleteOnExit();
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(LineReader lineReader) throws IOException {
        this.offsetReader.close();
        this.writer = new RandomAccessFile(this.offsetFile.getAbsolutePath(), "rw");
        try {
            super.update(lineReader);
        }
        finally {
            this.writer.close();
            this.writer = null;
            this.offsetReader = new RandomAccessFile(this.offsetFile, "r");
        }
    }

    @Override
    public void deleteOffsetFile() {
        if (this.offsetFile != null && this.offsetFile.exists()) {
            this.offsetFile.delete();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(offsetfile:").append(this.offsetFile.getName()).append(", nbLines:").append(this.getNbLines()).append(')');
        return sb.toString();
    }

    @Override
    protected void storeOffset(long position, long offset) throws IOException {
        this.writer.writeLong(offset);
    }

    @Override
    protected boolean needCreate() throws IOException {
        return !this.offsetFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long createOffsets(LineReader lineReader) throws IOException {
        try {
            this.writer = new RandomAccessFile(this.offsetFile, "rw");
            long l = super.createOffsets(lineReader);
            return l;
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long createOffsets(LineReader lineReader, LineReader parent) throws IOException {
        try {
            this.writer = new RandomAccessFile(this.offsetFile, "rw");
            long l = super.createOffsets(lineReader, parent);
            return l;
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }
}

