/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.export;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageHelper;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class ExportHelper
extends StorageHelper {
    private static Log log = LogFactory.getLog(ExportHelper.class);

    public static void doExport(SimulationStorage simulation, File destdir, List<Export> exports, File compileDir) {
        long timeStart = System.currentTimeMillis();
        for (Export export : exports) {
            long time;
            String exportName;
            block3: {
                exportName = ExportStorage.getName(export);
                time = System.currentTimeMillis();
                try {
                    ExportHelper.exportToFile(simulation, destdir, export);
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't export object: " + exportName), (Throwable)eee);
                }
            }
            simulation.getInformation().addExportTime(exportName, System.currentTimeMillis() - time);
        }
        simulation.getInformation().addExportTime("All export", System.currentTimeMillis() - timeStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void exportToFile(SimulationStorage simulation, File destdir, Export export) throws Exception {
        String filename = export.getExportFilename();
        String extension = export.getExtensionFilename();
        File file = new File(destdir, filename + extension);
        int val = 0;
        while (file.exists()) {
            file = new File(destdir, filename + extension + "_" + ++val);
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(file));
            export.export(simulation, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void populateSensitivityExport(int exportIndex, TopiaContext context, SensitivityExport export, Properties props) {
        ExportHelper.populateStorageParams(exportIndex, context, export, props, "sensitivityexport");
    }

    public static Properties getSensitivityExportAsProperties(int sensitivityExportIndex, TopiaContext context, SensitivityExport sensitivityExport) {
        return ExportHelper.getParamsAsProperties(sensitivityExportIndex, context, sensitivityExport, "sensitivityexport");
    }
}

