/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.VariableAbstract;
import fr.ifremer.isisfish.entities.VariableType;
import fr.ifremer.isisfish.equation.VariableEquation;
import org.apache.commons.beanutils.BeanUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class VariableImpl
extends VariableAbstract {
    private static final long serialVersionUID = 3978428224373810278L;

    public VariableImpl() {
        this.setType(VariableType.DOUBLE);
    }

    public void setEquationValueContent(String content) {
        try {
            Equation eq = this.getEquationValue();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Variable");
                eq.setJavaInterface(VariableEquation.class);
                eq.setLanguage("java");
                this.setEquationValue(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public String toString() {
        String result = null;
        try {
            TopiaEntity entity = this.getTopiaContext().findByTopiaId(this.getEntityId());
            result = BeanUtils.getProperty((Object)entity, (String)"name");
        }
        catch (Exception ex) {
            result = this.entityId;
        }
        result = result + "." + this.name;
        return result;
    }
}

