/*
 * #%L
 * IsisFish
 * 
 * $Id: CompositeFilterAcceptor.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * this class is a concrete implementation of {@link FilterAcceptor}
 * with an internal {@link Acceptor} (delegate Acceptor  operations),
 * and an internal {@link ValueGetter} (delegate ValueGetter operations)
 * <p/>
 *
 * @author chemit
 * @see Acceptor
 * @see FilterAcceptor
 * @see ValueGetter
 */
public class CompositeFilterAcceptor<M, T> implements FilterAcceptor<M, T> {

    static private Log log = LogFactory.getLog(CompositeFilterAcceptor.class);

    /** delegate Acceptor */
    protected Acceptor<T> acceptor;

    /** delegate ValueGetter */
    protected ValueGetter<M, T> getter;

    public CompositeFilterAcceptor(Class<T> klazz, ValueGetter<M, T> getter) {
        this(AcceptorFactory.getAcceptor(klazz), getter);
    }

    public CompositeFilterAcceptor(Acceptor<T> acceptor, ValueGetter<M, T> getter) {
        this.acceptor = acceptor;
        this.getter = getter;
    }

    ///////////////////////////////////
    // FilterDialog implementation
    ///////////////////////////////////

    public boolean acceptParam(M item, T value) {
        return accept(getValue(item), value);
    }

    ///////////////////////////////////
    // ValueGetter implementation
    ///////////////////////////////////

    public T getValue(M model) {
        // we assume that we also need to extract value from model
        // anyway if we have the already good type it will just return it
        return extract(getter.getValue(model));
    }

    ///////////////////////////////////
    // Acceptor implementation
    ///////////////////////////////////

    public Class<T> getKlazz() {
        return acceptor.getKlazz();
    }

    public boolean canUse(Object[] val) {
        return acceptor.canUse(val);
    }

    public boolean accept(T meta, T value) {
        return acceptor.accept(meta, value);
    }

    @SuppressWarnings({"unchecked"})
    public T extract(Object args) {
        return args == null || getKlazz().isAssignableFrom(args.getClass()) ?
                (T) args : acceptor.extract(args);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(' ').append(acceptor);
        sb.append(' ').append(getter);
        return sb.toString();
    }
}
