/*
 * #%L
 * IsisFish
 * 
 * $Id: IsisActionWithBackup.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;

import javax.swing.JDialog;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.script.action.BackupAction;

/**
 * This abstract action perform a backup action.
 * 
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (Mon, 29 Nov 2010) $
 * By : $Author: chatellier $
 * 
 * @deprecated C'est pas evident de faire des Actions swing avec jaxx
 */
public abstract class IsisActionWithBackup extends IsisAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5498329861390316586L;

    /** Root directory of files to be backupped. */
    protected File root;

    /**
     * Constructor.
     * 
     * @param dialog dialog ???
     * @param root root directory of files to be backupped
     */
    protected IsisActionWithBackup(JDialog dialog, File root) {
        super(dialog);
        this.root = root;
    }

    /**
     * obtain the list of relative path to {@link #root} directory needed
     * to be backuped in {@link #backupRoot} directory
     *
     * @return the list of relative path to files to backup
     */
    protected abstract List<String> getFilesToBackup();

    /**
     * Just perform a {@link BackupAction}.
     * 
     * Need to be overridden and called by {@code super.perform(e)}
     */
    @Override
    protected void perform(ActionEvent e) {
        // do backup stuff here        
        BackupAction backupAction = new BackupAction(root, IsisFish.config
                .getBackupSessionDirectory(), getFilesToBackup());
        backupAction.actionPerformed(e);
    }
}
