/*
 * #%L
 * IsisFish
 * 
 * $Id: ScriptTypesComboModel.java 3503 2011-10-28 12:31:01Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script;

import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.ui.script.ScriptAction.ScriptMapping;

/**
 * Model pour la liste des scripts disponibles.
 *
 * @author chatellier
 * @version $Revision: 3503 $
 * 
 * Last update : $Date: 2011-10-28 14:31:01 +0200 (Fri, 28 Oct 2011) $
 * By : $Author: chatellier $
 */
public class ScriptTypesComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Mapping list. */
    protected List<ScriptMapping> mappings;
    
    /**
     * Empty constructor.
     */
    public ScriptTypesComboModel() {
        ScriptMapping[] values = ScriptMapping.values();
        mappings = new ArrayList<ScriptMapping>(values.length);
        for (ScriptMapping mapping : values) {
            if (!mapping.isOfficialVCS()) {
                mappings.add(mapping);
            }
        }
        
        // default first selected
        if (!mappings.isEmpty()) {
            setSelectedItem(mappings.get(0));
        }
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return mappings.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        return mappings.size();
    }
}
