package fr.ifremer.isisfish.ui;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class WelcomeUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWVTU8TURSGL5VSCgjKl6hAKlbjQqd8F4UgAmloA341RLQbb5kLM2Q6M87csYML40/wJ+jejYk7V8aFaxdujH/BGBdujefOTKetXNrGG7tom/ue97nnnMmc8+Y7itoWunCAXVeyHJ2qJSLlbu3s3CkekF26TuxdSzWpYSH/0xZBkQLqlsNzm6KLhU1mTwX21JpRMg2d6DXuxU3UZdNDjdgKIZSisXrHrm2n8qG86JqOVaGGSfGor37+iLyUX7yOIOSakN04lJJo5qpW0r6JIqpMUT/c9BSnNKzvQxqWqu9DvifZ2ZqGbfs2LpEn6DmKbaIOE1sAo2ii9ZI9hud3TYo6k7mMBcBJihJ7lqTuWaRE4NdW7T3VViRHlR4Qbdcoke2saXq+DopiCtZljVgUXWps2vDjqs6uZG6L6M4qtuDGQVaTK9llKFGqnNfc4sdC4OkjgSykL4zs9iOzlJQgeuhINBNYaH/o6Enm8gS6h6E1YBmus4RKvafmlil2dKZeDtL1pMFj85sOnWM8eaaxPNtYnmssz3Pk2kZ4qZ871p7m2IOipxsXvRA6r/Hk6xy5p6bZk030KY4eJDbDSazWWn0c6b+ts6E1zbVWH9UiV59tos810ef5evi0psOnxc8vzSmtt+y/l3exTrTtbNP3N4hj7rgJ0+x83TSDOSlV52R1kLUVUNRy4JiikcLR0XofJH+ojvw1VBnQU38PD3x5/+1dpjJJx+DuIW5ozSKACWdahgljSWVX9/lj1KGqltrC5mIBxW2iwRbxtsQoJ7F8IENycJ83dCRmlzawrQAiGvv64ePw488nUCSDujQDyxnM4rMoThULumBosmveXPEy6il3wvcplhtFHQpR9xUY1P1Lqq6pOklgCpO96FCy7EIjRjmNCLMpxj/9Gsi/Xak0ow2SO3tseLUh0Ueow7/NWyzBzuAukm7TJo5sVHcDb1u0sd8uMxjQ97zvbW61Gj40HKi2d0nGFCeKqi7DYIVKmeWhVwL7V2iZGIfuqs9wUfMS3vl3ULQMG1YRhLRT4tIGjIEWGDGis3LkBpjhphh2bPxXwqgwYVyYkBAmTAgTksKEy8KEK8KEq8IESZgw2RKh0es1LZyDOGFWmDAvTFgQJtwQJiwJE5aFCSvChFVhwrowYQMIfwAIub0Y/w4AAA==";
    private static final Log log = LogFactory.getLog(WelcomeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected WelcomeHandler handler;
    protected WelcomePanelUI welcomePanelUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private WelcomeUI $JFrame0 = this;
    private JMenuBar $JMenuBar0;
    private JMenu $JMenu0;
    private JMenuItem $JMenuItem0;
    private JSeparator $JSeparator0;
    private JMenuItem $JMenuItem1;
    private JMenu $JMenu1;
    private JMenuItem $JMenuItem2;
    private JMenuItem $JMenuItem3;
    private JMenuItem $JMenuItem4;
    private JMenuItem $JMenuItem5;
    private JMenuItem $JMenuItem6;
    private JSeparator $JSeparator1;
    private JMenuItem $JMenuItem7;
    private JMenu $JMenu2;
    private JMenuItem $JMenuItem8;
    private JMenuItem $JMenuItem9;
    private JMenuItem $JMenuItem10;
    private JMenuItem $JMenuItem11;
    private JMenu $JMenu3;
    private JMenuItem $JMenuItem12;
    private JMenu $JMenu4;
    private JMenuItem $JMenuItem13;
    private JMenuItem $JMenuItem14;
    private JMenuItem $JMenuItem15;
    private JMenuItem $JMenuItem16;
    private JSeparator $JSeparator2;
    private JMenuItem $JMenuItem17;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            getHandler().postInit(this);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public WelcomeUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public WelcomeUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeUI(String param0) {
        super(param0);
        $initialize();
    }

    public WelcomeUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public WelcomeUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeUI() {
        $initialize();
    }

    public WelcomeUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().configurationSSHLauncher(this);
    }

    public void doActionPerformed__on__$JMenuItem17(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().about(this);
    }

    public void doActionPerformed__on__$JMenuItem16(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().help(this, "TOPIA_API");
    }

    public void doActionPerformed__on__$JMenuItem15(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().help(this, "MATRIX_API");
    }

    public void doActionPerformed__on__$JMenuItem14(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().help(this, "ISIS_API");
    }

    public void doActionPerformed__on__$JMenuItem9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().configVCS(this);
    }

    public void doActionPerformed__on__$JMenuItem13(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().help(this, "JAVA_API");
    }

    public void doActionPerformed__on__$JMenuItem8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().config(this);
    }

    public void doActionPerformed__on__$JMenuItem12(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().help(this, "ISISFISH");
    }

    public void doActionPerformed__on__$JMenuItem11(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().configurationR(this);
    }

    public void doActionPerformed__on__$JMenuItem6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newSensitivityFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newQueueFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newInputFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newScriptFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newSimulationFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().newResultFrame(this);
    }

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateVCS(this);
    }

    public void doActionPerformed__on__$JMenuItem1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public WelcomeHandler getHandler() {
        return handler;
    }

    public WelcomePanelUI getWelcomePanelUI() {
        return welcomePanelUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected JMenu get$JMenu3() {
        return $JMenu3;
    }

    protected JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected JMenuItem get$JMenuItem15() {
        return $JMenuItem15;
    }

    protected JMenuItem get$JMenuItem16() {
        return $JMenuItem16;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected JMenuItem get$JMenuItem17() {
        return $JMenuItem17;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new WelcomeHandler());
    }

    protected void createWelcomePanelUI() {
        $objectMap.put("welcomePanelUI", welcomePanelUI = new WelcomePanelUI(this));
        
        welcomePanelUI.setName("welcomePanelUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JFrame0
        add(welcomePanelUI);
        $JFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        $JMenuBar0.add($JMenu1);
        $JMenuBar0.add($JMenu2);
        $JMenuBar0.add($JMenu3);
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem1);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenuItem2);
        $JMenu1.add($JMenuItem3);
        $JMenu1.add($JMenuItem4);
        $JMenu1.add($JMenuItem5);
        $JMenu1.add($JMenuItem6);
        $JMenu1.add($JSeparator1);
        $JMenu1.add($JMenuItem7);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem8);
        $JMenu2.add($JMenuItem9);
        $JMenu2.add($JMenuItem10);
        $JMenu2.add($JMenuItem11);
        // inline complete setup of $JMenu3
        $JMenu3.add($JMenuItem12);
        $JMenu3.add($JMenu4);
        $JMenu3.add($JSeparator2);
        $JMenu3.add($JMenuItem17);
        // inline complete setup of $JMenu4
        $JMenu4.add($JMenuItem13);
        $JMenu4.add($JMenuItem14);
        $JMenu4.add($JMenuItem15);
        $JMenu4.add($JMenuItem16);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JFrame0", $JFrame0);
        createHandler();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(_("isisfish.welcome.menu.file"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setEnabled(false);
        $JMenuItem0.setText(_("isisfish.welcome.menu.synchro"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(_("isisfish.welcome.menu.close"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(_("isisfish.welcome.menu.frame"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(_("isisfish.welcome.menu.simulation"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(_("isisfish.welcome.menu.result"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(_("isisfish.welcome.menu.input"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(_("isisfish.welcome.menu.script"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(_("isisfish.sensitivity.title"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("isisfish.welcome.menu.queue"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(_("isisfish.welcome.menu.configuration"));
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(_("isisfish.welcome.menu.configuration"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setEnabled(false);
        $JMenuItem9.setText(_("isisfish.welcome.menu.configuration.vcs"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JMenuItem10
        $objectMap.put("$JMenuItem10", $JMenuItem10 = new JMenuItem());
        
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(_("isisfish.welcome.menu.configuration.sshlauncher"));
        $JMenuItem10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem10"));
        // inline creation of $JMenuItem11
        $objectMap.put("$JMenuItem11", $JMenuItem11 = new JMenuItem());
        
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("isisfish.welcome.menu.configuration.r"));
        $JMenuItem11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem11"));
        // inline creation of $JMenu3
        $objectMap.put("$JMenu3", $JMenu3 = new JMenu());
        
        $JMenu3.setName("$JMenu3");
        $JMenu3.setText(_("isisfish.welcome.menu.help"));
        // inline creation of $JMenuItem12
        $objectMap.put("$JMenuItem12", $JMenuItem12 = new JMenuItem());
        
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("isisfish.welcome.menu.help.isisfish"));
        $JMenuItem12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem12"));
        // inline creation of $JMenu4
        $objectMap.put("$JMenu4", $JMenu4 = new JMenu());
        
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(_("isisfish.welcome.menu.api"));
        // inline creation of $JMenuItem13
        $objectMap.put("$JMenuItem13", $JMenuItem13 = new JMenuItem());
        
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(_("isisfish.welcome.menu.help.javaapi"));
        $JMenuItem13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem13"));
        // inline creation of $JMenuItem14
        $objectMap.put("$JMenuItem14", $JMenuItem14 = new JMenuItem());
        
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setText(_("isisfish.welcome.menu.help.isisfishapi"));
        $JMenuItem14.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem14"));
        // inline creation of $JMenuItem15
        $objectMap.put("$JMenuItem15", $JMenuItem15 = new JMenuItem());
        
        $JMenuItem15.setName("$JMenuItem15");
        $JMenuItem15.setText(_("isisfish.welcome.menu.help.matrixapi"));
        $JMenuItem15.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem15"));
        // inline creation of $JMenuItem16
        $objectMap.put("$JMenuItem16", $JMenuItem16 = new JMenuItem());
        
        $JMenuItem16.setName("$JMenuItem16");
        $JMenuItem16.setText(_("isisfish.welcome.menu.help.topiaapi"));
        $JMenuItem16.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem16"));
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        // inline creation of $JMenuItem17
        $objectMap.put("$JMenuItem17", $JMenuItem17 = new JMenuItem());
        
        $JMenuItem17.setName("$JMenuItem17");
        $JMenuItem17.setText(_("isisfish.welcome.menu.about"));
        $JMenuItem17.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem17"));
        createWelcomePanelUI();
        // inline creation of $JFrame0
        setName("$JFrame0");
        SwingUtil.setComponentHeight($JFrame0,736);
        $JFrame0.getContentPane().setLayout(new BorderLayout());
        setResizable(true);
        SwingUtil.setComponentWidth($JFrame0,874);
        
        $completeSetup();
    }

}