/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationServiceListener.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, Code Lutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.launcher;

/**
 * Ecouteur sur les evenenements de changement d'états des simulations.
 * 
 * @author poussin
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (Mon, 29 Nov 2010) $
 * By : $Author: chatellier $
 */
public interface SimulationServiceListener {

    /**
     * Notify start of simulation.
     * 
     * @param simService le simulation service qui a lance la simulation
     * @param job job that responsible to simulation
     */
    public void simulationStart(SimulationService simService, SimulationJob job);

    /**
     * Notify end of simulation.
     * 
     * @param simService le simulation service qui a arrete la simulation
     * @param job job that responsible to simulation
     */
    public void simulationStop(SimulationService simService, SimulationJob job);

    /**
     * Previent que le simulation service a vide ca liste de simulation faites.
     * 
     * @param simService le simulation service dont la liste des jobs finis
     * a ete vide
     */
    public void clearJobDone(SimulationService simService);
}
