/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DesignPlanVisitor;

/**
 * XML design plan visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class DesignPlanXMLVisitor extends AbstractXMLVisitor implements DesignPlanVisitor {

    /**
     * {@inheritDoc}
     * 
     * Changes :
     *  v2 : depuis la v2, meilleur gestion des min/max, pourcentage poru quasiment
     *      tous les facteurs continue
     *  v0 : version original
     */
    @Override
    public void start(DesignPlan designPlan) {
        xmlBuffer.append("<experimentalDesign version=\"2\">");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(DesignPlan designPlan,
            FactorGroup factorGroup) {
        FactorGroupXMLVisitor visitor = new FactorGroupXMLVisitor();
        factorGroup.accept(visitor);
        xmlBuffer.append(visitor.getXML());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void end(DesignPlan designPlan) {
        xmlBuffer.append("</experimentalDesign>");
    }

}
