/*
 * #%L
 * IsisFish
 * 
 * $Id: FisheryRegionImpl.java 3393 2011-06-14 17:43:37Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.entities;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.nuiton.topia.TopiaException;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;

/**
 * FisheryRegionImpl.
 *
 * Created: 3 janv. 2006 17:14:52
 *
 * @author poussin
 * @version $Revision: 3393 $
 *
 * Last update: $Date: 2011-06-14 19:43:37 +0200 (Tue, 14 Jun 2011) $
 * by : $Author: chatellier $
 */
public class FisheryRegionImpl extends FisheryRegionAbstract {

    /** serialVersionUID */
    private static final long serialVersionUID = 1L;

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getMapFileList()
     */
    public List<String> getMapFileList() {
        List<String> result = new ArrayList<String>();
        String mapfiles = getMapFiles();
        if (mapfiles != null) {
            String[] mapNames = mapfiles.split(",");
            for (String mapName : mapNames) {
                if (!"".equals(mapName.trim())) {
                    result.add(mapName.trim());
                }
            }
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#setMapFileList(java.util.List)
     */
    public void setMapFileList(List<String> maps) {
        StringBuffer result = new StringBuffer();
        String sep = "";
        if (maps != null) {
            for (String filename : maps) {
                result.append(sep + filename);
                sep = ",";
            }
        }
        setMapFiles(result.toString());
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getMapFilePath()
     */
    public List<String> getMapFilePath() {
        List<String> mapNames = getMapFileList();
        List<String> result = new ArrayList<String>();
        RegionStorage regionStorage = RegionStorage.getRegion(getName());
        for (String mapName : mapNames) {
            result.add(regionStorage.getMapRepository().getPath()
                    + File.separator + mapName);
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getPort()
     */
    public List<Port> getPort() {
        try {
            PortDAO dao = IsisFishDAOHelper.getPortDAO(getTopiaContext());
            List<Port> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get port", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getCell()
     */
    public List<Cell> getCell() {
        try {
            CellDAO dao = IsisFishDAOHelper.getCellDAO(getTopiaContext());
            List<Cell> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get cell", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getVesselType()
     */
    public List<VesselType> getVesselType() {
        try {
            VesselTypeDAO dao = IsisFishDAOHelper
                    .getVesselTypeDAO(getTopiaContext());
            List<VesselType> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get vessel type", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getGear()
     */
    public List<Gear> getGear() {
        try {
            GearDAO dao = IsisFishDAOHelper.getGearDAO(getTopiaContext());
            List<Gear> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get gear", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getMetier()
     */
    public List<Metier> getMetier() {
        try {
            MetierDAO dao = IsisFishDAOHelper.getMetierDAO(getTopiaContext());
            List<Metier> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get metier", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getSetOfVessels()
     */
    public List<SetOfVessels> getSetOfVessels() {
        try {
            SetOfVesselsDAO dao = IsisFishDAOHelper
                    .getSetOfVesselsDAO(getTopiaContext());
            List<SetOfVessels> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get setOfVessels", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getSpecies()
     */
    public List<Species> getSpecies() {
        try {
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(getTopiaContext());
            List<Species> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get species", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getStrategy()
     */
    public List<Strategy> getStrategy() {
        try {
            StrategyDAO dao = IsisFishDAOHelper
                    .getStrategyDAO(getTopiaContext());
            List<Strategy> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get strategy", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getTripType()
     */
    public List<TripType> getTripType() {
        try {
            TripTypeDAO dao = IsisFishDAOHelper
                    .getTripTypeDAO(getTopiaContext());
            List<TripType> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get tripType", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegion#getZone()
     */
    public List<Zone> getZone() {
        try {
            ZoneDAO dao = IsisFishDAOHelper.getZoneDAO(getTopiaContext());
            List<Zone> result = dao.findAll();
            return result;
        } catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't get zone", eee);
        }
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegionAbstract#toString()
     */
    @Override
    public String toString() {
        String result = getName();
        return result;
    }
}
